/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.element.chart.ChartLabelSeparatorElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartSymbolImageElement;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartAngleOffsetAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartAutoPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartAutoSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartAxisLabelPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartAxisPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartConnectBarsAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDataLabelNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDataLabelSymbolAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDataLabelTextAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDeepAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDisplayLabelAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorCategoryAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorLowerIndicatorAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorLowerLimitAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorLowerRangeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorMarginAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorPercentageAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorUpperIndicatorAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorUpperLimitAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartErrorUpperRangeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartGapWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartGroupBarsPerAxisAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartHoleSizeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartIncludeHiddenCellsAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartInterpolationAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartIntervalMajorAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartIntervalMinorDivisorAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartJapaneseCandleStickAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLabelArrangementAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLabelPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLabelPositionNegativeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLinesAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLinkDataStyleToSourceAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLogarithmicAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartMaximumAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartMeanValueAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartMinimumAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartOriginAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartOverlapAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartPercentageAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartPieOffsetAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartRegressionTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartReverseDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartRightAngledAxesAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartScaleTextAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSeriesSourceAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSolidTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSortByXValuesAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSplineOrderAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSplineResolutionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartStackedAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSymbolHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSymbolNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSymbolTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartSymbolWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTextOverlapAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartThreeDimensionalAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTickMarkPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTickMarksMajorInnerAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTickMarksMajorOuterAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTickMarksMinorInnerAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTickMarksMinorOuterAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartTreatEmptyCellsAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartVerticalAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartVisibleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRotationAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextLineBreakAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;

/**
 * DOM implementation of OpenDocument element  {@odf.element style:chart-properties}.
 *
 */
public class StyleChartPropertiesElement extends OdfStylePropertiesBase {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.STYLE, "chart-properties");

	/**
	 * Create the instance of <code>StyleChartPropertiesElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public StyleChartPropertiesElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element style:chart-properties}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	public final static OdfStyleProperty AngleOffset =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "angle-offset"));

	public final static OdfStyleProperty AutoPosition =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "auto-position"));

	public final static OdfStyleProperty AutoSize =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "auto-size"));

	public final static OdfStyleProperty AxisLabelPosition =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "axis-label-position"));

	public final static OdfStyleProperty AxisPosition =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "axis-position"));

	public final static OdfStyleProperty ConnectBars =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "connect-bars"));

	public final static OdfStyleProperty DataLabelNumber =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "data-label-number"));

	public final static OdfStyleProperty DataLabelSymbol =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "data-label-symbol"));

	public final static OdfStyleProperty DataLabelText =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "data-label-text"));

	public final static OdfStyleProperty Deep =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "deep"));

	public final static OdfStyleProperty DisplayLabel =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "display-label"));

	public final static OdfStyleProperty ErrorCategory =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-category"));

	public final static OdfStyleProperty ErrorLowerIndicator =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-lower-indicator"));

	public final static OdfStyleProperty ErrorLowerLimit =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-lower-limit"));

	public final static OdfStyleProperty ErrorLowerRange =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-lower-range"));

	public final static OdfStyleProperty ErrorMargin =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-margin"));

	public final static OdfStyleProperty ErrorPercentage =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-percentage"));

	public final static OdfStyleProperty ErrorUpperIndicator =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-upper-indicator"));

	public final static OdfStyleProperty ErrorUpperLimit =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-upper-limit"));

	public final static OdfStyleProperty ErrorUpperRange =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "error-upper-range"));

	public final static OdfStyleProperty GapWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "gap-width"));

	public final static OdfStyleProperty GroupBarsPerAxis =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "group-bars-per-axis"));

	public final static OdfStyleProperty HoleSize =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "hole-size"));

	public final static OdfStyleProperty IncludeHiddenCells =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "include-hidden-cells"));

	public final static OdfStyleProperty Interpolation =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "interpolation"));

	public final static OdfStyleProperty IntervalMajor =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "interval-major"));

	public final static OdfStyleProperty IntervalMinorDivisor =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "interval-minor-divisor"));

	public final static OdfStyleProperty JapaneseCandleStick =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "japanese-candle-stick"));

	public final static OdfStyleProperty LabelArrangement =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "label-arrangement"));

	public final static OdfStyleProperty LabelPosition =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "label-position"));

	public final static OdfStyleProperty LabelPositionNegative =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "label-position-negative"));

	public final static OdfStyleProperty Lines =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "lines"));

	public final static OdfStyleProperty LinkDataStyleToSource =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "link-data-style-to-source"));

	public final static OdfStyleProperty Logarithmic =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "logarithmic"));

	public final static OdfStyleProperty Maximum =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "maximum"));

	public final static OdfStyleProperty MeanValue =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "mean-value"));

	public final static OdfStyleProperty Minimum =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "minimum"));

	public final static OdfStyleProperty Origin =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "origin"));

	public final static OdfStyleProperty Overlap =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "overlap"));

	public final static OdfStyleProperty Percentage =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "percentage"));

	public final static OdfStyleProperty PieOffset =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "pie-offset"));

	public final static OdfStyleProperty RegressionType =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "regression-type"));

	public final static OdfStyleProperty ReverseDirection =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "reverse-direction"));

	public final static OdfStyleProperty RightAngledAxes =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "right-angled-axes"));

	public final static OdfStyleProperty ScaleText =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "scale-text"));

	public final static OdfStyleProperty SeriesSource =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "series-source"));

	public final static OdfStyleProperty SolidType =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "solid-type"));

	public final static OdfStyleProperty SortByXValues =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "sort-by-x-values"));

	public final static OdfStyleProperty SplineOrder =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "spline-order"));

	public final static OdfStyleProperty SplineResolution =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "spline-resolution"));

	public final static OdfStyleProperty Stacked =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "stacked"));

	public final static OdfStyleProperty SymbolHeight =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "symbol-height"));

	public final static OdfStyleProperty SymbolName =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "symbol-name"));

	public final static OdfStyleProperty SymbolType =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "symbol-type"));

	public final static OdfStyleProperty SymbolWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "symbol-width"));

	public final static OdfStyleProperty TextOverlap =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "text-overlap"));

	public final static OdfStyleProperty ThreeDimensional =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "three-dimensional"));

	public final static OdfStyleProperty TickMarkPosition =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "tick-mark-position"));

	public final static OdfStyleProperty TickMarksMajorInner =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "tick-marks-major-inner"));

	public final static OdfStyleProperty TickMarksMajorOuter =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "tick-marks-major-outer"));

	public final static OdfStyleProperty TickMarksMinorInner =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "tick-marks-minor-inner"));

	public final static OdfStyleProperty TickMarksMinorOuter =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "tick-marks-minor-outer"));

	public final static OdfStyleProperty TreatEmptyCells =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "treat-empty-cells"));

	public final static OdfStyleProperty Vertical =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "vertical"));

	public final static OdfStyleProperty Visible =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.CHART, "visible"));

	public final static OdfStyleProperty Direction =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "direction"));

	public final static OdfStyleProperty RotationAngle =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "rotation-angle"));

	public final static OdfStyleProperty LineBreak =
		OdfStyleProperty.get(OdfStylePropertiesSet.ChartProperties, OdfName.newName(OdfDocumentNamespace.TEXT, "line-break"));

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartAngleOffsetAttribute</code> , See {@odf.attribute chart:angle-offset}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartAngleOffsetAttribute() {
		ChartAngleOffsetAttribute attr = (ChartAngleOffsetAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "angle-offset");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartAngleOffsetAttribute</code> , See {@odf.attribute chart:angle-offset}
	 *
	 * @param chartAngleOffsetValue   The type is <code>String</code>
	 */
	public void setChartAngleOffsetAttribute(String chartAngleOffsetValue) {
		ChartAngleOffsetAttribute attr = new ChartAngleOffsetAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartAngleOffsetValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartAutoPositionAttribute</code> , See {@odf.attribute chart:auto-position}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartAutoPositionAttribute() {
		ChartAutoPositionAttribute attr = (ChartAutoPositionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "auto-position");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartAutoPositionAttribute</code> , See {@odf.attribute chart:auto-position}
	 *
	 * @param chartAutoPositionValue   The type is <code>Boolean</code>
	 */
	public void setChartAutoPositionAttribute(Boolean chartAutoPositionValue) {
		ChartAutoPositionAttribute attr = new ChartAutoPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartAutoPositionValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartAutoSizeAttribute</code> , See {@odf.attribute chart:auto-size}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartAutoSizeAttribute() {
		ChartAutoSizeAttribute attr = (ChartAutoSizeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "auto-size");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartAutoSizeAttribute</code> , See {@odf.attribute chart:auto-size}
	 *
	 * @param chartAutoSizeValue   The type is <code>Boolean</code>
	 */
	public void setChartAutoSizeAttribute(Boolean chartAutoSizeValue) {
		ChartAutoSizeAttribute attr = new ChartAutoSizeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartAutoSizeValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartAxisLabelPositionAttribute</code> , See {@odf.attribute chart:axis-label-position}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartAxisLabelPositionAttribute() {
		ChartAxisLabelPositionAttribute attr = (ChartAxisLabelPositionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "axis-label-position");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartAxisLabelPositionAttribute</code> , See {@odf.attribute chart:axis-label-position}
	 *
	 * @param chartAxisLabelPositionValue   The type is <code>String</code>
	 */
	public void setChartAxisLabelPositionAttribute(String chartAxisLabelPositionValue) {
		ChartAxisLabelPositionAttribute attr = new ChartAxisLabelPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartAxisLabelPositionValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartAxisPositionAttribute</code> , See {@odf.attribute chart:axis-position}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartAxisPositionAttribute() {
		ChartAxisPositionAttribute attr = (ChartAxisPositionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "axis-position");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartAxisPositionAttribute</code> , See {@odf.attribute chart:axis-position}
	 *
	 * @param chartAxisPositionValue   The type is <code>Double</code>
	 */
	public void setChartAxisPositionAttribute(Double chartAxisPositionValue) {
		ChartAxisPositionAttribute attr = new ChartAxisPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartAxisPositionValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartConnectBarsAttribute</code> , See {@odf.attribute chart:connect-bars}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartConnectBarsAttribute() {
		ChartConnectBarsAttribute attr = (ChartConnectBarsAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "connect-bars");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartConnectBarsAttribute</code> , See {@odf.attribute chart:connect-bars}
	 *
	 * @param chartConnectBarsValue   The type is <code>Boolean</code>
	 */
	public void setChartConnectBarsAttribute(Boolean chartConnectBarsValue) {
		ChartConnectBarsAttribute attr = new ChartConnectBarsAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartConnectBarsValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartDataLabelNumberAttribute</code> , See {@odf.attribute chart:data-label-number}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartDataLabelNumberAttribute() {
		ChartDataLabelNumberAttribute attr = (ChartDataLabelNumberAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "data-label-number");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartDataLabelNumberAttribute</code> , See {@odf.attribute chart:data-label-number}
	 *
	 * @param chartDataLabelNumberValue   The type is <code>String</code>
	 */
	public void setChartDataLabelNumberAttribute(String chartDataLabelNumberValue) {
		ChartDataLabelNumberAttribute attr = new ChartDataLabelNumberAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartDataLabelNumberValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartDataLabelSymbolAttribute</code> , See {@odf.attribute chart:data-label-symbol}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartDataLabelSymbolAttribute() {
		ChartDataLabelSymbolAttribute attr = (ChartDataLabelSymbolAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "data-label-symbol");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartDataLabelSymbolAttribute</code> , See {@odf.attribute chart:data-label-symbol}
	 *
	 * @param chartDataLabelSymbolValue   The type is <code>Boolean</code>
	 */
	public void setChartDataLabelSymbolAttribute(Boolean chartDataLabelSymbolValue) {
		ChartDataLabelSymbolAttribute attr = new ChartDataLabelSymbolAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartDataLabelSymbolValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartDataLabelTextAttribute</code> , See {@odf.attribute chart:data-label-text}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartDataLabelTextAttribute() {
		ChartDataLabelTextAttribute attr = (ChartDataLabelTextAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "data-label-text");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartDataLabelTextAttribute</code> , See {@odf.attribute chart:data-label-text}
	 *
	 * @param chartDataLabelTextValue   The type is <code>Boolean</code>
	 */
	public void setChartDataLabelTextAttribute(Boolean chartDataLabelTextValue) {
		ChartDataLabelTextAttribute attr = new ChartDataLabelTextAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartDataLabelTextValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartDeepAttribute</code> , See {@odf.attribute chart:deep}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartDeepAttribute() {
		ChartDeepAttribute attr = (ChartDeepAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "deep");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartDeepAttribute</code> , See {@odf.attribute chart:deep}
	 *
	 * @param chartDeepValue   The type is <code>Boolean</code>
	 */
	public void setChartDeepAttribute(Boolean chartDeepValue) {
		ChartDeepAttribute attr = new ChartDeepAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartDeepValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartDisplayLabelAttribute</code> , See {@odf.attribute chart:display-label}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartDisplayLabelAttribute() {
		ChartDisplayLabelAttribute attr = (ChartDisplayLabelAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "display-label");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartDisplayLabelAttribute</code> , See {@odf.attribute chart:display-label}
	 *
	 * @param chartDisplayLabelValue   The type is <code>Boolean</code>
	 */
	public void setChartDisplayLabelAttribute(Boolean chartDisplayLabelValue) {
		ChartDisplayLabelAttribute attr = new ChartDisplayLabelAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartDisplayLabelValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorCategoryAttribute</code> , See {@odf.attribute chart:error-category}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartErrorCategoryAttribute() {
		ChartErrorCategoryAttribute attr = (ChartErrorCategoryAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-category");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorCategoryAttribute</code> , See {@odf.attribute chart:error-category}
	 *
	 * @param chartErrorCategoryValue   The type is <code>String</code>
	 */
	public void setChartErrorCategoryAttribute(String chartErrorCategoryValue) {
		ChartErrorCategoryAttribute attr = new ChartErrorCategoryAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartErrorCategoryValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorLowerIndicatorAttribute</code> , See {@odf.attribute chart:error-lower-indicator}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartErrorLowerIndicatorAttribute() {
		ChartErrorLowerIndicatorAttribute attr = (ChartErrorLowerIndicatorAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-lower-indicator");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorLowerIndicatorAttribute</code> , See {@odf.attribute chart:error-lower-indicator}
	 *
	 * @param chartErrorLowerIndicatorValue   The type is <code>Boolean</code>
	 */
	public void setChartErrorLowerIndicatorAttribute(Boolean chartErrorLowerIndicatorValue) {
		ChartErrorLowerIndicatorAttribute attr = new ChartErrorLowerIndicatorAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartErrorLowerIndicatorValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorLowerLimitAttribute</code> , See {@odf.attribute chart:error-lower-limit}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartErrorLowerLimitAttribute() {
		ChartErrorLowerLimitAttribute attr = (ChartErrorLowerLimitAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-lower-limit");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorLowerLimitAttribute</code> , See {@odf.attribute chart:error-lower-limit}
	 *
	 * @param chartErrorLowerLimitValue   The type is <code>Double</code>
	 */
	public void setChartErrorLowerLimitAttribute(Double chartErrorLowerLimitValue) {
		ChartErrorLowerLimitAttribute attr = new ChartErrorLowerLimitAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartErrorLowerLimitValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorLowerRangeAttribute</code> , See {@odf.attribute chart:error-lower-range}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartErrorLowerRangeAttribute() {
		ChartErrorLowerRangeAttribute attr = (ChartErrorLowerRangeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-lower-range");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorLowerRangeAttribute</code> , See {@odf.attribute chart:error-lower-range}
	 *
	 * @param chartErrorLowerRangeValue   The type is <code>String</code>
	 */
	public void setChartErrorLowerRangeAttribute(String chartErrorLowerRangeValue) {
		ChartErrorLowerRangeAttribute attr = new ChartErrorLowerRangeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartErrorLowerRangeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorMarginAttribute</code> , See {@odf.attribute chart:error-margin}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartErrorMarginAttribute() {
		ChartErrorMarginAttribute attr = (ChartErrorMarginAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-margin");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorMarginAttribute</code> , See {@odf.attribute chart:error-margin}
	 *
	 * @param chartErrorMarginValue   The type is <code>Double</code>
	 */
	public void setChartErrorMarginAttribute(Double chartErrorMarginValue) {
		ChartErrorMarginAttribute attr = new ChartErrorMarginAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartErrorMarginValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorPercentageAttribute</code> , See {@odf.attribute chart:error-percentage}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartErrorPercentageAttribute() {
		ChartErrorPercentageAttribute attr = (ChartErrorPercentageAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-percentage");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorPercentageAttribute</code> , See {@odf.attribute chart:error-percentage}
	 *
	 * @param chartErrorPercentageValue   The type is <code>Double</code>
	 */
	public void setChartErrorPercentageAttribute(Double chartErrorPercentageValue) {
		ChartErrorPercentageAttribute attr = new ChartErrorPercentageAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartErrorPercentageValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorUpperIndicatorAttribute</code> , See {@odf.attribute chart:error-upper-indicator}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartErrorUpperIndicatorAttribute() {
		ChartErrorUpperIndicatorAttribute attr = (ChartErrorUpperIndicatorAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-upper-indicator");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorUpperIndicatorAttribute</code> , See {@odf.attribute chart:error-upper-indicator}
	 *
	 * @param chartErrorUpperIndicatorValue   The type is <code>Boolean</code>
	 */
	public void setChartErrorUpperIndicatorAttribute(Boolean chartErrorUpperIndicatorValue) {
		ChartErrorUpperIndicatorAttribute attr = new ChartErrorUpperIndicatorAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartErrorUpperIndicatorValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorUpperLimitAttribute</code> , See {@odf.attribute chart:error-upper-limit}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartErrorUpperLimitAttribute() {
		ChartErrorUpperLimitAttribute attr = (ChartErrorUpperLimitAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-upper-limit");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorUpperLimitAttribute</code> , See {@odf.attribute chart:error-upper-limit}
	 *
	 * @param chartErrorUpperLimitValue   The type is <code>Double</code>
	 */
	public void setChartErrorUpperLimitAttribute(Double chartErrorUpperLimitValue) {
		ChartErrorUpperLimitAttribute attr = new ChartErrorUpperLimitAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartErrorUpperLimitValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartErrorUpperRangeAttribute</code> , See {@odf.attribute chart:error-upper-range}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartErrorUpperRangeAttribute() {
		ChartErrorUpperRangeAttribute attr = (ChartErrorUpperRangeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "error-upper-range");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartErrorUpperRangeAttribute</code> , See {@odf.attribute chart:error-upper-range}
	 *
	 * @param chartErrorUpperRangeValue   The type is <code>String</code>
	 */
	public void setChartErrorUpperRangeAttribute(String chartErrorUpperRangeValue) {
		ChartErrorUpperRangeAttribute attr = new ChartErrorUpperRangeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartErrorUpperRangeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartGapWidthAttribute</code> , See {@odf.attribute chart:gap-width}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getChartGapWidthAttribute() {
		ChartGapWidthAttribute attr = (ChartGapWidthAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "gap-width");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartGapWidthAttribute</code> , See {@odf.attribute chart:gap-width}
	 *
	 * @param chartGapWidthValue   The type is <code>Integer</code>
	 */
	public void setChartGapWidthAttribute(Integer chartGapWidthValue) {
		ChartGapWidthAttribute attr = new ChartGapWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(chartGapWidthValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartGroupBarsPerAxisAttribute</code> , See {@odf.attribute chart:group-bars-per-axis}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartGroupBarsPerAxisAttribute() {
		ChartGroupBarsPerAxisAttribute attr = (ChartGroupBarsPerAxisAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "group-bars-per-axis");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartGroupBarsPerAxisAttribute</code> , See {@odf.attribute chart:group-bars-per-axis}
	 *
	 * @param chartGroupBarsPerAxisValue   The type is <code>Boolean</code>
	 */
	public void setChartGroupBarsPerAxisAttribute(Boolean chartGroupBarsPerAxisValue) {
		ChartGroupBarsPerAxisAttribute attr = new ChartGroupBarsPerAxisAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartGroupBarsPerAxisValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartHoleSizeAttribute</code> , See {@odf.attribute chart:hole-size}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartHoleSizeAttribute() {
		ChartHoleSizeAttribute attr = (ChartHoleSizeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "hole-size");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartHoleSizeAttribute</code> , See {@odf.attribute chart:hole-size}
	 *
	 * @param chartHoleSizeValue   The type is <code>String</code>
	 */
	public void setChartHoleSizeAttribute(String chartHoleSizeValue) {
		ChartHoleSizeAttribute attr = new ChartHoleSizeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartHoleSizeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartIncludeHiddenCellsAttribute</code> , See {@odf.attribute chart:include-hidden-cells}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartIncludeHiddenCellsAttribute() {
		ChartIncludeHiddenCellsAttribute attr = (ChartIncludeHiddenCellsAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "include-hidden-cells");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartIncludeHiddenCellsAttribute</code> , See {@odf.attribute chart:include-hidden-cells}
	 *
	 * @param chartIncludeHiddenCellsValue   The type is <code>Boolean</code>
	 */
	public void setChartIncludeHiddenCellsAttribute(Boolean chartIncludeHiddenCellsValue) {
		ChartIncludeHiddenCellsAttribute attr = new ChartIncludeHiddenCellsAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartIncludeHiddenCellsValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartInterpolationAttribute</code> , See {@odf.attribute chart:interpolation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartInterpolationAttribute() {
		ChartInterpolationAttribute attr = (ChartInterpolationAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "interpolation");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartInterpolationAttribute</code> , See {@odf.attribute chart:interpolation}
	 *
	 * @param chartInterpolationValue   The type is <code>String</code>
	 */
	public void setChartInterpolationAttribute(String chartInterpolationValue) {
		ChartInterpolationAttribute attr = new ChartInterpolationAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartInterpolationValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartIntervalMajorAttribute</code> , See {@odf.attribute chart:interval-major}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartIntervalMajorAttribute() {
		ChartIntervalMajorAttribute attr = (ChartIntervalMajorAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "interval-major");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartIntervalMajorAttribute</code> , See {@odf.attribute chart:interval-major}
	 *
	 * @param chartIntervalMajorValue   The type is <code>Double</code>
	 */
	public void setChartIntervalMajorAttribute(Double chartIntervalMajorValue) {
		ChartIntervalMajorAttribute attr = new ChartIntervalMajorAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartIntervalMajorValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartIntervalMinorDivisorAttribute</code> , See {@odf.attribute chart:interval-minor-divisor}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getChartIntervalMinorDivisorAttribute() {
		ChartIntervalMinorDivisorAttribute attr = (ChartIntervalMinorDivisorAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "interval-minor-divisor");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartIntervalMinorDivisorAttribute</code> , See {@odf.attribute chart:interval-minor-divisor}
	 *
	 * @param chartIntervalMinorDivisorValue   The type is <code>Integer</code>
	 */
	public void setChartIntervalMinorDivisorAttribute(Integer chartIntervalMinorDivisorValue) {
		ChartIntervalMinorDivisorAttribute attr = new ChartIntervalMinorDivisorAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(chartIntervalMinorDivisorValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartJapaneseCandleStickAttribute</code> , See {@odf.attribute chart:japanese-candle-stick}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartJapaneseCandleStickAttribute() {
		ChartJapaneseCandleStickAttribute attr = (ChartJapaneseCandleStickAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "japanese-candle-stick");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartJapaneseCandleStickAttribute</code> , See {@odf.attribute chart:japanese-candle-stick}
	 *
	 * @param chartJapaneseCandleStickValue   The type is <code>Boolean</code>
	 */
	public void setChartJapaneseCandleStickAttribute(Boolean chartJapaneseCandleStickValue) {
		ChartJapaneseCandleStickAttribute attr = new ChartJapaneseCandleStickAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartJapaneseCandleStickValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartLabelArrangementAttribute</code> , See {@odf.attribute chart:label-arrangement}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartLabelArrangementAttribute() {
		ChartLabelArrangementAttribute attr = (ChartLabelArrangementAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "label-arrangement");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartLabelArrangementAttribute</code> , See {@odf.attribute chart:label-arrangement}
	 *
	 * @param chartLabelArrangementValue   The type is <code>String</code>
	 */
	public void setChartLabelArrangementAttribute(String chartLabelArrangementValue) {
		ChartLabelArrangementAttribute attr = new ChartLabelArrangementAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartLabelArrangementValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartLabelPositionAttribute</code> , See {@odf.attribute chart:label-position}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartLabelPositionAttribute() {
		ChartLabelPositionAttribute attr = (ChartLabelPositionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "label-position");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartLabelPositionAttribute</code> , See {@odf.attribute chart:label-position}
	 *
	 * @param chartLabelPositionValue   The type is <code>String</code>
	 */
	public void setChartLabelPositionAttribute(String chartLabelPositionValue) {
		ChartLabelPositionAttribute attr = new ChartLabelPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartLabelPositionValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartLabelPositionNegativeAttribute</code> , See {@odf.attribute chart:label-position-negative}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartLabelPositionNegativeAttribute() {
		ChartLabelPositionNegativeAttribute attr = (ChartLabelPositionNegativeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "label-position-negative");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartLabelPositionNegativeAttribute</code> , See {@odf.attribute chart:label-position-negative}
	 *
	 * @param chartLabelPositionNegativeValue   The type is <code>String</code>
	 */
	public void setChartLabelPositionNegativeAttribute(String chartLabelPositionNegativeValue) {
		ChartLabelPositionNegativeAttribute attr = new ChartLabelPositionNegativeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartLabelPositionNegativeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartLinesAttribute</code> , See {@odf.attribute chart:lines}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartLinesAttribute() {
		ChartLinesAttribute attr = (ChartLinesAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "lines");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartLinesAttribute</code> , See {@odf.attribute chart:lines}
	 *
	 * @param chartLinesValue   The type is <code>Boolean</code>
	 */
	public void setChartLinesAttribute(Boolean chartLinesValue) {
		ChartLinesAttribute attr = new ChartLinesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartLinesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartLinkDataStyleToSourceAttribute</code> , See {@odf.attribute chart:link-data-style-to-source}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartLinkDataStyleToSourceAttribute() {
		ChartLinkDataStyleToSourceAttribute attr = (ChartLinkDataStyleToSourceAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "link-data-style-to-source");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartLinkDataStyleToSourceAttribute</code> , See {@odf.attribute chart:link-data-style-to-source}
	 *
	 * @param chartLinkDataStyleToSourceValue   The type is <code>Boolean</code>
	 */
	public void setChartLinkDataStyleToSourceAttribute(Boolean chartLinkDataStyleToSourceValue) {
		ChartLinkDataStyleToSourceAttribute attr = new ChartLinkDataStyleToSourceAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartLinkDataStyleToSourceValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartLogarithmicAttribute</code> , See {@odf.attribute chart:logarithmic}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartLogarithmicAttribute() {
		ChartLogarithmicAttribute attr = (ChartLogarithmicAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "logarithmic");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartLogarithmicAttribute</code> , See {@odf.attribute chart:logarithmic}
	 *
	 * @param chartLogarithmicValue   The type is <code>Boolean</code>
	 */
	public void setChartLogarithmicAttribute(Boolean chartLogarithmicValue) {
		ChartLogarithmicAttribute attr = new ChartLogarithmicAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartLogarithmicValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartMaximumAttribute</code> , See {@odf.attribute chart:maximum}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartMaximumAttribute() {
		ChartMaximumAttribute attr = (ChartMaximumAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "maximum");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartMaximumAttribute</code> , See {@odf.attribute chart:maximum}
	 *
	 * @param chartMaximumValue   The type is <code>Double</code>
	 */
	public void setChartMaximumAttribute(Double chartMaximumValue) {
		ChartMaximumAttribute attr = new ChartMaximumAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartMaximumValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartMeanValueAttribute</code> , See {@odf.attribute chart:mean-value}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartMeanValueAttribute() {
		ChartMeanValueAttribute attr = (ChartMeanValueAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "mean-value");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartMeanValueAttribute</code> , See {@odf.attribute chart:mean-value}
	 *
	 * @param chartMeanValueValue   The type is <code>Boolean</code>
	 */
	public void setChartMeanValueAttribute(Boolean chartMeanValueValue) {
		ChartMeanValueAttribute attr = new ChartMeanValueAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartMeanValueValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartMinimumAttribute</code> , See {@odf.attribute chart:minimum}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartMinimumAttribute() {
		ChartMinimumAttribute attr = (ChartMinimumAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "minimum");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartMinimumAttribute</code> , See {@odf.attribute chart:minimum}
	 *
	 * @param chartMinimumValue   The type is <code>Double</code>
	 */
	public void setChartMinimumAttribute(Double chartMinimumValue) {
		ChartMinimumAttribute attr = new ChartMinimumAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartMinimumValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartOriginAttribute</code> , See {@odf.attribute chart:origin}
	 *
	 * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Double getChartOriginAttribute() {
		ChartOriginAttribute attr = (ChartOriginAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "origin");
		if (attr != null) {
			return Double.valueOf(attr.doubleValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartOriginAttribute</code> , See {@odf.attribute chart:origin}
	 *
	 * @param chartOriginValue   The type is <code>Double</code>
	 */
	public void setChartOriginAttribute(Double chartOriginValue) {
		ChartOriginAttribute attr = new ChartOriginAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setDoubleValue(chartOriginValue.doubleValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartOverlapAttribute</code> , See {@odf.attribute chart:overlap}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getChartOverlapAttribute() {
		ChartOverlapAttribute attr = (ChartOverlapAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "overlap");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartOverlapAttribute</code> , See {@odf.attribute chart:overlap}
	 *
	 * @param chartOverlapValue   The type is <code>Integer</code>
	 */
	public void setChartOverlapAttribute(Integer chartOverlapValue) {
		ChartOverlapAttribute attr = new ChartOverlapAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(chartOverlapValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartPercentageAttribute</code> , See {@odf.attribute chart:percentage}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartPercentageAttribute() {
		ChartPercentageAttribute attr = (ChartPercentageAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "percentage");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartPercentageAttribute</code> , See {@odf.attribute chart:percentage}
	 *
	 * @param chartPercentageValue   The type is <code>Boolean</code>
	 */
	public void setChartPercentageAttribute(Boolean chartPercentageValue) {
		ChartPercentageAttribute attr = new ChartPercentageAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartPercentageValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartPieOffsetAttribute</code> , See {@odf.attribute chart:pie-offset}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getChartPieOffsetAttribute() {
		ChartPieOffsetAttribute attr = (ChartPieOffsetAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "pie-offset");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartPieOffsetAttribute</code> , See {@odf.attribute chart:pie-offset}
	 *
	 * @param chartPieOffsetValue   The type is <code>Integer</code>
	 */
	public void setChartPieOffsetAttribute(Integer chartPieOffsetValue) {
		ChartPieOffsetAttribute attr = new ChartPieOffsetAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(chartPieOffsetValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartRegressionTypeAttribute</code> , See {@odf.attribute chart:regression-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartRegressionTypeAttribute() {
		ChartRegressionTypeAttribute attr = (ChartRegressionTypeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "regression-type");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartRegressionTypeAttribute</code> , See {@odf.attribute chart:regression-type}
	 *
	 * @param chartRegressionTypeValue   The type is <code>String</code>
	 */
	public void setChartRegressionTypeAttribute(String chartRegressionTypeValue) {
		ChartRegressionTypeAttribute attr = new ChartRegressionTypeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartRegressionTypeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartReverseDirectionAttribute</code> , See {@odf.attribute chart:reverse-direction}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartReverseDirectionAttribute() {
		ChartReverseDirectionAttribute attr = (ChartReverseDirectionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "reverse-direction");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartReverseDirectionAttribute</code> , See {@odf.attribute chart:reverse-direction}
	 *
	 * @param chartReverseDirectionValue   The type is <code>Boolean</code>
	 */
	public void setChartReverseDirectionAttribute(Boolean chartReverseDirectionValue) {
		ChartReverseDirectionAttribute attr = new ChartReverseDirectionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartReverseDirectionValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartRightAngledAxesAttribute</code> , See {@odf.attribute chart:right-angled-axes}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartRightAngledAxesAttribute() {
		ChartRightAngledAxesAttribute attr = (ChartRightAngledAxesAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "right-angled-axes");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartRightAngledAxesAttribute</code> , See {@odf.attribute chart:right-angled-axes}
	 *
	 * @param chartRightAngledAxesValue   The type is <code>Boolean</code>
	 */
	public void setChartRightAngledAxesAttribute(Boolean chartRightAngledAxesValue) {
		ChartRightAngledAxesAttribute attr = new ChartRightAngledAxesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartRightAngledAxesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartScaleTextAttribute</code> , See {@odf.attribute chart:scale-text}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartScaleTextAttribute() {
		ChartScaleTextAttribute attr = (ChartScaleTextAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "scale-text");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartScaleTextAttribute</code> , See {@odf.attribute chart:scale-text}
	 *
	 * @param chartScaleTextValue   The type is <code>Boolean</code>
	 */
	public void setChartScaleTextAttribute(Boolean chartScaleTextValue) {
		ChartScaleTextAttribute attr = new ChartScaleTextAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartScaleTextValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSeriesSourceAttribute</code> , See {@odf.attribute chart:series-source}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartSeriesSourceAttribute() {
		ChartSeriesSourceAttribute attr = (ChartSeriesSourceAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "series-source");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSeriesSourceAttribute</code> , See {@odf.attribute chart:series-source}
	 *
	 * @param chartSeriesSourceValue   The type is <code>String</code>
	 */
	public void setChartSeriesSourceAttribute(String chartSeriesSourceValue) {
		ChartSeriesSourceAttribute attr = new ChartSeriesSourceAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartSeriesSourceValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSolidTypeAttribute</code> , See {@odf.attribute chart:solid-type}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartSolidTypeAttribute() {
		ChartSolidTypeAttribute attr = (ChartSolidTypeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "solid-type");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSolidTypeAttribute</code> , See {@odf.attribute chart:solid-type}
	 *
	 * @param chartSolidTypeValue   The type is <code>String</code>
	 */
	public void setChartSolidTypeAttribute(String chartSolidTypeValue) {
		ChartSolidTypeAttribute attr = new ChartSolidTypeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartSolidTypeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSortByXValuesAttribute</code> , See {@odf.attribute chart:sort-by-x-values}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartSortByXValuesAttribute() {
		ChartSortByXValuesAttribute attr = (ChartSortByXValuesAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "sort-by-x-values");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSortByXValuesAttribute</code> , See {@odf.attribute chart:sort-by-x-values}
	 *
	 * @param chartSortByXValuesValue   The type is <code>Boolean</code>
	 */
	public void setChartSortByXValuesAttribute(Boolean chartSortByXValuesValue) {
		ChartSortByXValuesAttribute attr = new ChartSortByXValuesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartSortByXValuesValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSplineOrderAttribute</code> , See {@odf.attribute chart:spline-order}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getChartSplineOrderAttribute() {
		ChartSplineOrderAttribute attr = (ChartSplineOrderAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "spline-order");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSplineOrderAttribute</code> , See {@odf.attribute chart:spline-order}
	 *
	 * @param chartSplineOrderValue   The type is <code>Integer</code>
	 */
	public void setChartSplineOrderAttribute(Integer chartSplineOrderValue) {
		ChartSplineOrderAttribute attr = new ChartSplineOrderAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(chartSplineOrderValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSplineResolutionAttribute</code> , See {@odf.attribute chart:spline-resolution}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getChartSplineResolutionAttribute() {
		ChartSplineResolutionAttribute attr = (ChartSplineResolutionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "spline-resolution");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSplineResolutionAttribute</code> , See {@odf.attribute chart:spline-resolution}
	 *
	 * @param chartSplineResolutionValue   The type is <code>Integer</code>
	 */
	public void setChartSplineResolutionAttribute(Integer chartSplineResolutionValue) {
		ChartSplineResolutionAttribute attr = new ChartSplineResolutionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(chartSplineResolutionValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartStackedAttribute</code> , See {@odf.attribute chart:stacked}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartStackedAttribute() {
		ChartStackedAttribute attr = (ChartStackedAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "stacked");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartStackedAttribute</code> , See {@odf.attribute chart:stacked}
	 *
	 * @param chartStackedValue   The type is <code>Boolean</code>
	 */
	public void setChartStackedAttribute(Boolean chartStackedValue) {
		ChartStackedAttribute attr = new ChartStackedAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartStackedValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSymbolHeightAttribute</code> , See {@odf.attribute chart:symbol-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartSymbolHeightAttribute() {
		ChartSymbolHeightAttribute attr = (ChartSymbolHeightAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "symbol-height");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSymbolHeightAttribute</code> , See {@odf.attribute chart:symbol-height}
	 *
	 * @param chartSymbolHeightValue   The type is <code>String</code>
	 */
	public void setChartSymbolHeightAttribute(String chartSymbolHeightValue) {
		ChartSymbolHeightAttribute attr = new ChartSymbolHeightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartSymbolHeightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSymbolNameAttribute</code> , See {@odf.attribute chart:symbol-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartSymbolNameAttribute() {
		ChartSymbolNameAttribute attr = (ChartSymbolNameAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "symbol-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSymbolNameAttribute</code> , See {@odf.attribute chart:symbol-name}
	 *
	 * @param chartSymbolNameValue   The type is <code>String</code>
	 */
	public void setChartSymbolNameAttribute(String chartSymbolNameValue) {
		ChartSymbolNameAttribute attr = new ChartSymbolNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartSymbolNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSymbolTypeAttribute</code> , See {@odf.attribute chart:symbol-type}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartSymbolTypeAttribute() {
		ChartSymbolTypeAttribute attr = (ChartSymbolTypeAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "symbol-type");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSymbolTypeAttribute</code> , See {@odf.attribute chart:symbol-type}
	 *
	 * @param chartSymbolTypeValue   The type is <code>String</code>
	 */
	public void setChartSymbolTypeAttribute(String chartSymbolTypeValue) {
		ChartSymbolTypeAttribute attr = new ChartSymbolTypeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartSymbolTypeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartSymbolWidthAttribute</code> , See {@odf.attribute chart:symbol-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartSymbolWidthAttribute() {
		ChartSymbolWidthAttribute attr = (ChartSymbolWidthAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "symbol-width");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartSymbolWidthAttribute</code> , See {@odf.attribute chart:symbol-width}
	 *
	 * @param chartSymbolWidthValue   The type is <code>String</code>
	 */
	public void setChartSymbolWidthAttribute(String chartSymbolWidthValue) {
		ChartSymbolWidthAttribute attr = new ChartSymbolWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartSymbolWidthValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTextOverlapAttribute</code> , See {@odf.attribute chart:text-overlap}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartTextOverlapAttribute() {
		ChartTextOverlapAttribute attr = (ChartTextOverlapAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "text-overlap");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTextOverlapAttribute</code> , See {@odf.attribute chart:text-overlap}
	 *
	 * @param chartTextOverlapValue   The type is <code>Boolean</code>
	 */
	public void setChartTextOverlapAttribute(Boolean chartTextOverlapValue) {
		ChartTextOverlapAttribute attr = new ChartTextOverlapAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartTextOverlapValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartThreeDimensionalAttribute</code> , See {@odf.attribute chart:three-dimensional}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartThreeDimensionalAttribute() {
		ChartThreeDimensionalAttribute attr = (ChartThreeDimensionalAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "three-dimensional");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartThreeDimensionalAttribute</code> , See {@odf.attribute chart:three-dimensional}
	 *
	 * @param chartThreeDimensionalValue   The type is <code>Boolean</code>
	 */
	public void setChartThreeDimensionalAttribute(Boolean chartThreeDimensionalValue) {
		ChartThreeDimensionalAttribute attr = new ChartThreeDimensionalAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartThreeDimensionalValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTickMarkPositionAttribute</code> , See {@odf.attribute chart:tick-mark-position}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartTickMarkPositionAttribute() {
		ChartTickMarkPositionAttribute attr = (ChartTickMarkPositionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "tick-mark-position");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTickMarkPositionAttribute</code> , See {@odf.attribute chart:tick-mark-position}
	 *
	 * @param chartTickMarkPositionValue   The type is <code>String</code>
	 */
	public void setChartTickMarkPositionAttribute(String chartTickMarkPositionValue) {
		ChartTickMarkPositionAttribute attr = new ChartTickMarkPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartTickMarkPositionValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTickMarksMajorInnerAttribute</code> , See {@odf.attribute chart:tick-marks-major-inner}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartTickMarksMajorInnerAttribute() {
		ChartTickMarksMajorInnerAttribute attr = (ChartTickMarksMajorInnerAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "tick-marks-major-inner");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTickMarksMajorInnerAttribute</code> , See {@odf.attribute chart:tick-marks-major-inner}
	 *
	 * @param chartTickMarksMajorInnerValue   The type is <code>Boolean</code>
	 */
	public void setChartTickMarksMajorInnerAttribute(Boolean chartTickMarksMajorInnerValue) {
		ChartTickMarksMajorInnerAttribute attr = new ChartTickMarksMajorInnerAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartTickMarksMajorInnerValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTickMarksMajorOuterAttribute</code> , See {@odf.attribute chart:tick-marks-major-outer}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartTickMarksMajorOuterAttribute() {
		ChartTickMarksMajorOuterAttribute attr = (ChartTickMarksMajorOuterAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "tick-marks-major-outer");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTickMarksMajorOuterAttribute</code> , See {@odf.attribute chart:tick-marks-major-outer}
	 *
	 * @param chartTickMarksMajorOuterValue   The type is <code>Boolean</code>
	 */
	public void setChartTickMarksMajorOuterAttribute(Boolean chartTickMarksMajorOuterValue) {
		ChartTickMarksMajorOuterAttribute attr = new ChartTickMarksMajorOuterAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartTickMarksMajorOuterValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTickMarksMinorInnerAttribute</code> , See {@odf.attribute chart:tick-marks-minor-inner}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartTickMarksMinorInnerAttribute() {
		ChartTickMarksMinorInnerAttribute attr = (ChartTickMarksMinorInnerAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "tick-marks-minor-inner");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTickMarksMinorInnerAttribute</code> , See {@odf.attribute chart:tick-marks-minor-inner}
	 *
	 * @param chartTickMarksMinorInnerValue   The type is <code>Boolean</code>
	 */
	public void setChartTickMarksMinorInnerAttribute(Boolean chartTickMarksMinorInnerValue) {
		ChartTickMarksMinorInnerAttribute attr = new ChartTickMarksMinorInnerAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartTickMarksMinorInnerValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTickMarksMinorOuterAttribute</code> , See {@odf.attribute chart:tick-marks-minor-outer}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartTickMarksMinorOuterAttribute() {
		ChartTickMarksMinorOuterAttribute attr = (ChartTickMarksMinorOuterAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "tick-marks-minor-outer");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTickMarksMinorOuterAttribute</code> , See {@odf.attribute chart:tick-marks-minor-outer}
	 *
	 * @param chartTickMarksMinorOuterValue   The type is <code>Boolean</code>
	 */
	public void setChartTickMarksMinorOuterAttribute(Boolean chartTickMarksMinorOuterValue) {
		ChartTickMarksMinorOuterAttribute attr = new ChartTickMarksMinorOuterAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartTickMarksMinorOuterValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartTreatEmptyCellsAttribute</code> , See {@odf.attribute chart:treat-empty-cells}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getChartTreatEmptyCellsAttribute() {
		ChartTreatEmptyCellsAttribute attr = (ChartTreatEmptyCellsAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "treat-empty-cells");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartTreatEmptyCellsAttribute</code> , See {@odf.attribute chart:treat-empty-cells}
	 *
	 * @param chartTreatEmptyCellsValue   The type is <code>String</code>
	 */
	public void setChartTreatEmptyCellsAttribute(String chartTreatEmptyCellsValue) {
		ChartTreatEmptyCellsAttribute attr = new ChartTreatEmptyCellsAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(chartTreatEmptyCellsValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartVerticalAttribute</code> , See {@odf.attribute chart:vertical}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartVerticalAttribute() {
		ChartVerticalAttribute attr = (ChartVerticalAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "vertical");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartVerticalAttribute</code> , See {@odf.attribute chart:vertical}
	 *
	 * @param chartVerticalValue   The type is <code>Boolean</code>
	 */
	public void setChartVerticalAttribute(Boolean chartVerticalValue) {
		ChartVerticalAttribute attr = new ChartVerticalAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartVerticalValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>ChartVisibleAttribute</code> , See {@odf.attribute chart:visible}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getChartVisibleAttribute() {
		ChartVisibleAttribute attr = (ChartVisibleAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "visible");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>ChartVisibleAttribute</code> , See {@odf.attribute chart:visible}
	 *
	 * @param chartVisibleValue   The type is <code>Boolean</code>
	 */
	public void setChartVisibleAttribute(Boolean chartVisibleValue) {
		ChartVisibleAttribute attr = new ChartVisibleAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(chartVisibleValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleDirectionAttribute</code> , See {@odf.attribute style:direction}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleDirectionAttribute() {
		StyleDirectionAttribute attr = (StyleDirectionAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "direction");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleDirectionAttribute</code> , See {@odf.attribute style:direction}
	 *
	 * @param styleDirectionValue   The type is <code>String</code>
	 */
	public void setStyleDirectionAttribute(String styleDirectionValue) {
		StyleDirectionAttribute attr = new StyleDirectionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleDirectionValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRotationAngleAttribute</code> , See {@odf.attribute style:rotation-angle}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRotationAngleAttribute() {
		StyleRotationAngleAttribute attr = (StyleRotationAngleAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "rotation-angle");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRotationAngleAttribute</code> , See {@odf.attribute style:rotation-angle}
	 *
	 * @param styleRotationAngleValue   The type is <code>String</code>
	 */
	public void setStyleRotationAngleAttribute(String styleRotationAngleValue) {
		StyleRotationAngleAttribute attr = new StyleRotationAngleAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleRotationAngleValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TextLineBreakAttribute</code> , See {@odf.attribute text:line-break}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTextLineBreakAttribute() {
		TextLineBreakAttribute attr = (TextLineBreakAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "line-break");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TextLineBreakAttribute</code> , See {@odf.attribute text:line-break}
	 *
	 * @param textLineBreakValue   The type is <code>Boolean</code>
	 */
	public void setTextLineBreakAttribute(Boolean textLineBreakValue) {
		TextLineBreakAttribute attr = new TextLineBreakAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(textLineBreakValue.booleanValue());
	}

	/**
	 * Create child element {@odf.element chart:label-separator}.
	 *
	 * Child element is new in Odf 1.2
	 *
	 * @return the element {@odf.element chart:label-separator}
	 */
	public ChartLabelSeparatorElement newChartLabelSeparatorElement() {
		ChartLabelSeparatorElement chartLabelSeparator = ((OdfFileDom) this.ownerDocument).newOdfElement(ChartLabelSeparatorElement.class);
		this.appendChild(chartLabelSeparator);
		return chartLabelSeparator;
	}

	/**
	 * Create child element {@odf.element chart:symbol-image}.
	 *
	 * @param xlinkHrefValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * Child element is new in Odf 1.2
	 *
	 * @return the element {@odf.element chart:symbol-image}
	 */
	 public ChartSymbolImageElement newChartSymbolImageElement(String xlinkHrefValue) {
		ChartSymbolImageElement chartSymbolImage = ((OdfFileDom) this.ownerDocument).newOdfElement(ChartSymbolImageElement.class);
		chartSymbolImage.setXlinkHrefAttribute(xlinkHrefValue);
		this.appendChild(chartSymbolImage);
		return chartSymbolImage;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
