
#-----------------------------------------------------------------------------
# Options for HDF4 Filters
#-----------------------------------------------------------------------------
option (USE_LIBAEC_STATIC "Use static AEC library " OFF)
option (JPEG_USE_EXTERNAL "Use External Library Building for JPEG" OFF)
option (ZLIB_USE_EXTERNAL "Use External Library Building for ZLIB" OFF)
option (SZIP_USE_EXTERNAL "Use External Library Building for SZIP" OFF)

if (NOT JPEG_USE_LOCALCONTENT)
  set (JPEG_URL ${JPEG_TGZ_ORIGPATH}/${JPEG_TGZ_NAME})
else ()
  set (JPEG_URL ${TGZPATH}/${JPEG_TGZ_NAME})
endif ()
message (VERBOSE "Filter JPEG file is ${JPEG_URL}")

if (NOT ZLIB_USE_LOCALCONTENT)
  set (ZLIB_URL ${ZLIB_TGZ_ORIGPATH}/${ZLIB_TGZ_NAME})
else ()
  set (ZLIB_URL ${TGZPATH}/${ZLIB_TGZ_NAME})
endif ()
message (VERBOSE "Filter ZLIB file is ${ZLIB_URL}")

if (NOT LIBAEC_USE_LOCALCONTENT)
  set (SZIP_URL ${LIBAEC_TGZ_ORIGPATH}/${LIBAEC_TGZ_NAME})
else ()
  set (SZIP_URL ${TGZPATH}/${LIBAEC_TGZ_NAME})
endif ()
message (VERBOSE "Filter SZIP file is ${SZIP_URL}")

include (ExternalProject)
#option (HDF4_ALLOW_EXTERNAL_SUPPORT "Allow External Library Building (NO GIT TGZ)" "NO")
set (HDF4_ALLOW_EXTERNAL_SUPPORT "NO" CACHE STRING "Allow External Library Building (NO GIT TGZ)")
set_property (CACHE HDF4_ALLOW_EXTERNAL_SUPPORT PROPERTY STRINGS NO GIT TGZ)
if (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  set (JPEG_USE_EXTERNAL ON CACHE BOOL "Use External Library Building for JPEG" FORCE)
  set (ZLIB_USE_EXTERNAL ON CACHE BOOL "Use External Library Building for ZLIB" FORCE)
  set (SZIP_USE_EXTERNAL ON CACHE BOOL "Use External Library Building for SZIP" FORCE)
  if (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT")
    set (JPEG_URL ${JPEG_GIT_URL} CACHE STRING "Path to jpeg git repository")
    set (JPEG_BRANCH ${JPEG_GIT_BRANCH})
    set (ZLIB_URL ${ZLIB_GIT_URL} CACHE STRING "Path to zlib git repository")
    set (ZLIB_BRANCH ${ZLIB_GIT_BRANCH})
    set (SZIP_URL ${LIBAEC_GIT_URL} CACHE STRING "Path to szip git repository")
    set (SZIP_BRANCH ${LIBAEC_GIT_BRANCH})
  elseif (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    if (NOT TGZPATH)
      set (TGZPATH ${HDF4_SOURCE_DIR})
    endif ()
    if (JPEG_USE_LOCALCONTENT)
      if (NOT EXISTS "${JPEG_URL}")
        set (HDF4_ENABLE_JPEG_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
        message (FATAL_ERROR "Filter JPEG support in HDF4 is required but file ${JPEG_URL} not found")
      endif ()
    endif ()
    if (ZLIB_USE_LOCALCONTENT)
      if (NOT EXISTS "${ZLIB_URL}")
        set (HDF4_ENABLE_Z_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
        message (FATAL_ERROR "Filter ZLIB support in HDF4 is required but file ${ZLIB_URL} not found")
      endif ()
    endif ()
    if (LIBAEC_USE_LOCALCONTENT)
      if (NOT EXISTS "${SZIP_URL}")
        set (HDF4_ENABLE_SZIP_SUPPORT OFF CACHE BOOL "" FORCE)
        message (VERBOSE "Filter SZIP file ${SZIP_URL} not found")
      endif ()
    endif ()
  else ()
    set (HDF4_ENABLE_JPEG_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
    set (JPEG_USE_EXTERNAL OFF CACHE BOOL "Use External Library Building for JPEG" FORCE)
    set (HDF4_ENABLE_Z_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
    set (ZLIB_USE_EXTERNAL OFF CACHE BOOL "Use External Library Building for ZLIB" FORCE)
    set (HDF4_ENABLE_SZIP_SUPPORT OFF CACHE BOOL "" FORCE)
    set (SZIP_USE_EXTERNAL OFF CACHE BOOL "Use External Library Building for SZIP" FORCE)
  endif ()
endif ()

#-----------------------------------------------------------------------------
# Option for LibJpeg support
#-----------------------------------------------------------------------------
set (HDF4_ENABLE_JPEG_LIB_SUPPORT ON) #Enable libjpeg required
if (HDF4_ENABLE_JPEG_LIB_SUPPORT)
  if (NOT H4_JPEGLIB_HEADER)
    if (NOT JPEG_USE_EXTERNAL)
      find_package (JPEG NAMES ${JPEG_PACKAGE_NAME}${HDF_PACKAGE_EXT} COMPONENTS static shared)
      if (NOT JPEG_FOUND)
        find_package (JPEG) # Legacy find
      endif ()
      if (JPEG_FOUND)
        set (H4_JPEGLIB_HEADER "jpeglib.h")
        set (JPEG_INCLUDE_DIR_GEN ${JPEG_INCLUDE_DIR})
        set (JPEG_INCLUDE_DIRS ${JPEG_INCLUDE_DIRS} ${JPEG_INCLUDE_DIR})
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${JPEG_LIBRARIES})
      endif ()
    else ()
      if (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        EXTERNAL_JPEG_LIBRARY (${HDF4_ALLOW_EXTERNAL_SUPPORT})
        message (VERBOSE "JPEGLIB is built")
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${JPEG_STATIC_LIBRARY})
      endif ()
    endif ()
  else ()
    # This project is being called from within another and JPEGLib is already configured
    set (H4_HAVE_JPEGLIB_H 1)
    set (H4_HAVE_LIBJPEG 1)
  endif ()
  if (JPEG_FOUND)
    set (H4_HAVE_JPEGLIB_H 1)
    set (H4_HAVE_LIBJPEG 1)
    set (HDF4_COMP_INCLUDE_DIRECTORIES "${HDF4_COMP_INCLUDE_DIRECTORIES};${JPEG_INCLUDE_DIRS}")
    message (VERBOSE "Filter JPEGLIB is ON")
  else ()
    set (HDF4_ENABLE_JPEG_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
    message (FATAL_ERROR " JPEG support in HDF4 was requested and required but not found")
  endif ()
else ()
  message (FATAL_ERROR " JPEG support in HDF4 is required but not found")
endif ()

#-----------------------------------------------------------------------------
# Option for ZLib support
#-----------------------------------------------------------------------------
set (HDF4_ENABLE_Z_LIB_SUPPORT ON) #Enable libzlib required
if (HDF4_ENABLE_Z_LIB_SUPPORT)
  if (NOT H4_ZLIB_HEADER)
    if (NOT ZLIB_USE_EXTERNAL)
      find_package (ZLIB NAMES ${ZLIB_PACKAGE_NAME}${HDF_PACKAGE_EXT} COMPONENTS static shared)
      if (NOT ZLIB_FOUND)
        find_package (ZLIB) # Legacy find
      endif ()
      if (ZLIB_FOUND)
        set (H4_ZLIB_HEADER "zlib.h")
        set (ZLIB_INCLUDE_DIR_GEN ${ZLIB_INCLUDE_DIR})
        set (ZLIB_INCLUDE_DIRS ${ZLIB_INCLUDE_DIRS} ${ZLIB_INCLUDE_DIR})
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${ZLIB_LIBRARIES})
      endif ()
    else ()
      if (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        EXTERNAL_ZLIB_LIBRARY (${HDF4_ALLOW_EXTERNAL_SUPPORT})
        message (VERBOSE "Filter HDF4_ZLIB is built")
        set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${ZLIB_STATIC_LIBRARY})
      endif ()
    endif ()
  else ()
    # This project is being called from within another and ZLib is already configured
    set (H4_HAVE_FILTER_DEFLATE 1)
    set (H4_HAVE_ZLIB_H 1)
    set (H4_HAVE_LIBZ 1)
  endif ()
  if (ZLIB_FOUND)
    set (H4_HAVE_FILTER_DEFLATE 1)
    set (H4_HAVE_ZLIB_H 1)
    set (H4_HAVE_LIBZ 1)
    message (VERBOSE "Filter HDF4_ZLIB is ON")
    set (HDF4_COMP_INCLUDE_DIRECTORIES "${HDF4_COMP_INCLUDE_DIRECTORIES};${ZLIB_INCLUDE_DIRS}")
    message (VERBOSE "Filter HDF4_ZLIB is ON")
  else ()
    set (HDF4_ENABLE_Z_LIB_SUPPORT OFF CACHE BOOL "" FORCE)
    message (FATAL_ERROR " ZLib support in HDF4 is required but not found")
  endif ()
endif ()

#-----------------------------------------------------------------------------
# Option for SzLib support
#-----------------------------------------------------------------------------
option (HDF4_ENABLE_SZIP_SUPPORT "Use SZip Filter" OFF) #SZip is optional
set (SZIP_INFO "disabled")
if (HDF4_ENABLE_SZIP_SUPPORT)
  option (HDF4_ENABLE_SZIP_ENCODING "Use SZip Encoding" OFF)
  if (NOT SZIP_USE_EXTERNAL)
    set(SZIP_FOUND FALSE)
    set(libaec_USE_STATIC_LIBS ${USE_LIBAEC_STATIC})
    find_package (libaec 1.0.5 CONFIG)
    if (SZIP_FOUND)
      set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_LIBRARIES})
    endif ()
    if (NOT SZIP_FOUND)
      find_package (SZIP NAMES ${LIBAEC_PACKAGE_NAME}${HDF_PACKAGE_EXT} COMPONENTS static shared)
      if (NOT SZIP_FOUND)
        find_package (SZIP) # Legacy find
      endif ()
    endif ()
    if (SZIP_FOUND)
      set (SZIP_INCLUDE_DIR_GEN ${SZIP_INCLUDE_DIR})
      set (SZIP_INCLUDE_DIRS ${SZIP_INCLUDE_DIRS} ${SZIP_INCLUDE_DIR})
      set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_LIBRARIES})
    endif ()
  else ()
    if (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "GIT" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
      EXTERNAL_SZIP_LIBRARY (${HDF4_ALLOW_EXTERNAL_SUPPORT} ${HDF4_ENABLE_SZIP_ENCODING})
      message (VERBOSE "Filter SZIP is built")
      message (VERBOSE "... with library AEC")
      set (LINK_COMP_LIBS ${LINK_COMP_LIBS} ${SZIP_STATIC_LIBRARY})
    endif ()
  endif ()
  if (SZIP_FOUND)
    set (H4_HAVE_FILTER_SZIP 1)
    set (H4_HAVE_SZLIB_H 1)
    set (H4_HAVE_LIBSZ 1)
    set (HDF4_COMP_INCLUDE_DIRECTORIES "${HDF4_COMP_INCLUDE_DIRECTORIES};${SZIP_INCLUDE_DIRS}")
    message (VERBOSE "Filter SZIP is ON")
    if (HDF4_ENABLE_SZIP_ENCODING)
      set (H4_HAVE_SZIP_ENCODER 1)
      set (SZIP_INFO "enabled with encoder")
    else ()
      set (SZIP_INFO "enabled with decoder only")
    endif ()
  else ()
    set (HDF4_ENABLE_SZIP_SUPPORT OFF CACHE BOOL "" FORCE)
    message (FATAL_ERROR "SZIP support in HDF4 was requested but not found")
  endif ()
endif ()
