#!/usr/bin/perl -w
#
# Testprogram for lines
#
#======================================================================

use strict;
use Chart::Lines;

print "1..1\n";

my @messwerte = ();
my @zeit      = ();

my $graphic;
my $gif_name;
my $titel_name;
my $einheit;
my $min_y;
my $max_y;

#------------------------------------------------------------------------------------
# Start
#------------------------------------------------------------------------------------

$gif_name   = "Humidity";
$titel_name = "Examples of Humidity";
$einheit    = "% rH";
@zeit       = (
    '12:00', '12:01', '12:02', '12:03', '12:04', '12:05', '12:06', '12:07', '12:08', '12:09',    #1
    '12:10', '12:11', '12:12', '12:13', '12:14', '12:15', '12:16', '12:17', '12:18', '12:19',    #2
    '12:20', '12:21', '12:22', '12:23', '12:24', '12:25', '12:26', '12:27', '12:28', '12:29',    #3
    '12:30', '12:31', '12:32', '12:33', '12:34', '12:35', '12:36', '12:37', '12:38', '12:39',    #4
    '12:40', '12:41', '12:42', '12:43', '12:44', '12:45', '12:46', '12:47', '12:48', '12:49',    #5
    '12:50', '12:51', '12:52', '12:53', '12:54', '12:55', '12:56', '12:57', '12:58', '12:59',    #6
    '13:00', '13:01', '13:02', '13:03', '13:04', '13:05', '13:06', '13:07', '13:08', '13:09',    #7
    '13:10', '13:11', '13:12', '13:13', '13:14', '13:15', '13:16', '13:17', '13:18', '13:19',    #8
    '13:20', '13:21', '13:22', '13:23', '13:24', '13:25', '13:26', '13:27', '13:28', '13:29',    #9
    '13:30', '13:31', '13:32', '13:33', '13:34', '13:35', '13:36', '13:37', '13:38', '13:39',    #10
    '13:40', '13:41', '13:42', '13:43', '13:44', '13:45', '13:46', '13:47', '13:48', '13:49',    #11
    '13:50', '13:51', '13:52', '13:53', '13:54', '13:55', '13:56', '13:57', '13:58', '13:59',    #12
    '14:00', '14:01', '14:02', '14:03', '14:04', '14:05', '14:06', '14:07', '14:08', '14:09',    #13
    '14:10', '14:11', '14:12', '14:13', '14:14', '14:15', '14:16', '14:17', '14:18', '14:19',    #14
    '14:20', '14:21', '14:22', '14:23', '14:24', '14:25', '14:26', '14:27', '14:28', '14:29',    #15
    '14:30', '14:31', '14:32', '14:33', '14:34', '14:35', '14:36', '14:37', '14:38', '14:39',    #16
    '14:40', '14:41', '14:42', '14:43', '14:44', '14:45', '14:46', '14:47', '14:48', '14:49',    #17
    '14:50', '14:51', '14:52', '14:53', '14:54', '14:55', '14:56', '14:57', '14:58', '14:59',    #18
    '15:00', '15:01', '15:02', '15:03', '15:04', '15:05', '15:06', '15:07', '15:08', '15:09',    #19
    '15:10', '15:11', '15:12', '15:13', '15:14', '15:15', '15:16', '15:17', '15:18', '15:19',    #20
    '15:20', '15:21', '15:22', '15:23', '15:24', '15:25', '15:26', '15:27', '15:28', '15:29',    #21
    '15:30', '15:31', '15:32', '15:33', '15:34', '15:35', '15:36', '15:37', '15:38', '15:39',    #22
    '15:40', '15:41', '15:42', '15:43', '15:44', '15:45', '15:46', '15:47', '15:48', '15:49',    #23
    '15:50', '15:51', '15:52', '15:53', '15:54', '15:55', '15:56', '15:57', '15:58', '15:59',    #24
    '16:00', '16:01', '16:02', '16:03', '16:04', '16:05', '16:06', '16:07', '16:08', '16:09',    #25
    '16:10', '16:11', '16:12', '16:13', '16:14', '16:15', '16:16', '16:17', '16:18', '16:19',    #26
    '16:20', '16:21', '16:22', '16:23', '16:24', '16:25', '16:26', '16:27', '16:28', '16:29',    #27
    '16:30', '16:31', '16:32', '16:33', '16:34', '16:35', '16:36', '16:37', '16:38', '16:39',    #28
    '16:40', '16:41', '16:42', '16:43', '16:44', '16:45', '16:46', '16:47', '16:48', '16:49',    #29
    '16:50', '16:51', '16:52', '16:53', '16:54', '16:55', '16:56', '16:57', '16:58', '16:59',    #30
    '17:00', '17:01', '17:02', '17:03', '17:04', '17:05', '17:06', '17:07', '17:08', '17:09',    #31
    '17:10', '17:11', '17:12', '17:13', '17:14', '17:15', '17:16', '17:17', '17:18', '17:19',    #32
    '17:20', '17:21', '17:22', '17:23', '17:24', '17:25', '17:26', '17:27', '17:28', '17:29',    #33
    '17:30', '17:31', '17:32', '17:33', '17:34', '17:35', '17:36', '17:37', '17:38', '17:39',    #34
    '17:40', '17:41', '17:42', '17:43', '17:44', '17:45', '17:46', '17:47', '17:48', '17:49',    #35
    '17:50', '17:51', '17:52', '17:53', '17:54', '17:55', '17:56', '17:57', '17:58', '17:59',    #36
    '18:00', '18:01', '18:02', '18:03', '18:04', '18:05', '18:06', '18:07', '18:08', '18:09',    #37
    '18:10', '18:11', '18:12', '18:13', '18:14', '18:15', '18:16', '18:17', '18:18', '18:19',    #38
    '18:20', '18:21', '18:22', '18:23', '18:24', '18:25', '18:26', '18:27', '18:28', '18:29',    #39
    '18:30', '18:31', '18:32', '18:33', '18:34', '18:35', '18:36', '18:37', '18:38', '18:39',    #40
    '18:41', '18:42', '18:43', '18:44', '18:45', '18:46', '18:47', '18:48', '18:49', '18:50',    #41
    '18:51', '18:52', '18:53', '18:54', '18:55', '18:56', '18:57', '18:58', '18:59', '19:00',    #42
    '19:01', '19:02', '19:03', '19:04', '19:05', '19:06', '19:07', '19:08', '19:09', '19:10',    #43
    '19:11', '19:12', '19:13', '19:14', '19:15', '19:16', '19:17', '19:18', '19:19', '19:20',    #44
    '19:21', '19:22', '19:23', '19:24', '19:25', '19:26', '19:27', '19:28', '19:29', '19:30',    #45
    '19:31', '19:32', '19:33', '19:34', '19:35', '19:36', '19:37', '19:38', '19:39', '19:40',    #46
    '19:41', '19:42', '19:43', '19:44', '19:45', '19:46', '19:47', '19:48', '19:49', '19:50',    #47
    '19:51', '19:52', '19:53', '19:54', '19:55', '19:56', '19:57', '19:58', '19:59', '20:00',    #48
    '20:01', '20:02', '20:03', '20:04', '20:05', '20:06', '20:07', '20:08', '20:09', '20:10',    #49
    '20:11', '20:12', '20:13', '20:14', '20:15', '20:16', '20:17', '20:18', '20:19', '20:20',    #50
    '20:21', '20:22', '20:23', '20:24', '20:25', '20:26', '20:27', '20:28', '20:29', '20:30',    #51
    '20:31', '20:32', '20:33', '20:34', '20:35', '20:36', '20:37', '20:38', '20:39', '20:40',    #52
    '20:41', '20:42', '20:43', '20:44', '20:45', '20:46', '20:47', '20:48', '20:49', '20:50',    #53
    '20:51', '20:52', '20:53', '20:54', '20:55', '20:56', '20:57', '20:58', '20:59', '21:00',    #54
    '21:01', '21:02', '21:03', '21:04', '21:05', '21:06', '21:07', '21:08', '21:09', '21:10',    #55
    '21:11', '21:12', '21:13', '21:14', '21:15', '21:16', '21:17', '21:18', '21:19', '21:20',    #56
    '21:21', '21:22', '21:23', '21:24', '21:25', '21:26', '21:27', '21:28', '21:29', '21:30',    #57
    '21:31', '21:32', '21:33', '21:34', '21:35', '21:36', '21:37', '21:38', '21:39', '21:40',    #58
    '21:41', '21:42', '21:43', '21:44', '21:45', '21:46', '21:47', '21:48', '21:49', '21:50',    #59
    '21:51', '21:52', '21:53', '21:54', '21:55', '21:56', '21:57', '21:58', '21:59', '22:00',    #60
    '22:01', '22:02', '22:03', '22:04', '22:05', '22:06', '22:07', '22:08', '22:09', '22:10',    #61
    '22:11', '22:12', '22:13', '22:14', '22:15', '22:16', '22:17', '22:18', '22:19', '22:20',    #62
    '22:21', '22:22', '22:23', '22:24', '22:25', '22:26', '22:27', '22:28', '22:29', '22:30',    #63
    '22:31', '22:32', '22:33', '22:34', '22:35', '22:36', '22:37', '22:38', '22:39', '22:40',    #64
    '22:41', '22:42', '22:43', '22:44', '22:45', '22:46', '22:47', '22:48', '22:49', '22:50',    #65
    '22:51', '22:52', '22:53', '22:54', '22:55', '22:56', '22:57', '22:58', '22:59', '23:00',    #66
    '23:01', '23:02', '23:03', '23:04', '23:05', '23:06', '23:07', '23:08', '23:09', '23:10',    #67
    '23:11', '23:12', '23:13', '23:14', '23:15', '23:16', '23:17', '23:18', '23:19', '23:20',    #68
    '23:21', '23:22', '23:23', '23:24', '23:25', '23:26', '23:27', '23:28', '23:29', '23:30',    #69
    '23:31', '23:32', '23:33', '23:34', '23:35', '23:36', '23:37', '23:38', '23:39', '23:40',    #70
    '23:41', '23:42', '23:43', '23:44', '23:45', '23:46', '23:47', '23:48', '23:49', '23:50',    #71
    '23:51', '23:52', '23:53', '23:54', '23:55', '23:56', '23:57', '23:58', '23:59'
);                                                                                               #72

@messwerte = (
    36.3, 36.2, 36.2, 36.3, 36.4, 36.4, 36.3,  36.4,  36.4, 36.3,                                #1
    36.1, 36.3, 36.2, 36.3, 36.4, 36.3, 36.3,  36.1,  36.2, 36.2,                                #2
    36.3, 36.2, 36.2, 36.2, 36.1, 36.3, 36.3,  36.2,  36.2, 36.2,                                #3
    36.2, 36.1, 36.5, 36.4, 36.3, 36.2, 36.2,  36.3,  36.4, 36.4,                                #4
    36.3, 36.3, 36.3, 36.4, 36.5, 36.4, 36.4,  36.5,  36.5, 36.5,                                #5
    36.3, 36.4, 36.3, 36.2, 36.2, 36.3, 36.2,  36.3,  36.4, 36.2,                                #6
    36.2, 36.4, 36.3, 36.2, 36.4, 36.4, 36.4,  36.2,  36.4, 36.3,                                #7
    36.3, 36.4, 36.4, 36.5, 36.3, 36.5, 36.5,  36.4,  36.5, 36.4,                                #8
    36.5, 36.3, 36.4, 36.4, 36.4, 36.4, 36.5,  36.5,  36.3, 36.3,                                #9
    36.3, 36.4, 36.4, 36.3, 36.3, 36.2, 36.3,  36.3,  36.2, 36.2,                                #10
    36.2, 36.2, 36.2, 36.2, 36.3, 36.3, 36.2,  36.2,  36.2, 36.3,                                #11
    36.1, 36.2, 36.2, 36.2, 36.2, 36.4, 36.2,  36.1,  36.2, 36.2,                                #12
    36.3, 36.2, 36.3, 36.2, 36.1, 36.2, 36.2,  36.2,  36.2, 36.2,                                #13
    36.2, 36.1, 36.2, 36.2, 36.2, 36.2, 36.2,  36.3,  36.2, 36.2,                                #14
    36.3, 36.2, 36.3, 36.2, 36.3, 36.1, 36.2,  36.2,  36.2, 36.2,                                #15
    36.2, 36.2, 36.2, 36.2, 36.2, 36.3, 36.2,  36.2,  36.2, 36.2,                                #16
    36.2, 36.2, 36.3, 36.2, 36.3, 36.2, 36.3,  36.2,  36.2, 36.2,                                #17
    36.2, 36.2, 36.2, 36.2, 36.1, 36.2, 36.2,  36.2,  36.2, 36.2,                                #18
    36.3, 36.1, 36.2, 36.2, 36.3, 36.2, 36.3,  36.3,  36.2, 36.2,                                #19
    36.2, 36.3, 36.2, 36.3, 36.2, 36.2, 36.2,  36.3,  36.2, 36.2,                                #20
    36.2, 36.2, 36.2, 36.1, 36.2, 36.2, 36.2,  36.2,  36.2, 36.2,                                #21
    36.1, 36.2, 36.2, 36.2, 36.3, 36.2, 36.2,  36.1,  36.2, 36.2,                                #22
    36.2, 36.2, 36.2, 36.2, 36.1, 36.3, 36.2,  36.3,  36.2, 36.3,                                #23
    36.2, 36.2, 36.3, 36.2, 36.2, 36.3, 36.2,  36.2,  36.2, 36.2,                                #24
    36.2, 36.2, 36.2, 36.2, 36.1, 36.2, 36.36, 36.36, 36.2, 36.1,                                #25
    36.2, 36.2, 36.2, 36.3, 36.2, 36.3, 36.2,  36.3,  36.1, 36.1,                                #26
    36.2, 36.2, 36.2, 36.1, 36.2, 36.2, 36.1,  36.1,  36.2, 36.2,                                #27
    36.2, 36.2, 36.2, 36.2, 36.1, 36.1, 36.0,  36.2,  36.2, 36.2,                                #28
    36.2, 36.2, 36.2, 36.1, 36.1, 36.1, 36.1,  36.1,  36.2, 36.2,                                #29
    36.1, 36.2, 36.1, 36.1, 36.2, 36.2, 36.2,  36.2,  36.2, 36.2,                                #30
    36.2, 36.2, 36.3, 36.2, 36.1, 36.2, 36.2,  36.2,  36.2, 36.2,                                #31
    36.2, 36.3, 36.3, 36.2, 36.1, 36.2, 36.2,  36.2,  36.1, 36.3,                                #32
    36.3, 36.2, 36.3, 36.2, 36.2, 36.4, 36.3,  36.3,  36.2, 36.1,                                #33
    36.1, 36.1, 36.1, 36.1, 36.1, 36.0, 36.1,  36.2,  36.1, 36.1,                                #34
    36.1, 35.9, 36.2, 36.3, 36.5, 36.5, 36.5,  36.4,  36.1, 36.3,                                #35
    36.4, 36.1, 36.2, 36.4, 36.0, 36.2, 36.1,  36.0,  36.1, 36.1,                                #36
    36.2, 36.3, 36.4, 36.4, 36.5, 36.5, 36.5,  36.3,  36.0, 36.2,                                #37
    36.4, 36.4, 36.3, 36.4, 36.2, 36.3, 36.2,  36.3,  36.4, 36.2,                                #38
    36.4, 36.5, 36.4, 36.2, 36.2, 36.3, 36.1,  36.1,  36.3, 36.2,                                #39
    36.3, 36.3, 36.2, 36.2, 36.3, 36.4, 36.3,  36.3,  36.3, 36.4,                                #40
    36.3, 36.2, 36.3, 36.3, 36.3, 36.4, 36.3,  36.2,  36.1, 36.2,                                #41
    36.2, 36.1, 36.2, 36.1, 36.1, 36.2, 36.2,  36.1,  36.0, 36.1,                                #42
    36.1, 36.2, 36.2, 36.1, 36.2, 36.1, 36.1,  36.1,  36.1, 36.2,                                #43
    36.1, 36.1, 36.2, 36.0, 36.0, 36.1, 36.1,  35.9,  35.9, 35.8,                                #44
    36.1, 36.2, 36.2, 36.2, 36.1, 36.1, 35.9,  35.9,  35.9, 36.1,                                #45
    36.1, 35.9, 36.1, 36.2, 36.1, 36.1, 36.1,  36.1,  36.0, 36.1,                                #46
    36.2, 36.2, 36.1, 36.2, 36.0, 36.0, 35.9,  36.0,  36.0, 36.1,                                #47
    36.2, 36.0, 36.0, 36.0, 36.1, 36.0, 36.0,  35.9,  36.0, 35.8,                                #48
    35.9, 35.9, 35.9, 35.9, 35.8, 35.9, 35.7,  35.9,  35.9, 35.8,                                #49
    35.9, 35.9, 35.7, 35.8, 36.0, 36.1, 36.2,  36.2,  36.0, 36.1,                                #50
    36.2, 36.1, 36.2, 36.2, 36.1, 36.1, 36.0,  36.0,  35.9, 36.0,                                #51
    36.2, 36.1, 36.1, 36.2, 36.2, 36.1, 36.1,  36.3,  36.2, 36.2,                                #52
    36.1, 36.1, 36.1, 36.1, 36.1, 36.3, 36.4,  36.3,  36.2, 36.3,                                #53
    36.2, 36.2, 36.2, 36.3, 36.3, 36.3, 36.2,  36.3,  36.3, 36.4,                                #54
    36.3, 36.3, 36.4, 36.3, 36.3, 36.4, 36.4,  36.4,  36.4, 36.4,                                #55
    36.3, 36.3, 36.4, 36.3, 36.3, 36.2, 36.3,  36.1,  36.1, 36.1,                                #56
    36.2, 36.2, 36.2, 36.1, 36.1, 36.2, 36.2,  36.1,  36.2, 36.2,                                #57
    36.2, 36.2, 36.2, 36.1, 36.1, 36.2, 36.1,  36.2,  36.2, 36.2,                                #58
    36.1, 36.2, 36.2, 36.1, 36.2, 36.2, 36.2,  36.2,  36.2, 36.2,                                #59
    36.1, 36.1, 36.2, 36.2, 36.2, 36.2, 36.2,  36.1,  36.2, 36.2,                                #60
    36.2, 36.2, 36.1, 36.2, 36.1, 36.1, 36.2,  36.2,  36.2, 36.2,                                #61
    36.3, 36.1, 36.2, 36.2, 36.2, 36.3, 36.2,  36.2,  36.1, 36.2,                                #62
    36.3, 36.2, 36.3, 36.3, 36.3, 36.3, 36.3,  36.5,  36.3, 36.4,                                #63
    36.3, 36.3, 36.3, 36.2, 36.3, 36.3, 36.3,  36.3,  36.3, 36.2,                                #64
    36.2, 36.2, 36.2, 36.2, 36.2, 36.2, 36.2,  36.1,  36.1, 36.2,                                #65
    36.2, 36.2, 36.2, 36.2, 36.1, 36.1, 36.2,  36.1,  36.1, 36.1,                                #66
    36.2, 36.1, 36.2, 36.2, 36.2, 36.5, 36.3,  36.2,  36.3, 36.4,                                #67
    36.4, 36.4, 36.4, 36.4, 36.3, 36.3, 36.4,  36.4,  36.4, 36.4,                                #68
    36.4, 36.4, 36.3, 36.4, 36.4, 36.4, 36.3,  36.4,  36.3, 36.2,                                #69
    36.2, 36.2, 36.3, 36.1, 36.2, 36.1, 36.1,  36.1,  36.1, 36.2,                                #70
    36.1, 36.2, 36.1, 36.1, 36.1, 36.1, 36.1,  36.1,  36.2, 36.2,                                #71
    36.2, 36.1, 36.2, 36.2, 36.2, 36.2, 36.2,  36.2,  36.2
);                                                                                               #72

#------------------------------------------------------------------------------------
# Zeitarray aufbauen , Minimal- und Maximalwert bestimmen und X - Achse berechnen
#------------------------------------------------------------------------------------

#------------------------------------------------------------------------------------
# Graphic_objekt erstellen
#------------------------------------------------------------------------------------

$min_y = $max_y = $messwerte[0];
foreach (@messwerte)
{
    if ( $_ < $min_y ) { $min_y = $_; }
    if ( $_ > $max_y ) { $max_y = $_; }
}
$min_y = int($min_y) - 1;
$max_y = int($max_y) + 1;

$graphic = Chart::Lines->new( 750, 400 );
$graphic->set( 'brush_size' => 2 );

$graphic->add_dataset(@zeit);

$graphic->add_dataset(@messwerte);

#------------------------------------------------------------------------------------
# Diagramm Y-Achse berechnen
#------------------------------------------------------------------------------------

$graphic->set( 'min_val' => $min_y );
$graphic->set( 'max_val' => $max_y );

#$graphic -> set ('y_ticks' => 11 );
$graphic->set( 'x_ticks'      => 'vertical' );
$graphic->set( 'skip_x_ticks' => 30 );

$graphic->set( 'grey_background' => 'false' );
$graphic->set( 'graph_border'    => 18 );
$graphic->set( 'title'           => $titel_name );
$graphic->set( 'sub_title'       => "over Time" );
$graphic->set( 'y_grid_lines'    => 'true' );
$graphic->set( 'x_grid_lines'    => 'true' );
$graphic->set( 'x_ticks'         => 'vertical' );
$graphic->set(
    'colors' => { 'y_grid_lines' => [ 127, 127, 0 ], 'x_grid_lines' => [ 127, 127, 0 ], 'dataset0' => [ 0, 0, 200 ] } );
$graphic->set( 'legend'  => 'none' );
$graphic->set( 'x_label' => 'Time (UTC)' );
$graphic->set( 'y_label' => $einheit );

if ( $graphic->can('gif') )
{
    my $wettgif = "samples/" . $gif_name . ".gif";
    $graphic->gif($wettgif);
}
elsif ( $graphic->can('png') )
{
    my $wettgif = "samples/" . $gif_name . ".png";
    $graphic->png($wettgif);
}

print "ok 1\n";

exit(0);

