// ------------------------------------------------------------------------------
// NOTE: This file was generated from Microsoft's Language Server Protocol (LSP)
// specification. Please do not edit it by hand.
// ------------------------------------------------------------------------------

#include <cctype>
#include <cstdio>
#include <iostream>
#include <stdexcept>

#include <server/lsp_exception.h>
#include <server/lsp_json_parser.h>
#include <server/lsp_language_server.h>
#include <server/lsp_specification.h>

namespace LCompilers::LanguageServerProtocol {

    LspLanguageServer::LspLanguageServer(
        ls::MessageQueue &incomingMessages,
        ls::MessageQueue &outgoingMessages,
        lsl::Logger &logger
    )
        : ls::LanguageServer(incomingMessages, outgoingMessages, logger)
    {
        // empty
    }

    auto LspLanguageServer::nextRequestId() -> int
    {
        return serialRequestId++;
    }

    auto LspLanguageServer::send(const RequestMessage &request) -> void
    {
        auto any_0 = transformer.requestMessageToAny(request);
        auto message_0 = serializer.serialize(any_0);
        ls::LanguageServer::send(message_0);
    }

    auto LspLanguageServer::buildRequest(
        const std::string &method
    ) -> RequestMessage
    {
        RequestMessage request_0;
        request_0.jsonrpc = JSON_RPC_VERSION;
        request_0.method = method;
        auto requestId_0 = nextRequestId();
        request_0.id = requestId_0;
        return request_0;
    }

    auto LspLanguageServer::sendRequest(
        const std::string &method,
        MessageParams &params
    ) -> int
    {
        auto request_0 = buildRequest(method);
        request_0.params = std::move(params);
        send(request_0);
        return request_0.id.integer();
    }

    auto LspLanguageServer::sendRequest(const std::string &method) -> int
    {
        auto request_0 = buildRequest(method);
        send(request_0);
        return request_0.id.integer();
    }

    auto LspLanguageServer::send(
        const NotificationMessage &notification
    ) -> void
    {
        auto any_0 = transformer.notificationMessageToAny(notification);
        auto message_0 = serializer.serialize(any_0);
        ls::LanguageServer::send(message_0);
    }

    auto LspLanguageServer::buildNotification(
        const std::string &method
    ) -> NotificationMessage
    {
        NotificationMessage notification_0;
        notification_0.jsonrpc = JSON_RPC_VERSION;
        notification_0.method = method;
        return notification_0;
    }

    auto LspLanguageServer::sendNotification(
        const std::string &method,
        MessageParams &params
    ) -> void
    {
        auto notification_0 = buildNotification(method);
        notification_0.params = std::move(params);
        send(notification_0);
    }

    auto LspLanguageServer::sendNotification(const std::string &method) -> void
    {
        auto notification_0 = buildNotification(method);
        send(notification_0);
    }

    auto LspLanguageServer::dispatch(
        ResponseMessage &response,
        RequestMessage &request,
        IncomingRequest method
    ) -> void
    {
        switch (method) {
        case IncomingRequest::TextDocument_Implementation: {
            MessageParams &messageParams = requireMessageParams(request);
            ImplementationParams requestParams =
                transformer.asTextDocument_ImplementationParams(messageParams);
            TextDocument_ImplementationResult result =
                receiveTextDocument_implementation(requestParams);
            response.result =
                transformer.textDocument_ImplementationResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_TypeDefinition: {
            MessageParams &messageParams = requireMessageParams(request);
            TypeDefinitionParams requestParams =
                transformer.asTextDocument_TypeDefinitionParams(messageParams);
            TextDocument_TypeDefinitionResult result =
                receiveTextDocument_typeDefinition(requestParams);
            response.result =
                transformer.textDocument_TypeDefinitionResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_DocumentColor: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentColorParams requestParams =
                transformer.asTextDocument_DocumentColorParams(messageParams);
            TextDocument_DocumentColorResult result =
                receiveTextDocument_documentColor(requestParams);
            response.result =
                transformer.textDocument_DocumentColorResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_ColorPresentation: {
            MessageParams &messageParams = requireMessageParams(request);
            ColorPresentationParams requestParams =
                transformer.asTextDocument_ColorPresentationParams(messageParams);
            TextDocument_ColorPresentationResult result =
                receiveTextDocument_colorPresentation(requestParams);
            response.result =
                transformer.textDocument_ColorPresentationResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_FoldingRange: {
            MessageParams &messageParams = requireMessageParams(request);
            FoldingRangeParams requestParams =
                transformer.asTextDocument_FoldingRangeParams(messageParams);
            TextDocument_FoldingRangeResult result =
                receiveTextDocument_foldingRange(requestParams);
            response.result =
                transformer.textDocument_FoldingRangeResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Declaration: {
            MessageParams &messageParams = requireMessageParams(request);
            DeclarationParams requestParams =
                transformer.asTextDocument_DeclarationParams(messageParams);
            TextDocument_DeclarationResult result =
                receiveTextDocument_declaration(requestParams);
            response.result =
                transformer.textDocument_DeclarationResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_SelectionRange: {
            MessageParams &messageParams = requireMessageParams(request);
            SelectionRangeParams requestParams =
                transformer.asTextDocument_SelectionRangeParams(messageParams);
            TextDocument_SelectionRangeResult result =
                receiveTextDocument_selectionRange(requestParams);
            response.result =
                transformer.textDocument_SelectionRangeResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_PrepareCallHierarchy: {
            MessageParams &messageParams = requireMessageParams(request);
            CallHierarchyPrepareParams requestParams =
                transformer.asTextDocument_PrepareCallHierarchyParams(messageParams);
            TextDocument_PrepareCallHierarchyResult result =
                receiveTextDocument_prepareCallHierarchy(requestParams);
            response.result =
                transformer.textDocument_PrepareCallHierarchyResultToAny(result);
            break;
        }
        case IncomingRequest::CallHierarchy_IncomingCalls: {
            MessageParams &messageParams = requireMessageParams(request);
            CallHierarchyIncomingCallsParams requestParams =
                transformer.asCallHierarchy_IncomingCallsParams(messageParams);
            CallHierarchy_IncomingCallsResult result =
                receiveCallHierarchy_incomingCalls(requestParams);
            response.result =
                transformer.callHierarchy_IncomingCallsResultToAny(result);
            break;
        }
        case IncomingRequest::CallHierarchy_OutgoingCalls: {
            MessageParams &messageParams = requireMessageParams(request);
            CallHierarchyOutgoingCallsParams requestParams =
                transformer.asCallHierarchy_OutgoingCallsParams(messageParams);
            CallHierarchy_OutgoingCallsResult result =
                receiveCallHierarchy_outgoingCalls(requestParams);
            response.result =
                transformer.callHierarchy_OutgoingCallsResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_SemanticTokens_Full: {
            MessageParams &messageParams = requireMessageParams(request);
            SemanticTokensParams requestParams =
                transformer.asTextDocument_SemanticTokens_FullParams(messageParams);
            TextDocument_SemanticTokens_FullResult result =
                receiveTextDocument_semanticTokens_full(requestParams);
            response.result =
                transformer.textDocument_SemanticTokens_FullResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_SemanticTokens_Full_Delta: {
            MessageParams &messageParams = requireMessageParams(request);
            SemanticTokensDeltaParams requestParams =
                transformer.asTextDocument_SemanticTokens_Full_DeltaParams(messageParams);
            TextDocument_SemanticTokens_Full_DeltaResult result =
                receiveTextDocument_semanticTokens_full_delta(requestParams);
            response.result =
                transformer.textDocument_SemanticTokens_Full_DeltaResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_SemanticTokens_Range: {
            MessageParams &messageParams = requireMessageParams(request);
            SemanticTokensRangeParams requestParams =
                transformer.asTextDocument_SemanticTokens_RangeParams(messageParams);
            TextDocument_SemanticTokens_RangeResult result =
                receiveTextDocument_semanticTokens_range(requestParams);
            response.result =
                transformer.textDocument_SemanticTokens_RangeResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_LinkedEditingRange: {
            MessageParams &messageParams = requireMessageParams(request);
            LinkedEditingRangeParams requestParams =
                transformer.asTextDocument_LinkedEditingRangeParams(messageParams);
            TextDocument_LinkedEditingRangeResult result =
                receiveTextDocument_linkedEditingRange(requestParams);
            response.result =
                transformer.textDocument_LinkedEditingRangeResultToAny(result);
            break;
        }
        case IncomingRequest::Workspace_WillCreateFiles: {
            MessageParams &messageParams = requireMessageParams(request);
            CreateFilesParams requestParams =
                transformer.asWorkspace_WillCreateFilesParams(messageParams);
            Workspace_WillCreateFilesResult result =
                receiveWorkspace_willCreateFiles(requestParams);
            response.result =
                transformer.workspace_WillCreateFilesResultToAny(result);
            break;
        }
        case IncomingRequest::Workspace_WillRenameFiles: {
            MessageParams &messageParams = requireMessageParams(request);
            RenameFilesParams requestParams =
                transformer.asWorkspace_WillRenameFilesParams(messageParams);
            Workspace_WillRenameFilesResult result =
                receiveWorkspace_willRenameFiles(requestParams);
            response.result =
                transformer.workspace_WillRenameFilesResultToAny(result);
            break;
        }
        case IncomingRequest::Workspace_WillDeleteFiles: {
            MessageParams &messageParams = requireMessageParams(request);
            DeleteFilesParams requestParams =
                transformer.asWorkspace_WillDeleteFilesParams(messageParams);
            Workspace_WillDeleteFilesResult result =
                receiveWorkspace_willDeleteFiles(requestParams);
            response.result =
                transformer.workspace_WillDeleteFilesResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Moniker: {
            MessageParams &messageParams = requireMessageParams(request);
            MonikerParams requestParams =
                transformer.asTextDocument_MonikerParams(messageParams);
            TextDocument_MonikerResult result =
                receiveTextDocument_moniker(requestParams);
            response.result =
                transformer.textDocument_MonikerResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_PrepareTypeHierarchy: {
            MessageParams &messageParams = requireMessageParams(request);
            TypeHierarchyPrepareParams requestParams =
                transformer.asTextDocument_PrepareTypeHierarchyParams(messageParams);
            TextDocument_PrepareTypeHierarchyResult result =
                receiveTextDocument_prepareTypeHierarchy(requestParams);
            response.result =
                transformer.textDocument_PrepareTypeHierarchyResultToAny(result);
            break;
        }
        case IncomingRequest::TypeHierarchy_Supertypes: {
            MessageParams &messageParams = requireMessageParams(request);
            TypeHierarchySupertypesParams requestParams =
                transformer.asTypeHierarchy_SupertypesParams(messageParams);
            TypeHierarchy_SupertypesResult result =
                receiveTypeHierarchy_supertypes(requestParams);
            response.result =
                transformer.typeHierarchy_SupertypesResultToAny(result);
            break;
        }
        case IncomingRequest::TypeHierarchy_Subtypes: {
            MessageParams &messageParams = requireMessageParams(request);
            TypeHierarchySubtypesParams requestParams =
                transformer.asTypeHierarchy_SubtypesParams(messageParams);
            TypeHierarchy_SubtypesResult result =
                receiveTypeHierarchy_subtypes(requestParams);
            response.result =
                transformer.typeHierarchy_SubtypesResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_InlineValue: {
            MessageParams &messageParams = requireMessageParams(request);
            InlineValueParams requestParams =
                transformer.asTextDocument_InlineValueParams(messageParams);
            TextDocument_InlineValueResult result =
                receiveTextDocument_inlineValue(requestParams);
            response.result =
                transformer.textDocument_InlineValueResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_InlayHint: {
            MessageParams &messageParams = requireMessageParams(request);
            InlayHintParams requestParams =
                transformer.asTextDocument_InlayHintParams(messageParams);
            TextDocument_InlayHintResult result =
                receiveTextDocument_inlayHint(requestParams);
            response.result =
                transformer.textDocument_InlayHintResultToAny(result);
            break;
        }
        case IncomingRequest::InlayHint_Resolve: {
            MessageParams &messageParams = requireMessageParams(request);
            InlayHint requestParams =
                transformer.asInlayHint_ResolveParams(messageParams);
            InlayHint_ResolveResult result =
                receiveInlayHint_resolve(requestParams);
            response.result =
                transformer.inlayHint_ResolveResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Diagnostic: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentDiagnosticParams requestParams =
                transformer.asTextDocument_DiagnosticParams(messageParams);
            TextDocument_DiagnosticResult result =
                receiveTextDocument_diagnostic(requestParams);
            response.result =
                transformer.textDocument_DiagnosticResultToAny(result);
            break;
        }
        case IncomingRequest::Workspace_Diagnostic: {
            MessageParams &messageParams = requireMessageParams(request);
            WorkspaceDiagnosticParams requestParams =
                transformer.asWorkspace_DiagnosticParams(messageParams);
            Workspace_DiagnosticResult result =
                receiveWorkspace_diagnostic(requestParams);
            response.result =
                transformer.workspace_DiagnosticResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_InlineCompletion: {
            MessageParams &messageParams = requireMessageParams(request);
            InlineCompletionParams requestParams =
                transformer.asTextDocument_InlineCompletionParams(messageParams);
            TextDocument_InlineCompletionResult result =
                receiveTextDocument_inlineCompletion(requestParams);
            response.result =
                transformer.textDocument_InlineCompletionResultToAny(result);
            break;
        }
        case IncomingRequest::Initialize: {
            MessageParams &messageParams = requireMessageParams(request);
            InitializeParams requestParams =
                transformer.asInitializeParams(messageParams);
            InitializeResult result =
                receiveInitialize(requestParams);
            response.result =
                transformer.initializeResultToAny(result);
            break;
        }
        case IncomingRequest::Shutdown: {
            ShutdownResult result = receiveShutdown();
            response.result =
                transformer.shutdownResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_WillSaveWaitUntil: {
            MessageParams &messageParams = requireMessageParams(request);
            WillSaveTextDocumentParams requestParams =
                transformer.asTextDocument_WillSaveWaitUntilParams(messageParams);
            TextDocument_WillSaveWaitUntilResult result =
                receiveTextDocument_willSaveWaitUntil(requestParams);
            response.result =
                transformer.textDocument_WillSaveWaitUntilResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Completion: {
            MessageParams &messageParams = requireMessageParams(request);
            CompletionParams requestParams =
                transformer.asTextDocument_CompletionParams(messageParams);
            TextDocument_CompletionResult result =
                receiveTextDocument_completion(requestParams);
            response.result =
                transformer.textDocument_CompletionResultToAny(result);
            break;
        }
        case IncomingRequest::CompletionItem_Resolve: {
            MessageParams &messageParams = requireMessageParams(request);
            CompletionItem requestParams =
                transformer.asCompletionItem_ResolveParams(messageParams);
            CompletionItem_ResolveResult result =
                receiveCompletionItem_resolve(requestParams);
            response.result =
                transformer.completionItem_ResolveResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Hover: {
            MessageParams &messageParams = requireMessageParams(request);
            HoverParams requestParams =
                transformer.asTextDocument_HoverParams(messageParams);
            TextDocument_HoverResult result =
                receiveTextDocument_hover(requestParams);
            response.result =
                transformer.textDocument_HoverResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_SignatureHelp: {
            MessageParams &messageParams = requireMessageParams(request);
            SignatureHelpParams requestParams =
                transformer.asTextDocument_SignatureHelpParams(messageParams);
            TextDocument_SignatureHelpResult result =
                receiveTextDocument_signatureHelp(requestParams);
            response.result =
                transformer.textDocument_SignatureHelpResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Definition: {
            MessageParams &messageParams = requireMessageParams(request);
            DefinitionParams requestParams =
                transformer.asTextDocument_DefinitionParams(messageParams);
            TextDocument_DefinitionResult result =
                receiveTextDocument_definition(requestParams);
            response.result =
                transformer.textDocument_DefinitionResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_References: {
            MessageParams &messageParams = requireMessageParams(request);
            ReferenceParams requestParams =
                transformer.asTextDocument_ReferencesParams(messageParams);
            TextDocument_ReferencesResult result =
                receiveTextDocument_references(requestParams);
            response.result =
                transformer.textDocument_ReferencesResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_DocumentHighlight: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentHighlightParams requestParams =
                transformer.asTextDocument_DocumentHighlightParams(messageParams);
            TextDocument_DocumentHighlightResult result =
                receiveTextDocument_documentHighlight(requestParams);
            response.result =
                transformer.textDocument_DocumentHighlightResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_DocumentSymbol: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentSymbolParams requestParams =
                transformer.asTextDocument_DocumentSymbolParams(messageParams);
            TextDocument_DocumentSymbolResult result =
                receiveTextDocument_documentSymbol(requestParams);
            response.result =
                transformer.textDocument_DocumentSymbolResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_CodeAction: {
            MessageParams &messageParams = requireMessageParams(request);
            CodeActionParams requestParams =
                transformer.asTextDocument_CodeActionParams(messageParams);
            TextDocument_CodeActionResult result =
                receiveTextDocument_codeAction(requestParams);
            response.result =
                transformer.textDocument_CodeActionResultToAny(result);
            break;
        }
        case IncomingRequest::CodeAction_Resolve: {
            MessageParams &messageParams = requireMessageParams(request);
            CodeAction requestParams =
                transformer.asCodeAction_ResolveParams(messageParams);
            CodeAction_ResolveResult result =
                receiveCodeAction_resolve(requestParams);
            response.result =
                transformer.codeAction_ResolveResultToAny(result);
            break;
        }
        case IncomingRequest::Workspace_Symbol: {
            MessageParams &messageParams = requireMessageParams(request);
            WorkspaceSymbolParams requestParams =
                transformer.asWorkspace_SymbolParams(messageParams);
            Workspace_SymbolResult result =
                receiveWorkspace_symbol(requestParams);
            response.result =
                transformer.workspace_SymbolResultToAny(result);
            break;
        }
        case IncomingRequest::WorkspaceSymbol_Resolve: {
            MessageParams &messageParams = requireMessageParams(request);
            WorkspaceSymbol requestParams =
                transformer.asWorkspaceSymbol_ResolveParams(messageParams);
            WorkspaceSymbol_ResolveResult result =
                receiveWorkspaceSymbol_resolve(requestParams);
            response.result =
                transformer.workspaceSymbol_ResolveResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_CodeLens: {
            MessageParams &messageParams = requireMessageParams(request);
            CodeLensParams requestParams =
                transformer.asTextDocument_CodeLensParams(messageParams);
            TextDocument_CodeLensResult result =
                receiveTextDocument_codeLens(requestParams);
            response.result =
                transformer.textDocument_CodeLensResultToAny(result);
            break;
        }
        case IncomingRequest::CodeLens_Resolve: {
            MessageParams &messageParams = requireMessageParams(request);
            CodeLens requestParams =
                transformer.asCodeLens_ResolveParams(messageParams);
            CodeLens_ResolveResult result =
                receiveCodeLens_resolve(requestParams);
            response.result =
                transformer.codeLens_ResolveResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_DocumentLink: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentLinkParams requestParams =
                transformer.asTextDocument_DocumentLinkParams(messageParams);
            TextDocument_DocumentLinkResult result =
                receiveTextDocument_documentLink(requestParams);
            response.result =
                transformer.textDocument_DocumentLinkResultToAny(result);
            break;
        }
        case IncomingRequest::DocumentLink_Resolve: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentLink requestParams =
                transformer.asDocumentLink_ResolveParams(messageParams);
            DocumentLink_ResolveResult result =
                receiveDocumentLink_resolve(requestParams);
            response.result =
                transformer.documentLink_ResolveResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Formatting: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentFormattingParams requestParams =
                transformer.asTextDocument_FormattingParams(messageParams);
            TextDocument_FormattingResult result =
                receiveTextDocument_formatting(requestParams);
            response.result =
                transformer.textDocument_FormattingResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_RangeFormatting: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentRangeFormattingParams requestParams =
                transformer.asTextDocument_RangeFormattingParams(messageParams);
            TextDocument_RangeFormattingResult result =
                receiveTextDocument_rangeFormatting(requestParams);
            response.result =
                transformer.textDocument_RangeFormattingResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_RangesFormatting: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentRangesFormattingParams requestParams =
                transformer.asTextDocument_RangesFormattingParams(messageParams);
            TextDocument_RangesFormattingResult result =
                receiveTextDocument_rangesFormatting(requestParams);
            response.result =
                transformer.textDocument_RangesFormattingResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_OnTypeFormatting: {
            MessageParams &messageParams = requireMessageParams(request);
            DocumentOnTypeFormattingParams requestParams =
                transformer.asTextDocument_OnTypeFormattingParams(messageParams);
            TextDocument_OnTypeFormattingResult result =
                receiveTextDocument_onTypeFormatting(requestParams);
            response.result =
                transformer.textDocument_OnTypeFormattingResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_Rename: {
            MessageParams &messageParams = requireMessageParams(request);
            RenameParams requestParams =
                transformer.asTextDocument_RenameParams(messageParams);
            TextDocument_RenameResult result =
                receiveTextDocument_rename(requestParams);
            response.result =
                transformer.textDocument_RenameResultToAny(result);
            break;
        }
        case IncomingRequest::TextDocument_PrepareRename: {
            MessageParams &messageParams = requireMessageParams(request);
            PrepareRenameParams requestParams =
                transformer.asTextDocument_PrepareRenameParams(messageParams);
            TextDocument_PrepareRenameResult result =
                receiveTextDocument_prepareRename(requestParams);
            response.result =
                transformer.textDocument_PrepareRenameResultToAny(result);
            break;
        }
        case IncomingRequest::Workspace_ExecuteCommand: {
            MessageParams &messageParams = requireMessageParams(request);
            ExecuteCommandParams requestParams =
                transformer.asWorkspace_ExecuteCommandParams(messageParams);
            Workspace_ExecuteCommandResult result =
                receiveWorkspace_executeCommand(requestParams);
            response.result =
                transformer.workspace_ExecuteCommandResultToAny(result);
            break;
        }
        default: {
            throw LSP_EXCEPTION(
                ErrorCodes::MethodNotFound,
                "Unsupported request method: \"" + request.method + "\""
            );
        }
        }
    }

    auto LspLanguageServer::dispatch(
        ResponseMessage &/*response*/,
        NotificationMessage &notification,
        IncomingNotification method
    ) -> void
    {
        switch (method) {
        case IncomingNotification::Workspace_DidChangeWorkspaceFolders: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidChangeWorkspaceFoldersParams notificationParams =
                transformer.asWorkspace_DidChangeWorkspaceFoldersParams(messageParams);
            receiveWorkspace_didChangeWorkspaceFolders(notificationParams);
            break;
        }
        case IncomingNotification::Window_WorkDoneProgress_Cancel: {
            MessageParams &messageParams = requireMessageParams(notification);
            WorkDoneProgressCancelParams notificationParams =
                transformer.asWindow_WorkDoneProgress_CancelParams(messageParams);
            receiveWindow_workDoneProgress_cancel(notificationParams);
            break;
        }
        case IncomingNotification::Workspace_DidCreateFiles: {
            MessageParams &messageParams = requireMessageParams(notification);
            CreateFilesParams notificationParams =
                transformer.asWorkspace_DidCreateFilesParams(messageParams);
            receiveWorkspace_didCreateFiles(notificationParams);
            break;
        }
        case IncomingNotification::Workspace_DidRenameFiles: {
            MessageParams &messageParams = requireMessageParams(notification);
            RenameFilesParams notificationParams =
                transformer.asWorkspace_DidRenameFilesParams(messageParams);
            receiveWorkspace_didRenameFiles(notificationParams);
            break;
        }
        case IncomingNotification::Workspace_DidDeleteFiles: {
            MessageParams &messageParams = requireMessageParams(notification);
            DeleteFilesParams notificationParams =
                transformer.asWorkspace_DidDeleteFilesParams(messageParams);
            receiveWorkspace_didDeleteFiles(notificationParams);
            break;
        }
        case IncomingNotification::NotebookDocument_DidOpen: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidOpenNotebookDocumentParams notificationParams =
                transformer.asNotebookDocument_DidOpenParams(messageParams);
            receiveNotebookDocument_didOpen(notificationParams);
            break;
        }
        case IncomingNotification::NotebookDocument_DidChange: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidChangeNotebookDocumentParams notificationParams =
                transformer.asNotebookDocument_DidChangeParams(messageParams);
            receiveNotebookDocument_didChange(notificationParams);
            break;
        }
        case IncomingNotification::NotebookDocument_DidSave: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidSaveNotebookDocumentParams notificationParams =
                transformer.asNotebookDocument_DidSaveParams(messageParams);
            receiveNotebookDocument_didSave(notificationParams);
            break;
        }
        case IncomingNotification::NotebookDocument_DidClose: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidCloseNotebookDocumentParams notificationParams =
                transformer.asNotebookDocument_DidCloseParams(messageParams);
            receiveNotebookDocument_didClose(notificationParams);
            break;
        }
        case IncomingNotification::Initialized: {
            MessageParams &messageParams = requireMessageParams(notification);
            InitializedParams notificationParams =
                transformer.asInitializedParams(messageParams);
            receiveInitialized(notificationParams);
            break;
        }
        case IncomingNotification::Exit: {
            receiveExit();
            break;
        }
        case IncomingNotification::Workspace_DidChangeConfiguration: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidChangeConfigurationParams notificationParams =
                transformer.asWorkspace_DidChangeConfigurationParams(messageParams);
            receiveWorkspace_didChangeConfiguration(notificationParams);
            break;
        }
        case IncomingNotification::TextDocument_DidOpen: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidOpenTextDocumentParams notificationParams =
                transformer.asTextDocument_DidOpenParams(messageParams);
            receiveTextDocument_didOpen(notificationParams);
            break;
        }
        case IncomingNotification::TextDocument_DidChange: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidChangeTextDocumentParams notificationParams =
                transformer.asTextDocument_DidChangeParams(messageParams);
            receiveTextDocument_didChange(notificationParams);
            break;
        }
        case IncomingNotification::TextDocument_DidClose: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidCloseTextDocumentParams notificationParams =
                transformer.asTextDocument_DidCloseParams(messageParams);
            receiveTextDocument_didClose(notificationParams);
            break;
        }
        case IncomingNotification::TextDocument_DidSave: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidSaveTextDocumentParams notificationParams =
                transformer.asTextDocument_DidSaveParams(messageParams);
            receiveTextDocument_didSave(notificationParams);
            break;
        }
        case IncomingNotification::TextDocument_WillSave: {
            MessageParams &messageParams = requireMessageParams(notification);
            WillSaveTextDocumentParams notificationParams =
                transformer.asTextDocument_WillSaveParams(messageParams);
            receiveTextDocument_willSave(notificationParams);
            break;
        }
        case IncomingNotification::Workspace_DidChangeWatchedFiles: {
            MessageParams &messageParams = requireMessageParams(notification);
            DidChangeWatchedFilesParams notificationParams =
                transformer.asWorkspace_DidChangeWatchedFilesParams(messageParams);
            receiveWorkspace_didChangeWatchedFiles(notificationParams);
            break;
        }
        case IncomingNotification::SetTrace: {
            MessageParams &messageParams = requireMessageParams(notification);
            SetTraceParams notificationParams =
                transformer.asSetTraceParams(messageParams);
            receiveSetTrace(notificationParams);
            break;
        }
        default: {
            if (notification.method.compare(0, 2, "$/") == 0) {
                // NOTE: If a server or client receives notifications starting with "$/"
                // it is free to ignore the notification:
                logger.debug()
                    << "No handler exists for method: \"" << notification.method << "\""
                    << std::endl;
            } else {
                throw LSP_EXCEPTION(
                    ErrorCodes::MethodNotFound,
                    "Unsupported notification method: \"" + notification.method + "\""
                );
            }
        }
        }
    }

    auto LspLanguageServer::dispatch(
        ResponseMessage &response,
        const std::string &method
    ) -> void
    {
        OutgoingRequest request;
        try {
            request = outgoingRequestByValue(method);
        } catch (std::invalid_argument &/*e*/) {
            goto invalidMethod;
        }

        switch (request) {
        case OutgoingRequest::Workspace_WorkspaceFolders: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/workspaceFolders\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_WorkspaceFoldersResult params =
                transformer.anyToWorkspace_WorkspaceFoldersResult(result);
            receiveWorkspace_workspaceFolders(params);
            break;
        }
        case OutgoingRequest::Workspace_Configuration: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/configuration\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_ConfigurationResult params =
                transformer.anyToWorkspace_ConfigurationResult(result);
            receiveWorkspace_configuration(params);
            break;
        }
        case OutgoingRequest::Workspace_FoldingRange_Refresh: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/foldingRange/refresh\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_FoldingRange_RefreshResult params =
                transformer.anyToWorkspace_FoldingRange_RefreshResult(result);
            receiveWorkspace_foldingRange_refresh(params);
            break;
        }
        case OutgoingRequest::Window_WorkDoneProgress_Create: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"window/workDoneProgress/create\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Window_WorkDoneProgress_CreateResult params =
                transformer.anyToWindow_WorkDoneProgress_CreateResult(result);
            receiveWindow_workDoneProgress_create(params);
            break;
        }
        case OutgoingRequest::Workspace_SemanticTokens_Refresh: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/semanticTokens/refresh\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_SemanticTokens_RefreshResult params =
                transformer.anyToWorkspace_SemanticTokens_RefreshResult(result);
            receiveWorkspace_semanticTokens_refresh(params);
            break;
        }
        case OutgoingRequest::Window_ShowDocument: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"window/showDocument\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Window_ShowDocumentResult params =
                transformer.anyToWindow_ShowDocumentResult(result);
            receiveWindow_showDocument(params);
            break;
        }
        case OutgoingRequest::Workspace_InlineValue_Refresh: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/inlineValue/refresh\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_InlineValue_RefreshResult params =
                transformer.anyToWorkspace_InlineValue_RefreshResult(result);
            receiveWorkspace_inlineValue_refresh(params);
            break;
        }
        case OutgoingRequest::Workspace_InlayHint_Refresh: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/inlayHint/refresh\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_InlayHint_RefreshResult params =
                transformer.anyToWorkspace_InlayHint_RefreshResult(result);
            receiveWorkspace_inlayHint_refresh(params);
            break;
        }
        case OutgoingRequest::Workspace_Diagnostic_Refresh: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/diagnostic/refresh\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_Diagnostic_RefreshResult params =
                transformer.anyToWorkspace_Diagnostic_RefreshResult(result);
            receiveWorkspace_diagnostic_refresh(params);
            break;
        }
        case OutgoingRequest::Client_RegisterCapability: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"client/registerCapability\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Client_RegisterCapabilityResult params =
                transformer.anyToClient_RegisterCapabilityResult(result);
            receiveClient_registerCapability(params);
            break;
        }
        case OutgoingRequest::Client_UnregisterCapability: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"client/unregisterCapability\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Client_UnregisterCapabilityResult params =
                transformer.anyToClient_UnregisterCapabilityResult(result);
            receiveClient_unregisterCapability(params);
            break;
        }
        case OutgoingRequest::Window_ShowMessageRequest: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"window/showMessageRequest\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Window_ShowMessageRequestResult params =
                transformer.anyToWindow_ShowMessageRequestResult(result);
            receiveWindow_showMessageRequest(params);
            break;
        }
        case OutgoingRequest::Workspace_CodeLens_Refresh: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/codeLens/refresh\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_CodeLens_RefreshResult params =
                transformer.anyToWorkspace_CodeLens_RefreshResult(result);
            receiveWorkspace_codeLens_refresh(params);
            break;
        }
        case OutgoingRequest::Workspace_ApplyEdit: {
            if (!response.result.has_value()) {
                logger.error()
                    << ("Missing required attribute for method "
                        "\"workspace/applyEdit\": result")
                    << std::endl;
                return;
            }
            LSPAny &result = response.result.value();
            Workspace_ApplyEditResult params =
                transformer.anyToWorkspace_ApplyEditResult(result);
            receiveWorkspace_applyEdit(params);
            break;
        }
        default: {
            invalidMethod:
            logger.error()
                << "Unsupported request method: \""
                << method << "\"";
        }
        }
    }

    auto LspLanguageServer::requireMessageParams(
        RequestMessage &request
    ) const -> MessageParams &
    {
        if (request.params.has_value()) {
            return request.params.value();
        }
        throw LSP_EXCEPTION(
            ErrorCodes::InvalidParams,
            ("RequestMessage.params must be defined for "
             "method=\"" + request.method + "\"")
        );
    }

    auto LspLanguageServer::requireMessageParams(
        NotificationMessage &notification
    ) const -> MessageParams &
    {
        if (notification.params.has_value()) {
            return notification.params.value();
        }
        throw LSP_EXCEPTION(
            ErrorCodes::InvalidParams,
            "NotificationMessage.params must be defined for method=\"" + notification.method + "\""
        );
    }

    // notification: "$/setTrace"
    auto LspLanguageServer::receiveSetTrace(SetTraceParams &/*params*/) -> void
    {
        // NOTE: If a server or client receives notifications starting with "$/" it
        // is free to ignore the notification:
        logger.debug()
            << "No handler exists for method: \"$/setTrace\""
            << std::endl;
    }

    // notification: "textDocument/didClose"
    auto LspLanguageServer::receiveTextDocument_didClose(
        DidCloseTextDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/didClose\""
        );
    }

    // notification: "textDocument/willSave"
    auto LspLanguageServer::receiveTextDocument_willSave(
        WillSaveTextDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/willSave\""
        );
    }

    // notification: "workspace/didChangeWatchedFiles"
    auto LspLanguageServer::receiveWorkspace_didChangeWatchedFiles(
        DidChangeWatchedFilesParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/didChangeWatchedFiles\""
        );
    }

    // notification: "notebookDocument/didSave"
    auto LspLanguageServer::receiveNotebookDocument_didSave(
        DidSaveNotebookDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"notebookDocument/didSave\""
        );
    }

    // notification: "notebookDocument/didClose"
    auto LspLanguageServer::receiveNotebookDocument_didClose(
        DidCloseNotebookDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"notebookDocument/didClose\""
        );
    }

    // notification: "workspace/didChangeWorkspaceFolders"
    auto LspLanguageServer::receiveWorkspace_didChangeWorkspaceFolders(
        DidChangeWorkspaceFoldersParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/didChangeWorkspaceFolders\""
        );
    }

    // notification: "workspace/didCreateFiles"
    auto LspLanguageServer::receiveWorkspace_didCreateFiles(
        CreateFilesParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/didCreateFiles\""
        );
    }

    // notification: "workspace/didRenameFiles"
    auto LspLanguageServer::receiveWorkspace_didRenameFiles(
        RenameFilesParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/didRenameFiles\""
        );
    }

    // notification: "workspace/didDeleteFiles"
    auto LspLanguageServer::receiveWorkspace_didDeleteFiles(
        DeleteFilesParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/didDeleteFiles\""
        );
    }

    // notification: "window/showMessage"
    auto LspLanguageServer::sendWindow_showMessage(
        ShowMessageParams &params
    ) -> void
    {
        auto method_0 = "window/showMessage";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // notification: "window/logMessage"
    auto LspLanguageServer::sendWindow_logMessage(
        LogMessageParams &params
    ) -> void
    {
        auto method_0 = "window/logMessage";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // notification: "textDocument/didSave"
    auto LspLanguageServer::receiveTextDocument_didSave(
        DidSaveTextDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/didSave\""
        );
    }

    // notification: "$/logTrace"
    auto LspLanguageServer::sendLogTrace(LogTraceParams &params) -> void
    {
        auto method_0 = "$/logTrace";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // request: "workspace/workspaceFolders"
    auto LspLanguageServer::sendWorkspace_workspaceFolders() -> int
    {
        auto method_0 = "workspace/workspaceFolders";
        return sendRequest(method_0);
    }

    // request: "workspace/workspaceFolders"
    auto LspLanguageServer::receiveWorkspace_workspaceFolders(
        Workspace_WorkspaceFoldersResult &/*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/workspaceFolders\""
            << std::endl;
    }

    // request: "workspace/foldingRange/refresh"
    auto LspLanguageServer::sendWorkspace_foldingRange_refresh() -> int
    {
        auto method_0 = "workspace/foldingRange/refresh";
        return sendRequest(method_0);
    }

    // request: "workspace/foldingRange/refresh"
    auto LspLanguageServer::receiveWorkspace_foldingRange_refresh(
        Workspace_FoldingRange_RefreshResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/foldingRange/refresh\""
            << std::endl;
    }

    // request: "workspace/semanticTokens/refresh"
    auto LspLanguageServer::sendWorkspace_semanticTokens_refresh() -> int
    {
        auto method_0 = "workspace/semanticTokens/refresh";
        return sendRequest(method_0);
    }

    // request: "workspace/semanticTokens/refresh"
    auto LspLanguageServer::receiveWorkspace_semanticTokens_refresh(
        Workspace_SemanticTokens_RefreshResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/semanticTokens/refresh\""
            << std::endl;
    }

    // request: "workspace/inlineValue/refresh"
    auto LspLanguageServer::sendWorkspace_inlineValue_refresh() -> int
    {
        auto method_0 = "workspace/inlineValue/refresh";
        return sendRequest(method_0);
    }

    // request: "workspace/inlineValue/refresh"
    auto LspLanguageServer::receiveWorkspace_inlineValue_refresh(
        Workspace_InlineValue_RefreshResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/inlineValue/refresh\""
            << std::endl;
    }

    // request: "workspace/inlayHint/refresh"
    auto LspLanguageServer::sendWorkspace_inlayHint_refresh() -> int
    {
        auto method_0 = "workspace/inlayHint/refresh";
        return sendRequest(method_0);
    }

    // request: "workspace/inlayHint/refresh"
    auto LspLanguageServer::receiveWorkspace_inlayHint_refresh(
        Workspace_InlayHint_RefreshResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/inlayHint/refresh\""
            << std::endl;
    }

    // request: "workspace/diagnostic/refresh"
    auto LspLanguageServer::sendWorkspace_diagnostic_refresh() -> int
    {
        auto method_0 = "workspace/diagnostic/refresh";
        return sendRequest(method_0);
    }

    // request: "workspace/diagnostic/refresh"
    auto LspLanguageServer::receiveWorkspace_diagnostic_refresh(
        Workspace_Diagnostic_RefreshResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/diagnostic/refresh\""
            << std::endl;
    }

    // request: "client/unregisterCapability"
    auto LspLanguageServer::sendClient_unregisterCapability(
        UnregistrationParams &params
    ) -> int
    {
        auto method_0 = "client/unregisterCapability";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "client/unregisterCapability"
    auto LspLanguageServer::receiveClient_unregisterCapability(
        Client_UnregisterCapabilityResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"client/unregisterCapability\""
            << std::endl;
    }

    // request: "shutdown"
    auto LspLanguageServer::receiveShutdown() -> ShutdownResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"shutdown\""
        );
    }

    // request: "window/showMessageRequest"
    auto LspLanguageServer::sendWindow_showMessageRequest(
        ShowMessageRequestParams &params
    ) -> int
    {
        auto method_0 = "window/showMessageRequest";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "window/showMessageRequest"
    auto LspLanguageServer::receiveWindow_showMessageRequest(
        Window_ShowMessageRequestResult &/*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"window/showMessageRequest\""
            << std::endl;
    }

    // request: "workspace/codeLens/refresh"
    auto LspLanguageServer::sendWorkspace_codeLens_refresh() -> int
    {
        auto method_0 = "workspace/codeLens/refresh";
        return sendRequest(method_0);
    }

    // request: "workspace/codeLens/refresh"
    auto LspLanguageServer::receiveWorkspace_codeLens_refresh(
        Workspace_CodeLens_RefreshResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/codeLens/refresh\""
            << std::endl;
    }

    // request: "window/showDocument"
    auto LspLanguageServer::sendWindow_showDocument(
        ShowDocumentParams &params
    ) -> int
    {
        auto method_0 = "window/showDocument";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "window/showDocument"
    auto LspLanguageServer::receiveWindow_showDocument(
        Window_ShowDocumentResult &/*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"window/showDocument\""
            << std::endl;
    }

    // request: "textDocument/willSaveWaitUntil"
    auto LspLanguageServer::receiveTextDocument_willSaveWaitUntil(
        WillSaveTextDocumentParams &/*params*/
    ) -> TextDocument_WillSaveWaitUntilResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/willSaveWaitUntil\""
        );
    }

    // request: "textDocument/onTypeFormatting"
    auto LspLanguageServer::receiveTextDocument_onTypeFormatting(
        DocumentOnTypeFormattingParams &/*params*/
    ) -> TextDocument_OnTypeFormattingResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/onTypeFormatting\""
        );
    }

    // notification: "initialized"
    auto LspLanguageServer::receiveInitialized(
        InitializedParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"initialized\""
        );
    }

    // request: "textDocument/implementation"
    auto LspLanguageServer::receiveTextDocument_implementation(
        ImplementationParams &/*params*/
    ) -> TextDocument_ImplementationResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/implementation\""
        );
    }

    // request: "textDocument/typeDefinition"
    auto LspLanguageServer::receiveTextDocument_typeDefinition(
        TypeDefinitionParams &/*params*/
    ) -> TextDocument_TypeDefinitionResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/typeDefinition\""
        );
    }

    // request: "textDocument/foldingRange"
    auto LspLanguageServer::receiveTextDocument_foldingRange(
        FoldingRangeParams &/*params*/
    ) -> TextDocument_FoldingRangeResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/foldingRange\""
        );
    }

    // request: "textDocument/declaration"
    auto LspLanguageServer::receiveTextDocument_declaration(
        DeclarationParams &/*params*/
    ) -> TextDocument_DeclarationResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/declaration\""
        );
    }

    // request: "textDocument/selectionRange"
    auto LspLanguageServer::receiveTextDocument_selectionRange(
        SelectionRangeParams &/*params*/
    ) -> TextDocument_SelectionRangeResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/selectionRange\""
        );
    }

    // request: "window/workDoneProgress/create"
    auto LspLanguageServer::sendWindow_workDoneProgress_create(
        WorkDoneProgressCreateParams &params
    ) -> int
    {
        auto method_0 = "window/workDoneProgress/create";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "window/workDoneProgress/create"
    auto LspLanguageServer::receiveWindow_workDoneProgress_create(
        Window_WorkDoneProgress_CreateResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"window/workDoneProgress/create\""
            << std::endl;
    }

    // request: "textDocument/semanticTokens/full"
    auto LspLanguageServer::receiveTextDocument_semanticTokens_full(
        SemanticTokensParams &/*params*/
    ) -> TextDocument_SemanticTokens_FullResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/semanticTokens/full\""
        );
    }

    // request: "textDocument/semanticTokens/full/delta"
    auto LspLanguageServer::receiveTextDocument_semanticTokens_full_delta(
        SemanticTokensDeltaParams &/*params*/
    ) -> TextDocument_SemanticTokens_Full_DeltaResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/semanticTokens/full/delta\""
        );
    }

    // request: "textDocument/semanticTokens/range"
    auto LspLanguageServer::receiveTextDocument_semanticTokens_range(
        SemanticTokensRangeParams &/*params*/
    ) -> TextDocument_SemanticTokens_RangeResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/semanticTokens/range\""
        );
    }

    // request: "textDocument/linkedEditingRange"
    auto LspLanguageServer::receiveTextDocument_linkedEditingRange(
        LinkedEditingRangeParams &/*params*/
    ) -> TextDocument_LinkedEditingRangeResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/linkedEditingRange\""
        );
    }

    // request: "workspace/willCreateFiles"
    auto LspLanguageServer::receiveWorkspace_willCreateFiles(
        CreateFilesParams &/*params*/
    ) -> Workspace_WillCreateFilesResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/willCreateFiles\""
        );
    }

    // request: "workspace/willRenameFiles"
    auto LspLanguageServer::receiveWorkspace_willRenameFiles(
        RenameFilesParams &/*params*/
    ) -> Workspace_WillRenameFilesResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/willRenameFiles\""
        );
    }

    // request: "workspace/willDeleteFiles"
    auto LspLanguageServer::receiveWorkspace_willDeleteFiles(
        DeleteFilesParams &/*params*/
    ) -> Workspace_WillDeleteFilesResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/willDeleteFiles\""
        );
    }

    // request: "textDocument/moniker"
    auto LspLanguageServer::receiveTextDocument_moniker(
        MonikerParams &/*params*/
    ) -> TextDocument_MonikerResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/moniker\""
        );
    }

    // request: "textDocument/inlineValue"
    auto LspLanguageServer::receiveTextDocument_inlineValue(
        InlineValueParams &/*params*/
    ) -> TextDocument_InlineValueResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/inlineValue\""
        );
    }

    // request: "textDocument/hover"
    auto LspLanguageServer::receiveTextDocument_hover(
        HoverParams &/*params*/
    ) -> TextDocument_HoverResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/hover\""
        );
    }

    // request: "textDocument/signatureHelp"
    auto LspLanguageServer::receiveTextDocument_signatureHelp(
        SignatureHelpParams &/*params*/
    ) -> TextDocument_SignatureHelpResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/signatureHelp\""
        );
    }

    // request: "textDocument/definition"
    auto LspLanguageServer::receiveTextDocument_definition(
        DefinitionParams &/*params*/
    ) -> TextDocument_DefinitionResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/definition\""
        );
    }

    // request: "textDocument/references"
    auto LspLanguageServer::receiveTextDocument_references(
        ReferenceParams &/*params*/
    ) -> TextDocument_ReferencesResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/references\""
        );
    }

    // request: "textDocument/documentHighlight"
    auto LspLanguageServer::receiveTextDocument_documentHighlight(
        DocumentHighlightParams &/*params*/
    ) -> TextDocument_DocumentHighlightResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/documentHighlight\""
        );
    }

    // request: "textDocument/documentSymbol"
    auto LspLanguageServer::receiveTextDocument_documentSymbol(
        DocumentSymbolParams &/*params*/
    ) -> TextDocument_DocumentSymbolResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/documentSymbol\""
        );
    }

    // request: "textDocument/formatting"
    auto LspLanguageServer::receiveTextDocument_formatting(
        DocumentFormattingParams &/*params*/
    ) -> TextDocument_FormattingResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/formatting\""
        );
    }

    // request: "textDocument/rangeFormatting"
    auto LspLanguageServer::receiveTextDocument_rangeFormatting(
        DocumentRangeFormattingParams &/*params*/
    ) -> TextDocument_RangeFormattingResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/rangeFormatting\""
        );
    }

    // request: "textDocument/rangesFormatting"
    auto LspLanguageServer::receiveTextDocument_rangesFormatting(
        DocumentRangesFormattingParams &/*params*/
    ) -> TextDocument_RangesFormattingResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/rangesFormatting\""
        );
    }

    // request: "textDocument/rename"
    auto LspLanguageServer::receiveTextDocument_rename(
        RenameParams &/*params*/
    ) -> TextDocument_RenameResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/rename\""
        );
    }

    // request: "textDocument/prepareRename"
    auto LspLanguageServer::receiveTextDocument_prepareRename(
        PrepareRenameParams &/*params*/
    ) -> TextDocument_PrepareRenameResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/prepareRename\""
        );
    }

    // request: "workspace/applyEdit"
    auto LspLanguageServer::sendWorkspace_applyEdit(
        ApplyWorkspaceEditParams &params
    ) -> int
    {
        auto method_0 = "workspace/applyEdit";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "workspace/applyEdit"
    auto LspLanguageServer::receiveWorkspace_applyEdit(
        Workspace_ApplyEditResult &/*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/applyEdit\""
            << std::endl;
    }

    // notification: "window/workDoneProgress/cancel"
    auto LspLanguageServer::receiveWindow_workDoneProgress_cancel(
        WorkDoneProgressCancelParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"window/workDoneProgress/cancel\""
        );
    }

    // notification: "textDocument/didOpen"
    auto LspLanguageServer::receiveTextDocument_didOpen(
        DidOpenTextDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/didOpen\""
        );
    }

    // notification: "textDocument/didChange"
    auto LspLanguageServer::receiveTextDocument_didChange(
        DidChangeTextDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/didChange\""
        );
    }

    // notification: "$/cancelRequest"
    auto LspLanguageServer::receiveCancelRequest(
        CancelParams &/*params*/
    ) -> void
    {
        // NOTE: If a server or client receives notifications starting with "$/" it
        // is free to ignore the notification:
        logger.debug()
            << "No handler exists for method: \"$/cancelRequest\""
            << std::endl;
    }

    // notification: "$/cancelRequest"
    auto LspLanguageServer::sendCancelRequest(CancelParams &params) -> void
    {
        auto method_0 = "$/cancelRequest";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // request: "textDocument/documentColor"
    auto LspLanguageServer::receiveTextDocument_documentColor(
        DocumentColorParams &/*params*/
    ) -> TextDocument_DocumentColorResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/documentColor\""
        );
    }

    // request: "textDocument/colorPresentation"
    auto LspLanguageServer::receiveTextDocument_colorPresentation(
        ColorPresentationParams &/*params*/
    ) -> TextDocument_ColorPresentationResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/colorPresentation\""
        );
    }

    // notification: "notebookDocument/didOpen"
    auto LspLanguageServer::receiveNotebookDocument_didOpen(
        DidOpenNotebookDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"notebookDocument/didOpen\""
        );
    }

    // notification: "notebookDocument/didChange"
    auto LspLanguageServer::receiveNotebookDocument_didChange(
        DidChangeNotebookDocumentParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"notebookDocument/didChange\""
        );
    }

    // request: "workspace/configuration"
    auto LspLanguageServer::sendWorkspace_configuration(
        ConfigurationParams &params
    ) -> int
    {
        auto method_0 = "workspace/configuration";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "workspace/configuration"
    auto LspLanguageServer::receiveWorkspace_configuration(
        Workspace_ConfigurationResult &/*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"workspace/configuration\""
            << std::endl;
    }

    // request: "textDocument/prepareCallHierarchy"
    auto LspLanguageServer::receiveTextDocument_prepareCallHierarchy(
        CallHierarchyPrepareParams &/*params*/
    ) -> TextDocument_PrepareCallHierarchyResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/prepareCallHierarchy\""
        );
    }

    // request: "callHierarchy/incomingCalls"
    auto LspLanguageServer::receiveCallHierarchy_incomingCalls(
        CallHierarchyIncomingCallsParams &/*params*/
    ) -> CallHierarchy_IncomingCallsResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"callHierarchy/incomingCalls\""
        );
    }

    // request: "callHierarchy/outgoingCalls"
    auto LspLanguageServer::receiveCallHierarchy_outgoingCalls(
        CallHierarchyOutgoingCallsParams &/*params*/
    ) -> CallHierarchy_OutgoingCallsResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"callHierarchy/outgoingCalls\""
        );
    }

    // request: "textDocument/prepareTypeHierarchy"
    auto LspLanguageServer::receiveTextDocument_prepareTypeHierarchy(
        TypeHierarchyPrepareParams &/*params*/
    ) -> TextDocument_PrepareTypeHierarchyResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/prepareTypeHierarchy\""
        );
    }

    // request: "typeHierarchy/supertypes"
    auto LspLanguageServer::receiveTypeHierarchy_supertypes(
        TypeHierarchySupertypesParams &/*params*/
    ) -> TypeHierarchy_SupertypesResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"typeHierarchy/supertypes\""
        );
    }

    // request: "typeHierarchy/subtypes"
    auto LspLanguageServer::receiveTypeHierarchy_subtypes(
        TypeHierarchySubtypesParams &/*params*/
    ) -> TypeHierarchy_SubtypesResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"typeHierarchy/subtypes\""
        );
    }

    // request: "textDocument/inlayHint"
    auto LspLanguageServer::receiveTextDocument_inlayHint(
        InlayHintParams &/*params*/
    ) -> TextDocument_InlayHintResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/inlayHint\""
        );
    }

    // request: "inlayHint/resolve"
    auto LspLanguageServer::receiveInlayHint_resolve(
        InlayHint &/*params*/
    ) -> InlayHint_ResolveResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"inlayHint/resolve\""
        );
    }

    // request: "textDocument/diagnostic"
    auto LspLanguageServer::receiveTextDocument_diagnostic(
        DocumentDiagnosticParams &/*params*/
    ) -> TextDocument_DiagnosticResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/diagnostic\""
        );
    }

    // request: "workspace/diagnostic"
    auto LspLanguageServer::receiveWorkspace_diagnostic(
        WorkspaceDiagnosticParams &/*params*/
    ) -> Workspace_DiagnosticResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/diagnostic\""
        );
    }

    // request: "textDocument/inlineCompletion"
    auto LspLanguageServer::receiveTextDocument_inlineCompletion(
        InlineCompletionParams &/*params*/
    ) -> TextDocument_InlineCompletionResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/inlineCompletion\""
        );
    }

    // request: "client/registerCapability"
    auto LspLanguageServer::sendClient_registerCapability(
        RegistrationParams &params
    ) -> int
    {
        auto method_0 = "client/registerCapability";
        auto params_0 = transformer.asMessageParams(params);
        return sendRequest(method_0, params_0);
    }

    // request: "client/registerCapability"
    auto LspLanguageServer::receiveClient_registerCapability(
        Client_RegisterCapabilityResult /*params*/
    ) -> void
    {
        logger.debug()
            << "No handler exists for method: \"client/registerCapability\""
            << std::endl;
    }

    // request: "initialize"
    auto LspLanguageServer::receiveInitialize(
        InitializeParams &/*params*/
    ) -> InitializeResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"initialize\""
        );
    }

    // request: "textDocument/completion"
    auto LspLanguageServer::receiveTextDocument_completion(
        CompletionParams &/*params*/
    ) -> TextDocument_CompletionResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/completion\""
        );
    }

    // request: "completionItem/resolve"
    auto LspLanguageServer::receiveCompletionItem_resolve(
        CompletionItem &/*params*/
    ) -> CompletionItem_ResolveResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"completionItem/resolve\""
        );
    }

    // request: "textDocument/codeAction"
    auto LspLanguageServer::receiveTextDocument_codeAction(
        CodeActionParams &/*params*/
    ) -> TextDocument_CodeActionResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/codeAction\""
        );
    }

    // request: "codeAction/resolve"
    auto LspLanguageServer::receiveCodeAction_resolve(
        CodeAction &/*params*/
    ) -> CodeAction_ResolveResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"codeAction/resolve\""
        );
    }

    // request: "workspace/symbol"
    auto LspLanguageServer::receiveWorkspace_symbol(
        WorkspaceSymbolParams &/*params*/
    ) -> Workspace_SymbolResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/symbol\""
        );
    }

    // request: "workspaceSymbol/resolve"
    auto LspLanguageServer::receiveWorkspaceSymbol_resolve(
        WorkspaceSymbol &/*params*/
    ) -> WorkspaceSymbol_ResolveResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspaceSymbol/resolve\""
        );
    }

    // request: "textDocument/codeLens"
    auto LspLanguageServer::receiveTextDocument_codeLens(
        CodeLensParams &/*params*/
    ) -> TextDocument_CodeLensResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/codeLens\""
        );
    }

    // request: "codeLens/resolve"
    auto LspLanguageServer::receiveCodeLens_resolve(
        CodeLens &/*params*/
    ) -> CodeLens_ResolveResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"codeLens/resolve\""
        );
    }

    // request: "textDocument/documentLink"
    auto LspLanguageServer::receiveTextDocument_documentLink(
        DocumentLinkParams &/*params*/
    ) -> TextDocument_DocumentLinkResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"textDocument/documentLink\""
        );
    }

    // request: "documentLink/resolve"
    auto LspLanguageServer::receiveDocumentLink_resolve(
        DocumentLink &/*params*/
    ) -> DocumentLink_ResolveResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"documentLink/resolve\""
        );
    }

    // request: "workspace/executeCommand"
    auto LspLanguageServer::receiveWorkspace_executeCommand(
        ExecuteCommandParams &/*params*/
    ) -> Workspace_ExecuteCommandResult
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/executeCommand\""
        );
    }

    // notification: "workspace/didChangeConfiguration"
    auto LspLanguageServer::receiveWorkspace_didChangeConfiguration(
        DidChangeConfigurationParams &/*params*/
    ) -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"workspace/didChangeConfiguration\""
        );
    }

    // notification: "telemetry/event"
    auto LspLanguageServer::sendTelemetry_event(LSPAny &params) -> void
    {
        auto method_0 = "telemetry/event";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // notification: "textDocument/publishDiagnostics"
    auto LspLanguageServer::sendTextDocument_publishDiagnostics(
        PublishDiagnosticsParams &params
    ) -> void
    {
        auto method_0 = "textDocument/publishDiagnostics";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // notification: "$/progress"
    auto LspLanguageServer::receiveProgress(ProgressParams &/*params*/) -> void
    {
        // NOTE: If a server or client receives notifications starting with "$/" it
        // is free to ignore the notification:
        logger.debug()
            << "No handler exists for method: \"$/progress\""
            << std::endl;
    }

    // notification: "$/progress"
    auto LspLanguageServer::sendProgress(ProgressParams &params) -> void
    {
        auto method_0 = "$/progress";
        auto params_0 = transformer.asMessageParams(params);
        sendNotification(method_0, params_0);
    }

    // notification: "exit"
    auto LspLanguageServer::receiveExit() -> void
    {
        throw LSP_EXCEPTION(
            ErrorCodes::MethodNotFound,
            "No handler exists for method: \"exit\""
        );
    }

} // namespace LCompilers::LanguageServerProtocol
