#ifndef LFORTRAN_ASR_H
#define LFORTRAN_ASR_H

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>


namespace LCompilers::ASR {

enum asrType
{
    unit, symbol, stmt, expr, ttype, attribute, tbind, case_stmt, type_stmt, require_instantiation
};

struct asr_t
{
    asrType type;
    Location loc;
};


template <class T, class U>
inline bool is_a(const U &x)
{
    return T::class_type == x.type;
}

// Cast one level down

template <class T, class U>
static inline T* down_cast(const U *f)
{
    LCOMPILERS_ASSERT(f != nullptr);
    LCOMPILERS_ASSERT(is_a<T>(*f));
    return (T*)f;
}

// Cast two levels down

template <class T>
static inline T* down_cast2(const asr_t *f)
{
    typedef typename T::parent_type ptype;
    ptype *t = down_cast<ptype>(f);
    return down_cast<T>(t);
}

/******************************************************************************/
// Forward declarations

struct unit_t; // Sum
struct symbol_t; // Sum
struct stmt_t; // Sum
struct expr_t; // Sum
struct ttype_t; // Sum
enum cast_kindType // Simple Sum
{ // Types
    RealToInteger, IntegerToReal, LogicalToReal, RealToReal, IntegerToInteger, RealToComplex, IntegerToComplex, IntegerToLogical, RealToLogical, StringToLogical, StringToInteger, StringToList, ComplexToLogical, ComplexToComplex, ComplexToReal, ComplexToInteger, LogicalToInteger, RealToString, IntegerToString, LogicalToString, UnsignedIntegerToInteger, UnsignedIntegerToUnsignedInteger, UnsignedIntegerToReal, UnsignedIntegerToLogical, IntegerToUnsignedInteger, RealToUnsignedInteger, CPtrToUnsignedInteger, UnsignedIntegerToCPtr, IntegerToSymbolicExpression, ListToArray
};
enum storage_typeType // Simple Sum
{ // Types
    Default, Save, Parameter
};
enum accessType // Simple Sum
{ // Types
    Public, Private
};
enum intentType // Simple Sum
{ // Types
    Local, In, Out, InOut, ReturnVar, Unspecified
};
enum deftypeType // Simple Sum
{ // Types
    Implementation, Interface
};
enum presenceType // Simple Sum
{ // Types
    Required, Optional
};
enum abiType // Simple Sum
{ // Types
    Source, LFortranModule, GFortranModule, BindC, BindPython, BindJS, Interactive, Intrinsic
};
struct dimension_t; // Product
struct alloc_arg_t; // Product
struct attribute_t; // Sum
struct attribute_arg_t; // Product
struct call_arg_t; // Product
struct reduction_expr_t; // Product
struct tbind_t; // Sum
struct array_index_t; // Product
struct do_loop_head_t; // Product
struct case_stmt_t; // Sum
struct type_stmt_t; // Sum
enum enumtypeType // Simple Sum
{ // Types
    IntegerConsecutiveFromZero, IntegerUnique, IntegerNotUnique, NonInteger
};
struct require_instantiation_t; // Sum
enum array_physical_typeType // Simple Sum
{ // Types
    DescriptorArray, PointerToDataArray, UnboundedPointerToDataArray, FixedSizeArray, StringArraySinglePointer, NumPyArray, ISODescriptorArray, SIMDArray
};
enum string_physical_typeType // Simple Sum
{ // Types
    PointerString, DescriptorString
};
enum binopType // Simple Sum
{ // Types
    Add, Sub, Mul, Div, Pow, BitAnd, BitOr, BitXor, BitLShift, BitRShift
};
enum reduction_opType // Simple Sum
{ // Types
    ReduceAdd, ReduceSub, ReduceMul, ReduceMIN, ReduceMAX
};
enum logicalbinopType // Simple Sum
{ // Types
    And, Or, Xor, NEqv, Eqv
};
enum cmpopType // Simple Sum
{ // Types
    Eq, NotEq, Lt, LtE, Gt, GtE
};
enum integerbozType // Simple Sum
{ // Types
    Binary, Hex, Octal, Decimal
};
enum arrayboundType // Simple Sum
{ // Types
    LBound, UBound
};
enum arraystorageType // Simple Sum
{ // Types
    RowMajor, ColMajor
};
enum string_format_kindType // Simple Sum
{ // Types
    FormatFortran, FormatC, FormatPythonPercent, FormatPythonFString, FormatPythonFormat
};


/******************************************************************************/
// Products declarations

struct dimension_t // Product
{
    Location loc;
    expr_t* m_start;
    expr_t* m_length;
};
struct alloc_arg_t // Product
{
    Location loc;
    expr_t* m_a;
    dimension_t* m_dims; size_t n_dims; // Sequence
    expr_t* m_len_expr;
    ttype_t* m_type;
};
struct attribute_arg_t // Product
{
    Location loc;
    char* m_arg;
};
struct call_arg_t // Product
{
    Location loc;
    expr_t* m_value;
};
struct reduction_expr_t // Product
{
    Location loc;
    reduction_opType m_op;
    expr_t* m_arg;
};
struct array_index_t // Product
{
    Location loc;
    expr_t* m_left;
    expr_t* m_right;
    expr_t* m_step;
};
struct do_loop_head_t // Product
{
    Location loc;
    expr_t* m_v;
    expr_t* m_start;
    expr_t* m_end;
    expr_t* m_increment;
};


/******************************************************************************/
// Sums declarations

enum unitType // Types
{
    TranslationUnit
};

struct unit_t // Sum
{
    const static asrType class_type = asrType::unit;
    asr_t base;
    unitType type;
};

    struct TranslationUnit_t // Constructor
    {
        const static unitType class_type = unitType::TranslationUnit;
        typedef unit_t parent_type;
        unit_t base;
        SymbolTable* m_symtab;
        asr_t** m_items; size_t n_items; // Sequence
    };
    static inline asr_t* make_TranslationUnit_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, asr_t** a_items, size_t n_items) {
        TranslationUnit_t *n;
        n = al.make_new<TranslationUnit_t>();
        n->base.type = unitType::TranslationUnit;
        n->base.base.type = asrType::unit;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_items = a_items;
        n->n_items = n_items;
        return (asr_t*)n;
    }



enum symbolType // Types
{
    Program, Module, Function, GenericProcedure, CustomOperator, ExternalSymbol, Struct, Enum, Union, Variable, Class, ClassProcedure, AssociateBlock, Block, Requirement, Template
};

struct symbol_t // Sum
{
    const static asrType class_type = asrType::symbol;
    asr_t base;
    symbolType type;
};

    struct Program_t // Constructor
    {
        const static symbolType class_type = symbolType::Program;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        Location* m_start_name;
        Location* m_end_name;
    };
    static inline asr_t* make_Program_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, stmt_t** a_body, size_t n_body, Location* a_start_name = nullptr, Location* a_end_name = nullptr) {
        Program_t *n;
        n = al.make_new<Program_t>();
        n->base.type = symbolType::Program;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_start_name = a_start_name;
        n->m_end_name = a_end_name;
        return (asr_t*)n;
    }

    struct Module_t // Constructor
    {
        const static symbolType class_type = symbolType::Module;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        bool m_loaded_from_mod;
        bool m_intrinsic;
        Location* m_start_name;
        Location* m_end_name;
    };
    static inline asr_t* make_Module_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, bool a_loaded_from_mod, bool a_intrinsic, Location* a_start_name = nullptr, Location* a_end_name = nullptr) {
        Module_t *n;
        n = al.make_new<Module_t>();
        n->base.type = symbolType::Module;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_loaded_from_mod = a_loaded_from_mod;
        n->m_intrinsic = a_intrinsic;
        n->m_start_name = a_start_name;
        n->m_end_name = a_end_name;
        return (asr_t*)n;
    }

    struct Function_t // Constructor
    {
        const static symbolType class_type = symbolType::Function;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        ttype_t* m_function_signature;
        char** m_dependencies; size_t n_dependencies; // Sequence
        expr_t** m_args; size_t n_args; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        expr_t* m_return_var;
        accessType m_access;
        bool m_deterministic;
        bool m_side_effect_free;
        char* m_module_file;
        Location* m_start_name;
        Location* m_end_name;
    };
    static inline asr_t* make_Function_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, ttype_t* a_function_signature, char** a_dependencies, size_t n_dependencies, expr_t** a_args, size_t n_args, stmt_t** a_body, size_t n_body, expr_t* a_return_var, accessType a_access, bool a_deterministic, bool a_side_effect_free, char* a_module_file, Location* a_start_name = nullptr, Location* a_end_name = nullptr) {
        Function_t *n;
        n = al.make_new<Function_t>();
        n->base.type = symbolType::Function;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_function_signature = a_function_signature;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_return_var = a_return_var;
        n->m_access = a_access;
        n->m_deterministic = a_deterministic;
        n->m_side_effect_free = a_side_effect_free;
        n->m_module_file = a_module_file;
        n->m_start_name = a_start_name;
        n->m_end_name = a_end_name;
        return (asr_t*)n;
    }

    struct GenericProcedure_t // Constructor
    {
        const static symbolType class_type = symbolType::GenericProcedure;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        symbol_t** m_procs; size_t n_procs; // Sequence
        accessType m_access;
    };
    static inline asr_t* make_GenericProcedure_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, symbol_t** a_procs, size_t n_procs, accessType a_access) {
        GenericProcedure_t *n;
        n = al.make_new<GenericProcedure_t>();
        n->base.type = symbolType::GenericProcedure;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_procs = a_procs;
        n->n_procs = n_procs;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct CustomOperator_t // Constructor
    {
        const static symbolType class_type = symbolType::CustomOperator;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        symbol_t** m_procs; size_t n_procs; // Sequence
        accessType m_access;
    };
    static inline asr_t* make_CustomOperator_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, symbol_t** a_procs, size_t n_procs, accessType a_access) {
        CustomOperator_t *n;
        n = al.make_new<CustomOperator_t>();
        n->base.type = symbolType::CustomOperator;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_procs = a_procs;
        n->n_procs = n_procs;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct ExternalSymbol_t // Constructor
    {
        const static symbolType class_type = symbolType::ExternalSymbol;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        symbol_t* m_external;
        char* m_module_name;
        char** m_scope_names; size_t n_scope_names; // Sequence
        char* m_original_name;
        accessType m_access;
    };
    static inline asr_t* make_ExternalSymbol_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, symbol_t* a_external, char* a_module_name, char** a_scope_names, size_t n_scope_names, char* a_original_name, accessType a_access) {
        ExternalSymbol_t *n;
        n = al.make_new<ExternalSymbol_t>();
        n->base.type = symbolType::ExternalSymbol;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_external = a_external;
        n->m_module_name = a_module_name;
        n->m_scope_names = a_scope_names;
        n->n_scope_names = n_scope_names;
        n->m_original_name = a_original_name;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct Struct_t // Constructor
    {
        const static symbolType class_type = symbolType::Struct;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        char** m_members; size_t n_members; // Sequence
        abiType m_abi;
        accessType m_access;
        bool m_is_packed;
        bool m_is_abstract;
        call_arg_t* m_initializers; size_t n_initializers; // Sequence
        expr_t* m_alignment;
        symbol_t* m_parent;
    };
    static inline asr_t* make_Struct_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, char** a_members, size_t n_members, abiType a_abi, accessType a_access, bool a_is_packed, bool a_is_abstract, call_arg_t* a_initializers, size_t n_initializers, expr_t* a_alignment, symbol_t* a_parent) {
        Struct_t *n;
        n = al.make_new<Struct_t>();
        n->base.type = symbolType::Struct;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_members = a_members;
        n->n_members = n_members;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_is_packed = a_is_packed;
        n->m_is_abstract = a_is_abstract;
        n->m_initializers = a_initializers;
        n->n_initializers = n_initializers;
        n->m_alignment = a_alignment;
        n->m_parent = a_parent;
        return (asr_t*)n;
    }

    struct Enum_t // Constructor
    {
        const static symbolType class_type = symbolType::Enum;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        char** m_members; size_t n_members; // Sequence
        abiType m_abi;
        accessType m_access;
        enumtypeType m_enum_value_type;
        ttype_t* m_type;
        symbol_t* m_parent;
    };
    static inline asr_t* make_Enum_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, char** a_members, size_t n_members, abiType a_abi, accessType a_access, enumtypeType a_enum_value_type, ttype_t* a_type, symbol_t* a_parent) {
        Enum_t *n;
        n = al.make_new<Enum_t>();
        n->base.type = symbolType::Enum;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_members = a_members;
        n->n_members = n_members;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_enum_value_type = a_enum_value_type;
        n->m_type = a_type;
        n->m_parent = a_parent;
        return (asr_t*)n;
    }

    struct Union_t // Constructor
    {
        const static symbolType class_type = symbolType::Union;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        char** m_members; size_t n_members; // Sequence
        abiType m_abi;
        accessType m_access;
        call_arg_t* m_initializers; size_t n_initializers; // Sequence
        symbol_t* m_parent;
    };
    static inline asr_t* make_Union_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, char** a_members, size_t n_members, abiType a_abi, accessType a_access, call_arg_t* a_initializers, size_t n_initializers, symbol_t* a_parent) {
        Union_t *n;
        n = al.make_new<Union_t>();
        n->base.type = symbolType::Union;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_members = a_members;
        n->n_members = n_members;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_initializers = a_initializers;
        n->n_initializers = n_initializers;
        n->m_parent = a_parent;
        return (asr_t*)n;
    }

    struct Variable_t // Constructor
    {
        const static symbolType class_type = symbolType::Variable;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        intentType m_intent;
        expr_t* m_symbolic_value;
        expr_t* m_value;
        storage_typeType m_storage;
        ttype_t* m_type;
        symbol_t* m_type_declaration;
        abiType m_abi;
        accessType m_access;
        presenceType m_presence;
        bool m_value_attr;
        bool m_target_attr;
        bool m_contiguous_attr;
    };
    static inline asr_t* make_Variable_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, intentType a_intent, expr_t* a_symbolic_value, expr_t* a_value, storage_typeType a_storage, ttype_t* a_type, symbol_t* a_type_declaration, abiType a_abi, accessType a_access, presenceType a_presence, bool a_value_attr, bool a_target_attr, bool a_contiguous_attr) {
        Variable_t *n;
        n = al.make_new<Variable_t>();
        n->base.type = symbolType::Variable;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_intent = a_intent;
        n->m_symbolic_value = a_symbolic_value;
        n->m_value = a_value;
        n->m_storage = a_storage;
        n->m_type = a_type;
        n->m_type_declaration = a_type_declaration;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_presence = a_presence;
        n->m_value_attr = a_value_attr;
        n->m_target_attr = a_target_attr;
        n->m_contiguous_attr = a_contiguous_attr;
        return (asr_t*)n;
    }

    struct Class_t // Constructor
    {
        const static symbolType class_type = symbolType::Class;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        abiType m_abi;
        accessType m_access;
    };
    static inline asr_t* make_Class_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, abiType a_abi, accessType a_access) {
        Class_t *n;
        n = al.make_new<Class_t>();
        n->base.type = symbolType::Class;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_abi = a_abi;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct ClassProcedure_t // Constructor
    {
        const static symbolType class_type = symbolType::ClassProcedure;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        char* m_self_argument;
        char* m_proc_name;
        symbol_t* m_proc;
        abiType m_abi;
        bool m_is_deferred;
        bool m_is_nopass;
    };
    static inline asr_t* make_ClassProcedure_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, char* a_self_argument, char* a_proc_name, symbol_t* a_proc, abiType a_abi, bool a_is_deferred, bool a_is_nopass) {
        ClassProcedure_t *n;
        n = al.make_new<ClassProcedure_t>();
        n->base.type = symbolType::ClassProcedure;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_self_argument = a_self_argument;
        n->m_proc_name = a_proc_name;
        n->m_proc = a_proc;
        n->m_abi = a_abi;
        n->m_is_deferred = a_is_deferred;
        n->m_is_nopass = a_is_nopass;
        return (asr_t*)n;
    }

    struct AssociateBlock_t // Constructor
    {
        const static symbolType class_type = symbolType::AssociateBlock;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_AssociateBlock_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, stmt_t** a_body, size_t n_body) {
        AssociateBlock_t *n;
        n = al.make_new<AssociateBlock_t>();
        n->base.type = symbolType::AssociateBlock;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Block_t // Constructor
    {
        const static symbolType class_type = symbolType::Block;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_Block_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, stmt_t** a_body, size_t n_body) {
        Block_t *n;
        n = al.make_new<Block_t>();
        n->base.type = symbolType::Block;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Requirement_t // Constructor
    {
        const static symbolType class_type = symbolType::Requirement;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_args; size_t n_args; // Sequence
        require_instantiation_t** m_requires; size_t n_requires; // Sequence
    };
    static inline asr_t* make_Requirement_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_args, size_t n_args, require_instantiation_t** a_requires, size_t n_requires) {
        Requirement_t *n;
        n = al.make_new<Requirement_t>();
        n->base.type = symbolType::Requirement;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_requires = a_requires;
        n->n_requires = n_requires;
        return (asr_t*)n;
    }

    struct Template_t // Constructor
    {
        const static symbolType class_type = symbolType::Template;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_args; size_t n_args; // Sequence
        require_instantiation_t** m_requires; size_t n_requires; // Sequence
    };
    static inline asr_t* make_Template_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_args, size_t n_args, require_instantiation_t** a_requires, size_t n_requires) {
        Template_t *n;
        n = al.make_new<Template_t>();
        n->base.type = symbolType::Template;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_requires = a_requires;
        n->n_requires = n_requires;
        return (asr_t*)n;
    }



enum stmtType // Types
{
    Allocate, ReAlloc, Assign, Assignment, Associate, Cycle, ExplicitDeallocate, ImplicitDeallocate, DoConcurrentLoop, DoLoop, ErrorStop, Exit, ForAllSingle, GoTo, GoToTarget, If, IfArithmetic, Print, FileOpen, FileClose, FileRead, FileBackspace, FileRewind, FileInquire, FileWrite, Return, Select, Stop, Assert, SubroutineCall, IntrinsicImpureSubroutine, Where, WhileLoop, Nullify, Flush, ListAppend, AssociateBlockCall, SelectType, CPtrToPointer, BlockCall, SetInsert, SetRemove, ListInsert, ListRemove, ListClear, DictInsert, Expr
};

struct stmt_t // Sum
{
    const static asrType class_type = asrType::stmt;
    asr_t base;
    stmtType type;
};

    struct Allocate_t // Constructor
    {
        const static stmtType class_type = stmtType::Allocate;
        typedef stmt_t parent_type;
        stmt_t base;
        alloc_arg_t* m_args; size_t n_args; // Sequence
        expr_t* m_stat;
        expr_t* m_errmsg;
        expr_t* m_source;
    };
    static inline asr_t* make_Allocate_t(Allocator &al, const Location &a_loc, alloc_arg_t* a_args, size_t n_args, expr_t* a_stat, expr_t* a_errmsg, expr_t* a_source) {
        Allocate_t *n;
        n = al.make_new<Allocate_t>();
        n->base.type = stmtType::Allocate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_stat = a_stat;
        n->m_errmsg = a_errmsg;
        n->m_source = a_source;
        return (asr_t*)n;
    }

    struct ReAlloc_t // Constructor
    {
        const static stmtType class_type = stmtType::ReAlloc;
        typedef stmt_t parent_type;
        stmt_t base;
        alloc_arg_t* m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_ReAlloc_t(Allocator &al, const Location &a_loc, alloc_arg_t* a_args, size_t n_args) {
        ReAlloc_t *n;
        n = al.make_new<ReAlloc_t>();
        n->base.type = stmtType::ReAlloc;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }

    struct Assign_t // Constructor
    {
        const static stmtType class_type = stmtType::Assign;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_variable;
    };
    static inline asr_t* make_Assign_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_variable) {
        Assign_t *n;
        n = al.make_new<Assign_t>();
        n->base.type = stmtType::Assign;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_variable = a_variable;
        return (asr_t*)n;
    }

    struct Assignment_t // Constructor
    {
        const static stmtType class_type = stmtType::Assignment;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
        stmt_t* m_overloaded;
    };
    static inline asr_t* make_Assignment_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value, stmt_t* a_overloaded) {
        Assignment_t *n;
        n = al.make_new<Assignment_t>();
        n->base.type = stmtType::Assignment;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct Associate_t // Constructor
    {
        const static stmtType class_type = stmtType::Associate;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
    };
    static inline asr_t* make_Associate_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value) {
        Associate_t *n;
        n = al.make_new<Associate_t>();
        n->base.type = stmtType::Associate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Cycle_t // Constructor
    {
        const static stmtType class_type = stmtType::Cycle;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_stmt_name;
    };
    static inline asr_t* make_Cycle_t(Allocator &al, const Location &a_loc, char* a_stmt_name) {
        Cycle_t *n;
        n = al.make_new<Cycle_t>();
        n->base.type = stmtType::Cycle;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_stmt_name = a_stmt_name;
        return (asr_t*)n;
    }

    struct ExplicitDeallocate_t // Constructor
    {
        const static stmtType class_type = stmtType::ExplicitDeallocate;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t** m_vars; size_t n_vars; // Sequence
    };
    static inline asr_t* make_ExplicitDeallocate_t(Allocator &al, const Location &a_loc, expr_t** a_vars, size_t n_vars) {
        ExplicitDeallocate_t *n;
        n = al.make_new<ExplicitDeallocate_t>();
        n->base.type = stmtType::ExplicitDeallocate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (asr_t*)n;
    }

    struct ImplicitDeallocate_t // Constructor
    {
        const static stmtType class_type = stmtType::ImplicitDeallocate;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t** m_vars; size_t n_vars; // Sequence
    };
    static inline asr_t* make_ImplicitDeallocate_t(Allocator &al, const Location &a_loc, expr_t** a_vars, size_t n_vars) {
        ImplicitDeallocate_t *n;
        n = al.make_new<ImplicitDeallocate_t>();
        n->base.type = stmtType::ImplicitDeallocate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (asr_t*)n;
    }

    struct DoConcurrentLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::DoConcurrentLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        do_loop_head_t* m_head; size_t n_head; // Sequence
        expr_t** m_shared; size_t n_shared; // Sequence
        expr_t** m_local; size_t n_local; // Sequence
        reduction_expr_t* m_reduction; size_t n_reduction; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_DoConcurrentLoop_t(Allocator &al, const Location &a_loc, do_loop_head_t* a_head, size_t n_head, expr_t** a_shared, size_t n_shared, expr_t** a_local, size_t n_local, reduction_expr_t* a_reduction, size_t n_reduction, stmt_t** a_body, size_t n_body) {
        DoConcurrentLoop_t *n;
        n = al.make_new<DoConcurrentLoop_t>();
        n->base.type = stmtType::DoConcurrentLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_head = a_head;
        n->n_head = n_head;
        n->m_shared = a_shared;
        n->n_shared = n_shared;
        n->m_local = a_local;
        n->n_local = n_local;
        n->m_reduction = a_reduction;
        n->n_reduction = n_reduction;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct DoLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::DoLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_name;
        do_loop_head_t m_head;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_DoLoop_t(Allocator &al, const Location &a_loc, char* a_name, do_loop_head_t a_head, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        DoLoop_t *n;
        n = al.make_new<DoLoop_t>();
        n->base.type = stmtType::DoLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_head = a_head;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct ErrorStop_t // Constructor
    {
        const static stmtType class_type = stmtType::ErrorStop;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_code;
    };
    static inline asr_t* make_ErrorStop_t(Allocator &al, const Location &a_loc, expr_t* a_code) {
        ErrorStop_t *n;
        n = al.make_new<ErrorStop_t>();
        n->base.type = stmtType::ErrorStop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_code = a_code;
        return (asr_t*)n;
    }

    struct Exit_t // Constructor
    {
        const static stmtType class_type = stmtType::Exit;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_stmt_name;
    };
    static inline asr_t* make_Exit_t(Allocator &al, const Location &a_loc, char* a_stmt_name) {
        Exit_t *n;
        n = al.make_new<Exit_t>();
        n->base.type = stmtType::Exit;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_stmt_name = a_stmt_name;
        return (asr_t*)n;
    }

    struct ForAllSingle_t // Constructor
    {
        const static stmtType class_type = stmtType::ForAllSingle;
        typedef stmt_t parent_type;
        stmt_t base;
        do_loop_head_t m_head;
        stmt_t* m_assign_stmt;
    };
    static inline asr_t* make_ForAllSingle_t(Allocator &al, const Location &a_loc, do_loop_head_t a_head, stmt_t* a_assign_stmt) {
        ForAllSingle_t *n;
        n = al.make_new<ForAllSingle_t>();
        n->base.type = stmtType::ForAllSingle;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_head = a_head;
        n->m_assign_stmt = a_assign_stmt;
        return (asr_t*)n;
    }

    struct GoTo_t // Constructor
    {
        const static stmtType class_type = stmtType::GoTo;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_target_id;
        char* m_name;
    };
    static inline asr_t* make_GoTo_t(Allocator &al, const Location &a_loc, int64_t a_target_id, char* a_name) {
        GoTo_t *n;
        n = al.make_new<GoTo_t>();
        n->base.type = stmtType::GoTo;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target_id = a_target_id;
        n->m_name = a_name;
        return (asr_t*)n;
    }

    struct GoToTarget_t // Constructor
    {
        const static stmtType class_type = stmtType::GoToTarget;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_id;
        char* m_name;
    };
    static inline asr_t* make_GoToTarget_t(Allocator &al, const Location &a_loc, int64_t a_id, char* a_name) {
        GoToTarget_t *n;
        n = al.make_new<GoToTarget_t>();
        n->base.type = stmtType::GoToTarget;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        n->m_name = a_name;
        return (asr_t*)n;
    }

    struct If_t // Constructor
    {
        const static stmtType class_type = stmtType::If;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_If_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        If_t *n;
        n = al.make_new<If_t>();
        n->base.type = stmtType::If;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct IfArithmetic_t // Constructor
    {
        const static stmtType class_type = stmtType::IfArithmetic;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        int64_t m_lt_label;
        int64_t m_eq_label;
        int64_t m_gt_label;
    };
    static inline asr_t* make_IfArithmetic_t(Allocator &al, const Location &a_loc, expr_t* a_test, int64_t a_lt_label, int64_t a_eq_label, int64_t a_gt_label) {
        IfArithmetic_t *n;
        n = al.make_new<IfArithmetic_t>();
        n->base.type = stmtType::IfArithmetic;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_lt_label = a_lt_label;
        n->m_eq_label = a_eq_label;
        n->m_gt_label = a_gt_label;
        return (asr_t*)n;
    }

    struct Print_t // Constructor
    {
        const static stmtType class_type = stmtType::Print;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_text;
    };
    static inline asr_t* make_Print_t(Allocator &al, const Location &a_loc, expr_t* a_text) {
        Print_t *n;
        n = al.make_new<Print_t>();
        n->base.type = stmtType::Print;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_text = a_text;
        return (asr_t*)n;
    }

    struct FileOpen_t // Constructor
    {
        const static stmtType class_type = stmtType::FileOpen;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_newunit;
        expr_t* m_filename;
        expr_t* m_status;
        expr_t* m_form;
    };
    static inline asr_t* make_FileOpen_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_newunit, expr_t* a_filename, expr_t* a_status, expr_t* a_form) {
        FileOpen_t *n;
        n = al.make_new<FileOpen_t>();
        n->base.type = stmtType::FileOpen;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_newunit = a_newunit;
        n->m_filename = a_filename;
        n->m_status = a_status;
        n->m_form = a_form;
        return (asr_t*)n;
    }

    struct FileClose_t // Constructor
    {
        const static stmtType class_type = stmtType::FileClose;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iostat;
        expr_t* m_iomsg;
        expr_t* m_err;
        expr_t* m_status;
    };
    static inline asr_t* make_FileClose_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iostat, expr_t* a_iomsg, expr_t* a_err, expr_t* a_status) {
        FileClose_t *n;
        n = al.make_new<FileClose_t>();
        n->base.type = stmtType::FileClose;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iostat = a_iostat;
        n->m_iomsg = a_iomsg;
        n->m_err = a_err;
        n->m_status = a_status;
        return (asr_t*)n;
    }

    struct FileRead_t // Constructor
    {
        const static stmtType class_type = stmtType::FileRead;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_fmt;
        expr_t* m_iomsg;
        expr_t* m_iostat;
        expr_t* m_size;
        expr_t* m_id;
        expr_t** m_values; size_t n_values; // Sequence
        stmt_t* m_overloaded;
    };
    static inline asr_t* make_FileRead_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_fmt, expr_t* a_iomsg, expr_t* a_iostat, expr_t* a_size, expr_t* a_id, expr_t** a_values, size_t n_values, stmt_t* a_overloaded) {
        FileRead_t *n;
        n = al.make_new<FileRead_t>();
        n->base.type = stmtType::FileRead;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_fmt = a_fmt;
        n->m_iomsg = a_iomsg;
        n->m_iostat = a_iostat;
        n->m_size = a_size;
        n->m_id = a_id;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct FileBackspace_t // Constructor
    {
        const static stmtType class_type = stmtType::FileBackspace;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iostat;
        expr_t* m_err;
    };
    static inline asr_t* make_FileBackspace_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iostat, expr_t* a_err) {
        FileBackspace_t *n;
        n = al.make_new<FileBackspace_t>();
        n->base.type = stmtType::FileBackspace;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iostat = a_iostat;
        n->m_err = a_err;
        return (asr_t*)n;
    }

    struct FileRewind_t // Constructor
    {
        const static stmtType class_type = stmtType::FileRewind;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iostat;
        expr_t* m_err;
    };
    static inline asr_t* make_FileRewind_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iostat, expr_t* a_err) {
        FileRewind_t *n;
        n = al.make_new<FileRewind_t>();
        n->base.type = stmtType::FileRewind;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iostat = a_iostat;
        n->m_err = a_err;
        return (asr_t*)n;
    }

    struct FileInquire_t // Constructor
    {
        const static stmtType class_type = stmtType::FileInquire;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_file;
        expr_t* m_iostat;
        expr_t* m_err;
        expr_t* m_exist;
        expr_t* m_opened;
        expr_t* m_number;
        expr_t* m_named;
        expr_t* m_name;
        expr_t* m_access;
        expr_t* m_sequential;
        expr_t* m_direct;
        expr_t* m_form;
        expr_t* m_formatted;
        expr_t* m_unformatted;
        expr_t* m_recl;
        expr_t* m_nextrec;
        expr_t* m_blank;
        expr_t* m_position;
        expr_t* m_action;
        expr_t* m_read;
        expr_t* m_write;
        expr_t* m_readwrite;
        expr_t* m_delim;
        expr_t* m_pad;
        expr_t* m_flen;
        expr_t* m_blocksize;
        expr_t* m_convert;
        expr_t* m_carriagecontrol;
        expr_t* m_size;
        expr_t* m_iolength;
    };
    static inline asr_t* make_FileInquire_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_file, expr_t* a_iostat, expr_t* a_err, expr_t* a_exist, expr_t* a_opened, expr_t* a_number, expr_t* a_named, expr_t* a_name, expr_t* a_access, expr_t* a_sequential, expr_t* a_direct, expr_t* a_form, expr_t* a_formatted, expr_t* a_unformatted, expr_t* a_recl, expr_t* a_nextrec, expr_t* a_blank, expr_t* a_position, expr_t* a_action, expr_t* a_read, expr_t* a_write, expr_t* a_readwrite, expr_t* a_delim, expr_t* a_pad, expr_t* a_flen, expr_t* a_blocksize, expr_t* a_convert, expr_t* a_carriagecontrol, expr_t* a_size, expr_t* a_iolength) {
        FileInquire_t *n;
        n = al.make_new<FileInquire_t>();
        n->base.type = stmtType::FileInquire;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_file = a_file;
        n->m_iostat = a_iostat;
        n->m_err = a_err;
        n->m_exist = a_exist;
        n->m_opened = a_opened;
        n->m_number = a_number;
        n->m_named = a_named;
        n->m_name = a_name;
        n->m_access = a_access;
        n->m_sequential = a_sequential;
        n->m_direct = a_direct;
        n->m_form = a_form;
        n->m_formatted = a_formatted;
        n->m_unformatted = a_unformatted;
        n->m_recl = a_recl;
        n->m_nextrec = a_nextrec;
        n->m_blank = a_blank;
        n->m_position = a_position;
        n->m_action = a_action;
        n->m_read = a_read;
        n->m_write = a_write;
        n->m_readwrite = a_readwrite;
        n->m_delim = a_delim;
        n->m_pad = a_pad;
        n->m_flen = a_flen;
        n->m_blocksize = a_blocksize;
        n->m_convert = a_convert;
        n->m_carriagecontrol = a_carriagecontrol;
        n->m_size = a_size;
        n->m_iolength = a_iolength;
        return (asr_t*)n;
    }

    struct FileWrite_t // Constructor
    {
        const static stmtType class_type = stmtType::FileWrite;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iomsg;
        expr_t* m_iostat;
        expr_t* m_id;
        expr_t** m_values; size_t n_values; // Sequence
        expr_t* m_separator;
        expr_t* m_end;
        stmt_t* m_overloaded;
    };
    static inline asr_t* make_FileWrite_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iomsg, expr_t* a_iostat, expr_t* a_id, expr_t** a_values, size_t n_values, expr_t* a_separator, expr_t* a_end, stmt_t* a_overloaded) {
        FileWrite_t *n;
        n = al.make_new<FileWrite_t>();
        n->base.type = stmtType::FileWrite;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iomsg = a_iomsg;
        n->m_iostat = a_iostat;
        n->m_id = a_id;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_separator = a_separator;
        n->m_end = a_end;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct Return_t // Constructor
    {
        const static stmtType class_type = stmtType::Return;
        typedef stmt_t parent_type;
        stmt_t base;
    };
    static inline asr_t* make_Return_t(Allocator &al, const Location &a_loc) {
        Return_t *n;
        n = al.make_new<Return_t>();
        n->base.type = stmtType::Return;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct Select_t // Constructor
    {
        const static stmtType class_type = stmtType::Select;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        case_stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_default; size_t n_default; // Sequence
        bool m_enable_fall_through;
    };
    static inline asr_t* make_Select_t(Allocator &al, const Location &a_loc, expr_t* a_test, case_stmt_t** a_body, size_t n_body, stmt_t** a_default, size_t n_default, bool a_enable_fall_through) {
        Select_t *n;
        n = al.make_new<Select_t>();
        n->base.type = stmtType::Select;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_default = a_default;
        n->n_default = n_default;
        n->m_enable_fall_through = a_enable_fall_through;
        return (asr_t*)n;
    }

    struct Stop_t // Constructor
    {
        const static stmtType class_type = stmtType::Stop;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_code;
    };
    static inline asr_t* make_Stop_t(Allocator &al, const Location &a_loc, expr_t* a_code) {
        Stop_t *n;
        n = al.make_new<Stop_t>();
        n->base.type = stmtType::Stop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_code = a_code;
        return (asr_t*)n;
    }

    struct Assert_t // Constructor
    {
        const static stmtType class_type = stmtType::Assert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        expr_t* m_msg;
    };
    static inline asr_t* make_Assert_t(Allocator &al, const Location &a_loc, expr_t* a_test, expr_t* a_msg) {
        Assert_t *n;
        n = al.make_new<Assert_t>();
        n->base.type = stmtType::Assert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_msg = a_msg;
        return (asr_t*)n;
    }

    struct SubroutineCall_t // Constructor
    {
        const static stmtType class_type = stmtType::SubroutineCall;
        typedef stmt_t parent_type;
        stmt_t base;
        symbol_t* m_name;
        symbol_t* m_original_name;
        call_arg_t* m_args; size_t n_args; // Sequence
        expr_t* m_dt;
    };
    static inline asr_t* make_SubroutineCall_t(Allocator &al, const Location &a_loc, symbol_t* a_name, symbol_t* a_original_name, call_arg_t* a_args, size_t n_args, expr_t* a_dt) {
        SubroutineCall_t *n;
        n = al.make_new<SubroutineCall_t>();
        n->base.type = stmtType::SubroutineCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_original_name = a_original_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_dt = a_dt;
        return (asr_t*)n;
    }

    struct IntrinsicImpureSubroutine_t // Constructor
    {
        const static stmtType class_type = stmtType::IntrinsicImpureSubroutine;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_sub_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
    };
    static inline asr_t* make_IntrinsicImpureSubroutine_t(Allocator &al, const Location &a_loc, int64_t a_sub_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id) {
        IntrinsicImpureSubroutine_t *n;
        n = al.make_new<IntrinsicImpureSubroutine_t>();
        n->base.type = stmtType::IntrinsicImpureSubroutine;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_sub_intrinsic_id = a_sub_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        return (asr_t*)n;
    }

    struct Where_t // Constructor
    {
        const static stmtType class_type = stmtType::Where;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_Where_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        Where_t *n;
        n = al.make_new<Where_t>();
        n->base.type = stmtType::Where;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct WhileLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::WhileLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_name;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_WhileLoop_t(Allocator &al, const Location &a_loc, char* a_name, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        WhileLoop_t *n;
        n = al.make_new<WhileLoop_t>();
        n->base.type = stmtType::WhileLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct Nullify_t // Constructor
    {
        const static stmtType class_type = stmtType::Nullify;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t** m_vars; size_t n_vars; // Sequence
    };
    static inline asr_t* make_Nullify_t(Allocator &al, const Location &a_loc, expr_t** a_vars, size_t n_vars) {
        Nullify_t *n;
        n = al.make_new<Nullify_t>();
        n->base.type = stmtType::Nullify;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (asr_t*)n;
    }

    struct Flush_t // Constructor
    {
        const static stmtType class_type = stmtType::Flush;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_err;
        expr_t* m_iomsg;
        expr_t* m_iostat;
    };
    static inline asr_t* make_Flush_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_err, expr_t* a_iomsg, expr_t* a_iostat) {
        Flush_t *n;
        n = al.make_new<Flush_t>();
        n->base.type = stmtType::Flush;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_err = a_err;
        n->m_iomsg = a_iomsg;
        n->m_iostat = a_iostat;
        return (asr_t*)n;
    }

    struct ListAppend_t // Constructor
    {
        const static stmtType class_type = stmtType::ListAppend;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_ListAppend_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        ListAppend_t *n;
        n = al.make_new<ListAppend_t>();
        n->base.type = stmtType::ListAppend;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct AssociateBlockCall_t // Constructor
    {
        const static stmtType class_type = stmtType::AssociateBlockCall;
        typedef stmt_t parent_type;
        stmt_t base;
        symbol_t* m_m;
    };
    static inline asr_t* make_AssociateBlockCall_t(Allocator &al, const Location &a_loc, symbol_t* a_m) {
        AssociateBlockCall_t *n;
        n = al.make_new<AssociateBlockCall_t>();
        n->base.type = stmtType::AssociateBlockCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_m = a_m;
        return (asr_t*)n;
    }

    struct SelectType_t // Constructor
    {
        const static stmtType class_type = stmtType::SelectType;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_selector;
        type_stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_default; size_t n_default; // Sequence
    };
    static inline asr_t* make_SelectType_t(Allocator &al, const Location &a_loc, expr_t* a_selector, type_stmt_t** a_body, size_t n_body, stmt_t** a_default, size_t n_default) {
        SelectType_t *n;
        n = al.make_new<SelectType_t>();
        n->base.type = stmtType::SelectType;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_selector = a_selector;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_default = a_default;
        n->n_default = n_default;
        return (asr_t*)n;
    }

    struct CPtrToPointer_t // Constructor
    {
        const static stmtType class_type = stmtType::CPtrToPointer;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_cptr;
        expr_t* m_ptr;
        expr_t* m_shape;
        expr_t* m_lower_bounds;
    };
    static inline asr_t* make_CPtrToPointer_t(Allocator &al, const Location &a_loc, expr_t* a_cptr, expr_t* a_ptr, expr_t* a_shape, expr_t* a_lower_bounds) {
        CPtrToPointer_t *n;
        n = al.make_new<CPtrToPointer_t>();
        n->base.type = stmtType::CPtrToPointer;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_cptr = a_cptr;
        n->m_ptr = a_ptr;
        n->m_shape = a_shape;
        n->m_lower_bounds = a_lower_bounds;
        return (asr_t*)n;
    }

    struct BlockCall_t // Constructor
    {
        const static stmtType class_type = stmtType::BlockCall;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        symbol_t* m_m;
    };
    static inline asr_t* make_BlockCall_t(Allocator &al, const Location &a_loc, int64_t a_label, symbol_t* a_m) {
        BlockCall_t *n;
        n = al.make_new<BlockCall_t>();
        n->base.type = stmtType::BlockCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_m = a_m;
        return (asr_t*)n;
    }

    struct SetInsert_t // Constructor
    {
        const static stmtType class_type = stmtType::SetInsert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_SetInsert_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        SetInsert_t *n;
        n = al.make_new<SetInsert_t>();
        n->base.type = stmtType::SetInsert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct SetRemove_t // Constructor
    {
        const static stmtType class_type = stmtType::SetRemove;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_SetRemove_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        SetRemove_t *n;
        n = al.make_new<SetRemove_t>();
        n->base.type = stmtType::SetRemove;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct ListInsert_t // Constructor
    {
        const static stmtType class_type = stmtType::ListInsert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_pos;
        expr_t* m_ele;
    };
    static inline asr_t* make_ListInsert_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_pos, expr_t* a_ele) {
        ListInsert_t *n;
        n = al.make_new<ListInsert_t>();
        n->base.type = stmtType::ListInsert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_pos = a_pos;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct ListRemove_t // Constructor
    {
        const static stmtType class_type = stmtType::ListRemove;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_ListRemove_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        ListRemove_t *n;
        n = al.make_new<ListRemove_t>();
        n->base.type = stmtType::ListRemove;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct ListClear_t // Constructor
    {
        const static stmtType class_type = stmtType::ListClear;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
    };
    static inline asr_t* make_ListClear_t(Allocator &al, const Location &a_loc, expr_t* a_a) {
        ListClear_t *n;
        n = al.make_new<ListClear_t>();
        n->base.type = stmtType::ListClear;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        return (asr_t*)n;
    }

    struct DictInsert_t // Constructor
    {
        const static stmtType class_type = stmtType::DictInsert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_key;
        expr_t* m_value;
    };
    static inline asr_t* make_DictInsert_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_key, expr_t* a_value) {
        DictInsert_t *n;
        n = al.make_new<DictInsert_t>();
        n->base.type = stmtType::DictInsert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_key = a_key;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Expr_t // Constructor
    {
        const static stmtType class_type = stmtType::Expr;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_expression;
    };
    static inline asr_t* make_Expr_t(Allocator &al, const Location &a_loc, expr_t* a_expression) {
        Expr_t *n;
        n = al.make_new<Expr_t>();
        n->base.type = stmtType::Expr;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_expression = a_expression;
        return (asr_t*)n;
    }



enum exprType // Types
{
    IfExp, ComplexConstructor, NamedExpr, FunctionCall, IntrinsicElementalFunction, IntrinsicArrayFunction, IntrinsicImpureFunction, TypeInquiry, StructConstructor, StructConstant, EnumConstructor, UnionConstructor, ImpliedDoLoop, IntegerConstant, IntegerBitNot, IntegerUnaryMinus, IntegerCompare, IntegerBinOp, UnsignedIntegerConstant, UnsignedIntegerUnaryMinus, UnsignedIntegerBitNot, UnsignedIntegerCompare, UnsignedIntegerBinOp, RealConstant, RealUnaryMinus, RealCompare, RealBinOp, RealCopySign, ComplexConstant, ComplexUnaryMinus, ComplexCompare, ComplexBinOp, LogicalConstant, LogicalNot, LogicalCompare, LogicalBinOp, ListConstant, ListLen, ListConcat, ListCompare, ListCount, SetConstant, SetLen, TupleConstant, TupleLen, TupleCompare, TupleConcat, StringConstant, StringConcat, StringRepeat, StringLen, StringItem, StringSection, StringCompare, StringContains, StringOrd, StringChr, StringFormat, StringPhysicalCast, CPtrCompare, SymbolicCompare, DictConstant, DictLen, Var, FunctionParam, ArrayConstructor, ArrayConstant, ArrayItem, ArraySection, ArraySize, ArrayBound, ArrayTranspose, ArrayPack, ArrayReshape, ArrayBroadcast, BitCast, StructInstanceMember, StructStaticMember, EnumStaticMember, UnionInstanceMember, EnumName, EnumValue, OverloadedCompare, OverloadedBinOp, OverloadedUnaryMinus, OverloadedStringConcat, Cast, ArrayPhysicalCast, ComplexRe, ComplexIm, DictItem, CLoc, PointerToCPtr, GetPointer, ListItem, TupleItem, ListSection, ListRepeat, DictPop, SetPop, IntegerBitLen, Ichar, Iachar, SizeOfType, PointerNullConstant, PointerAssociated, RealSqrt, ArrayIsContiguous
};

struct expr_t // Sum
{
    const static asrType class_type = asrType::expr;
    asr_t base;
    exprType type;
};

    struct IfExp_t // Constructor
    {
        const static exprType class_type = exprType::IfExp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_test;
        expr_t* m_body;
        expr_t* m_orelse;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IfExp_t(Allocator &al, const Location &a_loc, expr_t* a_test, expr_t* a_body, expr_t* a_orelse, ttype_t* a_type, expr_t* a_value) {
        IfExp_t *n;
        n = al.make_new<IfExp_t>();
        n->base.type = exprType::IfExp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->m_orelse = a_orelse;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexConstructor_t // Constructor
    {
        const static exprType class_type = exprType::ComplexConstructor;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_re;
        expr_t* m_im;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexConstructor_t(Allocator &al, const Location &a_loc, expr_t* a_re, expr_t* a_im, ttype_t* a_type, expr_t* a_value) {
        ComplexConstructor_t *n;
        n = al.make_new<ComplexConstructor_t>();
        n->base.type = exprType::ComplexConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_re = a_re;
        n->m_im = a_im;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct NamedExpr_t // Constructor
    {
        const static exprType class_type = exprType::NamedExpr;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_target;
        expr_t* m_value;
        ttype_t* m_type;
    };
    static inline asr_t* make_NamedExpr_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value, ttype_t* a_type) {
        NamedExpr_t *n;
        n = al.make_new<NamedExpr_t>();
        n->base.type = exprType::NamedExpr;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct FunctionCall_t // Constructor
    {
        const static exprType class_type = exprType::FunctionCall;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_name;
        symbol_t* m_original_name;
        call_arg_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_dt;
    };
    static inline asr_t* make_FunctionCall_t(Allocator &al, const Location &a_loc, symbol_t* a_name, symbol_t* a_original_name, call_arg_t* a_args, size_t n_args, ttype_t* a_type, expr_t* a_value, expr_t* a_dt) {
        FunctionCall_t *n;
        n = al.make_new<FunctionCall_t>();
        n->base.type = exprType::FunctionCall;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_original_name = a_original_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_dt = a_dt;
        return (asr_t*)n;
    }

    struct IntrinsicElementalFunction_t // Constructor
    {
        const static exprType class_type = exprType::IntrinsicElementalFunction;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntrinsicElementalFunction_t(Allocator &al, const Location &a_loc, int64_t a_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id, ttype_t* a_type, expr_t* a_value) {
        IntrinsicElementalFunction_t *n;
        n = al.make_new<IntrinsicElementalFunction_t>();
        n->base.type = exprType::IntrinsicElementalFunction;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_intrinsic_id = a_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntrinsicArrayFunction_t // Constructor
    {
        const static exprType class_type = exprType::IntrinsicArrayFunction;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_arr_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntrinsicArrayFunction_t(Allocator &al, const Location &a_loc, int64_t a_arr_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id, ttype_t* a_type, expr_t* a_value) {
        IntrinsicArrayFunction_t *n;
        n = al.make_new<IntrinsicArrayFunction_t>();
        n->base.type = exprType::IntrinsicArrayFunction;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arr_intrinsic_id = a_arr_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntrinsicImpureFunction_t // Constructor
    {
        const static exprType class_type = exprType::IntrinsicImpureFunction;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_impure_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntrinsicImpureFunction_t(Allocator &al, const Location &a_loc, int64_t a_impure_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id, ttype_t* a_type, expr_t* a_value) {
        IntrinsicImpureFunction_t *n;
        n = al.make_new<IntrinsicImpureFunction_t>();
        n->base.type = exprType::IntrinsicImpureFunction;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_impure_intrinsic_id = a_impure_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TypeInquiry_t // Constructor
    {
        const static exprType class_type = exprType::TypeInquiry;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_inquiry_id;
        ttype_t* m_arg_type;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TypeInquiry_t(Allocator &al, const Location &a_loc, int64_t a_inquiry_id, ttype_t* a_arg_type, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        TypeInquiry_t *n;
        n = al.make_new<TypeInquiry_t>();
        n->base.type = exprType::TypeInquiry;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_inquiry_id = a_inquiry_id;
        n->m_arg_type = a_arg_type;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructConstructor_t // Constructor
    {
        const static exprType class_type = exprType::StructConstructor;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        call_arg_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StructConstructor_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, call_arg_t* a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        StructConstructor_t *n;
        n = al.make_new<StructConstructor_t>();
        n->base.type = exprType::StructConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructConstant_t // Constructor
    {
        const static exprType class_type = exprType::StructConstant;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        call_arg_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_StructConstant_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, call_arg_t* a_args, size_t n_args, ttype_t* a_type) {
        StructConstant_t *n;
        n = al.make_new<StructConstant_t>();
        n->base.type = exprType::StructConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct EnumConstructor_t // Constructor
    {
        const static exprType class_type = exprType::EnumConstructor;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumConstructor_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, expr_t** a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        EnumConstructor_t *n;
        n = al.make_new<EnumConstructor_t>();
        n->base.type = exprType::EnumConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnionConstructor_t // Constructor
    {
        const static exprType class_type = exprType::UnionConstructor;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnionConstructor_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, expr_t** a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        UnionConstructor_t *n;
        n = al.make_new<UnionConstructor_t>();
        n->base.type = exprType::UnionConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ImpliedDoLoop_t // Constructor
    {
        const static exprType class_type = exprType::ImpliedDoLoop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_values; size_t n_values; // Sequence
        expr_t* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ImpliedDoLoop_t(Allocator &al, const Location &a_loc, expr_t** a_values, size_t n_values, expr_t* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment, ttype_t* a_type, expr_t* a_value) {
        ImpliedDoLoop_t *n;
        n = al.make_new<ImpliedDoLoop_t>();
        n->base.type = exprType::ImpliedDoLoop;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerConstant_t // Constructor
    {
        const static exprType class_type = exprType::IntegerConstant;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n;
        ttype_t* m_type;
        integerbozType m_intboz_type;
    };
    static inline asr_t* make_IntegerConstant_t(Allocator &al, const Location &a_loc, int64_t a_n, ttype_t* a_type, integerbozType a_intboz_type = ASR::integerbozType::Decimal) {
        IntegerConstant_t *n;
        n = al.make_new<IntegerConstant_t>();
        n->base.type = exprType::IntegerConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        n->m_type = a_type;
        n->m_intboz_type = a_intboz_type;
        return (asr_t*)n;
    }

    struct IntegerBitNot_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBitNot;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerBitNot_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        IntegerBitNot_t *n;
        n = al.make_new<IntegerBitNot_t>();
        n->base.type = exprType::IntegerBitNot;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::IntegerUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        IntegerUnaryMinus_t *n;
        n = al.make_new<IntegerUnaryMinus_t>();
        n->base.type = exprType::IntegerUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerCompare_t // Constructor
    {
        const static exprType class_type = exprType::IntegerCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        IntegerCompare_t *n;
        n = al.make_new<IntegerCompare_t>();
        n->base.type = exprType::IntegerCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerBinOp_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        IntegerBinOp_t *n;
        n = al.make_new<IntegerBinOp_t>();
        n->base.type = exprType::IntegerBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerConstant_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerConstant;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n;
        ttype_t* m_type;
    };
    static inline asr_t* make_UnsignedIntegerConstant_t(Allocator &al, const Location &a_loc, int64_t a_n, ttype_t* a_type) {
        UnsignedIntegerConstant_t *n;
        n = al.make_new<UnsignedIntegerConstant_t>();
        n->base.type = exprType::UnsignedIntegerConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct UnsignedIntegerUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerUnaryMinus_t *n;
        n = al.make_new<UnsignedIntegerUnaryMinus_t>();
        n->base.type = exprType::UnsignedIntegerUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerBitNot_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerBitNot;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerBitNot_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerBitNot_t *n;
        n = al.make_new<UnsignedIntegerBitNot_t>();
        n->base.type = exprType::UnsignedIntegerBitNot;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerCompare_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerCompare_t *n;
        n = al.make_new<UnsignedIntegerCompare_t>();
        n->base.type = exprType::UnsignedIntegerCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerBinOp_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerBinOp_t *n;
        n = al.make_new<UnsignedIntegerBinOp_t>();
        n->base.type = exprType::UnsignedIntegerBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealConstant_t // Constructor
    {
        const static exprType class_type = exprType::RealConstant;
        typedef expr_t parent_type;
        expr_t base;
        double m_r;
        ttype_t* m_type;
    };
    static inline asr_t* make_RealConstant_t(Allocator &al, const Location &a_loc, double a_r, ttype_t* a_type) {
        RealConstant_t *n;
        n = al.make_new<RealConstant_t>();
        n->base.type = exprType::RealConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_r = a_r;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct RealUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::RealUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        RealUnaryMinus_t *n;
        n = al.make_new<RealUnaryMinus_t>();
        n->base.type = exprType::RealUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealCompare_t // Constructor
    {
        const static exprType class_type = exprType::RealCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        RealCompare_t *n;
        n = al.make_new<RealCompare_t>();
        n->base.type = exprType::RealCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealBinOp_t // Constructor
    {
        const static exprType class_type = exprType::RealBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        RealBinOp_t *n;
        n = al.make_new<RealBinOp_t>();
        n->base.type = exprType::RealBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealCopySign_t // Constructor
    {
        const static exprType class_type = exprType::RealCopySign;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_target;
        expr_t* m_source;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealCopySign_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_source, ttype_t* a_type, expr_t* a_value) {
        RealCopySign_t *n;
        n = al.make_new<RealCopySign_t>();
        n->base.type = exprType::RealCopySign;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_source = a_source;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexConstant_t // Constructor
    {
        const static exprType class_type = exprType::ComplexConstant;
        typedef expr_t parent_type;
        expr_t base;
        double m_re;
        double m_im;
        ttype_t* m_type;
    };
    static inline asr_t* make_ComplexConstant_t(Allocator &al, const Location &a_loc, double a_re, double a_im, ttype_t* a_type) {
        ComplexConstant_t *n;
        n = al.make_new<ComplexConstant_t>();
        n->base.type = exprType::ComplexConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_re = a_re;
        n->m_im = a_im;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct ComplexUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::ComplexUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ComplexUnaryMinus_t *n;
        n = al.make_new<ComplexUnaryMinus_t>();
        n->base.type = exprType::ComplexUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexCompare_t // Constructor
    {
        const static exprType class_type = exprType::ComplexCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ComplexCompare_t *n;
        n = al.make_new<ComplexCompare_t>();
        n->base.type = exprType::ComplexCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexBinOp_t // Constructor
    {
        const static exprType class_type = exprType::ComplexBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ComplexBinOp_t *n;
        n = al.make_new<ComplexBinOp_t>();
        n->base.type = exprType::ComplexBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct LogicalConstant_t // Constructor
    {
        const static exprType class_type = exprType::LogicalConstant;
        typedef expr_t parent_type;
        expr_t base;
        bool m_value;
        ttype_t* m_type;
    };
    static inline asr_t* make_LogicalConstant_t(Allocator &al, const Location &a_loc, bool a_value, ttype_t* a_type) {
        LogicalConstant_t *n;
        n = al.make_new<LogicalConstant_t>();
        n->base.type = exprType::LogicalConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct LogicalNot_t // Constructor
    {
        const static exprType class_type = exprType::LogicalNot;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_LogicalNot_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        LogicalNot_t *n;
        n = al.make_new<LogicalNot_t>();
        n->base.type = exprType::LogicalNot;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct LogicalCompare_t // Constructor
    {
        const static exprType class_type = exprType::LogicalCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_LogicalCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        LogicalCompare_t *n;
        n = al.make_new<LogicalCompare_t>();
        n->base.type = exprType::LogicalCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct LogicalBinOp_t // Constructor
    {
        const static exprType class_type = exprType::LogicalBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        logicalbinopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_LogicalBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, logicalbinopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        LogicalBinOp_t *n;
        n = al.make_new<LogicalBinOp_t>();
        n->base.type = exprType::LogicalBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListConstant_t // Constructor
    {
        const static exprType class_type = exprType::ListConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_ListConstant_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args, ttype_t* a_type) {
        ListConstant_t *n;
        n = al.make_new<ListConstant_t>();
        n->base.type = exprType::ListConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct ListLen_t // Constructor
    {
        const static exprType class_type = exprType::ListLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ListLen_t *n;
        n = al.make_new<ListLen_t>();
        n->base.type = exprType::ListLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListConcat_t // Constructor
    {
        const static exprType class_type = exprType::ListConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ListConcat_t *n;
        n = al.make_new<ListConcat_t>();
        n->base.type = exprType::ListConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListCompare_t // Constructor
    {
        const static exprType class_type = exprType::ListCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ListCompare_t *n;
        n = al.make_new<ListCompare_t>();
        n->base.type = exprType::ListCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListCount_t // Constructor
    {
        const static exprType class_type = exprType::ListCount;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        expr_t* m_ele;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListCount_t(Allocator &al, const Location &a_loc, expr_t* a_arg, expr_t* a_ele, ttype_t* a_type, expr_t* a_value) {
        ListCount_t *n;
        n = al.make_new<ListCount_t>();
        n->base.type = exprType::ListCount;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_ele = a_ele;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SetConstant_t // Constructor
    {
        const static exprType class_type = exprType::SetConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_elements; size_t n_elements; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_SetConstant_t(Allocator &al, const Location &a_loc, expr_t** a_elements, size_t n_elements, ttype_t* a_type) {
        SetConstant_t *n;
        n = al.make_new<SetConstant_t>();
        n->base.type = exprType::SetConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_elements = a_elements;
        n->n_elements = n_elements;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct SetLen_t // Constructor
    {
        const static exprType class_type = exprType::SetLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SetLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        SetLen_t *n;
        n = al.make_new<SetLen_t>();
        n->base.type = exprType::SetLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleConstant_t // Constructor
    {
        const static exprType class_type = exprType::TupleConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_elements; size_t n_elements; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_TupleConstant_t(Allocator &al, const Location &a_loc, expr_t** a_elements, size_t n_elements, ttype_t* a_type) {
        TupleConstant_t *n;
        n = al.make_new<TupleConstant_t>();
        n->base.type = exprType::TupleConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_elements = a_elements;
        n->n_elements = n_elements;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct TupleLen_t // Constructor
    {
        const static exprType class_type = exprType::TupleLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        TupleLen_t *n;
        n = al.make_new<TupleLen_t>();
        n->base.type = exprType::TupleLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleCompare_t // Constructor
    {
        const static exprType class_type = exprType::TupleCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        TupleCompare_t *n;
        n = al.make_new<TupleCompare_t>();
        n->base.type = exprType::TupleCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleConcat_t // Constructor
    {
        const static exprType class_type = exprType::TupleConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        TupleConcat_t *n;
        n = al.make_new<TupleConcat_t>();
        n->base.type = exprType::TupleConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringConstant_t // Constructor
    {
        const static exprType class_type = exprType::StringConstant;
        typedef expr_t parent_type;
        expr_t base;
        char* m_s;
        ttype_t* m_type;
    };
    static inline asr_t* make_StringConstant_t(Allocator &al, const Location &a_loc, char* a_s, ttype_t* a_type) {
        StringConstant_t *n;
        n = al.make_new<StringConstant_t>();
        n->base.type = exprType::StringConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct StringConcat_t // Constructor
    {
        const static exprType class_type = exprType::StringConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        StringConcat_t *n;
        n = al.make_new<StringConcat_t>();
        n->base.type = exprType::StringConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringRepeat_t // Constructor
    {
        const static exprType class_type = exprType::StringRepeat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringRepeat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        StringRepeat_t *n;
        n = al.make_new<StringRepeat_t>();
        n->base.type = exprType::StringRepeat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringLen_t // Constructor
    {
        const static exprType class_type = exprType::StringLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        StringLen_t *n;
        n = al.make_new<StringLen_t>();
        n->base.type = exprType::StringLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringItem_t // Constructor
    {
        const static exprType class_type = exprType::StringItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        expr_t* m_idx;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringItem_t(Allocator &al, const Location &a_loc, expr_t* a_arg, expr_t* a_idx, ttype_t* a_type, expr_t* a_value) {
        StringItem_t *n;
        n = al.make_new<StringItem_t>();
        n->base.type = exprType::StringItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_idx = a_idx;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringSection_t // Constructor
    {
        const static exprType class_type = exprType::StringSection;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_step;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringSection_t(Allocator &al, const Location &a_loc, expr_t* a_arg, expr_t* a_start, expr_t* a_end, expr_t* a_step, ttype_t* a_type, expr_t* a_value) {
        StringSection_t *n;
        n = al.make_new<StringSection_t>();
        n->base.type = exprType::StringSection;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_step = a_step;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringCompare_t // Constructor
    {
        const static exprType class_type = exprType::StringCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        StringCompare_t *n;
        n = al.make_new<StringCompare_t>();
        n->base.type = exprType::StringCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringContains_t // Constructor
    {
        const static exprType class_type = exprType::StringContains;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_substr;
        expr_t* m_str;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringContains_t(Allocator &al, const Location &a_loc, expr_t* a_substr, expr_t* a_str, ttype_t* a_type, expr_t* a_value) {
        StringContains_t *n;
        n = al.make_new<StringContains_t>();
        n->base.type = exprType::StringContains;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_substr = a_substr;
        n->m_str = a_str;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringOrd_t // Constructor
    {
        const static exprType class_type = exprType::StringOrd;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringOrd_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        StringOrd_t *n;
        n = al.make_new<StringOrd_t>();
        n->base.type = exprType::StringOrd;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringChr_t // Constructor
    {
        const static exprType class_type = exprType::StringChr;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringChr_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        StringChr_t *n;
        n = al.make_new<StringChr_t>();
        n->base.type = exprType::StringChr;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringFormat_t // Constructor
    {
        const static exprType class_type = exprType::StringFormat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_fmt;
        expr_t** m_args; size_t n_args; // Sequence
        string_format_kindType m_kind;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringFormat_t(Allocator &al, const Location &a_loc, expr_t* a_fmt, expr_t** a_args, size_t n_args, string_format_kindType a_kind, ttype_t* a_type, expr_t* a_value) {
        StringFormat_t *n;
        n = al.make_new<StringFormat_t>();
        n->base.type = exprType::StringFormat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_fmt = a_fmt;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kind = a_kind;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringPhysicalCast_t // Constructor
    {
        const static exprType class_type = exprType::StringPhysicalCast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        string_physical_typeType m_old;
        string_physical_typeType m_new;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringPhysicalCast_t(Allocator &al, const Location &a_loc, expr_t* a_arg, string_physical_typeType a_old, string_physical_typeType a_new, ttype_t* a_type, expr_t* a_value) {
        StringPhysicalCast_t *n;
        n = al.make_new<StringPhysicalCast_t>();
        n->base.type = exprType::StringPhysicalCast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_old = a_old;
        n->m_new = a_new;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct CPtrCompare_t // Constructor
    {
        const static exprType class_type = exprType::CPtrCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_CPtrCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        CPtrCompare_t *n;
        n = al.make_new<CPtrCompare_t>();
        n->base.type = exprType::CPtrCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SymbolicCompare_t // Constructor
    {
        const static exprType class_type = exprType::SymbolicCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SymbolicCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        SymbolicCompare_t *n;
        n = al.make_new<SymbolicCompare_t>();
        n->base.type = exprType::SymbolicCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct DictConstant_t // Constructor
    {
        const static exprType class_type = exprType::DictConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_keys; size_t n_keys; // Sequence
        expr_t** m_values; size_t n_values; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_DictConstant_t(Allocator &al, const Location &a_loc, expr_t** a_keys, size_t n_keys, expr_t** a_values, size_t n_values, ttype_t* a_type) {
        DictConstant_t *n;
        n = al.make_new<DictConstant_t>();
        n->base.type = exprType::DictConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_keys = a_keys;
        n->n_keys = n_keys;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct DictLen_t // Constructor
    {
        const static exprType class_type = exprType::DictLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_DictLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        DictLen_t *n;
        n = al.make_new<DictLen_t>();
        n->base.type = exprType::DictLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Var_t // Constructor
    {
        const static exprType class_type = exprType::Var;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_v;
    };
    static inline asr_t* make_Var_t(Allocator &al, const Location &a_loc, symbol_t* a_v) {
        Var_t *n;
        n = al.make_new<Var_t>();
        n->base.type = exprType::Var;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        return (asr_t*)n;
    }

    struct FunctionParam_t // Constructor
    {
        const static exprType class_type = exprType::FunctionParam;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_param_number;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_FunctionParam_t(Allocator &al, const Location &a_loc, int64_t a_param_number, ttype_t* a_type, expr_t* a_value) {
        FunctionParam_t *n;
        n = al.make_new<FunctionParam_t>();
        n->base.type = exprType::FunctionParam;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_param_number = a_param_number;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayConstructor_t // Constructor
    {
        const static exprType class_type = exprType::ArrayConstructor;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
        arraystorageType m_storage_format;
    };
    static inline asr_t* make_ArrayConstructor_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args, ttype_t* a_type, expr_t* a_value, arraystorageType a_storage_format) {
        ArrayConstructor_t *n;
        n = al.make_new<ArrayConstructor_t>();
        n->base.type = exprType::ArrayConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_storage_format = a_storage_format;
        return (asr_t*)n;
    }

    struct ArrayConstant_t // Constructor
    {
        const static exprType class_type = exprType::ArrayConstant;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n_data;
        void * m_data;
        ttype_t* m_type;
        arraystorageType m_storage_format;
    };
    static inline asr_t* make_ArrayConstant_t(Allocator &al, const Location &a_loc, int64_t a_n_data, void * a_data, ttype_t* a_type, arraystorageType a_storage_format) {
        ArrayConstant_t *n;
        n = al.make_new<ArrayConstant_t>();
        n->base.type = exprType::ArrayConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n_data = a_n_data;
        n->m_data = a_data;
        n->m_type = a_type;
        n->m_storage_format = a_storage_format;
        return (asr_t*)n;
    }

    struct ArrayItem_t // Constructor
    {
        const static exprType class_type = exprType::ArrayItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        array_index_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        arraystorageType m_storage_format;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayItem_t(Allocator &al, const Location &a_loc, expr_t* a_v, array_index_t* a_args, size_t n_args, ttype_t* a_type, arraystorageType a_storage_format, expr_t* a_value) {
        ArrayItem_t *n;
        n = al.make_new<ArrayItem_t>();
        n->base.type = exprType::ArrayItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_storage_format = a_storage_format;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArraySection_t // Constructor
    {
        const static exprType class_type = exprType::ArraySection;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        array_index_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArraySection_t(Allocator &al, const Location &a_loc, expr_t* a_v, array_index_t* a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        ArraySection_t *n;
        n = al.make_new<ArraySection_t>();
        n->base.type = exprType::ArraySection;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArraySize_t // Constructor
    {
        const static exprType class_type = exprType::ArraySize;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        expr_t* m_dim;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArraySize_t(Allocator &al, const Location &a_loc, expr_t* a_v, expr_t* a_dim, ttype_t* a_type, expr_t* a_value) {
        ArraySize_t *n;
        n = al.make_new<ArraySize_t>();
        n->base.type = exprType::ArraySize;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_dim = a_dim;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayBound_t // Constructor
    {
        const static exprType class_type = exprType::ArrayBound;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        expr_t* m_dim;
        ttype_t* m_type;
        arrayboundType m_bound;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayBound_t(Allocator &al, const Location &a_loc, expr_t* a_v, expr_t* a_dim, ttype_t* a_type, arrayboundType a_bound, expr_t* a_value) {
        ArrayBound_t *n;
        n = al.make_new<ArrayBound_t>();
        n->base.type = exprType::ArrayBound;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_dim = a_dim;
        n->m_type = a_type;
        n->m_bound = a_bound;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayTranspose_t // Constructor
    {
        const static exprType class_type = exprType::ArrayTranspose;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_matrix;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayTranspose_t(Allocator &al, const Location &a_loc, expr_t* a_matrix, ttype_t* a_type, expr_t* a_value) {
        ArrayTranspose_t *n;
        n = al.make_new<ArrayTranspose_t>();
        n->base.type = exprType::ArrayTranspose;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_matrix = a_matrix;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayPack_t // Constructor
    {
        const static exprType class_type = exprType::ArrayPack;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        expr_t* m_mask;
        expr_t* m_vector;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayPack_t(Allocator &al, const Location &a_loc, expr_t* a_array, expr_t* a_mask, expr_t* a_vector, ttype_t* a_type, expr_t* a_value) {
        ArrayPack_t *n;
        n = al.make_new<ArrayPack_t>();
        n->base.type = exprType::ArrayPack;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_mask = a_mask;
        n->m_vector = a_vector;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayReshape_t // Constructor
    {
        const static exprType class_type = exprType::ArrayReshape;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        expr_t* m_shape;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayReshape_t(Allocator &al, const Location &a_loc, expr_t* a_array, expr_t* a_shape, ttype_t* a_type, expr_t* a_value) {
        ArrayReshape_t *n;
        n = al.make_new<ArrayReshape_t>();
        n->base.type = exprType::ArrayReshape;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_shape = a_shape;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayBroadcast_t // Constructor
    {
        const static exprType class_type = exprType::ArrayBroadcast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        expr_t* m_shape;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayBroadcast_t(Allocator &al, const Location &a_loc, expr_t* a_array, expr_t* a_shape, ttype_t* a_type, expr_t* a_value) {
        ArrayBroadcast_t *n;
        n = al.make_new<ArrayBroadcast_t>();
        n->base.type = exprType::ArrayBroadcast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_shape = a_shape;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct BitCast_t // Constructor
    {
        const static exprType class_type = exprType::BitCast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_source;
        expr_t* m_mold;
        expr_t* m_size;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_BitCast_t(Allocator &al, const Location &a_loc, expr_t* a_source, expr_t* a_mold, expr_t* a_size, ttype_t* a_type, expr_t* a_value) {
        BitCast_t *n;
        n = al.make_new<BitCast_t>();
        n->base.type = exprType::BitCast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_source = a_source;
        n->m_mold = a_mold;
        n->m_size = a_size;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructInstanceMember_t // Constructor
    {
        const static exprType class_type = exprType::StructInstanceMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StructInstanceMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        StructInstanceMember_t *n;
        n = al.make_new<StructInstanceMember_t>();
        n->base.type = exprType::StructInstanceMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructStaticMember_t // Constructor
    {
        const static exprType class_type = exprType::StructStaticMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StructStaticMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        StructStaticMember_t *n;
        n = al.make_new<StructStaticMember_t>();
        n->base.type = exprType::StructStaticMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumStaticMember_t // Constructor
    {
        const static exprType class_type = exprType::EnumStaticMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumStaticMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        EnumStaticMember_t *n;
        n = al.make_new<EnumStaticMember_t>();
        n->base.type = exprType::EnumStaticMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnionInstanceMember_t // Constructor
    {
        const static exprType class_type = exprType::UnionInstanceMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnionInstanceMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        UnionInstanceMember_t *n;
        n = al.make_new<UnionInstanceMember_t>();
        n->base.type = exprType::UnionInstanceMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumName_t // Constructor
    {
        const static exprType class_type = exprType::EnumName;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        ttype_t* m_enum_type;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumName_t(Allocator &al, const Location &a_loc, expr_t* a_v, ttype_t* a_enum_type, ttype_t* a_type, expr_t* a_value) {
        EnumName_t *n;
        n = al.make_new<EnumName_t>();
        n->base.type = exprType::EnumName;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_enum_type = a_enum_type;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumValue_t // Constructor
    {
        const static exprType class_type = exprType::EnumValue;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        ttype_t* m_enum_type;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumValue_t(Allocator &al, const Location &a_loc, expr_t* a_v, ttype_t* a_enum_type, ttype_t* a_type, expr_t* a_value) {
        EnumValue_t *n;
        n = al.make_new<EnumValue_t>();
        n->base.type = exprType::EnumValue;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_enum_type = a_enum_type;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct OverloadedCompare_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedCompare_t *n;
        n = al.make_new<OverloadedCompare_t>();
        n->base.type = exprType::OverloadedCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct OverloadedBinOp_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedBinOp_t *n;
        n = al.make_new<OverloadedBinOp_t>();
        n->base.type = exprType::OverloadedBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct OverloadedUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedUnaryMinus_t *n;
        n = al.make_new<OverloadedUnaryMinus_t>();
        n->base.type = exprType::OverloadedUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct OverloadedStringConcat_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedStringConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedStringConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedStringConcat_t *n;
        n = al.make_new<OverloadedStringConcat_t>();
        n->base.type = exprType::OverloadedStringConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct Cast_t // Constructor
    {
        const static exprType class_type = exprType::Cast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        cast_kindType m_kind;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_Cast_t(Allocator &al, const Location &a_loc, expr_t* a_arg, cast_kindType a_kind, ttype_t* a_type, expr_t* a_value) {
        Cast_t *n;
        n = al.make_new<Cast_t>();
        n->base.type = exprType::Cast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_kind = a_kind;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayPhysicalCast_t // Constructor
    {
        const static exprType class_type = exprType::ArrayPhysicalCast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        array_physical_typeType m_old;
        array_physical_typeType m_new;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayPhysicalCast_t(Allocator &al, const Location &a_loc, expr_t* a_arg, array_physical_typeType a_old, array_physical_typeType a_new, ttype_t* a_type, expr_t* a_value) {
        ArrayPhysicalCast_t *n;
        n = al.make_new<ArrayPhysicalCast_t>();
        n->base.type = exprType::ArrayPhysicalCast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_old = a_old;
        n->m_new = a_new;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexRe_t // Constructor
    {
        const static exprType class_type = exprType::ComplexRe;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexRe_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ComplexRe_t *n;
        n = al.make_new<ComplexRe_t>();
        n->base.type = exprType::ComplexRe;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexIm_t // Constructor
    {
        const static exprType class_type = exprType::ComplexIm;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexIm_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ComplexIm_t *n;
        n = al.make_new<ComplexIm_t>();
        n->base.type = exprType::ComplexIm;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct DictItem_t // Constructor
    {
        const static exprType class_type = exprType::DictItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_key;
        expr_t* m_default;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_DictItem_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_key, expr_t* a_default, ttype_t* a_type, expr_t* a_value) {
        DictItem_t *n;
        n = al.make_new<DictItem_t>();
        n->base.type = exprType::DictItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_key = a_key;
        n->m_default = a_default;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct CLoc_t // Constructor
    {
        const static exprType class_type = exprType::CLoc;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_CLoc_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        CLoc_t *n;
        n = al.make_new<CLoc_t>();
        n->base.type = exprType::CLoc;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct PointerToCPtr_t // Constructor
    {
        const static exprType class_type = exprType::PointerToCPtr;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_PointerToCPtr_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        PointerToCPtr_t *n;
        n = al.make_new<PointerToCPtr_t>();
        n->base.type = exprType::PointerToCPtr;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct GetPointer_t // Constructor
    {
        const static exprType class_type = exprType::GetPointer;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_GetPointer_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        GetPointer_t *n;
        n = al.make_new<GetPointer_t>();
        n->base.type = exprType::GetPointer;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListItem_t // Constructor
    {
        const static exprType class_type = exprType::ListItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_pos;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListItem_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_pos, ttype_t* a_type, expr_t* a_value) {
        ListItem_t *n;
        n = al.make_new<ListItem_t>();
        n->base.type = exprType::ListItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_pos = a_pos;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleItem_t // Constructor
    {
        const static exprType class_type = exprType::TupleItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_pos;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleItem_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_pos, ttype_t* a_type, expr_t* a_value) {
        TupleItem_t *n;
        n = al.make_new<TupleItem_t>();
        n->base.type = exprType::TupleItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_pos = a_pos;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListSection_t // Constructor
    {
        const static exprType class_type = exprType::ListSection;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        array_index_t m_section;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListSection_t(Allocator &al, const Location &a_loc, expr_t* a_a, array_index_t a_section, ttype_t* a_type, expr_t* a_value) {
        ListSection_t *n;
        n = al.make_new<ListSection_t>();
        n->base.type = exprType::ListSection;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_section = a_section;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListRepeat_t // Constructor
    {
        const static exprType class_type = exprType::ListRepeat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListRepeat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ListRepeat_t *n;
        n = al.make_new<ListRepeat_t>();
        n->base.type = exprType::ListRepeat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct DictPop_t // Constructor
    {
        const static exprType class_type = exprType::DictPop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_key;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_DictPop_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_key, ttype_t* a_type, expr_t* a_value) {
        DictPop_t *n;
        n = al.make_new<DictPop_t>();
        n->base.type = exprType::DictPop;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_key = a_key;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SetPop_t // Constructor
    {
        const static exprType class_type = exprType::SetPop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SetPop_t(Allocator &al, const Location &a_loc, expr_t* a_a, ttype_t* a_type, expr_t* a_value) {
        SetPop_t *n;
        n = al.make_new<SetPop_t>();
        n->base.type = exprType::SetPop;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerBitLen_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBitLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerBitLen_t(Allocator &al, const Location &a_loc, expr_t* a_a, ttype_t* a_type, expr_t* a_value) {
        IntegerBitLen_t *n;
        n = al.make_new<IntegerBitLen_t>();
        n->base.type = exprType::IntegerBitLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Ichar_t // Constructor
    {
        const static exprType class_type = exprType::Ichar;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_Ichar_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        Ichar_t *n;
        n = al.make_new<Ichar_t>();
        n->base.type = exprType::Ichar;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Iachar_t // Constructor
    {
        const static exprType class_type = exprType::Iachar;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_Iachar_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        Iachar_t *n;
        n = al.make_new<Iachar_t>();
        n->base.type = exprType::Iachar;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SizeOfType_t // Constructor
    {
        const static exprType class_type = exprType::SizeOfType;
        typedef expr_t parent_type;
        expr_t base;
        ttype_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SizeOfType_t(Allocator &al, const Location &a_loc, ttype_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        SizeOfType_t *n;
        n = al.make_new<SizeOfType_t>();
        n->base.type = exprType::SizeOfType;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct PointerNullConstant_t // Constructor
    {
        const static exprType class_type = exprType::PointerNullConstant;
        typedef expr_t parent_type;
        expr_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_PointerNullConstant_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        PointerNullConstant_t *n;
        n = al.make_new<PointerNullConstant_t>();
        n->base.type = exprType::PointerNullConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct PointerAssociated_t // Constructor
    {
        const static exprType class_type = exprType::PointerAssociated;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_ptr;
        expr_t* m_tgt;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_PointerAssociated_t(Allocator &al, const Location &a_loc, expr_t* a_ptr, expr_t* a_tgt, ttype_t* a_type, expr_t* a_value) {
        PointerAssociated_t *n;
        n = al.make_new<PointerAssociated_t>();
        n->base.type = exprType::PointerAssociated;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_ptr = a_ptr;
        n->m_tgt = a_tgt;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealSqrt_t // Constructor
    {
        const static exprType class_type = exprType::RealSqrt;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealSqrt_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        RealSqrt_t *n;
        n = al.make_new<RealSqrt_t>();
        n->base.type = exprType::RealSqrt;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayIsContiguous_t // Constructor
    {
        const static exprType class_type = exprType::ArrayIsContiguous;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayIsContiguous_t(Allocator &al, const Location &a_loc, expr_t* a_array, ttype_t* a_type, expr_t* a_value) {
        ArrayIsContiguous_t *n;
        n = al.make_new<ArrayIsContiguous_t>();
        n->base.type = exprType::ArrayIsContiguous;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }



enum ttypeType // Types
{
    Integer, UnsignedInteger, Real, Complex, String, Logical, Set, List, Tuple, StructType, EnumType, UnionType, ClassType, Dict, Pointer, Allocatable, CPtr, SymbolicExpression, TypeParameter, Array, FunctionType
};

struct ttype_t // Sum
{
    const static asrType class_type = asrType::ttype;
    asr_t base;
    ttypeType type;
};

    struct Integer_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Integer;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Integer_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Integer_t *n;
        n = al.make_new<Integer_t>();
        n->base.type = ttypeType::Integer;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct UnsignedInteger_t // Constructor
    {
        const static ttypeType class_type = ttypeType::UnsignedInteger;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_UnsignedInteger_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        UnsignedInteger_t *n;
        n = al.make_new<UnsignedInteger_t>();
        n->base.type = ttypeType::UnsignedInteger;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Real_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Real;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Real_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Real_t *n;
        n = al.make_new<Real_t>();
        n->base.type = ttypeType::Real;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Complex_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Complex;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Complex_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Complex_t *n;
        n = al.make_new<Complex_t>();
        n->base.type = ttypeType::Complex;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct String_t // Constructor
    {
        const static ttypeType class_type = ttypeType::String;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
        int64_t m_len;
        expr_t* m_len_expr;
        string_physical_typeType m_physical_type;
    };
    static inline asr_t* make_String_t(Allocator &al, const Location &a_loc, int64_t a_kind, int64_t a_len, expr_t* a_len_expr, string_physical_typeType a_physical_type) {
        String_t *n;
        n = al.make_new<String_t>();
        n->base.type = ttypeType::String;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_len = a_len;
        n->m_len_expr = a_len_expr;
        n->m_physical_type = a_physical_type;
        return (asr_t*)n;
    }

    struct Logical_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Logical;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Logical_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Logical_t *n;
        n = al.make_new<Logical_t>();
        n->base.type = ttypeType::Logical;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Set_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Set;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_Set_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        Set_t *n;
        n = al.make_new<Set_t>();
        n->base.type = ttypeType::Set;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct List_t // Constructor
    {
        const static ttypeType class_type = ttypeType::List;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_List_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        List_t *n;
        n = al.make_new<List_t>();
        n->base.type = ttypeType::List;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Tuple_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Tuple;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t** m_type; size_t n_type; // Sequence
    };
    static inline asr_t* make_Tuple_t(Allocator &al, const Location &a_loc, ttype_t** a_type, size_t n_type) {
        Tuple_t *n;
        n = al.make_new<Tuple_t>();
        n->base.type = ttypeType::Tuple;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->n_type = n_type;
        return (asr_t*)n;
    }

    struct StructType_t // Constructor
    {
        const static ttypeType class_type = ttypeType::StructType;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_derived_type;
    };
    static inline asr_t* make_StructType_t(Allocator &al, const Location &a_loc, symbol_t* a_derived_type) {
        StructType_t *n;
        n = al.make_new<StructType_t>();
        n->base.type = ttypeType::StructType;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_derived_type = a_derived_type;
        return (asr_t*)n;
    }

    struct EnumType_t // Constructor
    {
        const static ttypeType class_type = ttypeType::EnumType;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_enum_type;
    };
    static inline asr_t* make_EnumType_t(Allocator &al, const Location &a_loc, symbol_t* a_enum_type) {
        EnumType_t *n;
        n = al.make_new<EnumType_t>();
        n->base.type = ttypeType::EnumType;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_enum_type = a_enum_type;
        return (asr_t*)n;
    }

    struct UnionType_t // Constructor
    {
        const static ttypeType class_type = ttypeType::UnionType;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_union_type;
    };
    static inline asr_t* make_UnionType_t(Allocator &al, const Location &a_loc, symbol_t* a_union_type) {
        UnionType_t *n;
        n = al.make_new<UnionType_t>();
        n->base.type = ttypeType::UnionType;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_union_type = a_union_type;
        return (asr_t*)n;
    }

    struct ClassType_t // Constructor
    {
        const static ttypeType class_type = ttypeType::ClassType;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_class_type;
    };
    static inline asr_t* make_ClassType_t(Allocator &al, const Location &a_loc, symbol_t* a_class_type) {
        ClassType_t *n;
        n = al.make_new<ClassType_t>();
        n->base.type = ttypeType::ClassType;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_class_type = a_class_type;
        return (asr_t*)n;
    }

    struct Dict_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Dict;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_key_type;
        ttype_t* m_value_type;
    };
    static inline asr_t* make_Dict_t(Allocator &al, const Location &a_loc, ttype_t* a_key_type, ttype_t* a_value_type) {
        Dict_t *n;
        n = al.make_new<Dict_t>();
        n->base.type = ttypeType::Dict;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_key_type = a_key_type;
        n->m_value_type = a_value_type;
        return (asr_t*)n;
    }

    struct Pointer_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Pointer;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_Pointer_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        Pointer_t *n;
        n = al.make_new<Pointer_t>();
        n->base.type = ttypeType::Pointer;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Allocatable_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Allocatable;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_Allocatable_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        Allocatable_t *n;
        n = al.make_new<Allocatable_t>();
        n->base.type = ttypeType::Allocatable;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct CPtr_t // Constructor
    {
        const static ttypeType class_type = ttypeType::CPtr;
        typedef ttype_t parent_type;
        ttype_t base;
    };
    static inline asr_t* make_CPtr_t(Allocator &al, const Location &a_loc) {
        CPtr_t *n;
        n = al.make_new<CPtr_t>();
        n->base.type = ttypeType::CPtr;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct SymbolicExpression_t // Constructor
    {
        const static ttypeType class_type = ttypeType::SymbolicExpression;
        typedef ttype_t parent_type;
        ttype_t base;
    };
    static inline asr_t* make_SymbolicExpression_t(Allocator &al, const Location &a_loc) {
        SymbolicExpression_t *n;
        n = al.make_new<SymbolicExpression_t>();
        n->base.type = ttypeType::SymbolicExpression;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct TypeParameter_t // Constructor
    {
        const static ttypeType class_type = ttypeType::TypeParameter;
        typedef ttype_t parent_type;
        ttype_t base;
        char* m_param;
    };
    static inline asr_t* make_TypeParameter_t(Allocator &al, const Location &a_loc, char* a_param) {
        TypeParameter_t *n;
        n = al.make_new<TypeParameter_t>();
        n->base.type = ttypeType::TypeParameter;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_param = a_param;
        return (asr_t*)n;
    }

    struct Array_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Array;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
        dimension_t* m_dims; size_t n_dims; // Sequence
        array_physical_typeType m_physical_type;
    };
    static inline asr_t* make_Array_t(Allocator &al, const Location &a_loc, ttype_t* a_type, dimension_t* a_dims, size_t n_dims, array_physical_typeType a_physical_type) {
        Array_t *n;
        n = al.make_new<Array_t>();
        n->base.type = ttypeType::Array;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        n->m_physical_type = a_physical_type;
        return (asr_t*)n;
    }

    struct FunctionType_t // Constructor
    {
        const static ttypeType class_type = ttypeType::FunctionType;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t** m_arg_types; size_t n_arg_types; // Sequence
        ttype_t* m_return_var_type;
        abiType m_abi;
        deftypeType m_deftype;
        char* m_bindc_name;
        bool m_elemental;
        bool m_pure;
        bool m_module;
        bool m_inline;
        bool m_static;
        symbol_t** m_restrictions; size_t n_restrictions; // Sequence
        bool m_is_restriction;
    };
    static inline asr_t* make_FunctionType_t(Allocator &al, const Location &a_loc, ttype_t** a_arg_types, size_t n_arg_types, ttype_t* a_return_var_type, abiType a_abi, deftypeType a_deftype, char* a_bindc_name, bool a_elemental, bool a_pure, bool a_module, bool a_inline, bool a_static, symbol_t** a_restrictions, size_t n_restrictions, bool a_is_restriction) {
        FunctionType_t *n;
        n = al.make_new<FunctionType_t>();
        n->base.type = ttypeType::FunctionType;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_arg_types = a_arg_types;
        n->n_arg_types = n_arg_types;
        n->m_return_var_type = a_return_var_type;
        n->m_abi = a_abi;
        n->m_deftype = a_deftype;
        n->m_bindc_name = a_bindc_name;
        n->m_elemental = a_elemental;
        n->m_pure = a_pure;
        n->m_module = a_module;
        n->m_inline = a_inline;
        n->m_static = a_static;
        n->m_restrictions = a_restrictions;
        n->n_restrictions = n_restrictions;
        n->m_is_restriction = a_is_restriction;
        return (asr_t*)n;
    }



enum attributeType // Types
{
    Attribute
};

struct attribute_t // Sum
{
    const static asrType class_type = asrType::attribute;
    asr_t base;
    attributeType type;
};

    struct Attribute_t // Constructor
    {
        const static attributeType class_type = attributeType::Attribute;
        typedef attribute_t parent_type;
        attribute_t base;
        char* m_name;
        attribute_arg_t* m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_Attribute_t(Allocator &al, const Location &a_loc, char* a_name, attribute_arg_t* a_args, size_t n_args) {
        Attribute_t *n;
        n = al.make_new<Attribute_t>();
        n->base.type = attributeType::Attribute;
        n->base.base.type = asrType::attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }



enum tbindType // Types
{
    Bind
};

struct tbind_t // Sum
{
    const static asrType class_type = asrType::tbind;
    asr_t base;
    tbindType type;
};

    struct Bind_t // Constructor
    {
        const static tbindType class_type = tbindType::Bind;
        typedef tbind_t parent_type;
        tbind_t base;
        char* m_lang;
        char* m_name;
    };
    static inline asr_t* make_Bind_t(Allocator &al, const Location &a_loc, char* a_lang, char* a_name) {
        Bind_t *n;
        n = al.make_new<Bind_t>();
        n->base.type = tbindType::Bind;
        n->base.base.type = asrType::tbind;
        n->base.base.loc = a_loc;
        n->m_lang = a_lang;
        n->m_name = a_name;
        return (asr_t*)n;
    }



enum case_stmtType // Types
{
    CaseStmt, CaseStmt_Range
};

struct case_stmt_t // Sum
{
    const static asrType class_type = asrType::case_stmt;
    asr_t base;
    case_stmtType type;
};

    struct CaseStmt_t // Constructor
    {
        const static case_stmtType class_type = case_stmtType::CaseStmt;
        typedef case_stmt_t parent_type;
        case_stmt_t base;
        expr_t** m_test; size_t n_test; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        bool m_fall_through;
    };
    static inline asr_t* make_CaseStmt_t(Allocator &al, const Location &a_loc, expr_t** a_test, size_t n_test, stmt_t** a_body, size_t n_body, bool a_fall_through) {
        CaseStmt_t *n;
        n = al.make_new<CaseStmt_t>();
        n->base.type = case_stmtType::CaseStmt;
        n->base.base.type = asrType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->n_test = n_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_fall_through = a_fall_through;
        return (asr_t*)n;
    }

    struct CaseStmt_Range_t // Constructor
    {
        const static case_stmtType class_type = case_stmtType::CaseStmt_Range;
        typedef case_stmt_t parent_type;
        case_stmt_t base;
        expr_t* m_start;
        expr_t* m_end;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_CaseStmt_Range_t(Allocator &al, const Location &a_loc, expr_t* a_start, expr_t* a_end, stmt_t** a_body, size_t n_body) {
        CaseStmt_Range_t *n;
        n = al.make_new<CaseStmt_Range_t>();
        n->base.type = case_stmtType::CaseStmt_Range;
        n->base.base.type = asrType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }



enum type_stmtType // Types
{
    TypeStmtName, ClassStmt, TypeStmtType
};

struct type_stmt_t // Sum
{
    const static asrType class_type = asrType::type_stmt;
    asr_t base;
    type_stmtType type;
};

    struct TypeStmtName_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::TypeStmtName;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        symbol_t* m_sym;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_TypeStmtName_t(Allocator &al, const Location &a_loc, symbol_t* a_sym, stmt_t** a_body, size_t n_body) {
        TypeStmtName_t *n;
        n = al.make_new<TypeStmtName_t>();
        n->base.type = type_stmtType::TypeStmtName;
        n->base.base.type = asrType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_sym = a_sym;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct ClassStmt_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::ClassStmt;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        symbol_t* m_sym;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_ClassStmt_t(Allocator &al, const Location &a_loc, symbol_t* a_sym, stmt_t** a_body, size_t n_body) {
        ClassStmt_t *n;
        n = al.make_new<ClassStmt_t>();
        n->base.type = type_stmtType::ClassStmt;
        n->base.base.type = asrType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_sym = a_sym;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct TypeStmtType_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::TypeStmtType;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        ttype_t* m_type;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_TypeStmtType_t(Allocator &al, const Location &a_loc, ttype_t* a_type, stmt_t** a_body, size_t n_body) {
        TypeStmtType_t *n;
        n = al.make_new<TypeStmtType_t>();
        n->base.type = type_stmtType::TypeStmtType;
        n->base.base.type = asrType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }



enum require_instantiationType // Types
{
    Require
};

struct require_instantiation_t // Sum
{
    const static asrType class_type = asrType::require_instantiation;
    asr_t base;
    require_instantiationType type;
};

    struct Require_t // Constructor
    {
        const static require_instantiationType class_type = require_instantiationType::Require;
        typedef require_instantiation_t parent_type;
        require_instantiation_t base;
        char* m_name;
        char** m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_Require_t(Allocator &al, const Location &a_loc, char* a_name, char** a_args, size_t n_args) {
        Require_t *n;
        n = al.make_new<Require_t>();
        n->base.type = require_instantiationType::Require;
        n->base.base.type = asrType::require_instantiation;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }





} // namespace LCompilers::ASR

#endif // LFORTRAN_ASR_H
