/* Generated by re2c 3.1 on Mon Mar 10 15:17:37 2025 */
#line 1 "parser/tokenizer.re"
#include <limits>

#include <lfortran/parser/parser_exception.h>
#include <lfortran/parser/tokenizer.h>
#include <lfortran/parser/parser.tab.hh>
#include <libasr/bigint.h>

using LCompilers::diag::Level;
using LCompilers::diag::Stage;
using LCompilers::diag::Label;
using LCompilers::diag::Diagnostic;

namespace LCompilers::LFortran {

void Tokenizer::set_string(const std::string &str)
{
    // The input string must be NULL terminated, otherwise the tokenizer will
    // not detect the end of string. After C++11, the std::string is guaranteed
    // to end with \0, but we check this here just in case.
    LCOMPILERS_ASSERT(str[str.size()] == '\0');
    cur = (unsigned char *)(&str[0]);
    string_start = cur;
    cur_line = cur;
    line_num = 1;
}

template<int base>
bool adddgt(uint64_t &u, uint64_t d)
{
    if (u > (std::numeric_limits<uint64_t>::max() - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

bool lex_dec(const unsigned char *s, const unsigned char *e, uint64_t &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

// Tokenizes integer of the kind 1234_ikind into `u` and `suffix`
// s ... the start of the integer
// e ... the character after the end
bool lex_int(const unsigned char *s, const unsigned char *e, uint64_t &u,
    Str &suffix)
{
    for (u = 0; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;
            return true;
        } else if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    return true;
}

void lex_int_large(Allocator &al, const unsigned char *s,
    const unsigned char *e, BigInt::BigInt &u, Str &suffix)
{
    uint64_t ui;
    if (lex_int(s, e, ui, suffix)) {
        if (ui <= BigInt::MAX_SMALL_INT) {
            u.from_smallint(ui);
            return;
        }
    }
    const unsigned char *start = s;
    for (; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;

            Str num;
            num.p = (char*)start;
            num.n = s-start-1;
            u.from_largeint(al, num);
            return;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    Str num;
    num.p = (char*)start;
    num.n = e-start;
    u.from_largeint(al, num);
}

uint64_t parse_int(const unsigned char *s)
{
    while (*s == ' ') s++;
    uint64_t u;
    for (u = 0; ; ++s) {
        if (*s >= '0' && *s <= '9') {
            if (!adddgt<10>(u, *s - 0x30u)) {
                return false;
            }
        } else {
            return u;
        }
    }
}

#define KW(x) token(yylval.string); RET(KW_##x);
#define RET(x) token_loc(loc); last_token=yytokentype::x; return yytokentype::x;
#define WARN_REL(x) add_rel_warning(diagnostics, fixed_form, yytokentype::TK_##x);

#define TK_TRIVIA(X) {                              \
    line_num++; cur_line=cur;                       \
    token(yylval.string);                           \
    token_loc(loc);                                 \
    if (last_token == yytokentype::TK_NEWLINE) {    \
        return yytokentype::X;                      \
    } else {                                        \
        last_token=yytokentype::TK_NEWLINE;         \
        return yytokentype::TK_EOLCOMMENT;          \
    }                                               \
}

void Tokenizer::add_rel_warning(diag::Diagnostics &diagnostics, bool fixed_form, int rel_token) const {
    if (!fixed_form) {
        static const std::map<int, std::pair<std::string, std::string>> m = {
            {yytokentype::TK_EQ, {"==", ".eq."}},
            {yytokentype::TK_NE, {"/=", ".ne."}},
            {yytokentype::TK_LT, {"<",  ".lt."}},
            {yytokentype::TK_GT, {">",  ".gt."}},
            {yytokentype::TK_LE, {"<=", ".le."}},
            {yytokentype::TK_GE, {">=", ".ge."}},
        };
        const std::string rel_new = m.at(rel_token).first;
        const std::string rel_old = m.at(rel_token).second;
        Location loc;
        token_loc(loc);
        diagnostics.tokenizer_style_label(
            "Use '" + rel_new + "' instead of '" + rel_old + "'",
            {loc},
            "help: write this as '" + rel_new + "'");
    }
}

int Tokenizer::lex(Allocator &al, YYSTYPE &yylval, Location &loc, diag::Diagnostics &diagnostics, bool continue_compilation)
{
    if (enddo_state == 1) {
        enddo_state = 2;
        KW(END_DO)
    } else if (enddo_state == 2) {
        enddo_insert_count--;
        if (enddo_insert_count > 0) {
            enddo_state = 1;
        } else {
            enddo_state = 0;
            token_loc(loc); line_num++; cur_line=cur;
            last_token = yytokentype::TK_NEWLINE;
        }
        return yytokentype::TK_NEWLINE;
    }
    for (;;) {
        tok = cur;

        /*
        Re2c has excellent documentation at:

        https://re2c.org/manual/manual_c.html

        The first paragraph there explains the basics:

        * If multiple rules match, the longest match takes precedence
        * If multiple rules match the same string, the earlier rule takes
          precedence
        * Default rule `*` should always be defined, it has the lowest priority
          regardless of its place and matches any code unit
        * We use the "Sentinel character" method for end of input:
            * The end of the input text is denoted with a null character \x00
            * Thus the null character cannot be part of the input otherwise
            * There is one rule to match \x00 to end the parser
            * No other rule is allowed to match \x00, otherwise the re2c block
              would parse past the end of the string and segfaults
            * A special case of the previous point are negated character
              ranges, such as [^"\x00], where one must include \x00 in it to
              ensure this rule does not match \x00 (all other rules simply do
              not mention \x00)
            * See the "Handling the end of input" section in the re2c
              documentation for more info

        The re2c block interacts with the rest of the code via just one pointer
        variable `cur`. On entering the re2c block, the `cur` variable must
        point to the first character of the token to be tokenized by the block.
        The re2c block below then executes on its own until a rule is matched:
        the action in {} is then executed. In that action `cur` points to the
        first character of the next token.

        Before the re2c block we save the current `cur` into `tok`, so that we
        can use `tok` and `cur` in the action in {} to extract the token that
        corresponds to the rule that got matched:

        * `tok` points to the first character of the token
        * `cur-1` points to the last character of the token
        * `cur` points to the first character of the next token
        * `cur-tok` is the length of the token

        In the action, we do one of:

        * call `continue` which executes another cycle in the for loop (which
          will parse the next token); we use this to skip a token
        * call `return` which returns from this function; we return a token
        * throw an exception (terminates the tokenizer)

        In the first two cases, `cur` points to first character of the next
        token, which becomes `tok` at the next iteration of the loop (either
        right away after `continue` or after the `lex` function is called again
        after `return`).

        See the manual for more details.
        */


        // These two variables are needed by the re2c block below internally,
        // initialization is not needed. One can think of them as local
        // variables of the re2c block.
        unsigned char *mar, *ctxmar;
        
#line 236 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		/* table 1 .. 8: 0 */
		  0,   2,   2,   2,   2,   2,   2,   2, 
		  2,   3,   3,   3,   2,   3,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  3,   2,   2,   2,   2,   2,   2,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		242, 242, 210, 210, 210, 210, 210, 210, 
		146, 146,   2,   2,   2,   2,   2,   2, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,  26, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		/* table 9 .. 13: 256 */
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 200, 128, 200, 192, 200, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		200, 192,  64, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		240, 240, 240, 240, 240, 240, 240, 240, 
		240, 240, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
	switch (yych) {
		case 0x00: goto yy1;
		case '\t':
		case '\n': goto yy5;
		case ' ':
		case '!': goto yy6;
		case '"': goto yy7;
		case '#': goto yy8;
		case '%': goto yy9;
		case '&': goto yy10;
		case '\'': goto yy11;
		case '(': goto yy12;
		case ')': goto yy13;
		case '*': goto yy14;
		case '+': goto yy15;
		case ',': goto yy16;
		case '-': goto yy17;
		case '.': goto yy18;
		case '/': goto yy19;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy20;
		case ':': goto yy22;
		case ';': goto yy23;
		case '<': goto yy24;
		case '=': goto yy25;
		case '>': goto yy27;
		case 'A':
		case 'a': goto yy28;
		case 'B':
		case 'b': goto yy30;
		case 'C':
		case 'c': goto yy31;
		case 'D':
		case 'd': goto yy32;
		case 'E':
		case 'e': goto yy33;
		case 'F':
		case 'f': goto yy34;
		case 'G':
		case 'g': goto yy35;
		case 'H':
		case 'J':
		case 'X':
		case 'Y':
		case '_':
		case 'h':
		case 'j':
		case 'x':
		case 'y': goto yy36;
		case 'I':
		case 'i': goto yy38;
		case 'K':
		case 'k': goto yy39;
		case 'L':
		case 'l': goto yy40;
		case 'M':
		case 'm': goto yy41;
		case 'N':
		case 'n': goto yy42;
		case 'O':
		case 'o': goto yy43;
		case 'P':
		case 'p': goto yy44;
		case 'Q':
		case 'q': goto yy45;
		case 'R':
		case 'r': goto yy46;
		case 'S':
		case 's': goto yy47;
		case 'T':
		case 't': goto yy48;
		case 'U':
		case 'u': goto yy49;
		case 'V':
		case 'v': goto yy50;
		case 'W':
		case 'w': goto yy51;
		case 'Z':
		case 'z': goto yy52;
		case '[': goto yy53;
		case ']': goto yy55;
		case '{': goto yy56;
		case '|': goto yy57;
		case '}': goto yy58;
		default: goto yy2;
	}
yy1:
	++cur;
#line 275 "parser/tokenizer.re"
	{ RET(END_OF_FILE); }
#line 410 "parser/tokenizer.cpp"
yy2:
	++cur;
yy3:
#line 261 "parser/tokenizer.re"
	{ token_loc(loc);
                std::string t = token();
                diagnostics.add(diag::Diagnostic(
                        "Token '" + t + "' is not recognized",
                        diag::Level::Error, diag::Stage::Tokenizer, {
                        diag::Label("token not recognized", {loc})
                    }));

                if(!continue_compilation) {
                    throw parser_local::TokenizerAbort();
                } else {
                    continue;
                }
            }
#line 429 "parser/tokenizer.cpp"
yy4:
	yych = *++cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
#line 276 "parser/tokenizer.re"
	{ continue; }
#line 437 "parser/tokenizer.cpp"
yy5:
	++cur;
#line 532 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    enddo_newline_process = false;
                    enddo_state = 1;
                    return yytokentype::TK_NEWLINE;
                } else {
                    enddo_newline_process = false;
                    enddo_insert_count = 0;
                    token_loc(loc); line_num++; cur_line=cur;
                    last_token = yytokentype::TK_NEWLINE;
                    return yytokentype::TK_NEWLINE;
                }
            }
#line 454 "parser/tokenizer.cpp"
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '$') {
		if (yych <= 0x00) goto yy3;
		if (yych <= '#') goto yy60;
		goto yy63;
	} else {
		if (yych == 'L') goto yy64;
		goto yy60;
	}
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy66;
yy8:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy71;
yy9:
	++cur;
#line 567 "parser/tokenizer.re"
	{ RET(TK_PERCENT) }
#line 480 "parser/tokenizer.cpp"
yy10:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy3;
		if (yych <= '\v') goto yy78;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy78;
		if (yych <= 0x1F) goto yy3;
		if (yych <= '!') goto yy78;
		goto yy3;
	}
yy11:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy83;
yy12:
	yych = *++cur;
	if (yych == '/') {
		ctxmar = cur;
		goto yy85;
	}
#line 547 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 507 "parser/tokenizer.cpp"
yy13:
	++cur;
#line 555 "parser/tokenizer.re"
	{ RET(TK_RPAREN) }
#line 512 "parser/tokenizer.cpp"
yy14:
	yych = *++cur;
	if (yych == '*') goto yy86;
#line 569 "parser/tokenizer.re"
	{ RET(TK_STAR) }
#line 518 "parser/tokenizer.cpp"
yy15:
	++cur;
#line 561 "parser/tokenizer.re"
	{ RET(TK_PLUS) }
#line 523 "parser/tokenizer.cpp"
yy16:
	++cur;
#line 568 "parser/tokenizer.re"
	{ RET(TK_COMMA) }
#line 528 "parser/tokenizer.cpp"
yy17:
	++cur;
#line 562 "parser/tokenizer.re"
	{ RET(TK_MINUS) }
#line 533 "parser/tokenizer.cpp"
yy18:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '.': goto yy87;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy88;
		case 'A':
		case 'a': goto yy91;
		case 'B':
		case 'C':
		case 'D':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy92;
		case 'E':
		case 'e': goto yy94;
		case 'F':
		case 'f': goto yy95;
		case 'G':
		case 'g': goto yy96;
		case 'L':
		case 'l': goto yy97;
		case 'N':
		case 'n': goto yy98;
		case 'O':
		case 'o': goto yy99;
		case 'T':
		case 't': goto yy100;
		case 'X':
		case 'x': goto yy101;
		default: goto yy3;
	}
yy19:
	yych = *++cur;
	if (yych <= '.') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= '/') goto yy103;
		if (yych == '=') goto yy104;
	}
#line 566 "parser/tokenizer.re"
	{ RET(TK_SLASH) }
#line 613 "parser/tokenizer.cpp"
yy20:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 16) {
		goto yy20;
	}
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych >= '\v') {
				ctxmar = cur;
				goto yy105;
			}
		} else {
			if (yych == '\r') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych >= ' ') {
				ctxmar = cur;
				goto yy105;
			}
		}
	} else {
		if (yych <= 'E') {
			if (yych == '.') {
				ctxmar = cur;
				goto yy106;
			}
			if (yych >= 'D') goto yy107;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy108;
			} else {
				if (yych <= 'c') goto yy21;
				if (yych <= 'e') goto yy107;
			}
		}
	}
yy21:
#line 658 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 664 "parser/tokenizer.cpp"
yy22:
	yych = *++cur;
	if (yych == ':') goto yy109;
#line 564 "parser/tokenizer.re"
	{ RET(TK_COLON) }
#line 670 "parser/tokenizer.cpp"
yy23:
	++cur;
#line 565 "parser/tokenizer.re"
	{ RET(TK_SEMICOLON) }
#line 675 "parser/tokenizer.cpp"
yy24:
	yych = *++cur;
	if (yych == '=') goto yy110;
#line 586 "parser/tokenizer.re"
	{ RET(TK_LT) }
#line 681 "parser/tokenizer.cpp"
yy25:
	yych = *++cur;
	if (yych <= '<') goto yy26;
	if (yych <= '=') goto yy111;
	if (yych <= '>') goto yy112;
yy26:
#line 563 "parser/tokenizer.re"
	{ RET(TK_EQUAL) }
#line 690 "parser/tokenizer.cpp"
yy27:
	yych = *++cur;
	if (yych == '=') goto yy113;
#line 592 "parser/tokenizer.re"
	{ RET(TK_GT) }
#line 696 "parser/tokenizer.cpp"
yy28:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'K') {
			if (yych == 'B') goto yy114;
			goto yy37;
		} else {
			if (yych <= 'L') goto yy115;
			if (yych <= 'R') goto yy37;
			goto yy116;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'b') goto yy114;
			goto yy37;
		} else {
			if (yych <= 'l') goto yy115;
			if (yych == 's') goto yy116;
			goto yy37;
		}
	}
yy29:
#line 749 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_NAME) }
#line 721 "parser/tokenizer.cpp"
yy30:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'I') {
		if (yych <= '\'') {
			if (yych == '"') goto yy118;
			if (yych <= '&') goto yy37;
			goto yy119;
		} else {
			if (yych == 'A') goto yy120;
			if (yych <= 'H') goto yy37;
			goto yy121;
		}
	} else {
		if (yych <= 'a') {
			if (yych == 'L') goto yy122;
			if (yych <= '`') goto yy37;
			goto yy120;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy121;
			} else {
				if (yych == 'l') goto yy122;
				goto yy37;
			}
		}
	}
yy31:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy123;
		case 'H':
		case 'h': goto yy124;
		case 'L':
		case 'l': goto yy125;
		case 'O':
		case 'o': goto yy126;
		case 'R':
		case 'r': goto yy127;
		case 'Y':
		case 'y': goto yy128;
		default: goto yy37;
	}
yy32:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy129;
			if (yych <= 'D') goto yy37;
			goto yy130;
		} else {
			if (yych == 'I') goto yy131;
			if (yych <= 'N') goto yy37;
			goto yy132;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy129;
			if (yych <= 'd') goto yy37;
			goto yy130;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy131;
			} else {
				if (yych == 'o') goto yy132;
				goto yy37;
			}
		}
	}
yy33:
	yych = *++cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy134;
		case 'N':
		case 'n': goto yy135;
		case 'Q':
		case 'q': goto yy136;
		case 'R':
		case 'r': goto yy137;
		case 'V':
		case 'v': goto yy138;
		case 'X':
		case 'x': goto yy139;
		default: goto yy37;
	}
yy34:
	yych = *++cur;
	switch (yych) {
		case 'I':
		case 'i': goto yy140;
		case 'L':
		case 'l': goto yy141;
		case 'O':
		case 'o': goto yy142;
		case 'U':
		case 'u': goto yy143;
		default: goto yy37;
	}
yy35:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy144;
		if (yych <= 'N') goto yy37;
		goto yy145;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy144;
		} else {
			if (yych == 'o') goto yy145;
			goto yy37;
		}
	}
yy36:
	yych = *++cur;
yy37:
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
	goto yy29;
yy38:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'L') {
			if (yych == 'F') goto yy147;
			goto yy37;
		} else {
			if (yych <= 'M') goto yy148;
			if (yych <= 'N') goto yy149;
			if (yych <= 'R') goto yy37;
			goto yy151;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'f') goto yy147;
			if (yych <= 'l') goto yy37;
			goto yy148;
		} else {
			if (yych <= 'n') goto yy149;
			if (yych == 's') goto yy151;
			goto yy37;
		}
	}
yy39:
	yych = *++cur;
	if (yych == 'I') goto yy152;
	if (yych == 'i') goto yy152;
	goto yy37;
yy40:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy153;
		if (yych <= 'N') goto yy37;
		goto yy154;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy153;
		} else {
			if (yych == 'o') goto yy154;
			goto yy37;
		}
	}
yy41:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy155;
		if (yych <= 'N') goto yy37;
		goto yy156;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy155;
		} else {
			if (yych == 'o') goto yy156;
			goto yy37;
		}
	}
yy42:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy157;
			if (yych <= 'D') goto yy37;
			goto yy158;
		} else {
			if (yych == 'O') goto yy159;
			if (yych <= 'T') goto yy37;
			goto yy160;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy157;
			if (yych <= 'd') goto yy37;
			goto yy158;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy159;
			} else {
				if (yych == 'u') goto yy160;
				goto yy37;
			}
		}
	}
yy43:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'P') {
		if (yych <= '\'') {
			if (yych == '"') goto yy161;
			if (yych <= '&') goto yy37;
			goto yy162;
		} else {
			if (yych == 'N') goto yy163;
			if (yych <= 'O') goto yy37;
			goto yy164;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'U') goto yy165;
			if (yych <= 'm') goto yy37;
			goto yy163;
		} else {
			if (yych <= 'p') {
				if (yych <= 'o') goto yy37;
				goto yy164;
			} else {
				if (yych == 'u') goto yy165;
				goto yy37;
			}
		}
	}
yy44:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'A') goto yy166;
			if (yych <= 'N') goto yy37;
			goto yy167;
		} else {
			if (yych == 'R') goto yy168;
			if (yych <= 'T') goto yy37;
			goto yy169;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'a') goto yy166;
			if (yych <= 'n') goto yy37;
			goto yy167;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy37;
				goto yy168;
			} else {
				if (yych == 'u') goto yy169;
				goto yy37;
			}
		}
	}
yy45:
	yych = *++cur;
	if (yych == 'U') goto yy170;
	if (yych == 'u') goto yy170;
	goto yy37;
yy46:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy171;
		if (yych <= 'D') goto yy37;
		goto yy172;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy171;
		} else {
			if (yych == 'e') goto yy172;
			goto yy37;
		}
	}
yy47:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy173;
		case 'E':
		case 'e': goto yy174;
		case 'H':
		case 'h': goto yy175;
		case 'O':
		case 'o': goto yy176;
		case 'T':
		case 't': goto yy177;
		case 'U':
		case 'u': goto yy178;
		case 'Y':
		case 'y': goto yy179;
		default: goto yy37;
	}
yy48:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy180;
		case 'E':
		case 'e': goto yy181;
		case 'H':
		case 'h': goto yy182;
		case 'O':
		case 'o': goto yy183;
		case 'Y':
		case 'y': goto yy184;
		default: goto yy37;
	}
yy49:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'N') goto yy185;
		if (yych <= 'R') goto yy37;
		goto yy186;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy185;
		} else {
			if (yych == 's') goto yy186;
			goto yy37;
		}
	}
yy50:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy187;
		if (yych <= 'N') goto yy37;
		goto yy188;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy187;
		} else {
			if (yych == 'o') goto yy188;
			goto yy37;
		}
	}
yy51:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'G') {
			if (yych == 'A') goto yy189;
			goto yy37;
		} else {
			if (yych <= 'H') goto yy190;
			if (yych <= 'Q') goto yy37;
			goto yy191;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'a') goto yy189;
			goto yy37;
		} else {
			if (yych <= 'h') goto yy190;
			if (yych == 'r') goto yy191;
			goto yy37;
		}
	}
yy52:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy192;
	if (yych == '\'') goto yy193;
	goto yy37;
yy53:
	++cur;
yy54:
#line 556 "parser/tokenizer.re"
	{ RET(TK_LBRACKET) }
#line 1103 "parser/tokenizer.cpp"
yy55:
	++cur;
#line 557 "parser/tokenizer.re"
	{ RET(TK_RBRACKET) }
#line 1108 "parser/tokenizer.cpp"
yy56:
	++cur;
#line 558 "parser/tokenizer.re"
	{ RET(TK_LBRACE) }
#line 1113 "parser/tokenizer.cpp"
yy57:
	++cur;
#line 570 "parser/tokenizer.re"
	{ RET(TK_VBAR) }
#line 1118 "parser/tokenizer.cpp"
yy58:
	++cur;
#line 559 "parser/tokenizer.re"
	{ RET(TK_RBRACE) }
#line 1123 "parser/tokenizer.cpp"
yy59:
	yych = *++cur;
yy60:
	if (yybm[256+yych] & 64) {
		goto yy59;
	}
	if (yych >= 0x01) goto yy62;
yy61:
	cur = mar;
	if (yyaccept <= 7) {
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy3;
				} else {
					goto yy21;
				}
			} else {
				if (yyaccept == 2) {
					goto yy29;
				} else {
					goto yy67;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy80;
				} else {
					goto yy84;
				}
			} else {
				if (yyaccept == 6) {
					goto yy54;
				} else {
					goto yy90;
				}
			}
		}
	} else {
		if (yyaccept <= 11) {
			if (yyaccept <= 9) {
				if (yyaccept == 8) {
					goto yy133;
				} else {
					goto yy150;
				}
			} else {
				if (yyaccept == 10) {
					goto yy259;
				} else {
					goto yy685;
				}
			}
		} else {
			if (yyaccept <= 13) {
				if (yyaccept == 12) {
					goto yy820;
				} else {
					goto yy975;
				}
			} else {
				goto yy1047;
			}
		}
	}
yy62:
	++cur;
#line 680 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                yylval.string.n--;
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_COMMENT;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 1205 "parser/tokenizer.cpp"
yy63:
	yych = *++cur;
	if (yych == 'O') goto yy194;
	if (yych == 'o') goto yy194;
	goto yy60;
yy64:
	yych = *++cur;
	if (yych == 'F') goto yy195;
	goto yy60;
yy65:
	yych = *++cur;
yy66:
	if (yybm[256+yych] & 128) {
		goto yy65;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy65;
yy67:
#line 745 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '"'); RET(TK_STRING) }
#line 1228 "parser/tokenizer.cpp"
yy68:
	yych = *++cur;
yy69:
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy72;
	goto yy68;
yy70:
	yych = *++cur;
yy71:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy61;
			if (yych <= 0x08) goto yy68;
			if (yych <= '\t') goto yy70;
		} else {
			if (yych == '\f') goto yy68;
			if (yych <= '\r') goto yy70;
			goto yy68;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= ' ') goto yy70;
			if (yych <= 'c') goto yy68;
			if (yych <= 'd') goto yy73;
			goto yy74;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy68;
				goto yy75;
			} else {
				if (yych == 'l') goto yy76;
				goto yy68;
			}
		}
	}
yy72:
	++cur;
#line 737 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "Unsupported macro", {loc},
                    "Ignored");
                line_num++; cur_line=cur; continue;
            }
#line 1274 "parser/tokenizer.cpp"
yy73:
	yych = *++cur;
	if (yych == 'e') goto yy196;
	goto yy69;
yy74:
	yych = *++cur;
	if (yych == 'l') goto yy197;
	if (yych == 'n') goto yy198;
	goto yy69;
yy75:
	yych = *++cur;
	if (yych == 'f') goto yy199;
	if (yych == 'n') goto yy200;
	goto yy69;
yy76:
	yych = *++cur;
	if (yych == 'i') goto yy201;
	goto yy69;
yy77:
	yych = *++cur;
yy78:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy77;
		} else {
			if (yych <= '\n') goto yy79;
			if (yych <= '\v') goto yy77;
			goto yy61;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy77;
			goto yy61;
		} else {
			if (yych <= ' ') goto yy77;
			if (yych <= '!') goto yy81;
			goto yy61;
		}
	}
yy79:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 1) {
		goto yy79;
	}
	if (yych <= 0x1F) goto yy80;
	if (yych <= '!') goto yy81;
	if (yych == '&') goto yy202;
yy80:
#line 672 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur; continue;
            }
#line 1329 "parser/tokenizer.cpp"
yy81:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy79;
	goto yy81;
yy82:
	yych = *++cur;
yy83:
	if (yybm[0+yych] & 2) {
		goto yy82;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy82;
yy84:
#line 746 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '\''); RET(TK_STRING) }
#line 1348 "parser/tokenizer.cpp"
yy85:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy203;
			goto yy54;
		} else {
			if (yych == '\f') goto yy54;
			if (yych <= '\r') goto yy203;
			goto yy54;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ' ') goto yy203;
			if (yych == ')') goto yy204;
			goto yy54;
		} else {
			if (yych <= '/') goto yy205;
			if (yych == '=') goto yy206;
			goto yy54;
		}
	}
yy86:
	++cur;
#line 575 "parser/tokenizer.re"
	{ RET(TK_POW) }
#line 1376 "parser/tokenizer.cpp"
yy87:
	++cur;
#line 573 "parser/tokenizer.re"
	{ RET(TK_DBL_DOT) }
#line 1381 "parser/tokenizer.cpp"
yy88:
	yyaccept = 7;
	yych = *(mar = ++cur);
yy89:
	if (yych <= 'E') {
		if (yych <= '/') goto yy90;
		if (yych <= '9') goto yy88;
		if (yych >= 'D') goto yy107;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy207;
		} else {
			if (yych <= 'c') goto yy90;
			if (yych <= 'e') goto yy107;
		}
	}
yy90:
#line 625 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_REAL) }
#line 1401 "parser/tokenizer.cpp"
yy91:
	yych = *++cur;
	if (yych == 'N') goto yy209;
	if (yych == 'n') goto yy209;
	goto yy93;
yy92:
	yych = *++cur;
yy93:
	if (yybm[0+yych] & 4) {
		goto yy92;
	}
	if (yych == '.') goto yy208;
	goto yy61;
yy94:
	yych = *++cur;
	if (yych == 'Q') goto yy210;
	if (yych == 'q') goto yy210;
	goto yy93;
yy95:
	yych = *++cur;
	if (yych == 'A') goto yy211;
	if (yych == 'a') goto yy211;
	goto yy93;
yy96:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy212;
		if (yych <= 'S') goto yy93;
		goto yy213;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy93;
			goto yy212;
		} else {
			if (yych == 't') goto yy213;
			goto yy93;
		}
	}
yy97:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy214;
		if (yych <= 'S') goto yy93;
		goto yy215;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy93;
			goto yy214;
		} else {
			if (yych == 't') goto yy215;
			goto yy93;
		}
	}
yy98:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy216;
		if (yych <= 'N') goto yy93;
		goto yy217;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy93;
			goto yy216;
		} else {
			if (yych == 'o') goto yy217;
			goto yy93;
		}
	}
yy99:
	yych = *++cur;
	if (yych == 'R') goto yy218;
	if (yych == 'r') goto yy218;
	goto yy93;
yy100:
	yych = *++cur;
	if (yych == 'R') goto yy219;
	if (yych == 'r') goto yy219;
	goto yy93;
yy101:
	yych = *++cur;
	if (yych == 'O') goto yy220;
	if (yych == 'o') goto yy220;
	goto yy93;
yy102:
	++cur;
#line 560 "parser/tokenizer.re"
	{ RET(TK_RBRACKET_OLD) }
#line 1489 "parser/tokenizer.cpp"
yy103:
	++cur;
#line 576 "parser/tokenizer.re"
	{ RET(TK_CONCAT) }
#line 1494 "parser/tokenizer.cpp"
yy104:
	++cur;
#line 583 "parser/tokenizer.re"
	{ RET(TK_NE) }
#line 1499 "parser/tokenizer.cpp"
yy105:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy105;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			if (yych <= '\r') goto yy105;
			goto yy61;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy105;
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy221;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy221;
			goto yy61;
		}
	}
yy106:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= 'Z') {
		if (yych <= '@') goto yy89;
		if (yych <= 'C') goto yy222;
		if (yych <= 'E') goto yy224;
		goto yy222;
	} else {
		if (yych <= 'c') {
			if (yych <= '`') goto yy89;
			goto yy222;
		} else {
			if (yych <= 'e') goto yy224;
			if (yych <= 'z') goto yy222;
			goto yy89;
		}
	}
yy107:
	yych = *++cur;
	if (yych <= ',') {
		if (yych == '+') goto yy225;
		goto yy61;
	} else {
		if (yych <= '-') goto yy225;
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy226;
		goto yy61;
	}
yy108:
	yych = *++cur;
	if (yych <= '9') {
		if (yych <= '&') {
			if (yych == '"') goto yy65;
			goto yy61;
		} else {
			if (yych <= '\'') goto yy82;
			if (yych <= '/') goto yy61;
			goto yy227;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy228;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy228;
			goto yy61;
		}
	}
yy109:
	++cur;
#line 574 "parser/tokenizer.re"
	{ RET(TK_DBL_COLON) }
#line 1578 "parser/tokenizer.cpp"
yy110:
	++cur;
#line 589 "parser/tokenizer.re"
	{ RET(TK_LE) }
#line 1583 "parser/tokenizer.cpp"
yy111:
	++cur;
#line 580 "parser/tokenizer.re"
	{ RET(TK_EQ) }
#line 1588 "parser/tokenizer.cpp"
yy112:
	++cur;
#line 577 "parser/tokenizer.re"
	{ RET(TK_ARROW) }
#line 1593 "parser/tokenizer.cpp"
yy113:
	++cur;
#line 595 "parser/tokenizer.re"
	{ RET(TK_GE) }
#line 1598 "parser/tokenizer.cpp"
yy114:
	yych = *++cur;
	if (yych == 'S') goto yy229;
	if (yych == 's') goto yy229;
	goto yy37;
yy115:
	yych = *++cur;
	if (yych == 'L') goto yy230;
	if (yych == 'l') goto yy230;
	goto yy37;
yy116:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'S') goto yy232;
		if (yych <= 'X') goto yy37;
		goto yy233;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy37;
			goto yy232;
		} else {
			if (yych == 'y') goto yy233;
			goto yy37;
		}
	}
yy117:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych <= '&') {
		if (yych == '"') goto yy65;
		goto yy29;
	} else {
		if (yych <= '\'') goto yy82;
		if (yych == '_') goto yy117;
		goto yy29;
	}
yy118:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy234;
	}
	goto yy61;
yy119:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy235;
	goto yy61;
yy120:
	yych = *++cur;
	if (yych == 'C') goto yy236;
	if (yych == 'c') goto yy236;
	goto yy37;
yy121:
	yych = *++cur;
	if (yych == 'N') goto yy237;
	if (yych == 'n') goto yy237;
	goto yy37;
yy122:
	yych = *++cur;
	if (yych == 'O') goto yy238;
	if (yych == 'o') goto yy238;
	goto yy37;
yy123:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'L') goto yy239;
		if (yych <= 'R') goto yy37;
		goto yy240;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy239;
		} else {
			if (yych == 's') goto yy240;
			goto yy37;
		}
	}
yy124:
	yych = *++cur;
	if (yych == 'A') goto yy241;
	if (yych == 'a') goto yy241;
	goto yy37;
yy125:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy242;
		if (yych <= 'N') goto yy37;
		goto yy243;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy242;
		} else {
			if (yych == 'o') goto yy243;
			goto yy37;
		}
	}
yy126:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy244;
		} else {
			if (yych <= 'L') goto yy37;
			if (yych <= 'M') goto yy245;
			goto yy246;
		}
	} else {
		if (yych <= 'l') {
			if (yych == 'd') goto yy244;
			goto yy37;
		} else {
			if (yych <= 'm') goto yy245;
			if (yych <= 'n') goto yy246;
			goto yy37;
		}
	}
yy127:
	yych = *++cur;
	if (yych == 'I') goto yy247;
	if (yych == 'i') goto yy247;
	goto yy37;
yy128:
	yych = *++cur;
	if (yych == 'C') goto yy248;
	if (yych == 'c') goto yy248;
	goto yy37;
yy129:
	yych = *++cur;
	if (yych == 'T') goto yy249;
	if (yych == 't') goto yy249;
	goto yy37;
yy130:
	yych = *++cur;
	if (yych <= 'F') {
		if (yych == 'A') goto yy250;
		if (yych <= 'E') goto yy37;
		goto yy251;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy250;
		} else {
			if (yych == 'f') goto yy251;
			goto yy37;
		}
	}
yy131:
	yych = *++cur;
	if (yych == 'M') goto yy252;
	if (yych == 'm') goto yy252;
	goto yy37;
yy132:
	yyaccept = 8;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= '@') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych >= '\t') {
					ctxmar = cur;
					goto yy253;
				}
			} else {
				if (yych == '\v') {
					ctxmar = cur;
					goto yy253;
				}
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') {
					ctxmar = cur;
					goto yy253;
				}
				if (yych >= ' ') {
					ctxmar = cur;
					goto yy253;
				}
			} else {
				if (yych <= '/') goto yy133;
				if (yych <= '9') goto yy36;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'V') {
				if (yych == 'U') goto yy254;
				goto yy36;
			} else {
				if (yych <= 'W') goto yy255;
				if (yych <= 'Z') goto yy36;
			}
		} else {
			if (yych <= 'v') {
				if (yych == 'u') goto yy254;
				goto yy36;
			} else {
				if (yych <= 'w') goto yy255;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy133:
#line 318 "parser/tokenizer.re"
	{ KW(DO) }
#line 1811 "parser/tokenizer.cpp"
yy134:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'E') goto yy256;
		if (yych <= 'R') goto yy37;
		goto yy257;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy256;
		} else {
			if (yych == 's') goto yy257;
			goto yy37;
		}
	}
yy135:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy258;
		} else {
			if (yych <= 'S') goto yy37;
			if (yych <= 'T') goto yy260;
			goto yy261;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'd') goto yy258;
			goto yy37;
		} else {
			if (yych <= 't') goto yy260;
			if (yych <= 'u') goto yy261;
			goto yy37;
		}
	}
yy136:
	yych = *++cur;
	if (yych == 'U') goto yy262;
	if (yych == 'u') goto yy262;
	goto yy37;
yy137:
	yych = *++cur;
	if (yych == 'R') goto yy263;
	if (yych == 'r') goto yy263;
	goto yy37;
yy138:
	yych = *++cur;
	if (yych == 'E') goto yy264;
	if (yych == 'e') goto yy264;
	goto yy37;
yy139:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'I') goto yy265;
		if (yych <= 'S') goto yy37;
		goto yy266;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy265;
		} else {
			if (yych == 't') goto yy266;
			goto yy37;
		}
	}
yy140:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'L') goto yy267;
		if (yych <= 'M') goto yy37;
		goto yy268;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy267;
		} else {
			if (yych == 'n') goto yy268;
			goto yy37;
		}
	}
yy141:
	yych = *++cur;
	if (yych == 'U') goto yy269;
	if (yych == 'u') goto yy269;
	goto yy37;
yy142:
	yych = *++cur;
	if (yych == 'R') goto yy270;
	if (yych == 'r') goto yy270;
	goto yy37;
yy143:
	yych = *++cur;
	if (yych == 'N') goto yy271;
	if (yych == 'n') goto yy271;
	goto yy37;
yy144:
	yych = *++cur;
	if (yych == 'N') goto yy272;
	if (yych == 'n') goto yy272;
	goto yy37;
yy145:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy146;
			if (yych <= 'S') goto yy36;
			goto yy273;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy273;
			if (yych <= 'z') goto yy36;
		}
	}
yy146:
#line 435 "parser/tokenizer.re"
	{ KW(GO) }
#line 1938 "parser/tokenizer.cpp"
yy147:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 437 "parser/tokenizer.re"
	{ KW(IF) }
#line 1947 "parser/tokenizer.cpp"
yy148:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'A') goto yy274;
		if (yych <= 'O') goto yy37;
		goto yy275;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy274;
		} else {
			if (yych == 'p') goto yy275;
			goto yy37;
		}
	}
yy149:
	yyaccept = 9;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych <= '\v') {
				if (yych == '\t') goto yy276;
				if (yych >= '\v') goto yy276;
			} else {
				if (yych == '\r') goto yy276;
				if (yych >= ' ') goto yy276;
			}
		} else {
			if (yych <= 'B') {
				if (yych <= '/') goto yy150;
				if (yych <= '9') goto yy36;
				if (yych >= 'A') goto yy36;
			} else {
				if (yych <= 'C') goto yy277;
				if (yych == 'O') goto yy278;
				goto yy36;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'T') {
				if (yych <= 'Q') goto yy279;
				if (yych <= 'R') goto yy36;
				if (yych <= 'S') goto yy280;
				goto yy281;
			} else {
				if (yych <= 'Z') goto yy36;
				if (yych <= '`') goto yy150;
				if (yych <= 'b') goto yy36;
				goto yy277;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy278;
				if (yych <= 'p') goto yy36;
				goto yy279;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy36;
					goto yy280;
				} else {
					if (yych <= 't') goto yy281;
					if (yych <= 'z') goto yy36;
				}
			}
		}
	}
yy150:
#line 442 "parser/tokenizer.re"
	{ KW(IN) }
#line 2021 "parser/tokenizer.cpp"
yy151:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 452 "parser/tokenizer.re"
	{ KW(IS) }
#line 2030 "parser/tokenizer.cpp"
yy152:
	yych = *++cur;
	if (yych == 'N') goto yy282;
	if (yych == 'n') goto yy282;
	goto yy37;
yy153:
	yych = *++cur;
	if (yych == 'N') goto yy283;
	if (yych == 'n') goto yy283;
	goto yy37;
yy154:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy284;
		if (yych <= 'F') goto yy37;
		goto yy285;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy284;
		} else {
			if (yych == 'g') goto yy285;
			goto yy37;
		}
	}
yy155:
	yych = *++cur;
	if (yych == 'M') goto yy286;
	if (yych == 'm') goto yy286;
	goto yy37;
yy156:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy287;
		if (yych <= 'K') goto yy37;
		goto yy288;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy287;
		} else {
			if (yych == 'l') goto yy288;
			goto yy37;
		}
	}
yy157:
	yych = *++cur;
	if (yych == 'M') goto yy289;
	if (yych == 'm') goto yy289;
	goto yy37;
yy158:
	yych = *++cur;
	if (yych == 'W') goto yy290;
	if (yych == 'w') goto yy290;
	goto yy37;
yy159:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'N') goto yy291;
		if (yych <= 'O') goto yy37;
		goto yy292;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy291;
		} else {
			if (yych == 'p') goto yy292;
			goto yy37;
		}
	}
yy160:
	yych = *++cur;
	if (yych == 'L') goto yy293;
	if (yych == 'l') goto yy293;
	goto yy37;
yy161:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy294;
	}
	goto yy61;
yy162:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy295;
	goto yy61;
yy163:
	yych = *++cur;
	if (yych == 'L') goto yy296;
	if (yych == 'l') goto yy296;
	goto yy37;
yy164:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy297;
		if (yych <= 'S') goto yy37;
		goto yy298;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy297;
		} else {
			if (yych == 't') goto yy298;
			goto yy37;
		}
	}
yy165:
	yych = *++cur;
	if (yych == 'T') goto yy299;
	if (yych == 't') goto yy299;
	goto yy37;
yy166:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'Q') goto yy37;
		if (yych <= 'R') goto yy300;
		goto yy301;
	} else {
		if (yych <= 'q') goto yy37;
		if (yych <= 'r') goto yy300;
		if (yych <= 's') goto yy301;
		goto yy37;
	}
yy167:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'I') goto yy302;
		if (yych <= 'R') goto yy37;
		goto yy303;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy302;
		} else {
			if (yych == 's') goto yy303;
			goto yy37;
		}
	}
yy168:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'E') goto yy304;
			goto yy37;
		} else {
			if (yych <= 'I') goto yy305;
			if (yych <= 'N') goto yy37;
			goto yy306;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto yy304;
			goto yy37;
		} else {
			if (yych <= 'i') goto yy305;
			if (yych == 'o') goto yy306;
			goto yy37;
		}
	}
yy169:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'B') goto yy307;
		if (yych <= 'Q') goto yy37;
		goto yy308;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto yy37;
			goto yy307;
		} else {
			if (yych == 'r') goto yy308;
			goto yy37;
		}
	}
yy170:
	yych = *++cur;
	if (yych == 'I') goto yy309;
	if (yych == 'i') goto yy309;
	goto yy37;
yy171:
	yych = *++cur;
	if (yych == 'N') goto yy310;
	if (yych == 'n') goto yy310;
	goto yy37;
yy172:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy311;
		case 'C':
		case 'c': goto yy312;
		case 'D':
		case 'd': goto yy313;
		case 'Q':
		case 'q': goto yy314;
		case 'S':
		case 's': goto yy315;
		case 'T':
		case 't': goto yy316;
		case 'W':
		case 'w': goto yy317;
		default: goto yy37;
	}
yy173:
	yych = *++cur;
	if (yych == 'V') goto yy318;
	if (yych == 'v') goto yy318;
	goto yy37;
yy174:
	yych = *++cur;
	if (yych <= 'Q') {
		if (yych == 'L') goto yy319;
		if (yych <= 'P') goto yy37;
		goto yy320;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy319;
		} else {
			if (yych == 'q') goto yy320;
			goto yy37;
		}
	}
yy175:
	yych = *++cur;
	if (yych == 'A') goto yy321;
	if (yych == 'a') goto yy321;
	goto yy37;
yy176:
	yych = *++cur;
	if (yych == 'U') goto yy322;
	if (yych == 'u') goto yy322;
	goto yy37;
yy177:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy323;
		if (yych <= 'N') goto yy37;
		goto yy324;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy323;
		} else {
			if (yych == 'o') goto yy324;
			goto yy37;
		}
	}
yy178:
	yych = *++cur;
	if (yych == 'B') goto yy325;
	if (yych == 'b') goto yy325;
	goto yy37;
yy179:
	yych = *++cur;
	if (yych == 'N') goto yy326;
	if (yych == 'n') goto yy326;
	goto yy37;
yy180:
	yych = *++cur;
	if (yych == 'R') goto yy327;
	if (yych == 'r') goto yy327;
	goto yy37;
yy181:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy328;
		if (yych <= 'L') goto yy37;
		goto yy329;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy328;
		} else {
			if (yych == 'm') goto yy329;
			goto yy37;
		}
	}
yy182:
	yych = *++cur;
	if (yych == 'E') goto yy330;
	if (yych == 'e') goto yy330;
	goto yy37;
yy183:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 520 "parser/tokenizer.re"
	{ KW(TO) }
#line 2322 "parser/tokenizer.cpp"
yy184:
	yych = *++cur;
	if (yych == 'P') goto yy331;
	if (yych == 'p') goto yy331;
	goto yy37;
yy185:
	yych = *++cur;
	if (yych == 'F') goto yy332;
	if (yych == 'f') goto yy332;
	goto yy37;
yy186:
	yych = *++cur;
	if (yych == 'E') goto yy333;
	if (yych == 'e') goto yy333;
	goto yy37;
yy187:
	yych = *++cur;
	if (yych == 'L') goto yy334;
	if (yych == 'l') goto yy334;
	goto yy37;
yy188:
	yych = *++cur;
	if (yych == 'L') goto yy335;
	if (yych == 'l') goto yy335;
	goto yy37;
yy189:
	yych = *++cur;
	if (yych == 'I') goto yy336;
	if (yych == 'i') goto yy336;
	goto yy37;
yy190:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'E') goto yy337;
		if (yych <= 'H') goto yy37;
		goto yy338;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy337;
		} else {
			if (yych == 'i') goto yy338;
			goto yy37;
		}
	}
yy191:
	yych = *++cur;
	if (yych == 'I') goto yy339;
	if (yych == 'i') goto yy339;
	goto yy37;
yy192:
	yych = *++cur;
	if (yych == '"') goto yy61;
	goto yy341;
yy193:
	yych = *++cur;
	if (yych == '\'') goto yy61;
	goto yy343;
yy194:
	yych = *++cur;
	if (yych == 'M') goto yy344;
	if (yych == 'm') goto yy344;
	goto yy60;
yy195:
	yych = *++cur;
	if (yych == '$') goto yy345;
	goto yy60;
yy196:
	yych = *++cur;
	if (yych == 'f') goto yy346;
	goto yy69;
yy197:
	yych = *++cur;
	if (yych == 'i') goto yy347;
	if (yych == 's') goto yy348;
	goto yy69;
yy198:
	yych = *++cur;
	if (yych == 'd') goto yy349;
	goto yy69;
yy199:
	yych = *++cur;
	if (yych == 'd') goto yy350;
	goto yy69;
yy200:
	yych = *++cur;
	if (yych == 'c') goto yy351;
	goto yy69;
yy201:
	yych = *++cur;
	if (yych == 'n') goto yy352;
	goto yy69;
yy202:
	++cur;
	goto yy80;
yy203:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy203;
		} else {
			if (yych == '\v') goto yy203;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy203;
			if (yych <= 0x1F) goto yy61;
			goto yy203;
		} else {
			if (yych == ')') goto yy353;
			goto yy61;
		}
	}
yy204:
	++cur;
	cur -= 2;
#line 549 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2443 "parser/tokenizer.cpp"
yy205:
	yych = *++cur;
	if (yych == ')') goto yy356;
	goto yy355;
yy206:
	++cur;
	cur -= 2;
#line 548 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2453 "parser/tokenizer.cpp"
yy207:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy357;
		if (yych <= '@') goto yy61;
		goto yy358;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy358;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy358;
			goto yy61;
		}
	}
yy208:
	++cur;
#line 748 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_DEF_OP) }
#line 2475 "parser/tokenizer.cpp"
yy209:
	yych = *++cur;
	if (yych == 'D') goto yy359;
	if (yych == 'd') goto yy359;
	goto yy93;
yy210:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == '.') goto yy360;
		goto yy93;
	} else {
		if (yych <= 'V') goto yy361;
		if (yych == 'v') goto yy361;
		goto yy93;
	}
yy211:
	yych = *++cur;
	if (yych == 'L') goto yy362;
	if (yych == 'l') goto yy362;
	goto yy93;
yy212:
	yych = *++cur;
	if (yych == '.') goto yy363;
	goto yy93;
yy213:
	yych = *++cur;
	if (yych == '.') goto yy364;
	goto yy93;
yy214:
	yych = *++cur;
	if (yych == '.') goto yy365;
	goto yy93;
yy215:
	yych = *++cur;
	if (yych == '.') goto yy366;
	goto yy93;
yy216:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == '.') goto yy367;
		goto yy93;
	} else {
		if (yych <= 'Q') goto yy368;
		if (yych == 'q') goto yy368;
		goto yy93;
	}
yy217:
	yych = *++cur;
	if (yych == 'T') goto yy369;
	if (yych == 't') goto yy369;
	goto yy93;
yy218:
	yych = *++cur;
	if (yych == '.') goto yy370;
	goto yy93;
yy219:
	yych = *++cur;
	if (yych == 'U') goto yy371;
	if (yych == 'u') goto yy371;
	goto yy93;
yy220:
	yych = *++cur;
	if (yych == 'R') goto yy372;
	if (yych == 'r') goto yy372;
	goto yy93;
yy221:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy221;
	}
	cur = ctxmar;
#line 626 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_NEWLINE) {
                    uint64_t u;
                    if (lex_int(tok, cur, u, yylval.int_suffix.int_kind)) {
                            yylval.n = u;
                            if (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                while (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                    enddo_label_stack.pop_back();
                                    enddo_insert_count++;
                                }
                                enddo_newline_process = true;
                            } else {
                                enddo_newline_process = false;
                            }
                            RET(TK_LABEL)
                    } else {
                        token_loc(loc);
                        std::string t = token();
                        diagnostics.add(diag::Diagnostic(
                            "Integer '" + t + "' too large",
                            diag::Level::Error, diag::Stage::Tokenizer, {
                            diag::Label("", {loc})}
                        ));
                        throw parser_local::TokenizerAbort();
                    }
                } else {
                    lex_int_large(al, tok, cur,
                        yylval.int_suffix.int_n,
                        yylval.int_suffix.int_kind);
                    RET(TK_INTEGER)
                }
            }
#line 2580 "parser/tokenizer.cpp"
yy222:
	yych = *++cur;
yy223:
	if (yych <= '@') {
		if (yych == '.') goto yy373;
		goto yy61;
	} else {
		if (yych <= 'Z') goto yy222;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy222;
		goto yy61;
	}
yy224:
	yych = *++cur;
	if (yych <= ',') {
		if (yych != '+') goto yy223;
	} else {
		if (yych <= '-') goto yy225;
		if (yych <= '/') goto yy223;
		if (yych <= '9') goto yy226;
		goto yy223;
	}
yy225:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych >= ':') goto yy61;
yy226:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy90;
	if (yych <= '9') goto yy226;
	if (yych == '_') goto yy207;
	goto yy90;
yy227:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy105;
			}
			goto yy21;
		} else {
			if (yych == '\f') goto yy21;
			ctxmar = cur;
			goto yy105;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') {
				ctxmar = cur;
				goto yy105;
			}
			goto yy21;
		} else {
			if (yych <= '.') {
				ctxmar = cur;
				goto yy374;
			}
			if (yych <= '/') goto yy21;
			if (yych <= '9') goto yy227;
			goto yy21;
		}
	}
yy228:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '-') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych <= '\n') goto yy21;
			ctxmar = cur;
			goto yy105;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy21;
				ctxmar = cur;
				goto yy105;
			} else {
				if (yych == ' ') {
					ctxmar = cur;
					goto yy105;
				}
				goto yy21;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '.') {
					ctxmar = cur;
					goto yy374;
				}
				goto yy21;
			} else {
				if (yych <= '9') goto yy228;
				if (yych <= '@') goto yy21;
				goto yy228;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy21;
				goto yy228;
			} else {
				if (yych <= '`') goto yy21;
				if (yych <= 'z') goto yy228;
				goto yy21;
			}
		}
	}
yy229:
	yych = *++cur;
	if (yych == 'T') goto yy375;
	if (yych == 't') goto yy375;
	goto yy37;
yy230:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy231;
			if (yych <= 'N') goto yy36;
			goto yy376;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'o') goto yy376;
			if (yych <= 'z') goto yy36;
		}
	}
yy231:
#line 280 "parser/tokenizer.re"
	{ KW(ALL) }
#line 2725 "parser/tokenizer.cpp"
yy232:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'I') goto yy377;
		if (yych <= 'N') goto yy37;
		goto yy378;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy377;
		} else {
			if (yych == 'o') goto yy378;
			goto yy37;
		}
	}
yy233:
	yych = *++cur;
	if (yych == 'N') goto yy379;
	if (yych == 'n') goto yy379;
	goto yy37;
yy234:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy234;
	}
	if (yych == '"') goto yy380;
	goto yy61;
yy235:
	yych = *++cur;
	if (yych == '\'') goto yy381;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy235;
	goto yy61;
yy236:
	yych = *++cur;
	if (yych == 'K') goto yy382;
	if (yych == 'k') goto yy382;
	goto yy37;
yy237:
	yych = *++cur;
	if (yych == 'D') goto yy383;
	if (yych == 'd') goto yy383;
	goto yy37;
yy238:
	yych = *++cur;
	if (yych == 'C') goto yy384;
	if (yych == 'c') goto yy384;
	goto yy37;
yy239:
	yych = *++cur;
	if (yych == 'L') goto yy385;
	if (yych == 'l') goto yy385;
	goto yy37;
yy240:
	yych = *++cur;
	if (yych == 'E') goto yy386;
	if (yych == 'e') goto yy386;
	goto yy37;
yy241:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy387;
		if (yych <= 'Q') goto yy37;
		goto yy388;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy387;
		} else {
			if (yych == 'r') goto yy388;
			goto yy37;
		}
	}
yy242:
	yych = *++cur;
	if (yych == 'S') goto yy389;
	if (yych == 's') goto yy389;
	goto yy37;
yy243:
	yych = *++cur;
	if (yych == 'S') goto yy390;
	if (yych == 's') goto yy390;
	goto yy37;
yy244:
	yych = *++cur;
	if (yych == 'I') goto yy391;
	if (yych == 'i') goto yy391;
	goto yy37;
yy245:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'M') goto yy392;
		if (yych <= 'O') goto yy37;
		goto yy393;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy392;
		} else {
			if (yych == 'p') goto yy393;
			goto yy37;
		}
	}
yy246:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'C') goto yy394;
		if (yych <= 'S') goto yy37;
		goto yy395;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy394;
		} else {
			if (yych == 't') goto yy395;
			goto yy37;
		}
	}
yy247:
	yych = *++cur;
	if (yych == 'T') goto yy396;
	if (yych == 't') goto yy396;
	goto yy37;
yy248:
	yych = *++cur;
	if (yych == 'L') goto yy397;
	if (yych == 'l') goto yy397;
	goto yy37;
yy249:
	yych = *++cur;
	if (yych == 'A') goto yy398;
	if (yych == 'a') goto yy398;
	goto yy37;
yy250:
	yych = *++cur;
	if (yych == 'L') goto yy399;
	if (yych == 'l') goto yy399;
	goto yy37;
yy251:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy400;
		if (yych <= 'D') goto yy37;
		goto yy401;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy400;
		} else {
			if (yych == 'e') goto yy401;
			goto yy37;
		}
	}
yy252:
	yych = *++cur;
	if (yych == 'E') goto yy402;
	if (yych == 'e') goto yy402;
	goto yy37;
yy253:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy253;
		} else {
			if (yych == '\v') goto yy253;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy253;
			if (yych <= 0x1F) goto yy61;
			goto yy253;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '9') goto yy403;
			goto yy61;
		}
	}
yy254:
	yych = *++cur;
	if (yych == 'B') goto yy405;
	if (yych == 'b') goto yy405;
	goto yy37;
yy255:
	yych = *++cur;
	if (yych == 'H') goto yy406;
	if (yych == 'h') goto yy406;
	goto yy37;
yy256:
	yych = *++cur;
	if (yych == 'M') goto yy407;
	if (yych == 'm') goto yy407;
	goto yy37;
yy257:
	yych = *++cur;
	if (yych == 'E') goto yy408;
	if (yych == 'e') goto yy408;
	goto yy37;
yy258:
	yyaccept = 10;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r': goto yy410;
		case ' ': goto yy412;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy36;
		case 'A':
		case 'a': goto yy413;
		case 'B':
		case 'b': goto yy414;
		case 'C':
		case 'c': goto yy415;
		case 'D':
		case 'd': goto yy416;
		case 'E':
		case 'e': goto yy417;
		case 'F':
		case 'f': goto yy418;
		case 'I':
		case 'i': goto yy419;
		case 'M':
		case 'm': goto yy420;
		case 'P':
		case 'p': goto yy421;
		case 'S':
		case 's': goto yy422;
		case 'T':
		case 't': goto yy423;
		case 'W':
		case 'w': goto yy424;
		default: goto yy259;
	}
yy259:
#line 328 "parser/tokenizer.re"
	{ KW(END) }
#line 3003 "parser/tokenizer.cpp"
yy260:
	yych = *++cur;
	if (yych == 'R') goto yy425;
	if (yych == 'r') goto yy425;
	goto yy37;
yy261:
	yych = *++cur;
	if (yych == 'M') goto yy426;
	if (yych == 'm') goto yy426;
	goto yy37;
yy262:
	yych = *++cur;
	if (yych == 'I') goto yy428;
	if (yych == 'i') goto yy428;
	goto yy37;
yy263:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'M') goto yy429;
		if (yych <= 'N') goto yy37;
		goto yy430;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy429;
		} else {
			if (yych == 'o') goto yy430;
			goto yy37;
		}
	}
yy264:
	yych = *++cur;
	if (yych == 'N') goto yy431;
	if (yych == 'n') goto yy431;
	goto yy37;
yy265:
	yych = *++cur;
	if (yych == 'T') goto yy432;
	if (yych == 't') goto yy432;
	goto yy37;
yy266:
	yych = *++cur;
	if (yych == 'E') goto yy433;
	if (yych == 'e') goto yy433;
	goto yy37;
yy267:
	yych = *++cur;
	if (yych == 'E') goto yy434;
	if (yych == 'e') goto yy434;
	goto yy37;
yy268:
	yych = *++cur;
	if (yych == 'A') goto yy435;
	if (yych == 'a') goto yy435;
	goto yy37;
yy269:
	yych = *++cur;
	if (yych == 'S') goto yy436;
	if (yych == 's') goto yy436;
	goto yy37;
yy270:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy437;
		if (yych <= 'L') goto yy37;
		goto yy438;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy437;
		} else {
			if (yych == 'm') goto yy438;
			goto yy37;
		}
	}
yy271:
	yych = *++cur;
	if (yych == 'C') goto yy440;
	if (yych == 'c') goto yy440;
	goto yy37;
yy272:
	yych = *++cur;
	if (yych == 'E') goto yy441;
	if (yych == 'e') goto yy441;
	goto yy37;
yy273:
	yych = *++cur;
	if (yych == 'O') goto yy442;
	if (yych == 'o') goto yy442;
	goto yy37;
yy274:
	yych = *++cur;
	if (yych == 'G') goto yy443;
	if (yych == 'g') goto yy443;
	goto yy37;
yy275:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'L') goto yy444;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy445;
			if (yych <= 'T') goto yy37;
			goto yy446;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'l') goto yy444;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy445;
			if (yych == 'u') goto yy446;
			goto yy37;
		}
	}
yy276:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy276;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy276;
		}
	} else {
		if (yych <= 'N') {
			if (yych == ' ') goto yy276;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy447;
			if (yych == 'o') goto yy447;
			goto yy61;
		}
	}
yy277:
	yych = *++cur;
	if (yych == 'L') goto yy448;
	if (yych == 'l') goto yy448;
	goto yy37;
yy278:
	yych = *++cur;
	if (yych == 'U') goto yy449;
	if (yych == 'u') goto yy449;
	goto yy37;
yy279:
	yych = *++cur;
	if (yych == 'U') goto yy450;
	if (yych == 'u') goto yy450;
	goto yy37;
yy280:
	yych = *++cur;
	if (yych == 'T') goto yy451;
	if (yych == 't') goto yy451;
	goto yy37;
yy281:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'E') goto yy452;
		if (yych <= 'Q') goto yy37;
		goto yy453;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy452;
		} else {
			if (yych == 'r') goto yy453;
			goto yy37;
		}
	}
yy282:
	yych = *++cur;
	if (yych == 'D') goto yy454;
	if (yych == 'd') goto yy454;
	goto yy37;
yy283:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 454 "parser/tokenizer.re"
	{ KW(LEN) }
#line 3188 "parser/tokenizer.cpp"
yy284:
	yych = *++cur;
	if (yych == 'A') goto yy455;
	if (yych == 'a') goto yy455;
	goto yy37;
yy285:
	yych = *++cur;
	if (yych == 'I') goto yy456;
	if (yych == 'i') goto yy456;
	goto yy37;
yy286:
	yych = *++cur;
	if (yych == 'O') goto yy457;
	if (yych == 'o') goto yy457;
	goto yy37;
yy287:
	yych = *++cur;
	if (yych == 'U') goto yy458;
	if (yych == 'u') goto yy458;
	goto yy37;
yy288:
	yych = *++cur;
	if (yych == 'D') goto yy459;
	if (yych == 'd') goto yy459;
	goto yy37;
yy289:
	yych = *++cur;
	if (yych == 'E') goto yy460;
	if (yych == 'e') goto yy460;
	goto yy37;
yy290:
	yych = *++cur;
	if (yych == '_') goto yy462;
	goto yy37;
yy291:
	yych = *++cur;
	if (yych <= '^') {
		if (yych == 'E') goto yy463;
		goto yy37;
	} else {
		if (yych <= '_') goto yy464;
		if (yych == 'e') goto yy463;
		goto yy37;
	}
yy292:
	yych = *++cur;
	if (yych == 'A') goto yy465;
	if (yych == 'a') goto yy465;
	goto yy37;
yy293:
	yych = *++cur;
	if (yych == 'L') goto yy466;
	if (yych == 'l') goto yy466;
	goto yy37;
yy294:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy294;
	}
	if (yych == '"') goto yy467;
	goto yy61;
yy295:
	yych = *++cur;
	if (yych == '\'') goto yy468;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy295;
	goto yy61;
yy296:
	yych = *++cur;
	if (yych == 'Y') goto yy469;
	if (yych == 'y') goto yy469;
	goto yy37;
yy297:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy470;
		if (yych <= 'Q') goto yy37;
		goto yy471;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy470;
		} else {
			if (yych == 'r') goto yy471;
			goto yy37;
		}
	}
yy298:
	yych = *++cur;
	if (yych == 'I') goto yy472;
	if (yych == 'i') goto yy472;
	goto yy37;
yy299:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 474 "parser/tokenizer.re"
	{ KW(OUT) }
#line 3289 "parser/tokenizer.cpp"
yy300:
	yych = *++cur;
	if (yych == 'A') goto yy473;
	if (yych == 'a') goto yy473;
	goto yy37;
yy301:
	yych = *++cur;
	if (yych == 'S') goto yy474;
	if (yych == 's') goto yy474;
	goto yy37;
yy302:
	yych = *++cur;
	if (yych == 'N') goto yy475;
	if (yych == 'n') goto yy475;
	goto yy37;
yy303:
	yych = *++cur;
	if (yych == 'T') goto yy476;
	if (yych == 't') goto yy476;
	goto yy37;
yy304:
	yych = *++cur;
	if (yych == 'C') goto yy477;
	if (yych == 'c') goto yy477;
	goto yy37;
yy305:
	yych = *++cur;
	if (yych <= 'V') {
		if (yych == 'N') goto yy478;
		if (yych <= 'U') goto yy37;
		goto yy479;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy478;
		} else {
			if (yych == 'v') goto yy479;
			goto yy37;
		}
	}
yy306:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych <= 'F') {
			if (yych == 'C') goto yy480;
			goto yy37;
		} else {
			if (yych <= 'G') goto yy481;
			if (yych <= 'S') goto yy37;
			goto yy482;
		}
	} else {
		if (yych <= 'f') {
			if (yych == 'c') goto yy480;
			goto yy37;
		} else {
			if (yych <= 'g') goto yy481;
			if (yych == 't') goto yy482;
			goto yy37;
		}
	}
yy307:
	yych = *++cur;
	if (yych == 'L') goto yy483;
	if (yych == 'l') goto yy483;
	goto yy37;
yy308:
	yych = *++cur;
	if (yych == 'E') goto yy484;
	if (yych == 'e') goto yy484;
	goto yy37;
yy309:
	yych = *++cur;
	if (yych == 'E') goto yy485;
	if (yych == 'e') goto yy485;
	goto yy37;
yy310:
	yych = *++cur;
	if (yych == 'K') goto yy486;
	if (yych == 'k') goto yy486;
	goto yy37;
yy311:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy487;
		if (yych <= 'K') goto yy37;
		goto yy488;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy487;
		} else {
			if (yych == 'l') goto yy488;
			goto yy37;
		}
	}
yy312:
	yych = *++cur;
	if (yych == 'U') goto yy489;
	if (yych == 'u') goto yy489;
	goto yy37;
yy313:
	yych = *++cur;
	if (yych == 'U') goto yy490;
	if (yych == 'u') goto yy490;
	goto yy37;
yy314:
	yych = *++cur;
	if (yych == 'U') goto yy491;
	if (yych == 'u') goto yy491;
	goto yy37;
yy315:
	yych = *++cur;
	if (yych == 'U') goto yy492;
	if (yych == 'u') goto yy492;
	goto yy37;
yy316:
	yych = *++cur;
	if (yych == 'U') goto yy493;
	if (yych == 'u') goto yy493;
	goto yy37;
yy317:
	yych = *++cur;
	if (yych == 'I') goto yy494;
	if (yych == 'i') goto yy494;
	goto yy37;
yy318:
	yych = *++cur;
	if (yych == 'E') goto yy495;
	if (yych == 'e') goto yy495;
	goto yy37;
yy319:
	yych = *++cur;
	if (yych == 'E') goto yy496;
	if (yych == 'e') goto yy496;
	goto yy37;
yy320:
	yych = *++cur;
	if (yych == 'U') goto yy497;
	if (yych == 'u') goto yy497;
	goto yy37;
yy321:
	yych = *++cur;
	if (yych == 'R') goto yy498;
	if (yych == 'r') goto yy498;
	goto yy37;
yy322:
	yych = *++cur;
	if (yych == 'R') goto yy499;
	if (yych == 'r') goto yy499;
	goto yy37;
yy323:
	yych = *++cur;
	if (yych == 'T') goto yy500;
	if (yych == 't') goto yy500;
	goto yy37;
yy324:
	yych = *++cur;
	if (yych == 'P') goto yy501;
	if (yych == 'p') goto yy501;
	goto yy37;
yy325:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy502;
		if (yych <= 'Q') goto yy37;
		goto yy503;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy502;
		} else {
			if (yych == 'r') goto yy503;
			goto yy37;
		}
	}
yy326:
	yych = *++cur;
	if (yych == 'C') goto yy504;
	if (yych == 'c') goto yy504;
	goto yy37;
yy327:
	yych = *++cur;
	if (yych == 'G') goto yy506;
	if (yych == 'g') goto yy506;
	goto yy37;
yy328:
	yych = *++cur;
	if (yych == 'M') goto yy507;
	if (yych == 'm') goto yy507;
	goto yy37;
yy329:
	yych = *++cur;
	if (yych == 'P') goto yy508;
	if (yych == 'p') goto yy508;
	goto yy37;
yy330:
	yych = *++cur;
	if (yych == 'N') goto yy509;
	if (yych == 'n') goto yy509;
	goto yy37;
yy331:
	yych = *++cur;
	if (yych == 'E') goto yy510;
	if (yych == 'e') goto yy510;
	goto yy37;
yy332:
	yych = *++cur;
	if (yych == 'O') goto yy511;
	if (yych == 'o') goto yy511;
	goto yy37;
yy333:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 523 "parser/tokenizer.re"
	{ KW(USE) }
#line 3509 "parser/tokenizer.cpp"
yy334:
	yych = *++cur;
	if (yych == 'U') goto yy512;
	if (yych == 'u') goto yy512;
	goto yy37;
yy335:
	yych = *++cur;
	if (yych == 'A') goto yy513;
	if (yych == 'a') goto yy513;
	goto yy37;
yy336:
	yych = *++cur;
	if (yych == 'T') goto yy514;
	if (yych == 't') goto yy514;
	goto yy37;
yy337:
	yych = *++cur;
	if (yych == 'R') goto yy515;
	if (yych == 'r') goto yy515;
	goto yy37;
yy338:
	yych = *++cur;
	if (yych == 'L') goto yy516;
	if (yych == 'l') goto yy516;
	goto yy37;
yy339:
	yych = *++cur;
	if (yych == 'T') goto yy517;
	if (yych == 't') goto yy517;
	goto yy37;
yy340:
	yych = *++cur;
yy341:
	if (yybm[0+yych] & 128) {
		goto yy340;
	}
	if (yych == '"') goto yy518;
	goto yy61;
yy342:
	yych = *++cur;
yy343:
	if (yych <= '9') {
		if (yych == '\'') goto yy519;
		if (yych <= '/') goto yy61;
		goto yy342;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy61;
			goto yy342;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'f') goto yy342;
			goto yy61;
		}
	}
yy344:
	yych = *++cur;
	if (yych == 'P') goto yy520;
	if (yych == 'p') goto yy520;
	goto yy60;
yy345:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy521;
	goto yy345;
yy346:
	yych = *++cur;
	if (yych == 'i') goto yy522;
	goto yy69;
yy347:
	yych = *++cur;
	if (yych == 'f') goto yy523;
	goto yy69;
yy348:
	yych = *++cur;
	if (yych == 'e') goto yy524;
	goto yy69;
yy349:
	yych = *++cur;
	if (yych == 'i') goto yy525;
	goto yy69;
yy350:
	yych = *++cur;
	if (yych == 'e') goto yy526;
	goto yy69;
yy351:
	yych = *++cur;
	if (yych == 'l') goto yy527;
	goto yy69;
yy352:
	yych = *++cur;
	if (yych == 'e') goto yy528;
	goto yy69;
yy353:
	++cur;
	cur = ctxmar;
#line 551 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3608 "parser/tokenizer.cpp"
yy354:
	yych = *++cur;
yy355:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy354;
		} else {
			if (yych == '\v') goto yy354;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy354;
			if (yych <= 0x1F) goto yy61;
			goto yy354;
		} else {
			if (yych == ')') goto yy529;
			goto yy61;
		}
	}
yy356:
	++cur;
	cur -= 3;
#line 554 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3635 "parser/tokenizer.cpp"
yy357:
	yych = *++cur;
	if (yych <= '/') goto yy90;
	if (yych <= '9') goto yy357;
	goto yy90;
yy358:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy90;
		if (yych <= '9') goto yy358;
		if (yych <= '@') goto yy90;
		goto yy358;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy90;
			goto yy358;
		} else {
			if (yych <= '`') goto yy90;
			if (yych <= 'z') goto yy358;
			goto yy90;
		}
	}
yy359:
	yych = *++cur;
	if (yych == '.') goto yy530;
	goto yy93;
yy360:
	++cur;
#line 581 "parser/tokenizer.re"
	{ WARN_REL(EQ) RET(TK_EQ) }
#line 3666 "parser/tokenizer.cpp"
yy361:
	yych = *++cur;
	if (yych == '.') goto yy531;
	goto yy93;
yy362:
	yych = *++cur;
	if (yych == 'S') goto yy532;
	if (yych == 's') goto yy532;
	goto yy93;
yy363:
	++cur;
#line 596 "parser/tokenizer.re"
	{ WARN_REL(GE) RET(TK_GE) }
#line 3680 "parser/tokenizer.cpp"
yy364:
	++cur;
#line 593 "parser/tokenizer.re"
	{ WARN_REL(GT) RET(TK_GT) }
#line 3685 "parser/tokenizer.cpp"
yy365:
	++cur;
#line 590 "parser/tokenizer.re"
	{ WARN_REL(LE) RET(TK_LE) }
#line 3690 "parser/tokenizer.cpp"
yy366:
	++cur;
#line 587 "parser/tokenizer.re"
	{ WARN_REL(LT) RET(TK_LT) }
#line 3695 "parser/tokenizer.cpp"
yy367:
	++cur;
#line 584 "parser/tokenizer.re"
	{ WARN_REL(NE) RET(TK_NE) }
#line 3700 "parser/tokenizer.cpp"
yy368:
	yych = *++cur;
	if (yych == 'V') goto yy533;
	if (yych == 'v') goto yy533;
	goto yy93;
yy369:
	yych = *++cur;
	if (yych == '.') goto yy534;
	goto yy93;
yy370:
	++cur;
#line 602 "parser/tokenizer.re"
	{ RET(TK_OR) }
#line 3714 "parser/tokenizer.cpp"
yy371:
	yych = *++cur;
	if (yych == 'E') goto yy535;
	if (yych == 'e') goto yy535;
	goto yy93;
yy372:
	yych = *++cur;
	if (yych == '.') goto yy536;
	goto yy93;
yy373:
	++cur;
	cur = ctxmar;
#line 617 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 3734 "parser/tokenizer.cpp"
yy374:
	yych = *++cur;
	if (yych == '.') goto yy61;
	goto yy223;
yy375:
	yych = *++cur;
	if (yych == 'R') goto yy537;
	if (yych == 'r') goto yy537;
	goto yy37;
yy376:
	yych = *++cur;
	if (yych == 'C') goto yy538;
	if (yych == 'c') goto yy538;
	goto yy37;
yy377:
	yych = *++cur;
	if (yych == 'G') goto yy539;
	if (yych == 'g') goto yy539;
	goto yy37;
yy378:
	yych = *++cur;
	if (yych == 'C') goto yy540;
	if (yych == 'c') goto yy540;
	goto yy37;
yy379:
	yych = *++cur;
	if (yych == 'C') goto yy541;
	if (yych == 'c') goto yy541;
	goto yy37;
yy380:
	++cur;
#line 665 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3768 "parser/tokenizer.cpp"
yy381:
	++cur;
#line 666 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3773 "parser/tokenizer.cpp"
yy382:
	yych = *++cur;
	if (yych == 'S') goto yy542;
	if (yych == 's') goto yy542;
	goto yy37;
yy383:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 288 "parser/tokenizer.re"
	{ KW(BIND) }
#line 3787 "parser/tokenizer.cpp"
yy384:
	yych = *++cur;
	if (yych == 'K') goto yy543;
	if (yych == 'k') goto yy543;
	goto yy37;
yy385:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 290 "parser/tokenizer.re"
	{ KW(CALL) }
#line 3801 "parser/tokenizer.cpp"
yy386:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 291 "parser/tokenizer.re"
	{ KW(CASE) }
#line 3810 "parser/tokenizer.cpp"
yy387:
	yych = *++cur;
	if (yych == 'G') goto yy544;
	if (yych == 'g') goto yy544;
	goto yy37;
yy388:
	yych = *++cur;
	if (yych == 'A') goto yy545;
	if (yych == 'a') goto yy545;
	goto yy37;
yy389:
	yych = *++cur;
	if (yych == 'S') goto yy546;
	if (yych == 's') goto yy546;
	goto yy37;
yy390:
	yych = *++cur;
	if (yych == 'E') goto yy547;
	if (yych == 'e') goto yy547;
	goto yy37;
yy391:
	yych = *++cur;
	if (yych == 'M') goto yy548;
	if (yych == 'm') goto yy548;
	goto yy37;
yy392:
	yych = *++cur;
	if (yych == 'O') goto yy549;
	if (yych == 'o') goto yy549;
	goto yy37;
yy393:
	yych = *++cur;
	if (yych == 'L') goto yy550;
	if (yych == 'l') goto yy550;
	goto yy37;
yy394:
	yych = *++cur;
	if (yych == 'U') goto yy551;
	if (yych == 'u') goto yy551;
	goto yy37;
yy395:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'A') goto yy552;
		if (yych <= 'H') goto yy37;
		goto yy553;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy552;
		} else {
			if (yych == 'i') goto yy553;
			goto yy37;
		}
	}
yy396:
	yych = *++cur;
	if (yych == 'I') goto yy554;
	if (yych == 'i') goto yy554;
	goto yy37;
yy397:
	yych = *++cur;
	if (yych == 'E') goto yy555;
	if (yych == 'e') goto yy555;
	goto yy37;
yy398:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 306 "parser/tokenizer.re"
	{ KW(DATA) }
#line 3884 "parser/tokenizer.cpp"
yy399:
	yych = *++cur;
	if (yych == 'L') goto yy556;
	if (yych == 'l') goto yy556;
	goto yy37;
yy400:
	yych = *++cur;
	if (yych == 'U') goto yy557;
	if (yych == 'u') goto yy557;
	goto yy37;
yy401:
	yych = *++cur;
	if (yych == 'R') goto yy558;
	if (yych == 'r') goto yy558;
	goto yy37;
yy402:
	yych = *++cur;
	if (yych == 'N') goto yy559;
	if (yych == 'n') goto yy559;
	goto yy37;
yy403:
	yych = *++cur;
	if (yych <= '/') goto yy404;
	if (yych <= '9') goto yy403;
yy404:
	cur = ctxmar;
#line 311 "parser/tokenizer.re"
	{
                // This is a label do statement, we have to match the
                // corresponding continue base "end do".
                uint64_t n = parse_int(cur);
                enddo_label_stack.push_back(n);
                KW(DO);
            }
#line 3919 "parser/tokenizer.cpp"
yy405:
	yych = *++cur;
	if (yych == 'L') goto yy560;
	if (yych == 'l') goto yy560;
	goto yy37;
yy406:
	yych = *++cur;
	if (yych == 'I') goto yy561;
	if (yych == 'i') goto yy561;
	goto yy37;
yy407:
	yych = *++cur;
	if (yych == 'E') goto yy562;
	if (yych == 'e') goto yy562;
	goto yy37;
yy408:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= '/') goto yy409;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'I') goto yy563;
			if (yych <= 'V') goto yy36;
			goto yy564;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy409;
			if (yych <= 'h') goto yy36;
			goto yy563;
		} else {
			if (yych == 'w') goto yy564;
			if (yych <= 'z') goto yy36;
		}
	}
yy409:
#line 324 "parser/tokenizer.re"
	{ KW(ELSE) }
#line 3963 "parser/tokenizer.cpp"
yy410:
	yych = *++cur;
yy411:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy410;
		case 'A':
		case 'a': goto yy565;
		case 'B':
		case 'b': goto yy566;
		case 'C':
		case 'c': goto yy567;
		case 'D':
		case 'd': goto yy568;
		case 'E':
		case 'e': goto yy569;
		case 'F':
		case 'f': goto yy570;
		case 'I':
		case 'i': goto yy571;
		case 'M':
		case 'm': goto yy572;
		case 'P':
		case 'p': goto yy573;
		case 'S':
		case 's': goto yy574;
		case 'T':
		case 't': goto yy575;
		case 'W':
		case 'w': goto yy576;
		default: goto yy61;
	}
yy412:
	yych = *++cur;
	if (yych == 'F') goto yy577;
	if (yych == 'f') goto yy577;
	goto yy411;
yy413:
	yych = *++cur;
	if (yych == 'S') goto yy578;
	if (yych == 's') goto yy578;
	goto yy37;
yy414:
	yych = *++cur;
	if (yych == 'L') goto yy579;
	if (yych == 'l') goto yy579;
	goto yy37;
yy415:
	yych = *++cur;
	if (yych == 'R') goto yy580;
	if (yych == 'r') goto yy580;
	goto yy37;
yy416:
	yych = *++cur;
	if (yych == 'O') goto yy581;
	if (yych == 'o') goto yy581;
	goto yy37;
yy417:
	yych = *++cur;
	if (yych == 'N') goto yy582;
	if (yych == 'n') goto yy582;
	goto yy37;
yy418:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy583;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy584;
			if (yych <= 'T') goto yy37;
			goto yy585;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy583;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy584;
			if (yych == 'u') goto yy585;
			goto yy37;
		}
	}
yy419:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy586;
		if (yych <= 'M') goto yy37;
		goto yy587;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy37;
			goto yy586;
		} else {
			if (yych == 'n') goto yy587;
			goto yy37;
		}
	}
yy420:
	yych = *++cur;
	if (yych == 'O') goto yy588;
	if (yych == 'o') goto yy588;
	goto yy37;
yy421:
	yych = *++cur;
	if (yych == 'R') goto yy589;
	if (yych == 'r') goto yy589;
	goto yy37;
yy422:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy590;
		if (yych <= 'T') goto yy37;
		goto yy591;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy590;
		} else {
			if (yych == 'u') goto yy591;
			goto yy37;
		}
	}
yy423:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy592;
		if (yych <= 'X') goto yy37;
		goto yy593;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy592;
		} else {
			if (yych == 'y') goto yy593;
			goto yy37;
		}
	}
yy424:
	yych = *++cur;
	if (yych == 'H') goto yy594;
	if (yych == 'h') goto yy594;
	goto yy37;
yy425:
	yych = *++cur;
	if (yych == 'Y') goto yy595;
	if (yych == 'y') goto yy595;
	goto yy37;
yy426:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'E') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy427;
			if (yych <= 'D') goto yy36;
			goto yy596;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'e') goto yy596;
			if (yych <= 'z') goto yy36;
		}
	}
yy427:
#line 405 "parser/tokenizer.re"
	{ KW(ENUM) }
#line 4139 "parser/tokenizer.cpp"
yy428:
	yych = *++cur;
	if (yych == 'V') goto yy597;
	if (yych == 'v') goto yy597;
	goto yy37;
yy429:
	yych = *++cur;
	if (yych == 'S') goto yy598;
	if (yych == 's') goto yy598;
	goto yy37;
yy430:
	yych = *++cur;
	if (yych == 'R') goto yy599;
	if (yych == 'r') goto yy599;
	goto yy37;
yy431:
	yych = *++cur;
	if (yych == 'T') goto yy600;
	if (yych == 't') goto yy600;
	goto yy37;
yy432:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 411 "parser/tokenizer.re"
	{ KW(EXIT) }
#line 4168 "parser/tokenizer.cpp"
yy433:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy601;
		if (yych <= 'Q') goto yy37;
		goto yy602;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy601;
		} else {
			if (yych == 'r') goto yy602;
			goto yy37;
		}
	}
yy434:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 414 "parser/tokenizer.re"
	{ KW(FILE) }
#line 4192 "parser/tokenizer.cpp"
yy435:
	yych = *++cur;
	if (yych == 'L') goto yy603;
	if (yych == 'l') goto yy603;
	goto yy37;
yy436:
	yych = *++cur;
	if (yych == 'H') goto yy604;
	if (yych == 'h') goto yy604;
	goto yy37;
yy437:
	yych = *++cur;
	if (yych == 'L') goto yy605;
	if (yych == 'l') goto yy605;
	goto yy37;
yy438:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych <= '/') goto yy439;
			if (yych <= '9') goto yy36;
		} else {
			if (yych <= 'A') goto yy606;
			if (yych <= 'S') goto yy36;
			goto yy607;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy606;
		} else {
			if (yych == 't') goto yy607;
			if (yych <= 'z') goto yy36;
		}
	}
yy439:
#line 431 "parser/tokenizer.re"
	{ KW(FORM) }
#line 4234 "parser/tokenizer.cpp"
yy440:
	yych = *++cur;
	if (yych == 'T') goto yy608;
	if (yych == 't') goto yy608;
	goto yy37;
yy441:
	yych = *++cur;
	if (yych == 'R') goto yy609;
	if (yych == 'r') goto yy609;
	goto yy37;
yy442:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 436 "parser/tokenizer.re"
	{ KW(GOTO) }
#line 4253 "parser/tokenizer.cpp"
yy443:
	yych = *++cur;
	if (yych == 'E') goto yy610;
	if (yych == 'e') goto yy610;
	goto yy37;
yy444:
	yych = *++cur;
	if (yych == 'I') goto yy611;
	if (yych == 'i') goto yy611;
	goto yy37;
yy445:
	yych = *++cur;
	if (yych == 'R') goto yy612;
	if (yych == 'r') goto yy612;
	goto yy37;
yy446:
	yych = *++cur;
	if (yych == 'R') goto yy613;
	if (yych == 'r') goto yy613;
	goto yy37;
yy447:
	yych = *++cur;
	if (yych == 'U') goto yy614;
	if (yych == 'u') goto yy614;
	goto yy61;
yy448:
	yych = *++cur;
	if (yych == 'U') goto yy615;
	if (yych == 'u') goto yy615;
	goto yy37;
yy449:
	yych = *++cur;
	if (yych == 'T') goto yy616;
	if (yych == 't') goto yy616;
	goto yy37;
yy450:
	yych = *++cur;
	if (yych == 'I') goto yy617;
	if (yych == 'i') goto yy617;
	goto yy37;
yy451:
	yych = *++cur;
	if (yych == 'A') goto yy618;
	if (yych == 'a') goto yy618;
	goto yy37;
yy452:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'M') {
			if (yych == 'G') goto yy619;
			goto yy37;
		} else {
			if (yych <= 'N') goto yy620;
			if (yych <= 'Q') goto yy37;
			goto yy621;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'g') goto yy619;
			goto yy37;
		} else {
			if (yych <= 'n') goto yy620;
			if (yych == 'r') goto yy621;
			goto yy37;
		}
	}
yy453:
	yych = *++cur;
	if (yych == 'I') goto yy622;
	if (yych == 'i') goto yy622;
	goto yy37;
yy454:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 453 "parser/tokenizer.re"
	{ KW(KIND) }
#line 4333 "parser/tokenizer.cpp"
yy455:
	yych = *++cur;
	if (yych == 'L') goto yy623;
	if (yych == 'l') goto yy623;
	goto yy37;
yy456:
	yych = *++cur;
	if (yych == 'C') goto yy624;
	if (yych == 'c') goto yy624;
	goto yy37;
yy457:
	yych = *++cur;
	if (yych == 'R') goto yy625;
	if (yych == 'r') goto yy625;
	goto yy37;
yy458:
	yych = *++cur;
	if (yych == 'L') goto yy626;
	if (yych == 'l') goto yy626;
	goto yy37;
yy459:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 460 "parser/tokenizer.re"
	{ KW(MOLD) }
#line 4362 "parser/tokenizer.cpp"
yy460:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy461;
			if (yych <= 'K') goto yy36;
			goto yy627;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'l') goto yy627;
			if (yych <= 'z') goto yy36;
		}
	}
yy461:
#line 461 "parser/tokenizer.re"
	{ KW(NAME) }
#line 4388 "parser/tokenizer.cpp"
yy462:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy65;
		if (yych <= '&') goto yy37;
		goto yy82;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy628;
		} else {
			if (yych == 'i') goto yy628;
			goto yy37;
		}
	}
yy463:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 468 "parser/tokenizer.re"
	{ KW(NONE) }
#line 4413 "parser/tokenizer.cpp"
yy464:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'O') {
		if (yych <= '\'') {
			if (yych == '"') goto yy65;
			if (yych <= '&') goto yy37;
			goto yy82;
		} else {
			if (yych == 'I') goto yy629;
			if (yych <= 'N') goto yy37;
			goto yy630;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'R') goto yy631;
			if (yych <= 'h') goto yy37;
			goto yy629;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy630;
			} else {
				if (yych == 'r') goto yy631;
				goto yy37;
			}
		}
	}
yy465:
	yych = *++cur;
	if (yych == 'S') goto yy632;
	if (yych == 's') goto yy632;
	goto yy37;
yy466:
	yych = *++cur;
	if (yych == 'I') goto yy633;
	if (yych == 'i') goto yy633;
	goto yy37;
yy467:
	++cur;
#line 667 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4456 "parser/tokenizer.cpp"
yy468:
	++cur;
#line 668 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4461 "parser/tokenizer.cpp"
yy469:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 470 "parser/tokenizer.re"
	{ KW(ONLY) }
#line 4470 "parser/tokenizer.cpp"
yy470:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 471 "parser/tokenizer.re"
	{ KW(OPEN) }
#line 4479 "parser/tokenizer.cpp"
yy471:
	yych = *++cur;
	if (yych == 'A') goto yy634;
	if (yych == 'a') goto yy634;
	goto yy37;
yy472:
	yych = *++cur;
	if (yych == 'O') goto yy635;
	if (yych == 'o') goto yy635;
	goto yy37;
yy473:
	yych = *++cur;
	if (yych == 'M') goto yy636;
	if (yych == 'm') goto yy636;
	goto yy37;
yy474:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 476 "parser/tokenizer.re"
	{ KW(PASS) }
#line 4503 "parser/tokenizer.cpp"
yy475:
	yych = *++cur;
	if (yych == 'T') goto yy637;
	if (yych == 't') goto yy637;
	goto yy37;
yy476:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 478 "parser/tokenizer.re"
	{ KW(POST) }
#line 4517 "parser/tokenizer.cpp"
yy477:
	yych = *++cur;
	if (yych == 'I') goto yy638;
	if (yych == 'i') goto yy638;
	goto yy37;
yy478:
	yych = *++cur;
	if (yych == 'T') goto yy639;
	if (yych == 't') goto yy639;
	goto yy37;
yy479:
	yych = *++cur;
	if (yych == 'A') goto yy640;
	if (yych == 'a') goto yy640;
	goto yy37;
yy480:
	yych = *++cur;
	if (yych == 'E') goto yy641;
	if (yych == 'e') goto yy641;
	goto yy37;
yy481:
	yych = *++cur;
	if (yych == 'R') goto yy642;
	if (yych == 'r') goto yy642;
	goto yy37;
yy482:
	yych = *++cur;
	if (yych == 'E') goto yy643;
	if (yych == 'e') goto yy643;
	goto yy37;
yy483:
	yych = *++cur;
	if (yych == 'I') goto yy644;
	if (yych == 'i') goto yy644;
	goto yy37;
yy484:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 486 "parser/tokenizer.re"
	{ KW(PURE) }
#line 4561 "parser/tokenizer.cpp"
yy485:
	yych = *++cur;
	if (yych == 'T') goto yy645;
	if (yych == 't') goto yy645;
	goto yy37;
yy486:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 488 "parser/tokenizer.re"
	{ KW(RANK) }
#line 4575 "parser/tokenizer.cpp"
yy487:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 489 "parser/tokenizer.re"
	{ KW(READ) }
#line 4584 "parser/tokenizer.cpp"
yy488:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 490 "parser/tokenizer.re"
	{KW(REAL) }
#line 4593 "parser/tokenizer.cpp"
yy489:
	yych = *++cur;
	if (yych == 'R') goto yy646;
	if (yych == 'r') goto yy646;
	goto yy37;
yy490:
	yych = *++cur;
	if (yych == 'C') goto yy647;
	if (yych == 'c') goto yy647;
	goto yy37;
yy491:
	yych = *++cur;
	if (yych == 'I') goto yy648;
	if (yych == 'i') goto yy648;
	goto yy37;
yy492:
	yych = *++cur;
	if (yych == 'L') goto yy649;
	if (yych == 'l') goto yy649;
	goto yy37;
yy493:
	yych = *++cur;
	if (yych == 'R') goto yy650;
	if (yych == 'r') goto yy650;
	goto yy37;
yy494:
	yych = *++cur;
	if (yych == 'N') goto yy651;
	if (yych == 'n') goto yy651;
	goto yy37;
yy495:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 498 "parser/tokenizer.re"
	{ KW(SAVE) }
#line 4632 "parser/tokenizer.cpp"
yy496:
	yych = *++cur;
	if (yych == 'C') goto yy652;
	if (yych == 'c') goto yy652;
	goto yy37;
yy497:
	yych = *++cur;
	if (yych == 'E') goto yy653;
	if (yych == 'e') goto yy653;
	goto yy37;
yy498:
	yych = *++cur;
	if (yych == 'E') goto yy654;
	if (yych == 'e') goto yy654;
	goto yy37;
yy499:
	yych = *++cur;
	if (yych == 'C') goto yy655;
	if (yych == 'c') goto yy655;
	goto yy37;
yy500:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 506 "parser/tokenizer.re"
	{ KW(STAT) }
#line 4661 "parser/tokenizer.cpp"
yy501:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 507 "parser/tokenizer.re"
	{ KW(STOP) }
#line 4670 "parser/tokenizer.cpp"
yy502:
	yych = *++cur;
	if (yych == 'O') goto yy656;
	if (yych == 'o') goto yy656;
	goto yy37;
yy503:
	yych = *++cur;
	if (yych == 'O') goto yy657;
	if (yych == 'o') goto yy657;
	goto yy37;
yy504:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= 'H') {
			if (yych <= '9') {
				if (yych >= '0') goto yy36;
			} else {
				if (yych <= '@') goto yy505;
				if (yych <= 'A') goto yy658;
				goto yy36;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'I') goto yy659;
				goto yy36;
			} else {
				if (yych <= 'M') goto yy660;
				if (yych <= 'S') goto yy36;
				goto yy661;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych <= 'a') goto yy658;
				if (yych <= 'h') goto yy36;
				goto yy659;
			}
		} else {
			if (yych <= 's') {
				if (yych == 'm') goto yy660;
				goto yy36;
			} else {
				if (yych <= 't') goto yy661;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy505:
#line 510 "parser/tokenizer.re"
	{ KW(SYNC) }
#line 4727 "parser/tokenizer.cpp"
yy506:
	yych = *++cur;
	if (yych == 'E') goto yy662;
	if (yych == 'e') goto yy662;
	goto yy37;
yy507:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy663;
#line 516 "parser/tokenizer.re"
	{ KW(TEAM) }
#line 4741 "parser/tokenizer.cpp"
yy508:
	yych = *++cur;
	if (yych == 'L') goto yy664;
	if (yych == 'l') goto yy664;
	goto yy37;
yy509:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 519 "parser/tokenizer.re"
	{ KW(THEN) }
#line 4755 "parser/tokenizer.cpp"
yy510:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 521 "parser/tokenizer.re"
	{ KW(TYPE) }
#line 4764 "parser/tokenizer.cpp"
yy511:
	yych = *++cur;
	if (yych == 'R') goto yy665;
	if (yych == 'r') goto yy665;
	goto yy37;
yy512:
	yych = *++cur;
	if (yych == 'E') goto yy666;
	if (yych == 'e') goto yy666;
	goto yy37;
yy513:
	yych = *++cur;
	if (yych == 'T') goto yy667;
	if (yych == 't') goto yy667;
	goto yy37;
yy514:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 526 "parser/tokenizer.re"
	{ KW(WAIT) }
#line 4788 "parser/tokenizer.cpp"
yy515:
	yych = *++cur;
	if (yych == 'E') goto yy668;
	if (yych == 'e') goto yy668;
	goto yy37;
yy516:
	yych = *++cur;
	if (yych == 'E') goto yy669;
	if (yych == 'e') goto yy669;
	goto yy37;
yy517:
	yych = *++cur;
	if (yych == 'E') goto yy670;
	if (yych == 'e') goto yy670;
	goto yy37;
yy518:
	++cur;
#line 669 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4808 "parser/tokenizer.cpp"
yy519:
	++cur;
#line 670 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4813 "parser/tokenizer.cpp"
yy520:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy673;
		if (yych <= '\n') goto yy672;
		goto yy673;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy672;
			goto yy673;
		} else {
			if (yych == ' ') goto yy673;
			goto yy672;
		}
	}
yy521:
	++cur;
	cur -= 1;
#line 678 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_PRAGMA_DECL) }
#line 4834 "parser/tokenizer.cpp"
yy522:
	yych = *++cur;
	if (yych == 'n') goto yy675;
	goto yy69;
yy523:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy676;
		if (yych <= '\n') goto yy69;
		goto yy676;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy676;
		} else {
			if (yych == ' ') goto yy676;
			goto yy69;
		}
	}
yy524:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy61;
			goto yy68;
		} else {
			if (yych == '\n') goto yy677;
			goto yy524;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy524;
		} else {
			if (yych == ' ') goto yy524;
			goto yy68;
		}
	}
yy525:
	yych = *++cur;
	if (yych == 'f') goto yy678;
	goto yy69;
yy526:
	yych = *++cur;
	if (yych == 'f') goto yy679;
	goto yy69;
yy527:
	yych = *++cur;
	if (yych == 'u') goto yy680;
	goto yy69;
yy528:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy681;
		if (yych <= '\n') goto yy69;
		goto yy681;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy681;
		} else {
			if (yych == ' ') goto yy681;
			goto yy69;
		}
	}
yy529:
	++cur;
	cur = ctxmar;
#line 553 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 4905 "parser/tokenizer.cpp"
yy530:
	++cur;
#line 601 "parser/tokenizer.re"
	{ RET(TK_AND) }
#line 4910 "parser/tokenizer.cpp"
yy531:
	++cur;
#line 604 "parser/tokenizer.re"
	{ RET(TK_EQV) }
#line 4915 "parser/tokenizer.cpp"
yy532:
	yych = *++cur;
	if (yych == 'E') goto yy682;
	if (yych == 'e') goto yy682;
	goto yy93;
yy533:
	yych = *++cur;
	if (yych == '.') goto yy683;
	goto yy93;
yy534:
	++cur;
#line 600 "parser/tokenizer.re"
	{ RET(TK_NOT) }
#line 4929 "parser/tokenizer.cpp"
yy535:
	yych = *++cur;
	if (yych == '.') goto yy684;
	goto yy93;
yy536:
	++cur;
#line 603 "parser/tokenizer.re"
	{ RET(TK_XOR) }
#line 4938 "parser/tokenizer.cpp"
yy537:
	yych = *++cur;
	if (yych == 'A') goto yy686;
	if (yych == 'a') goto yy686;
	goto yy37;
yy538:
	yych = *++cur;
	if (yych == 'A') goto yy687;
	if (yych == 'a') goto yy687;
	goto yy37;
yy539:
	yych = *++cur;
	if (yych == 'N') goto yy688;
	if (yych == 'n') goto yy688;
	goto yy37;
yy540:
	yych = *++cur;
	if (yych == 'I') goto yy690;
	if (yych == 'i') goto yy690;
	goto yy37;
yy541:
	yych = *++cur;
	if (yych == 'H') goto yy691;
	if (yych == 'h') goto yy691;
	goto yy37;
yy542:
	yych = *++cur;
	if (yych == 'P') goto yy692;
	if (yych == 'p') goto yy692;
	goto yy37;
yy543:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 289 "parser/tokenizer.re"
	{ KW(BLOCK) }
#line 4977 "parser/tokenizer.cpp"
yy544:
	yych = *++cur;
	if (yych == 'E') goto yy693;
	if (yych == 'e') goto yy693;
	goto yy37;
yy545:
	yych = *++cur;
	if (yych == 'C') goto yy695;
	if (yych == 'c') goto yy695;
	goto yy37;
yy546:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 295 "parser/tokenizer.re"
	{ KW(CLASS) }
#line 4996 "parser/tokenizer.cpp"
yy547:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 296 "parser/tokenizer.re"
	{ KW(CLOSE) }
#line 5005 "parser/tokenizer.cpp"
yy548:
	yych = *++cur;
	if (yych == 'E') goto yy696;
	if (yych == 'e') goto yy696;
	goto yy37;
yy549:
	yych = *++cur;
	if (yych == 'N') goto yy697;
	if (yych == 'n') goto yy697;
	goto yy37;
yy550:
	yych = *++cur;
	if (yych == 'E') goto yy698;
	if (yych == 'e') goto yy698;
	goto yy37;
yy551:
	yych = *++cur;
	if (yych == 'R') goto yy699;
	if (yych == 'r') goto yy699;
	goto yy37;
yy552:
	yych = *++cur;
	if (yych == 'I') goto yy700;
	if (yych == 'i') goto yy700;
	goto yy37;
yy553:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'G') goto yy701;
		if (yych <= 'M') goto yy37;
		goto yy702;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto yy37;
			goto yy701;
		} else {
			if (yych == 'n') goto yy702;
			goto yy37;
		}
	}
yy554:
	yych = *++cur;
	if (yych == 'C') goto yy703;
	if (yych == 'c') goto yy703;
	goto yy37;
yy555:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 305 "parser/tokenizer.re"
	{ KW(CYCLE) }
#line 5059 "parser/tokenizer.cpp"
yy556:
	yych = *++cur;
	if (yych == 'O') goto yy704;
	if (yych == 'o') goto yy704;
	goto yy37;
yy557:
	yych = *++cur;
	if (yych == 'L') goto yy705;
	if (yych == 'l') goto yy705;
	goto yy37;
yy558:
	yych = *++cur;
	if (yych == 'R') goto yy706;
	if (yych == 'r') goto yy706;
	goto yy37;
yy559:
	yych = *++cur;
	if (yych == 'S') goto yy707;
	if (yych == 's') goto yy707;
	goto yy37;
yy560:
	yych = *++cur;
	if (yych == 'E') goto yy708;
	if (yych == 'e') goto yy708;
	goto yy37;
yy561:
	yych = *++cur;
	if (yych == 'L') goto yy710;
	if (yych == 'l') goto yy710;
	goto yy37;
yy562:
	yych = *++cur;
	if (yych == 'N') goto yy711;
	if (yych == 'n') goto yy711;
	goto yy37;
yy563:
	yych = *++cur;
	if (yych == 'F') goto yy712;
	if (yych == 'f') goto yy712;
	goto yy37;
yy564:
	yych = *++cur;
	if (yych == 'H') goto yy713;
	if (yych == 'h') goto yy713;
	goto yy37;
yy565:
	yych = *++cur;
	if (yych == 'S') goto yy714;
	if (yych == 's') goto yy714;
	goto yy61;
yy566:
	yych = *++cur;
	if (yych == 'L') goto yy715;
	if (yych == 'l') goto yy715;
	goto yy61;
yy567:
	yych = *++cur;
	if (yych == 'R') goto yy716;
	if (yych == 'r') goto yy716;
	goto yy61;
yy568:
	yych = *++cur;
	if (yych == 'O') goto yy717;
	if (yych == 'o') goto yy717;
	goto yy61;
yy569:
	yych = *++cur;
	if (yych == 'N') goto yy718;
	if (yych == 'n') goto yy718;
	goto yy61;
yy570:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'O') goto yy719;
		if (yych <= 'T') goto yy61;
		goto yy720;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy61;
			goto yy719;
		} else {
			if (yych == 'u') goto yy720;
			goto yy61;
		}
	}
yy571:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy721;
		if (yych <= 'M') goto yy61;
		goto yy722;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy61;
			goto yy721;
		} else {
			if (yych == 'n') goto yy722;
			goto yy61;
		}
	}
yy572:
	yych = *++cur;
	if (yych == 'O') goto yy723;
	if (yych == 'o') goto yy723;
	goto yy61;
yy573:
	yych = *++cur;
	if (yych == 'R') goto yy724;
	if (yych == 'r') goto yy724;
	goto yy61;
yy574:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy725;
		if (yych <= 'T') goto yy61;
		goto yy726;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy725;
		} else {
			if (yych == 'u') goto yy726;
			goto yy61;
		}
	}
yy575:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy727;
		if (yych <= 'X') goto yy61;
		goto yy728;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy727;
		} else {
			if (yych == 'y') goto yy728;
			goto yy61;
		}
	}
yy576:
	yych = *++cur;
	if (yych == 'H') goto yy729;
	if (yych == 'h') goto yy729;
	goto yy61;
yy577:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy730;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy719;
			if (yych <= 'T') goto yy61;
			goto yy720;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy730;
			goto yy61;
		} else {
			if (yych <= 'o') goto yy719;
			if (yych == 'u') goto yy720;
			goto yy61;
		}
	}
yy578:
	yych = *++cur;
	if (yych == 'S') goto yy731;
	if (yych == 's') goto yy731;
	goto yy37;
yy579:
	yych = *++cur;
	if (yych == 'O') goto yy732;
	if (yych == 'o') goto yy732;
	goto yy37;
yy580:
	yych = *++cur;
	if (yych == 'I') goto yy733;
	if (yych == 'i') goto yy733;
	goto yy37;
yy581:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 390 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(ENDDO)
                }
            }
#line 5255 "parser/tokenizer.cpp"
yy582:
	yych = *++cur;
	if (yych == 'U') goto yy734;
	if (yych == 'u') goto yy734;
	goto yy37;
yy583:
	yych = *++cur;
	if (yych == 'L') goto yy735;
	if (yych == 'l') goto yy735;
	goto yy37;
yy584:
	yych = *++cur;
	if (yych == 'R') goto yy736;
	if (yych == 'r') goto yy736;
	goto yy37;
yy585:
	yych = *++cur;
	if (yych == 'N') goto yy737;
	if (yych == 'n') goto yy737;
	goto yy37;
yy586:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 375 "parser/tokenizer.re"
	{ KW(ENDIF) }
#line 5284 "parser/tokenizer.cpp"
yy587:
	yych = *++cur;
	if (yych == 'T') goto yy738;
	if (yych == 't') goto yy738;
	goto yy37;
yy588:
	yych = *++cur;
	if (yych == 'D') goto yy739;
	if (yych == 'd') goto yy739;
	goto yy37;
yy589:
	yych = *++cur;
	if (yych == 'O') goto yy740;
	if (yych == 'o') goto yy740;
	goto yy37;
yy590:
	yych = *++cur;
	if (yych == 'L') goto yy741;
	if (yych == 'l') goto yy741;
	goto yy37;
yy591:
	yych = *++cur;
	if (yych == 'B') goto yy742;
	if (yych == 'b') goto yy742;
	goto yy37;
yy592:
	yych = *++cur;
	if (yych == 'A') goto yy743;
	if (yych == 'a') goto yy743;
	goto yy37;
yy593:
	yych = *++cur;
	if (yych == 'P') goto yy744;
	if (yych == 'p') goto yy744;
	goto yy37;
yy594:
	yych = *++cur;
	if (yych == 'E') goto yy745;
	if (yych == 'e') goto yy745;
	goto yy37;
yy595:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 404 "parser/tokenizer.re"
	{ KW(ENTRY) }
#line 5333 "parser/tokenizer.cpp"
yy596:
	yych = *++cur;
	if (yych == 'R') goto yy746;
	if (yych == 'r') goto yy746;
	goto yy37;
yy597:
	yych = *++cur;
	if (yych == 'A') goto yy747;
	if (yych == 'a') goto yy747;
	goto yy37;
yy598:
	yych = *++cur;
	if (yych == 'G') goto yy748;
	if (yych == 'g') goto yy748;
	goto yy37;
yy599:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 409 "parser/tokenizer.re"
	{ KW(ERROR) }
#line 5357 "parser/tokenizer.cpp"
yy600:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 410 "parser/tokenizer.re"
	{ KW(EVENT) }
#line 5366 "parser/tokenizer.cpp"
yy601:
	yych = *++cur;
	if (yych == 'D') goto yy749;
	if (yych == 'd') goto yy749;
	goto yy37;
yy602:
	yych = *++cur;
	if (yych == 'N') goto yy750;
	if (yych == 'n') goto yy750;
	goto yy37;
yy603:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 415 "parser/tokenizer.re"
	{ KW(FINAL) }
#line 5385 "parser/tokenizer.cpp"
yy604:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 416 "parser/tokenizer.re"
	{ KW(FLUSH) }
#line 5394 "parser/tokenizer.cpp"
yy605:
	yych = *++cur;
	if (yych == 'L') goto yy751;
	if (yych == 'l') goto yy751;
	goto yy37;
yy606:
	yych = *++cur;
	if (yych == 'T') goto yy752;
	if (yych == 't') goto yy752;
	goto yy37;
yy607:
	yych = *++cur;
	if (yych == 'E') goto yy754;
	if (yych == 'e') goto yy754;
	goto yy37;
yy608:
	yych = *++cur;
	if (yych == 'I') goto yy755;
	if (yych == 'i') goto yy755;
	goto yy37;
yy609:
	yych = *++cur;
	if (yych == 'I') goto yy756;
	if (yych == 'i') goto yy756;
	goto yy37;
yy610:
	yych = *++cur;
	if (yych == 'S') goto yy757;
	if (yych == 's') goto yy757;
	goto yy37;
yy611:
	yych = *++cur;
	if (yych == 'C') goto yy758;
	if (yych == 'c') goto yy758;
	goto yy37;
yy612:
	yych = *++cur;
	if (yych == 'T') goto yy759;
	if (yych == 't') goto yy759;
	goto yy37;
yy613:
	yych = *++cur;
	if (yych == 'E') goto yy760;
	if (yych == 'e') goto yy760;
	goto yy37;
yy614:
	yych = *++cur;
	if (yych == 'T') goto yy761;
	if (yych == 't') goto yy761;
	goto yy61;
yy615:
	yych = *++cur;
	if (yych == 'D') goto yy762;
	if (yych == 'd') goto yy762;
	goto yy37;
yy616:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 444 "parser/tokenizer.re"
	{ KW(INOUT) }
#line 5458 "parser/tokenizer.cpp"
yy617:
	yych = *++cur;
	if (yych == 'R') goto yy763;
	if (yych == 'r') goto yy763;
	goto yy37;
yy618:
	yych = *++cur;
	if (yych == 'N') goto yy764;
	if (yych == 'n') goto yy764;
	goto yy37;
yy619:
	yych = *++cur;
	if (yych == 'E') goto yy765;
	if (yych == 'e') goto yy765;
	goto yy37;
yy620:
	yych = *++cur;
	if (yych == 'T') goto yy766;
	if (yych == 't') goto yy766;
	goto yy37;
yy621:
	yych = *++cur;
	if (yych == 'F') goto yy767;
	if (yych == 'f') goto yy767;
	goto yy37;
yy622:
	yych = *++cur;
	if (yych == 'N') goto yy768;
	if (yych == 'n') goto yy768;
	goto yy37;
yy623:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy769;
#line 455 "parser/tokenizer.re"
	{ KW(LOCAL) }
#line 5497 "parser/tokenizer.cpp"
yy624:
	yych = *++cur;
	if (yych == 'A') goto yy770;
	if (yych == 'a') goto yy770;
	goto yy37;
yy625:
	yych = *++cur;
	if (yych == 'Y') goto yy771;
	if (yych == 'y') goto yy771;
	goto yy37;
yy626:
	yych = *++cur;
	if (yych == 'E') goto yy772;
	if (yych == 'e') goto yy772;
	goto yy37;
yy627:
	yych = *++cur;
	if (yych == 'I') goto yy773;
	if (yych == 'i') goto yy773;
	goto yy37;
yy628:
	yych = *++cur;
	if (yych == 'N') goto yy774;
	if (yych == 'n') goto yy774;
	goto yy37;
yy629:
	yych = *++cur;
	if (yych == 'N') goto yy775;
	if (yych == 'n') goto yy775;
	goto yy37;
yy630:
	yych = *++cur;
	if (yych == 'V') goto yy776;
	if (yych == 'v') goto yy776;
	goto yy37;
yy631:
	yych = *++cur;
	if (yych == 'E') goto yy777;
	if (yych == 'e') goto yy777;
	goto yy37;
yy632:
	yych = *++cur;
	if (yych == 'S') goto yy778;
	if (yych == 's') goto yy778;
	goto yy37;
yy633:
	yych = *++cur;
	if (yych == 'F') goto yy779;
	if (yych == 'f') goto yy779;
	goto yy37;
yy634:
	yych = *++cur;
	if (yych == 'T') goto yy780;
	if (yych == 't') goto yy780;
	goto yy37;
yy635:
	yych = *++cur;
	if (yych == 'N') goto yy781;
	if (yych == 'n') goto yy781;
	goto yy37;
yy636:
	yych = *++cur;
	if (yych == 'E') goto yy782;
	if (yych == 'e') goto yy782;
	goto yy37;
yy637:
	yych = *++cur;
	if (yych == 'E') goto yy783;
	if (yych == 'e') goto yy783;
	goto yy37;
yy638:
	yych = *++cur;
	if (yych == 'S') goto yy784;
	if (yych == 's') goto yy784;
	goto yy37;
yy639:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 480 "parser/tokenizer.re"
	{ KW(PRINT) }
#line 5581 "parser/tokenizer.cpp"
yy640:
	yych = *++cur;
	if (yych == 'T') goto yy785;
	if (yych == 't') goto yy785;
	goto yy37;
yy641:
	yych = *++cur;
	if (yych == 'D') goto yy786;
	if (yych == 'd') goto yy786;
	goto yy37;
yy642:
	yych = *++cur;
	if (yych == 'A') goto yy787;
	if (yych == 'a') goto yy787;
	goto yy37;
yy643:
	yych = *++cur;
	if (yych == 'C') goto yy788;
	if (yych == 'c') goto yy788;
	goto yy37;
yy644:
	yych = *++cur;
	if (yych == 'C') goto yy789;
	if (yych == 'c') goto yy789;
	goto yy37;
yy645:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 487 "parser/tokenizer.re"
	{ KW(QUIET) }
#line 5615 "parser/tokenizer.cpp"
yy646:
	yych = *++cur;
	if (yych == 'S') goto yy790;
	if (yych == 's') goto yy790;
	goto yy37;
yy647:
	yych = *++cur;
	if (yych == 'E') goto yy791;
	if (yych == 'e') goto yy791;
	goto yy37;
yy648:
	yych = *++cur;
	if (yych == 'R') goto yy792;
	if (yych == 'r') goto yy792;
	goto yy37;
yy649:
	yych = *++cur;
	if (yych == 'T') goto yy793;
	if (yych == 't') goto yy793;
	goto yy37;
yy650:
	yych = *++cur;
	if (yych == 'N') goto yy794;
	if (yych == 'n') goto yy794;
	goto yy37;
yy651:
	yych = *++cur;
	if (yych == 'D') goto yy795;
	if (yych == 'd') goto yy795;
	goto yy37;
yy652:
	yych = *++cur;
	if (yych == 'T') goto yy796;
	if (yych == 't') goto yy796;
	goto yy37;
yy653:
	yych = *++cur;
	if (yych == 'N') goto yy798;
	if (yych == 'n') goto yy798;
	goto yy37;
yy654:
	yych = *++cur;
	if (yych == 'D') goto yy799;
	if (yych == 'd') goto yy799;
	goto yy37;
yy655:
	yych = *++cur;
	if (yych == 'E') goto yy800;
	if (yych == 'e') goto yy800;
	goto yy37;
yy656:
	yych = *++cur;
	if (yych == 'D') goto yy801;
	if (yych == 'd') goto yy801;
	goto yy37;
yy657:
	yych = *++cur;
	if (yych == 'U') goto yy802;
	if (yych == 'u') goto yy802;
	goto yy37;
yy658:
	yych = *++cur;
	if (yych == 'L') goto yy803;
	if (yych == 'l') goto yy803;
	goto yy37;
yy659:
	yych = *++cur;
	if (yych == 'M') goto yy804;
	if (yych == 'm') goto yy804;
	goto yy37;
yy660:
	yych = *++cur;
	if (yych == 'E') goto yy805;
	if (yych == 'e') goto yy805;
	goto yy37;
yy661:
	yych = *++cur;
	if (yych == 'E') goto yy806;
	if (yych == 'e') goto yy806;
	goto yy37;
yy662:
	yych = *++cur;
	if (yych == 'T') goto yy807;
	if (yych == 't') goto yy807;
	goto yy37;
yy663:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy65;
		if (yych <= '&') goto yy37;
		goto yy82;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy37;
			goto yy808;
		} else {
			if (yych == 'n') goto yy808;
			goto yy37;
		}
	}
yy664:
	yych = *++cur;
	if (yych == 'A') goto yy809;
	if (yych == 'a') goto yy809;
	goto yy37;
yy665:
	yych = *++cur;
	if (yych == 'M') goto yy810;
	if (yych == 'm') goto yy810;
	goto yy37;
yy666:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 524 "parser/tokenizer.re"
	{ KW(VALUE) }
#line 5735 "parser/tokenizer.cpp"
yy667:
	yych = *++cur;
	if (yych == 'I') goto yy811;
	if (yych == 'i') goto yy811;
	goto yy37;
yy668:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 527 "parser/tokenizer.re"
	{ KW(WHERE) }
#line 5749 "parser/tokenizer.cpp"
yy669:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 528 "parser/tokenizer.re"
	{ KW(WHILE) }
#line 5758 "parser/tokenizer.cpp"
yy670:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 529 "parser/tokenizer.re"
	{ KW(WRITE) }
#line 5767 "parser/tokenizer.cpp"
yy671:
	yych = *++cur;
yy672:
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy674;
	goto yy671;
yy673:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy61;
			if (yych <= 0x08) goto yy671;
			goto yy673;
		} else {
			if (yych <= '\n') goto yy674;
			if (yych == '\f') goto yy671;
			goto yy673;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy673;
			goto yy671;
		} else {
			if (yych <= 'E') goto yy812;
			if (yych == 'e') goto yy812;
			goto yy671;
		}
	}
yy674:
	++cur;
	cur -= 1;
#line 677 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_OMP) }
#line 5801 "parser/tokenizer.cpp"
yy675:
	yych = *++cur;
	if (yych == 'e') goto yy813;
	goto yy69;
yy676:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy814;
	goto yy676;
yy677:
	++cur;
#line 708 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#else ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 5821 "parser/tokenizer.cpp"
yy678:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy61;
			goto yy68;
		} else {
			if (yych == '\n') goto yy815;
			goto yy678;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy678;
		} else {
			if (yych == ' ') goto yy678;
			goto yy68;
		}
	}
yy679:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy816;
		if (yych <= '\n') goto yy69;
		goto yy816;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy816;
		} else {
			if (yych == ' ') goto yy816;
			goto yy69;
		}
	}
yy680:
	yych = *++cur;
	if (yych == 'd') goto yy817;
	goto yy69;
yy681:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy818;
	goto yy681;
yy682:
	yych = *++cur;
	if (yych == '.') goto yy819;
	goto yy93;
yy683:
	++cur;
#line 605 "parser/tokenizer.re"
	{ RET(TK_NEQV) }
#line 5873 "parser/tokenizer.cpp"
yy684:
	yyaccept = 11;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy821;
yy685:
#line 609 "parser/tokenizer.re"
	{ RET(TK_TRUE) }
#line 5881 "parser/tokenizer.cpp"
yy686:
	yych = *++cur;
	if (yych == 'C') goto yy822;
	if (yych == 'c') goto yy822;
	goto yy37;
yy687:
	yych = *++cur;
	if (yych == 'T') goto yy823;
	if (yych == 't') goto yy823;
	goto yy37;
yy688:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy689;
			if (yych <= 'L') goto yy36;
			goto yy824;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy824;
			if (yych <= 'z') goto yy36;
		}
	}
yy689:
#line 283 "parser/tokenizer.re"
	{ KW(ASSIGN) }
#line 5917 "parser/tokenizer.cpp"
yy690:
	yych = *++cur;
	if (yych == 'A') goto yy825;
	if (yych == 'a') goto yy825;
	goto yy37;
yy691:
	yych = *++cur;
	if (yych == 'R') goto yy826;
	if (yych == 'r') goto yy826;
	goto yy37;
yy692:
	yych = *++cur;
	if (yych == 'A') goto yy827;
	if (yych == 'a') goto yy827;
	goto yy37;
yy693:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy694;
			if (yych <= 'S') goto yy36;
			goto yy828;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy828;
			if (yych <= 'z') goto yy36;
		}
	}
yy694:
#line 292 "parser/tokenizer.re"
	{ KW(CHANGE) }
#line 5958 "parser/tokenizer.cpp"
yy695:
	yych = *++cur;
	if (yych == 'T') goto yy829;
	if (yych == 't') goto yy829;
	goto yy37;
yy696:
	yych = *++cur;
	if (yych == 'N') goto yy830;
	if (yych == 'n') goto yy830;
	goto yy37;
yy697:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 298 "parser/tokenizer.re"
	{ KW(COMMON) }
#line 5977 "parser/tokenizer.cpp"
yy698:
	yych = *++cur;
	if (yych == 'X') goto yy831;
	if (yych == 'x') goto yy831;
	goto yy37;
yy699:
	yych = *++cur;
	if (yych == 'R') goto yy832;
	if (yych == 'r') goto yy832;
	goto yy37;
yy700:
	yych = *++cur;
	if (yych == 'N') goto yy833;
	if (yych == 'n') goto yy833;
	goto yy37;
yy701:
	yych = *++cur;
	if (yych == 'U') goto yy834;
	if (yych == 'u') goto yy834;
	goto yy37;
yy702:
	yych = *++cur;
	if (yych == 'U') goto yy835;
	if (yych == 'u') goto yy835;
	goto yy37;
yy703:
	yych = *++cur;
	if (yych == 'A') goto yy836;
	if (yych == 'a') goto yy836;
	goto yy37;
yy704:
	yych = *++cur;
	if (yych == 'C') goto yy837;
	if (yych == 'c') goto yy837;
	goto yy37;
yy705:
	yych = *++cur;
	if (yych == 'T') goto yy838;
	if (yych == 't') goto yy838;
	goto yy37;
yy706:
	yych = *++cur;
	if (yych == 'E') goto yy839;
	if (yych == 'e') goto yy839;
	goto yy37;
yy707:
	yych = *++cur;
	if (yych == 'I') goto yy840;
	if (yych == 'i') goto yy840;
	goto yy37;
yy708:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'P') {
		if (yych <= '@') {
			if (yych <= '/') goto yy709;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'C') goto yy841;
			if (yych <= 'O') goto yy36;
			goto yy842;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy709;
			if (yych <= 'b') goto yy36;
			goto yy841;
		} else {
			if (yych == 'p') goto yy842;
			if (yych <= 'z') goto yy36;
		}
	}
yy709:
#line 320 "parser/tokenizer.re"
	{ KW(DOUBLE) }
#line 6056 "parser/tokenizer.cpp"
yy710:
	yych = *++cur;
	if (yych == 'E') goto yy843;
	if (yych == 'e') goto yy843;
	goto yy37;
yy711:
	yych = *++cur;
	if (yych == 'T') goto yy844;
	if (yych == 't') goto yy844;
	goto yy37;
yy712:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 325 "parser/tokenizer.re"
	{ KW(ELSEIF) }
#line 6075 "parser/tokenizer.cpp"
yy713:
	yych = *++cur;
	if (yych == 'E') goto yy845;
	if (yych == 'e') goto yy845;
	goto yy37;
yy714:
	yych = *++cur;
	if (yych == 'S') goto yy846;
	if (yych == 's') goto yy846;
	goto yy61;
yy715:
	yych = *++cur;
	if (yych == 'O') goto yy847;
	if (yych == 'o') goto yy847;
	goto yy61;
yy716:
	yych = *++cur;
	if (yych == 'I') goto yy848;
	if (yych == 'i') goto yy848;
	goto yy61;
yy717:
	++cur;
#line 383 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(END_DO)
                }
            }
#line 6106 "parser/tokenizer.cpp"
yy718:
	yych = *++cur;
	if (yych == 'U') goto yy849;
	if (yych == 'u') goto yy849;
	goto yy61;
yy719:
	yych = *++cur;
	if (yych == 'R') goto yy850;
	if (yych == 'r') goto yy850;
	goto yy61;
yy720:
	yych = *++cur;
	if (yych == 'N') goto yy851;
	if (yych == 'n') goto yy851;
	goto yy61;
yy721:
	++cur;
#line 374 "parser/tokenizer.re"
	{ KW(END_IF) }
#line 6126 "parser/tokenizer.cpp"
yy722:
	yych = *++cur;
	if (yych == 'T') goto yy852;
	if (yych == 't') goto yy852;
	goto yy61;
yy723:
	yych = *++cur;
	if (yych == 'D') goto yy853;
	if (yych == 'd') goto yy853;
	goto yy61;
yy724:
	yych = *++cur;
	if (yych == 'O') goto yy854;
	if (yych == 'o') goto yy854;
	goto yy61;
yy725:
	yych = *++cur;
	if (yych == 'L') goto yy855;
	if (yych == 'l') goto yy855;
	goto yy61;
yy726:
	yych = *++cur;
	if (yych == 'B') goto yy856;
	if (yych == 'b') goto yy856;
	goto yy61;
yy727:
	yych = *++cur;
	if (yych == 'A') goto yy857;
	if (yych == 'a') goto yy857;
	goto yy61;
yy728:
	yych = *++cur;
	if (yych == 'P') goto yy858;
	if (yych == 'p') goto yy858;
	goto yy61;
yy729:
	yych = *++cur;
	if (yych == 'E') goto yy859;
	if (yych == 'e') goto yy859;
	goto yy61;
yy730:
	yych = *++cur;
	if (yych == 'L') goto yy860;
	if (yych == 'l') goto yy860;
	goto yy61;
yy731:
	yych = *++cur;
	if (yych == 'O') goto yy861;
	if (yych == 'o') goto yy861;
	goto yy37;
yy732:
	yych = *++cur;
	if (yych == 'C') goto yy862;
	if (yych == 'c') goto yy862;
	goto yy37;
yy733:
	yych = *++cur;
	if (yych == 'T') goto yy863;
	if (yych == 't') goto yy863;
	goto yy37;
yy734:
	yych = *++cur;
	if (yych == 'M') goto yy864;
	if (yych == 'm') goto yy864;
	goto yy37;
yy735:
	yych = *++cur;
	if (yych == 'E') goto yy865;
	if (yych == 'e') goto yy865;
	goto yy37;
yy736:
	yych = *++cur;
	if (yych == 'A') goto yy866;
	if (yych == 'a') goto yy866;
	goto yy37;
yy737:
	yych = *++cur;
	if (yych == 'C') goto yy867;
	if (yych == 'c') goto yy867;
	goto yy37;
yy738:
	yych = *++cur;
	if (yych == 'E') goto yy868;
	if (yych == 'e') goto yy868;
	goto yy37;
yy739:
	yych = *++cur;
	if (yych == 'U') goto yy869;
	if (yych == 'u') goto yy869;
	goto yy37;
yy740:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy870;
		if (yych <= 'F') goto yy37;
		goto yy871;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy870;
		} else {
			if (yych == 'g') goto yy871;
			goto yy37;
		}
	}
yy741:
	yych = *++cur;
	if (yych == 'E') goto yy872;
	if (yych == 'e') goto yy872;
	goto yy37;
yy742:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy873;
		if (yych <= 'Q') goto yy37;
		goto yy874;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy873;
		} else {
			if (yych == 'r') goto yy874;
			goto yy37;
		}
	}
yy743:
	yych = *++cur;
	if (yych == 'M') goto yy875;
	if (yych == 'm') goto yy875;
	goto yy37;
yy744:
	yych = *++cur;
	if (yych == 'E') goto yy876;
	if (yych == 'e') goto yy876;
	goto yy37;
yy745:
	yych = *++cur;
	if (yych == 'R') goto yy877;
	if (yych == 'r') goto yy877;
	goto yy37;
yy746:
	yych = *++cur;
	if (yych == 'A') goto yy878;
	if (yych == 'a') goto yy878;
	goto yy37;
yy747:
	yych = *++cur;
	if (yych == 'L') goto yy879;
	if (yych == 'l') goto yy879;
	goto yy37;
yy748:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 408 "parser/tokenizer.re"
	{ KW(ERRMSG) }
#line 6285 "parser/tokenizer.cpp"
yy749:
	yych = *++cur;
	if (yych == 'S') goto yy880;
	if (yych == 's') goto yy880;
	goto yy37;
yy750:
	yych = *++cur;
	if (yych == 'A') goto yy881;
	if (yych == 'a') goto yy881;
	goto yy37;
yy751:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 417 "parser/tokenizer.re"
	{ KW(FORALL) }
#line 6304 "parser/tokenizer.cpp"
yy752:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy753;
			if (yych <= 'S') goto yy36;
			goto yy882;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy882;
			if (yych <= 'z') goto yy36;
		}
	}
yy753:
#line 418 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_LABEL) {
                    unsigned char *start;
                    lex_format(cur, loc, start, diagnostics, continue_compilation);
                    yylval.string.p = (char*) start;
                    yylval.string.n = cur-start-1;
                    RET(TK_FORMAT)
                } else {
                    token(yylval.string);
                    RET(TK_NAME)
                }
            }
#line 6341 "parser/tokenizer.cpp"
yy754:
	yych = *++cur;
	if (yych == 'A') goto yy883;
	if (yych == 'a') goto yy883;
	goto yy37;
yy755:
	yych = *++cur;
	if (yych == 'O') goto yy884;
	if (yych == 'o') goto yy884;
	goto yy37;
yy756:
	yych = *++cur;
	if (yych == 'C') goto yy885;
	if (yych == 'c') goto yy885;
	goto yy37;
yy757:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 438 "parser/tokenizer.re"
	{ KW(IMAGES) }
#line 6365 "parser/tokenizer.cpp"
yy758:
	yych = *++cur;
	if (yych == 'I') goto yy886;
	if (yych == 'i') goto yy886;
	goto yy37;
yy759:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 440 "parser/tokenizer.re"
	{ KW(IMPORT) }
#line 6379 "parser/tokenizer.cpp"
yy760:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 441 "parser/tokenizer.re"
	{ KW(IMPURE) }
#line 6388 "parser/tokenizer.cpp"
yy761:
	++cur;
#line 445 "parser/tokenizer.re"
	{ KW(IN_OUT) }
#line 6393 "parser/tokenizer.cpp"
yy762:
	yych = *++cur;
	if (yych == 'E') goto yy887;
	if (yych == 'e') goto yy887;
	goto yy37;
yy763:
	yych = *++cur;
	if (yych == 'E') goto yy888;
	if (yych == 'e') goto yy888;
	goto yy37;
yy764:
	yych = *++cur;
	if (yych == 'T') goto yy889;
	if (yych == 't') goto yy889;
	goto yy37;
yy765:
	yych = *++cur;
	if (yych == 'R') goto yy890;
	if (yych == 'r') goto yy890;
	goto yy37;
yy766:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 449 "parser/tokenizer.re"
	{ KW(INTENT) }
#line 6422 "parser/tokenizer.cpp"
yy767:
	yych = *++cur;
	if (yych == 'A') goto yy891;
	if (yych == 'a') goto yy891;
	goto yy37;
yy768:
	yych = *++cur;
	if (yych == 'S') goto yy892;
	if (yych == 's') goto yy892;
	goto yy37;
yy769:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy65;
		if (yych <= '&') goto yy37;
		goto yy82;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy893;
		} else {
			if (yych == 'i') goto yy893;
			goto yy37;
		}
	}
yy770:
	yych = *++cur;
	if (yych == 'L') goto yy894;
	if (yych == 'l') goto yy894;
	goto yy37;
yy771:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 458 "parser/tokenizer.re"
	{ KW(MEMORY) }
#line 6462 "parser/tokenizer.cpp"
yy772:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 459 "parser/tokenizer.re"
	{ KW(MODULE) }
#line 6471 "parser/tokenizer.cpp"
yy773:
	yych = *++cur;
	if (yych == 'S') goto yy895;
	if (yych == 's') goto yy895;
	goto yy37;
yy774:
	yych = *++cur;
	if (yych == 'D') goto yy896;
	if (yych == 'd') goto yy896;
	goto yy37;
yy775:
	yych = *++cur;
	if (yych == 'T') goto yy897;
	if (yych == 't') goto yy897;
	goto yy37;
yy776:
	yych = *++cur;
	if (yych == 'E') goto yy898;
	if (yych == 'e') goto yy898;
	goto yy37;
yy777:
	yych = *++cur;
	if (yych == 'C') goto yy899;
	if (yych == 'c') goto yy899;
	goto yy37;
yy778:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 464 "parser/tokenizer.re"
	{ KW(NOPASS) }
#line 6505 "parser/tokenizer.cpp"
yy779:
	yych = *++cur;
	if (yych == 'Y') goto yy900;
	if (yych == 'y') goto yy900;
	goto yy37;
yy780:
	yych = *++cur;
	if (yych == 'O') goto yy901;
	if (yych == 'o') goto yy901;
	goto yy37;
yy781:
	yych = *++cur;
	if (yych == 'A') goto yy902;
	if (yych == 'a') goto yy902;
	goto yy37;
yy782:
	yych = *++cur;
	if (yych == 'T') goto yy903;
	if (yych == 't') goto yy903;
	goto yy37;
yy783:
	yych = *++cur;
	if (yych == 'R') goto yy904;
	if (yych == 'r') goto yy904;
	goto yy37;
yy784:
	yych = *++cur;
	if (yych == 'I') goto yy905;
	if (yych == 'i') goto yy905;
	goto yy37;
yy785:
	yych = *++cur;
	if (yych == 'E') goto yy906;
	if (yych == 'e') goto yy906;
	goto yy37;
yy786:
	yych = *++cur;
	if (yych == 'U') goto yy907;
	if (yych == 'u') goto yy907;
	goto yy37;
yy787:
	yych = *++cur;
	if (yych == 'M') goto yy908;
	if (yych == 'm') goto yy908;
	goto yy37;
yy788:
	yych = *++cur;
	if (yych == 'T') goto yy909;
	if (yych == 't') goto yy909;
	goto yy37;
yy789:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 485 "parser/tokenizer.re"
	{ KW(PUBLIC) }
#line 6564 "parser/tokenizer.cpp"
yy790:
	yych = *++cur;
	if (yych == 'I') goto yy910;
	if (yych == 'i') goto yy910;
	goto yy37;
yy791:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 492 "parser/tokenizer.re"
	{ KW(REDUCE) }
#line 6578 "parser/tokenizer.cpp"
yy792:
	yych = *++cur;
	if (yych == 'E') goto yy911;
	if (yych == 'e') goto yy911;
	goto yy37;
yy793:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 495 "parser/tokenizer.re"
	{ KW(RESULT) }
#line 6592 "parser/tokenizer.cpp"
yy794:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 496 "parser/tokenizer.re"
	{ KW(RETURN) }
#line 6601 "parser/tokenizer.cpp"
yy795:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 497 "parser/tokenizer.re"
	{ KW(REWIND) }
#line 6610 "parser/tokenizer.cpp"
yy796:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= 'B') {
			if (yych <= '/') goto yy797;
			if (yych <= '9') goto yy36;
			if (yych >= 'A') goto yy36;
		} else {
			if (yych <= 'Q') {
				if (yych <= 'C') goto yy913;
				goto yy36;
			} else {
				if (yych <= 'R') goto yy914;
				if (yych <= 'S') goto yy36;
				goto yy915;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych == 'c') goto yy913;
				goto yy36;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'r') goto yy914;
				goto yy36;
			} else {
				if (yych <= 't') goto yy915;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy797:
#line 499 "parser/tokenizer.re"
	{ KW(SELECT) }
#line 6652 "parser/tokenizer.cpp"
yy798:
	yych = *++cur;
	if (yych == 'C') goto yy916;
	if (yych == 'c') goto yy916;
	goto yy37;
yy799:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 504 "parser/tokenizer.re"
	{ KW(SHARED) }
#line 6666 "parser/tokenizer.cpp"
yy800:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 505 "parser/tokenizer.re"
	{ KW(SOURCE) }
#line 6675 "parser/tokenizer.cpp"
yy801:
	yych = *++cur;
	if (yych == 'U') goto yy917;
	if (yych == 'u') goto yy917;
	goto yy37;
yy802:
	yych = *++cur;
	if (yych == 'T') goto yy918;
	if (yych == 't') goto yy918;
	goto yy37;
yy803:
	yych = *++cur;
	if (yych == 'L') goto yy919;
	if (yych == 'l') goto yy919;
	goto yy37;
yy804:
	yych = *++cur;
	if (yych == 'A') goto yy920;
	if (yych == 'a') goto yy920;
	goto yy37;
yy805:
	yych = *++cur;
	if (yych == 'M') goto yy921;
	if (yych == 'm') goto yy921;
	goto yy37;
yy806:
	yych = *++cur;
	if (yych == 'A') goto yy922;
	if (yych == 'a') goto yy922;
	goto yy37;
yy807:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 515 "parser/tokenizer.re"
	{ KW(TARGET) }
#line 6714 "parser/tokenizer.cpp"
yy808:
	yych = *++cur;
	if (yych == 'U') goto yy923;
	if (yych == 'u') goto yy923;
	goto yy37;
yy809:
	yych = *++cur;
	if (yych == 'T') goto yy924;
	if (yych == 't') goto yy924;
	goto yy37;
yy810:
	yych = *++cur;
	if (yych == 'A') goto yy925;
	if (yych == 'a') goto yy925;
	goto yy37;
yy811:
	yych = *++cur;
	if (yych == 'L') goto yy926;
	if (yych == 'l') goto yy926;
	goto yy37;
yy812:
	yych = *++cur;
	if (yych == 'N') goto yy927;
	if (yych == 'n') goto yy927;
	goto yy672;
yy813:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy928;
		if (yych <= '\n') goto yy69;
		goto yy928;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy928;
		} else {
			if (yych == ' ') goto yy928;
			goto yy69;
		}
	}
yy814:
	++cur;
#line 701 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#elif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6765 "parser/tokenizer.cpp"
yy815:
	++cur;
#line 715 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#endif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6776 "parser/tokenizer.cpp"
yy816:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy929;
	goto yy816;
yy817:
	yych = *++cur;
	if (yych == 'e') goto yy930;
	goto yy69;
yy818:
	++cur;
#line 693 "parser/tokenizer.re"
	{ line_num++; cur_line=cur; continue; }
#line 6790 "parser/tokenizer.cpp"
yy819:
	yyaccept = 12;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy931;
yy820:
#line 610 "parser/tokenizer.re"
	{ RET(TK_FALSE) }
#line 6798 "parser/tokenizer.cpp"
yy821:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy932;
		if (yych <= '@') goto yy61;
		goto yy933;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy933;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy933;
			goto yy61;
		}
	}
yy822:
	yych = *++cur;
	if (yych == 'T') goto yy934;
	if (yych == 't') goto yy934;
	goto yy37;
yy823:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy935;
		if (yych <= 'D') goto yy37;
		goto yy936;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy935;
		} else {
			if (yych == 'e') goto yy936;
			goto yy37;
		}
	}
yy824:
	yych = *++cur;
	if (yych == 'E') goto yy937;
	if (yych == 'e') goto yy937;
	goto yy37;
yy825:
	yych = *++cur;
	if (yych == 'T') goto yy938;
	if (yych == 't') goto yy938;
	goto yy37;
yy826:
	yych = *++cur;
	if (yych == 'O') goto yy939;
	if (yych == 'o') goto yy939;
	goto yy37;
yy827:
	yych = *++cur;
	if (yych == 'C') goto yy940;
	if (yych == 'c') goto yy940;
	goto yy37;
yy828:
	yych = *++cur;
	if (yych == 'E') goto yy941;
	if (yych == 'e') goto yy941;
	goto yy37;
yy829:
	yych = *++cur;
	if (yych == 'E') goto yy942;
	if (yych == 'e') goto yy942;
	goto yy37;
yy830:
	yych = *++cur;
	if (yych == 'S') goto yy943;
	if (yych == 's') goto yy943;
	goto yy37;
yy831:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 299 "parser/tokenizer.re"
	{ KW(COMPLEX) }
#line 6879 "parser/tokenizer.cpp"
yy832:
	yych = *++cur;
	if (yych == 'E') goto yy944;
	if (yych == 'e') goto yy944;
	goto yy37;
yy833:
	yych = *++cur;
	if (yych == 'S') goto yy945;
	if (yych == 's') goto yy945;
	goto yy37;
yy834:
	yych = *++cur;
	if (yych == 'O') goto yy946;
	if (yych == 'o') goto yy946;
	goto yy37;
yy835:
	yych = *++cur;
	if (yych == 'E') goto yy947;
	if (yych == 'e') goto yy947;
	goto yy37;
yy836:
	yych = *++cur;
	if (yych == 'L') goto yy948;
	if (yych == 'l') goto yy948;
	goto yy37;
yy837:
	yych = *++cur;
	if (yych == 'A') goto yy949;
	if (yych == 'a') goto yy949;
	goto yy37;
yy838:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 308 "parser/tokenizer.re"
	{ KW(DEFAULT) }
#line 6918 "parser/tokenizer.cpp"
yy839:
	yych = *++cur;
	if (yych == 'D') goto yy950;
	if (yych == 'd') goto yy950;
	goto yy37;
yy840:
	yych = *++cur;
	if (yych == 'O') goto yy951;
	if (yych == 'o') goto yy951;
	goto yy37;
yy841:
	yych = *++cur;
	if (yych == 'O') goto yy952;
	if (yych == 'o') goto yy952;
	goto yy37;
yy842:
	yych = *++cur;
	if (yych == 'R') goto yy953;
	if (yych == 'r') goto yy953;
	goto yy37;
yy843:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 319 "parser/tokenizer.re"
	{ KW(DOWHILE) }
#line 6947 "parser/tokenizer.cpp"
yy844:
	yych = *++cur;
	if (yych == 'A') goto yy954;
	if (yych == 'a') goto yy954;
	goto yy37;
yy845:
	yych = *++cur;
	if (yych == 'R') goto yy955;
	if (yych == 'r') goto yy955;
	goto yy37;
yy846:
	yych = *++cur;
	if (yych == 'O') goto yy956;
	if (yych == 'o') goto yy956;
	goto yy61;
yy847:
	yych = *++cur;
	if (yych == 'C') goto yy957;
	if (yych == 'c') goto yy957;
	goto yy61;
yy848:
	yych = *++cur;
	if (yych == 'T') goto yy958;
	if (yych == 't') goto yy958;
	goto yy61;
yy849:
	yych = *++cur;
	if (yych == 'M') goto yy959;
	if (yych == 'm') goto yy959;
	goto yy61;
yy850:
	yych = *++cur;
	if (yych == 'A') goto yy960;
	if (yych == 'a') goto yy960;
	goto yy61;
yy851:
	yych = *++cur;
	if (yych == 'C') goto yy961;
	if (yych == 'c') goto yy961;
	goto yy61;
yy852:
	yych = *++cur;
	if (yych == 'E') goto yy962;
	if (yych == 'e') goto yy962;
	goto yy61;
yy853:
	yych = *++cur;
	if (yych == 'U') goto yy963;
	if (yych == 'u') goto yy963;
	goto yy61;
yy854:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy964;
		if (yych <= 'F') goto yy61;
		goto yy965;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy61;
			goto yy964;
		} else {
			if (yych == 'g') goto yy965;
			goto yy61;
		}
	}
yy855:
	yych = *++cur;
	if (yych == 'E') goto yy966;
	if (yych == 'e') goto yy966;
	goto yy61;
yy856:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy967;
		if (yych <= 'Q') goto yy61;
		goto yy968;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy61;
			goto yy967;
		} else {
			if (yych == 'r') goto yy968;
			goto yy61;
		}
	}
yy857:
	yych = *++cur;
	if (yych == 'M') goto yy969;
	if (yych == 'm') goto yy969;
	goto yy61;
yy858:
	yych = *++cur;
	if (yych == 'E') goto yy970;
	if (yych == 'e') goto yy970;
	goto yy61;
yy859:
	yych = *++cur;
	if (yych == 'R') goto yy971;
	if (yych == 'r') goto yy971;
	goto yy61;
yy860:
	yych = *++cur;
	if (yych == 'E') goto yy972;
	if (yych == 'e') goto yy972;
	goto yy61;
yy861:
	yych = *++cur;
	if (yych == 'C') goto yy973;
	if (yych == 'c') goto yy973;
	goto yy37;
yy862:
	yych = *++cur;
	if (yych == 'K') goto yy974;
	if (yych == 'k') goto yy974;
	goto yy37;
yy863:
	yych = *++cur;
	if (yych == 'I') goto yy976;
	if (yych == 'i') goto yy976;
	goto yy37;
yy864:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 357 "parser/tokenizer.re"
	{ KW(ENDENUM) }
#line 7076 "parser/tokenizer.cpp"
yy865:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 402 "parser/tokenizer.re"
	{ KW(ENDFILE) }
#line 7085 "parser/tokenizer.cpp"
yy866:
	yych = *++cur;
	if (yych == 'L') goto yy977;
	if (yych == 'l') goto yy977;
	goto yy37;
yy867:
	yych = *++cur;
	if (yych == 'T') goto yy978;
	if (yych == 't') goto yy978;
	goto yy37;
yy868:
	yych = *++cur;
	if (yych == 'R') goto yy979;
	if (yych == 'r') goto yy979;
	goto yy37;
yy869:
	yych = *++cur;
	if (yych == 'L') goto yy980;
	if (yych == 'l') goto yy980;
	goto yy37;
yy870:
	yych = *++cur;
	if (yych == 'E') goto yy981;
	if (yych == 'e') goto yy981;
	goto yy37;
yy871:
	yych = *++cur;
	if (yych == 'R') goto yy982;
	if (yych == 'r') goto yy982;
	goto yy37;
yy872:
	yych = *++cur;
	if (yych == 'C') goto yy983;
	if (yych == 'c') goto yy983;
	goto yy37;
yy873:
	yych = *++cur;
	if (yych == 'O') goto yy984;
	if (yych == 'o') goto yy984;
	goto yy37;
yy874:
	yych = *++cur;
	if (yych == 'O') goto yy985;
	if (yych == 'o') goto yy985;
	goto yy37;
yy875:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 369 "parser/tokenizer.re"
	{ KW(ENDTEAM) }
#line 7139 "parser/tokenizer.cpp"
yy876:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 381 "parser/tokenizer.re"
	{ KW(ENDTYPE) }
#line 7148 "parser/tokenizer.cpp"
yy877:
	yych = *++cur;
	if (yych == 'E') goto yy986;
	if (yych == 'e') goto yy986;
	goto yy37;
yy878:
	yych = *++cur;
	if (yych == 'T') goto yy987;
	if (yych == 't') goto yy987;
	goto yy37;
yy879:
	yych = *++cur;
	if (yych == 'E') goto yy988;
	if (yych == 'e') goto yy988;
	goto yy37;
yy880:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 412 "parser/tokenizer.re"
	{ KW(EXTENDS) }
#line 7172 "parser/tokenizer.cpp"
yy881:
	yych = *++cur;
	if (yych == 'L') goto yy989;
	if (yych == 'l') goto yy989;
	goto yy37;
yy882:
	yych = *++cur;
	if (yych == 'E') goto yy990;
	if (yych == 'e') goto yy990;
	goto yy37;
yy883:
	yych = *++cur;
	if (yych == 'M') goto yy991;
	if (yych == 'm') goto yy991;
	goto yy37;
yy884:
	yych = *++cur;
	if (yych == 'N') goto yy992;
	if (yych == 'n') goto yy992;
	goto yy37;
yy885:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 434 "parser/tokenizer.re"
	{ KW(GENERIC) }
#line 7201 "parser/tokenizer.cpp"
yy886:
	yych = *++cur;
	if (yych == 'T') goto yy993;
	if (yych == 't') goto yy993;
	goto yy37;
yy887:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 443 "parser/tokenizer.re"
	{ KW(INCLUDE) }
#line 7215 "parser/tokenizer.cpp"
yy888:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 446 "parser/tokenizer.re"
	{ KW(INQUIRE) }
#line 7224 "parser/tokenizer.cpp"
yy889:
	yych = *++cur;
	if (yych == 'I') goto yy994;
	if (yych == 'i') goto yy994;
	goto yy37;
yy890:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 448 "parser/tokenizer.re"
	{ KW(INTEGER) }
#line 7238 "parser/tokenizer.cpp"
yy891:
	yych = *++cur;
	if (yych == 'C') goto yy995;
	if (yych == 'c') goto yy995;
	goto yy37;
yy892:
	yych = *++cur;
	if (yych == 'I') goto yy996;
	if (yych == 'i') goto yy996;
	goto yy37;
yy893:
	yych = *++cur;
	if (yych == 'N') goto yy997;
	if (yych == 'n') goto yy997;
	goto yy37;
yy894:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 457 "parser/tokenizer.re"
	{ KW(LOGICAL) }
#line 7262 "parser/tokenizer.cpp"
yy895:
	yych = *++cur;
	if (yych == 'T') goto yy998;
	if (yych == 't') goto yy998;
	goto yy37;
yy896:
	yych = *++cur;
	if (yych == 'E') goto yy999;
	if (yych == 'e') goto yy999;
	goto yy37;
yy897:
	yych = *++cur;
	if (yych == 'R') goto yy1000;
	if (yych == 'r') goto yy1000;
	goto yy37;
yy898:
	yych = *++cur;
	if (yych == 'R') goto yy1001;
	if (yych == 'r') goto yy1001;
	goto yy37;
yy899:
	yych = *++cur;
	if (yych == 'U') goto yy1002;
	if (yych == 'u') goto yy1002;
	goto yy37;
yy900:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 469 "parser/tokenizer.re"
	{ KW(NULLIFY) }
#line 7296 "parser/tokenizer.cpp"
yy901:
	yych = *++cur;
	if (yych == 'R') goto yy1003;
	if (yych == 'r') goto yy1003;
	goto yy37;
yy902:
	yych = *++cur;
	if (yych == 'L') goto yy1004;
	if (yych == 'l') goto yy1004;
	goto yy37;
yy903:
	yych = *++cur;
	if (yych == 'E') goto yy1005;
	if (yych == 'e') goto yy1005;
	goto yy37;
yy904:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 477 "parser/tokenizer.re"
	{ KW(POINTER) }
#line 7320 "parser/tokenizer.cpp"
yy905:
	yych = *++cur;
	if (yych == 'O') goto yy1006;
	if (yych == 'o') goto yy1006;
	goto yy37;
yy906:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 481 "parser/tokenizer.re"
	{ KW(PRIVATE) }
#line 7334 "parser/tokenizer.cpp"
yy907:
	yych = *++cur;
	if (yych == 'R') goto yy1007;
	if (yych == 'r') goto yy1007;
	goto yy37;
yy908:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 483 "parser/tokenizer.re"
	{ KW(PROGRAM) }
#line 7348 "parser/tokenizer.cpp"
yy909:
	yych = *++cur;
	if (yych == 'E') goto yy1008;
	if (yych == 'e') goto yy1008;
	goto yy37;
yy910:
	yych = *++cur;
	if (yych == 'V') goto yy1009;
	if (yych == 'v') goto yy1009;
	goto yy37;
yy911:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy912;
			if (yych <= 'L') goto yy36;
			goto yy1010;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy1010;
			if (yych <= 'z') goto yy36;
		}
	}
yy912:
#line 494 "parser/tokenizer.re"
	{ KW(REQUIRE) }
#line 7384 "parser/tokenizer.cpp"
yy913:
	yych = *++cur;
	if (yych == 'A') goto yy1011;
	if (yych == 'a') goto yy1011;
	goto yy37;
yy914:
	yych = *++cur;
	if (yych == 'A') goto yy1012;
	if (yych == 'a') goto yy1012;
	goto yy37;
yy915:
	yych = *++cur;
	if (yych == 'Y') goto yy1013;
	if (yych == 'y') goto yy1013;
	goto yy37;
yy916:
	yych = *++cur;
	if (yych == 'E') goto yy1014;
	if (yych == 'e') goto yy1014;
	goto yy37;
yy917:
	yych = *++cur;
	if (yych == 'L') goto yy1015;
	if (yych == 'l') goto yy1015;
	goto yy37;
yy918:
	yych = *++cur;
	if (yych == 'I') goto yy1016;
	if (yych == 'i') goto yy1016;
	goto yy37;
yy919:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 511 "parser/tokenizer.re"
	{ KW(SYNC_ALL) }
#line 7423 "parser/tokenizer.cpp"
yy920:
	yych = *++cur;
	if (yych == 'G') goto yy1017;
	if (yych == 'g') goto yy1017;
	goto yy37;
yy921:
	yych = *++cur;
	if (yych == 'O') goto yy1018;
	if (yych == 'o') goto yy1018;
	goto yy37;
yy922:
	yych = *++cur;
	if (yych == 'M') goto yy1019;
	if (yych == 'm') goto yy1019;
	goto yy37;
yy923:
	yych = *++cur;
	if (yych == 'M') goto yy1020;
	if (yych == 'm') goto yy1020;
	goto yy37;
yy924:
	yych = *++cur;
	if (yych == 'E') goto yy1021;
	if (yych == 'e') goto yy1021;
	goto yy37;
yy925:
	yych = *++cur;
	if (yych == 'T') goto yy1022;
	if (yych == 't') goto yy1022;
	goto yy37;
yy926:
	yych = *++cur;
	if (yych == 'E') goto yy1023;
	if (yych == 'e') goto yy1023;
	goto yy37;
yy927:
	yych = *++cur;
	if (yych == 'D') goto yy1024;
	if (yych == 'd') goto yy1024;
	goto yy672;
yy928:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy1025;
	goto yy928;
yy929:
	++cur;
#line 694 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#ifdef ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 7479 "parser/tokenizer.cpp"
yy930:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy1026;
		if (yych <= '\n') goto yy69;
		goto yy1026;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy1026;
		} else {
			if (yych == ' ') goto yy1026;
			goto yy69;
		}
	}
yy931:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy1027;
		if (yych <= '@') goto yy61;
		goto yy1028;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy1028;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy1028;
			goto yy61;
		}
	}
yy932:
	yych = *++cur;
	if (yych <= '/') goto yy685;
	if (yych <= '9') goto yy932;
	goto yy685;
yy933:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy685;
		if (yych <= '9') goto yy933;
		if (yych <= '@') goto yy685;
		goto yy933;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy685;
			goto yy933;
		} else {
			if (yych <= '`') goto yy685;
			if (yych <= 'z') goto yy933;
			goto yy685;
		}
	}
yy934:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 279 "parser/tokenizer.re"
	{ KW(ABSTRACT) }
#line 7542 "parser/tokenizer.cpp"
yy935:
	yych = *++cur;
	if (yych == 'B') goto yy1029;
	if (yych == 'b') goto yy1029;
	goto yy37;
yy936:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 282 "parser/tokenizer.re"
	{ KW(ALLOCATE) }
#line 7556 "parser/tokenizer.cpp"
yy937:
	yych = *++cur;
	if (yych == 'N') goto yy1030;
	if (yych == 'n') goto yy1030;
	goto yy37;
yy938:
	yych = *++cur;
	if (yych == 'E') goto yy1031;
	if (yych == 'e') goto yy1031;
	goto yy37;
yy939:
	yych = *++cur;
	if (yych == 'N') goto yy1032;
	if (yych == 'n') goto yy1032;
	goto yy37;
yy940:
	yych = *++cur;
	if (yych == 'E') goto yy1033;
	if (yych == 'e') goto yy1033;
	goto yy37;
yy941:
	yych = *++cur;
	if (yych == 'A') goto yy1034;
	if (yych == 'a') goto yy1034;
	goto yy37;
yy942:
	yych = *++cur;
	if (yych == 'R') goto yy1035;
	if (yych == 'r') goto yy1035;
	goto yy37;
yy943:
	yych = *++cur;
	if (yych == 'I') goto yy1036;
	if (yych == 'i') goto yy1036;
	goto yy37;
yy944:
	yych = *++cur;
	if (yych == 'N') goto yy1037;
	if (yych == 'n') goto yy1037;
	goto yy37;
yy945:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 301 "parser/tokenizer.re"
	{ KW(CONTAINS) }
#line 7605 "parser/tokenizer.cpp"
yy946:
	yych = *++cur;
	if (yych == 'U') goto yy1038;
	if (yych == 'u') goto yy1038;
	goto yy37;
yy947:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 303 "parser/tokenizer.re"
	{ KW(CONTINUE) }
#line 7619 "parser/tokenizer.cpp"
yy948:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 304 "parser/tokenizer.re"
	{ KW(CRITICAL) }
#line 7628 "parser/tokenizer.cpp"
yy949:
	yych = *++cur;
	if (yych == 'T') goto yy1039;
	if (yych == 't') goto yy1039;
	goto yy37;
yy950:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 309 "parser/tokenizer.re"
	{ KW(DEFERRED) }
#line 7642 "parser/tokenizer.cpp"
yy951:
	yych = *++cur;
	if (yych == 'N') goto yy1040;
	if (yych == 'n') goto yy1040;
	goto yy37;
yy952:
	yych = *++cur;
	if (yych == 'M') goto yy1041;
	if (yych == 'm') goto yy1041;
	goto yy37;
yy953:
	yych = *++cur;
	if (yych == 'E') goto yy1042;
	if (yych == 'e') goto yy1042;
	goto yy37;
yy954:
	yych = *++cur;
	if (yych == 'L') goto yy1043;
	if (yych == 'l') goto yy1043;
	goto yy37;
yy955:
	yych = *++cur;
	if (yych == 'E') goto yy1044;
	if (yych == 'e') goto yy1044;
	goto yy37;
yy956:
	yych = *++cur;
	if (yych == 'C') goto yy1045;
	if (yych == 'c') goto yy1045;
	goto yy61;
yy957:
	yych = *++cur;
	if (yych == 'K') goto yy1046;
	if (yych == 'k') goto yy1046;
	goto yy61;
yy958:
	yych = *++cur;
	if (yych == 'I') goto yy1048;
	if (yych == 'i') goto yy1048;
	goto yy61;
yy959:
	++cur;
#line 356 "parser/tokenizer.re"
	{ KW(END_ENUM) }
#line 7687 "parser/tokenizer.cpp"
yy960:
	yych = *++cur;
	if (yych == 'L') goto yy1049;
	if (yych == 'l') goto yy1049;
	goto yy61;
yy961:
	yych = *++cur;
	if (yych == 'T') goto yy1050;
	if (yych == 't') goto yy1050;
	goto yy61;
yy962:
	yych = *++cur;
	if (yych == 'R') goto yy1051;
	if (yych == 'r') goto yy1051;
	goto yy61;
yy963:
	yych = *++cur;
	if (yych == 'L') goto yy1052;
	if (yych == 'l') goto yy1052;
	goto yy61;
yy964:
	yych = *++cur;
	if (yych == 'E') goto yy1053;
	if (yych == 'e') goto yy1053;
	goto yy61;
yy965:
	yych = *++cur;
	if (yych == 'R') goto yy1054;
	if (yych == 'r') goto yy1054;
	goto yy61;
yy966:
	yych = *++cur;
	if (yych == 'C') goto yy1055;
	if (yych == 'c') goto yy1055;
	goto yy61;
yy967:
	yych = *++cur;
	if (yych == 'O') goto yy1056;
	if (yych == 'o') goto yy1056;
	goto yy61;
yy968:
	yych = *++cur;
	if (yych == 'O') goto yy1057;
	if (yych == 'o') goto yy1057;
	goto yy61;
yy969:
	++cur;
#line 368 "parser/tokenizer.re"
	{ KW(END_TEAM) }
#line 7737 "parser/tokenizer.cpp"
yy970:
	++cur;
#line 380 "parser/tokenizer.re"
	{ KW(END_TYPE) }
#line 7742 "parser/tokenizer.cpp"
yy971:
	yych = *++cur;
	if (yych == 'E') goto yy1058;
	if (yych == 'e') goto yy1058;
	goto yy61;
yy972:
	++cur;
#line 401 "parser/tokenizer.re"
	{ KW(END_FILE) }
#line 7752 "parser/tokenizer.cpp"
yy973:
	yych = *++cur;
	if (yych == 'I') goto yy1059;
	if (yych == 'i') goto yy1059;
	goto yy37;
yy974:
	yyaccept = 13;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1060;
			if (yych >= '\v') goto yy1060;
		} else {
			if (yych <= '\r') {
				if (yych >= '\r') goto yy1060;
			} else {
				if (yych == ' ') goto yy1060;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy36;
			} else {
				if (yych == 'D') goto yy1061;
				goto yy36;
			}
		} else {
			if (yych <= 'c') {
				if (yych >= 'a') goto yy36;
			} else {
				if (yych <= 'd') goto yy1061;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy975:
#line 340 "parser/tokenizer.re"
	{ KW(ENDBLOCK) }
#line 7795 "parser/tokenizer.cpp"
yy976:
	yych = *++cur;
	if (yych == 'C') goto yy1062;
	if (yych == 'c') goto yy1062;
	goto yy37;
yy977:
	yych = *++cur;
	if (yych == 'L') goto yy1063;
	if (yych == 'l') goto yy1063;
	goto yy37;
yy978:
	yych = *++cur;
	if (yych == 'I') goto yy1064;
	if (yych == 'i') goto yy1064;
	goto yy37;
yy979:
	yych = *++cur;
	if (yych == 'F') goto yy1065;
	if (yych == 'f') goto yy1065;
	goto yy37;
yy980:
	yych = *++cur;
	if (yych == 'E') goto yy1066;
	if (yych == 'e') goto yy1066;
	goto yy37;
yy981:
	yych = *++cur;
	if (yych == 'D') goto yy1067;
	if (yych == 'd') goto yy1067;
	goto yy37;
yy982:
	yych = *++cur;
	if (yych == 'A') goto yy1068;
	if (yych == 'a') goto yy1068;
	goto yy37;
yy983:
	yych = *++cur;
	if (yych == 'T') goto yy1069;
	if (yych == 't') goto yy1069;
	goto yy37;
yy984:
	yych = *++cur;
	if (yych == 'D') goto yy1070;
	if (yych == 'd') goto yy1070;
	goto yy37;
yy985:
	yych = *++cur;
	if (yych == 'U') goto yy1071;
	if (yych == 'u') goto yy1071;
	goto yy37;
yy986:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 399 "parser/tokenizer.re"
	{ KW(ENDWHERE) }
#line 7854 "parser/tokenizer.cpp"
yy987:
	yych = *++cur;
	if (yych == 'O') goto yy1072;
	if (yych == 'o') goto yy1072;
	goto yy37;
yy988:
	yych = *++cur;
	if (yych == 'N') goto yy1073;
	if (yych == 'n') goto yy1073;
	goto yy37;
yy989:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 413 "parser/tokenizer.re"
	{ KW(EXTERNAL) }
#line 7873 "parser/tokenizer.cpp"
yy990:
	yych = *++cur;
	if (yych == 'D') goto yy1074;
	if (yych == 'd') goto yy1074;
	goto yy37;
yy991:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 432 "parser/tokenizer.re"
	{ KW(FORM_TEAM) }
#line 7887 "parser/tokenizer.cpp"
yy992:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 433 "parser/tokenizer.re"
	{ KW(FUNCTION) }
#line 7896 "parser/tokenizer.cpp"
yy993:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 439 "parser/tokenizer.re"
	{ KW(IMPLICIT) }
#line 7905 "parser/tokenizer.cpp"
yy994:
	yych = *++cur;
	if (yych == 'A') goto yy1075;
	if (yych == 'a') goto yy1075;
	goto yy37;
yy995:
	yych = *++cur;
	if (yych == 'E') goto yy1076;
	if (yych == 'e') goto yy1076;
	goto yy37;
yy996:
	yych = *++cur;
	if (yych == 'C') goto yy1077;
	if (yych == 'c') goto yy1077;
	goto yy37;
yy997:
	yych = *++cur;
	if (yych == 'I') goto yy1078;
	if (yych == 'i') goto yy1078;
	goto yy37;
yy998:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 462 "parser/tokenizer.re"
	{ KW(NAMELIST) }
#line 7934 "parser/tokenizer.cpp"
yy999:
	yych = *++cur;
	if (yych == 'X') goto yy1079;
	if (yych == 'x') goto yy1079;
	goto yy37;
yy1000:
	yych = *++cur;
	if (yych == 'I') goto yy1080;
	if (yych == 'i') goto yy1080;
	goto yy37;
yy1001:
	yych = *++cur;
	if (yych == 'R') goto yy1081;
	if (yych == 'r') goto yy1081;
	goto yy37;
yy1002:
	yych = *++cur;
	if (yych == 'R') goto yy1082;
	if (yych == 'r') goto yy1082;
	goto yy37;
yy1003:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 472 "parser/tokenizer.re"
	{ KW(OPERATOR) }
#line 7963 "parser/tokenizer.cpp"
yy1004:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 473 "parser/tokenizer.re"
	{ KW(OPTIONAL) }
#line 7972 "parser/tokenizer.cpp"
yy1005:
	yych = *++cur;
	if (yych == 'R') goto yy1083;
	if (yych == 'r') goto yy1083;
	goto yy37;
yy1006:
	yych = *++cur;
	if (yych == 'N') goto yy1084;
	if (yych == 'n') goto yy1084;
	goto yy37;
yy1007:
	yych = *++cur;
	if (yych == 'E') goto yy1085;
	if (yych == 'e') goto yy1085;
	goto yy37;
yy1008:
	yych = *++cur;
	if (yych == 'D') goto yy1086;
	if (yych == 'd') goto yy1086;
	goto yy37;
yy1009:
	yych = *++cur;
	if (yych == 'E') goto yy1087;
	if (yych == 'e') goto yy1087;
	goto yy37;
yy1010:
	yych = *++cur;
	if (yych == 'E') goto yy1088;
	if (yych == 'e') goto yy1088;
	goto yy37;
yy1011:
	yych = *++cur;
	if (yych == 'S') goto yy1089;
	if (yych == 's') goto yy1089;
	goto yy37;
yy1012:
	yych = *++cur;
	if (yych == 'N') goto yy1090;
	if (yych == 'n') goto yy1090;
	goto yy37;
yy1013:
	yych = *++cur;
	if (yych == 'P') goto yy1091;
	if (yych == 'p') goto yy1091;
	goto yy37;
yy1014:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 503 "parser/tokenizer.re"
	{ KW(SEQUENCE) }
#line 8026 "parser/tokenizer.cpp"
yy1015:
	yych = *++cur;
	if (yych == 'E') goto yy1092;
	if (yych == 'e') goto yy1092;
	goto yy37;
yy1016:
	yych = *++cur;
	if (yych == 'N') goto yy1093;
	if (yych == 'n') goto yy1093;
	goto yy37;
yy1017:
	yych = *++cur;
	if (yych == 'E') goto yy1094;
	if (yych == 'e') goto yy1094;
	goto yy37;
yy1018:
	yych = *++cur;
	if (yych == 'R') goto yy1095;
	if (yych == 'r') goto yy1095;
	goto yy37;
yy1019:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 514 "parser/tokenizer.re"
	{ KW(SYNC_TEAM) }
#line 8055 "parser/tokenizer.cpp"
yy1020:
	yych = *++cur;
	if (yych == 'B') goto yy1096;
	if (yych == 'b') goto yy1096;
	goto yy37;
yy1021:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 518 "parser/tokenizer.re"
	{ KW(TEMPLATE) }
#line 8069 "parser/tokenizer.cpp"
yy1022:
	yych = *++cur;
	if (yych == 'T') goto yy1097;
	if (yych == 't') goto yy1097;
	goto yy37;
yy1023:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 525 "parser/tokenizer.re"
	{ KW(VOLATILE) }
#line 8083 "parser/tokenizer.cpp"
yy1024:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy1098;
	goto yy1024;
yy1025:
	++cur;
#line 722 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#define ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 8099 "parser/tokenizer.cpp"
yy1026:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy1099;
	goto yy1026;
yy1027:
	yych = *++cur;
	if (yych <= '/') goto yy820;
	if (yych <= '9') goto yy1027;
	goto yy820;
yy1028:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy820;
		if (yych <= '9') goto yy1028;
		if (yych <= '@') goto yy820;
		goto yy1028;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy820;
			goto yy1028;
		} else {
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1028;
			goto yy820;
		}
	}
yy1029:
	yych = *++cur;
	if (yych == 'L') goto yy1100;
	if (yych == 'l') goto yy1100;
	goto yy37;
yy1030:
	yych = *++cur;
	if (yych == 'T') goto yy1101;
	if (yych == 't') goto yy1101;
	goto yy37;
yy1031:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 285 "parser/tokenizer.re"
	{ KW(ASSOCIATE) }
#line 8145 "parser/tokenizer.cpp"
yy1032:
	yych = *++cur;
	if (yych == 'O') goto yy1102;
	if (yych == 'o') goto yy1102;
	goto yy37;
yy1033:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 287 "parser/tokenizer.re"
	{ KW(BACKSPACE) }
#line 8159 "parser/tokenizer.cpp"
yy1034:
	yych = *++cur;
	if (yych == 'M') goto yy1103;
	if (yych == 'm') goto yy1103;
	goto yy37;
yy1035:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 294 "parser/tokenizer.re"
	{ KW(CHARACTER) }
#line 8173 "parser/tokenizer.cpp"
yy1036:
	yych = *++cur;
	if (yych == 'O') goto yy1104;
	if (yych == 'o') goto yy1104;
	goto yy37;
yy1037:
	yych = *++cur;
	if (yych == 'T') goto yy1105;
	if (yych == 't') goto yy1105;
	goto yy37;
yy1038:
	yych = *++cur;
	if (yych == 'S') goto yy1106;
	if (yych == 's') goto yy1106;
	goto yy37;
yy1039:
	yych = *++cur;
	if (yych == 'E') goto yy1107;
	if (yych == 'e') goto yy1107;
	goto yy37;
yy1040:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 310 "parser/tokenizer.re"
	{ KW(DIMENSION) }
#line 8202 "parser/tokenizer.cpp"
yy1041:
	yych = *++cur;
	if (yych == 'P') goto yy1108;
	if (yych == 'p') goto yy1108;
	goto yy37;
yy1042:
	yych = *++cur;
	if (yych == 'C') goto yy1109;
	if (yych == 'c') goto yy1109;
	goto yy37;
yy1043:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 323 "parser/tokenizer.re"
	{ KW(ELEMENTAL) }
#line 8221 "parser/tokenizer.cpp"
yy1044:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 326 "parser/tokenizer.re"
	{ KW(ELSEWHERE) }
#line 8230 "parser/tokenizer.cpp"
yy1045:
	yych = *++cur;
	if (yych == 'I') goto yy1110;
	if (yych == 'i') goto yy1110;
	goto yy61;
yy1046:
	yyaccept = 14;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1111;
		} else {
			if (yych != '\f') goto yy1111;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1111;
		} else {
			if (yych <= 'D') goto yy1112;
			if (yych == 'd') goto yy1112;
		}
	}
yy1047:
#line 339 "parser/tokenizer.re"
	{ KW(END_BLOCK) }
#line 8256 "parser/tokenizer.cpp"
yy1048:
	yych = *++cur;
	if (yych == 'C') goto yy1113;
	if (yych == 'c') goto yy1113;
	goto yy61;
yy1049:
	yych = *++cur;
	if (yych == 'L') goto yy1114;
	if (yych == 'l') goto yy1114;
	goto yy61;
yy1050:
	yych = *++cur;
	if (yych == 'I') goto yy1115;
	if (yych == 'i') goto yy1115;
	goto yy61;
yy1051:
	yych = *++cur;
	if (yych == 'F') goto yy1116;
	if (yych == 'f') goto yy1116;
	goto yy61;
yy1052:
	yych = *++cur;
	if (yych == 'E') goto yy1117;
	if (yych == 'e') goto yy1117;
	goto yy61;
yy1053:
	yych = *++cur;
	if (yych == 'D') goto yy1118;
	if (yych == 'd') goto yy1118;
	goto yy61;
yy1054:
	yych = *++cur;
	if (yych == 'A') goto yy1119;
	if (yych == 'a') goto yy1119;
	goto yy61;
yy1055:
	yych = *++cur;
	if (yych == 'T') goto yy1120;
	if (yych == 't') goto yy1120;
	goto yy61;
yy1056:
	yych = *++cur;
	if (yych == 'D') goto yy1121;
	if (yych == 'd') goto yy1121;
	goto yy61;
yy1057:
	yych = *++cur;
	if (yych == 'U') goto yy1122;
	if (yych == 'u') goto yy1122;
	goto yy61;
yy1058:
	++cur;
#line 398 "parser/tokenizer.re"
	{ KW(END_WHERE) }
#line 8311 "parser/tokenizer.cpp"
yy1059:
	yych = *++cur;
	if (yych == 'A') goto yy1123;
	if (yych == 'a') goto yy1123;
	goto yy37;
yy1060:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1060;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1060;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1060;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1124;
			if (yych == 'd') goto yy1124;
			goto yy61;
		}
	}
yy1061:
	yych = *++cur;
	if (yych == 'A') goto yy1125;
	if (yych == 'a') goto yy1125;
	goto yy37;
yy1062:
	yych = *++cur;
	if (yych == 'A') goto yy1126;
	if (yych == 'a') goto yy1126;
	goto yy37;
yy1063:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 372 "parser/tokenizer.re"
	{ KW(ENDFORALL) }
#line 8355 "parser/tokenizer.cpp"
yy1064:
	yych = *++cur;
	if (yych == 'O') goto yy1127;
	if (yych == 'o') goto yy1127;
	goto yy37;
yy1065:
	yych = *++cur;
	if (yych == 'A') goto yy1128;
	if (yych == 'a') goto yy1128;
	goto yy37;
yy1066:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 334 "parser/tokenizer.re"
	{ KW(ENDMODULE) }
#line 8374 "parser/tokenizer.cpp"
yy1067:
	yych = *++cur;
	if (yych == 'U') goto yy1129;
	if (yych == 'u') goto yy1129;
	goto yy37;
yy1068:
	yych = *++cur;
	if (yych == 'M') goto yy1130;
	if (yych == 'm') goto yy1130;
	goto yy37;
yy1069:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 360 "parser/tokenizer.re"
	{ KW(ENDSELECT) }
#line 8393 "parser/tokenizer.cpp"
yy1070:
	yych = *++cur;
	if (yych == 'U') goto yy1131;
	if (yych == 'u') goto yy1131;
	goto yy37;
yy1071:
	yych = *++cur;
	if (yych == 'T') goto yy1132;
	if (yych == 't') goto yy1132;
	goto yy37;
yy1072:
	yych = *++cur;
	if (yych == 'R') goto yy1133;
	if (yych == 'r') goto yy1133;
	goto yy37;
yy1073:
	yych = *++cur;
	if (yych == 'C') goto yy1134;
	if (yych == 'c') goto yy1134;
	goto yy37;
yy1074:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 430 "parser/tokenizer.re"
	{ KW(FORMATTED) }
#line 8422 "parser/tokenizer.cpp"
yy1075:
	yych = *++cur;
	if (yych == 'T') goto yy1135;
	if (yych == 't') goto yy1135;
	goto yy37;
yy1076:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 450 "parser/tokenizer.re"
	{ KW(INTERFACE) }
#line 8436 "parser/tokenizer.cpp"
yy1077:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 451 "parser/tokenizer.re"
	{ KW(INTRINSIC) }
#line 8445 "parser/tokenizer.cpp"
yy1078:
	yych = *++cur;
	if (yych == 'T') goto yy1136;
	if (yych == 't') goto yy1136;
	goto yy37;
yy1079:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 463 "parser/tokenizer.re"
	{ KW(NEW_INDEX) }
#line 8459 "parser/tokenizer.cpp"
yy1080:
	yych = *++cur;
	if (yych == 'N') goto yy1137;
	if (yych == 'n') goto yy1137;
	goto yy37;
yy1081:
	yych = *++cur;
	if (yych == 'I') goto yy1138;
	if (yych == 'i') goto yy1138;
	goto yy37;
yy1082:
	yych = *++cur;
	if (yych == 'S') goto yy1139;
	if (yych == 's') goto yy1139;
	goto yy37;
yy1083:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 475 "parser/tokenizer.re"
	{ KW(PARAMETER) }
#line 8483 "parser/tokenizer.cpp"
yy1084:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 479 "parser/tokenizer.re"
	{ KW(PRECISION) }
#line 8492 "parser/tokenizer.cpp"
yy1085:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 482 "parser/tokenizer.re"
	{ KW(PROCEDURE) }
#line 8501 "parser/tokenizer.cpp"
yy1086:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 484 "parser/tokenizer.re"
	{ KW(PROTECTED) }
#line 8510 "parser/tokenizer.cpp"
yy1087:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 491 "parser/tokenizer.re"
	{ KW(RECURSIVE) }
#line 8519 "parser/tokenizer.cpp"
yy1088:
	yych = *++cur;
	if (yych == 'N') goto yy1140;
	if (yych == 'n') goto yy1140;
	goto yy37;
yy1089:
	yych = *++cur;
	if (yych == 'E') goto yy1141;
	if (yych == 'e') goto yy1141;
	goto yy37;
yy1090:
	yych = *++cur;
	if (yych == 'K') goto yy1142;
	if (yych == 'k') goto yy1142;
	goto yy37;
yy1091:
	yych = *++cur;
	if (yych == 'E') goto yy1143;
	if (yych == 'e') goto yy1143;
	goto yy37;
yy1092:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 508 "parser/tokenizer.re"
	{ KW(SUBMODULE) }
#line 8548 "parser/tokenizer.cpp"
yy1093:
	yych = *++cur;
	if (yych == 'E') goto yy1144;
	if (yych == 'e') goto yy1144;
	goto yy37;
yy1094:
	yych = *++cur;
	if (yych == 'S') goto yy1145;
	if (yych == 's') goto yy1145;
	goto yy37;
yy1095:
	yych = *++cur;
	if (yych == 'Y') goto yy1146;
	if (yych == 'y') goto yy1146;
	goto yy37;
yy1096:
	yych = *++cur;
	if (yych == 'E') goto yy1147;
	if (yych == 'e') goto yy1147;
	goto yy37;
yy1097:
	yych = *++cur;
	if (yych == 'E') goto yy1148;
	if (yych == 'e') goto yy1148;
	goto yy37;
yy1098:
	++cur;
	cur -= 1;
#line 676 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_OMP_END) }
#line 8579 "parser/tokenizer.cpp"
yy1099:
	++cur;
#line 729 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#include ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 8590 "parser/tokenizer.cpp"
yy1100:
	yych = *++cur;
	if (yych == 'E') goto yy1149;
	if (yych == 'e') goto yy1149;
	goto yy37;
yy1101:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 284 "parser/tokenizer.re"
	{ KW(ASSIGNMENT) }
#line 8604 "parser/tokenizer.cpp"
yy1102:
	yych = *++cur;
	if (yych == 'U') goto yy1150;
	if (yych == 'u') goto yy1150;
	goto yy37;
yy1103:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 293 "parser/tokenizer.re"
	{ KW(CHANGE_TEAM) }
#line 8618 "parser/tokenizer.cpp"
yy1104:
	yych = *++cur;
	if (yych == 'N') goto yy1151;
	if (yych == 'n') goto yy1151;
	goto yy37;
yy1105:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 300 "parser/tokenizer.re"
	{ KW(CONCURRENT) }
#line 8632 "parser/tokenizer.cpp"
yy1106:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 302 "parser/tokenizer.re"
	{ KW(CONTIGUOUS) }
#line 8641 "parser/tokenizer.cpp"
yy1107:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 307 "parser/tokenizer.re"
	{ KW(DEALLOCATE) }
#line 8650 "parser/tokenizer.cpp"
yy1108:
	yych = *++cur;
	if (yych == 'L') goto yy1152;
	if (yych == 'l') goto yy1152;
	goto yy37;
yy1109:
	yych = *++cur;
	if (yych == 'I') goto yy1153;
	if (yych == 'i') goto yy1153;
	goto yy37;
yy1110:
	yych = *++cur;
	if (yych == 'A') goto yy1154;
	if (yych == 'a') goto yy1154;
	goto yy61;
yy1111:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1111;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1111;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1111;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1155;
			if (yych == 'd') goto yy1155;
			goto yy61;
		}
	}
yy1112:
	yych = *++cur;
	if (yych == 'A') goto yy1156;
	if (yych == 'a') goto yy1156;
	goto yy61;
yy1113:
	yych = *++cur;
	if (yych == 'A') goto yy1157;
	if (yych == 'a') goto yy1157;
	goto yy61;
yy1114:
	++cur;
#line 371 "parser/tokenizer.re"
	{ KW(END_FORALL) }
#line 8700 "parser/tokenizer.cpp"
yy1115:
	yych = *++cur;
	if (yych == 'O') goto yy1158;
	if (yych == 'o') goto yy1158;
	goto yy61;
yy1116:
	yych = *++cur;
	if (yych == 'A') goto yy1159;
	if (yych == 'a') goto yy1159;
	goto yy61;
yy1117:
	++cur;
#line 333 "parser/tokenizer.re"
	{ KW(END_MODULE) }
#line 8715 "parser/tokenizer.cpp"
yy1118:
	yych = *++cur;
	if (yych == 'U') goto yy1160;
	if (yych == 'u') goto yy1160;
	goto yy61;
yy1119:
	yych = *++cur;
	if (yych == 'M') goto yy1161;
	if (yych == 'm') goto yy1161;
	goto yy61;
yy1120:
	++cur;
#line 359 "parser/tokenizer.re"
	{ KW(END_SELECT) }
#line 8730 "parser/tokenizer.cpp"
yy1121:
	yych = *++cur;
	if (yych == 'U') goto yy1162;
	if (yych == 'u') goto yy1162;
	goto yy61;
yy1122:
	yych = *++cur;
	if (yych == 'T') goto yy1163;
	if (yych == 't') goto yy1163;
	goto yy61;
yy1123:
	yych = *++cur;
	if (yych == 'T') goto yy1164;
	if (yych == 't') goto yy1164;
	goto yy37;
yy1124:
	yych = *++cur;
	if (yych == 'A') goto yy1165;
	if (yych == 'a') goto yy1165;
	goto yy61;
yy1125:
	yych = *++cur;
	if (yych == 'T') goto yy1166;
	if (yych == 't') goto yy1166;
	goto yy37;
yy1126:
	yych = *++cur;
	if (yych == 'L') goto yy1167;
	if (yych == 'l') goto yy1167;
	goto yy37;
yy1127:
	yych = *++cur;
	if (yych == 'N') goto yy1168;
	if (yych == 'n') goto yy1168;
	goto yy37;
yy1128:
	yych = *++cur;
	if (yych == 'C') goto yy1169;
	if (yych == 'c') goto yy1169;
	goto yy37;
yy1129:
	yych = *++cur;
	if (yych == 'R') goto yy1170;
	if (yych == 'r') goto yy1170;
	goto yy37;
yy1130:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 331 "parser/tokenizer.re"
	{ KW(ENDPROGRAM) }
#line 8784 "parser/tokenizer.cpp"
yy1131:
	yych = *++cur;
	if (yych == 'L') goto yy1171;
	if (yych == 'l') goto yy1171;
	goto yy37;
yy1132:
	yych = *++cur;
	if (yych == 'I') goto yy1172;
	if (yych == 'i') goto yy1172;
	goto yy37;
yy1133:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 406 "parser/tokenizer.re"
	{ KW(ENUMERATOR) }
#line 8803 "parser/tokenizer.cpp"
yy1134:
	yych = *++cur;
	if (yych == 'E') goto yy1173;
	if (yych == 'e') goto yy1173;
	goto yy37;
yy1135:
	yych = *++cur;
	if (yych == 'E') goto yy1174;
	if (yych == 'e') goto yy1174;
	goto yy37;
yy1136:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 456 "parser/tokenizer.re"
	{ KW(LOCAL_INIT) }
#line 8822 "parser/tokenizer.cpp"
yy1137:
	yych = *++cur;
	if (yych == 'S') goto yy1175;
	if (yych == 's') goto yy1175;
	goto yy37;
yy1138:
	yych = *++cur;
	if (yych == 'D') goto yy1176;
	if (yych == 'd') goto yy1176;
	goto yy37;
yy1139:
	yych = *++cur;
	if (yych == 'I') goto yy1177;
	if (yych == 'i') goto yy1177;
	goto yy37;
yy1140:
	yych = *++cur;
	if (yych == 'T') goto yy1178;
	if (yych == 't') goto yy1178;
	goto yy37;
yy1141:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 500 "parser/tokenizer.re"
	{ KW(SELECT_CASE) }
#line 8851 "parser/tokenizer.cpp"
yy1142:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 501 "parser/tokenizer.re"
	{ KW(SELECT_RANK) }
#line 8860 "parser/tokenizer.cpp"
yy1143:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 502 "parser/tokenizer.re"
	{ KW(SELECT_TYPE) }
#line 8869 "parser/tokenizer.cpp"
yy1144:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 509 "parser/tokenizer.re"
	{ KW(SUBROUTINE) }
#line 8878 "parser/tokenizer.cpp"
yy1145:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 512 "parser/tokenizer.re"
	{ KW(SYNC_IMAGES) }
#line 8887 "parser/tokenizer.cpp"
yy1146:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 513 "parser/tokenizer.re"
	{ KW(SYNC_MEMORY) }
#line 8896 "parser/tokenizer.cpp"
yy1147:
	yych = *++cur;
	if (yych == 'R') goto yy1179;
	if (yych == 'r') goto yy1179;
	goto yy37;
yy1148:
	yych = *++cur;
	if (yych == 'D') goto yy1180;
	if (yych == 'd') goto yy1180;
	goto yy37;
yy1149:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 281 "parser/tokenizer.re"
	{ KW(ALLOCATABLE) }
#line 8915 "parser/tokenizer.cpp"
yy1150:
	yych = *++cur;
	if (yych == 'S') goto yy1181;
	if (yych == 's') goto yy1181;
	goto yy37;
yy1151:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 297 "parser/tokenizer.re"
	{ KW(CODIMENSION) }
#line 8929 "parser/tokenizer.cpp"
yy1152:
	yych = *++cur;
	if (yych == 'E') goto yy1182;
	if (yych == 'e') goto yy1182;
	goto yy37;
yy1153:
	yych = *++cur;
	if (yych == 'S') goto yy1183;
	if (yych == 's') goto yy1183;
	goto yy37;
yy1154:
	yych = *++cur;
	if (yych == 'T') goto yy1184;
	if (yych == 't') goto yy1184;
	goto yy61;
yy1155:
	yych = *++cur;
	if (yych == 'A') goto yy1185;
	if (yych == 'a') goto yy1185;
	goto yy61;
yy1156:
	yych = *++cur;
	if (yych == 'T') goto yy1186;
	if (yych == 't') goto yy1186;
	goto yy61;
yy1157:
	yych = *++cur;
	if (yych == 'L') goto yy1187;
	if (yych == 'l') goto yy1187;
	goto yy61;
yy1158:
	yych = *++cur;
	if (yych == 'N') goto yy1188;
	if (yych == 'n') goto yy1188;
	goto yy61;
yy1159:
	yych = *++cur;
	if (yych == 'C') goto yy1189;
	if (yych == 'c') goto yy1189;
	goto yy61;
yy1160:
	yych = *++cur;
	if (yych == 'R') goto yy1190;
	if (yych == 'r') goto yy1190;
	goto yy61;
yy1161:
	++cur;
#line 330 "parser/tokenizer.re"
	{ KW(END_PROGRAM) }
#line 8979 "parser/tokenizer.cpp"
yy1162:
	yych = *++cur;
	if (yych == 'L') goto yy1191;
	if (yych == 'l') goto yy1191;
	goto yy61;
yy1163:
	yych = *++cur;
	if (yych == 'I') goto yy1192;
	if (yych == 'i') goto yy1192;
	goto yy61;
yy1164:
	yych = *++cur;
	if (yych == 'E') goto yy1193;
	if (yych == 'e') goto yy1193;
	goto yy37;
yy1165:
	yych = *++cur;
	if (yych == 'T') goto yy1194;
	if (yych == 't') goto yy1194;
	goto yy61;
yy1166:
	yych = *++cur;
	if (yych == 'A') goto yy1195;
	if (yych == 'a') goto yy1195;
	goto yy37;
yy1167:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 366 "parser/tokenizer.re"
	{ KW(ENDCRITICAL) }
#line 9013 "parser/tokenizer.cpp"
yy1168:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 351 "parser/tokenizer.re"
	{ KW(ENDFUNCTION) }
#line 9022 "parser/tokenizer.cpp"
yy1169:
	yych = *++cur;
	if (yych == 'E') goto yy1196;
	if (yych == 'e') goto yy1196;
	goto yy37;
yy1170:
	yych = *++cur;
	if (yych == 'E') goto yy1197;
	if (yych == 'e') goto yy1197;
	goto yy37;
yy1171:
	yych = *++cur;
	if (yych == 'E') goto yy1198;
	if (yych == 'e') goto yy1198;
	goto yy37;
yy1172:
	yych = *++cur;
	if (yych == 'N') goto yy1199;
	if (yych == 'n') goto yy1199;
	goto yy37;
yy1173:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 407 "parser/tokenizer.re"
	{ KW(EQUIVALENCE) }
#line 9051 "parser/tokenizer.cpp"
yy1174:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 447 "parser/tokenizer.re"
	{ KW(INSTANTIATE) }
#line 9060 "parser/tokenizer.cpp"
yy1175:
	yych = *++cur;
	if (yych == 'I') goto yy1200;
	if (yych == 'i') goto yy1200;
	goto yy37;
yy1176:
	yych = *++cur;
	if (yych == 'A') goto yy1201;
	if (yych == 'a') goto yy1201;
	goto yy37;
yy1177:
	yych = *++cur;
	if (yych == 'V') goto yy1202;
	if (yych == 'v') goto yy1202;
	goto yy37;
yy1178:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 493 "parser/tokenizer.re"
	{ KW(REQUIREMENT) }
#line 9084 "parser/tokenizer.cpp"
yy1179:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 517 "parser/tokenizer.re"
	{ KW(TEAM_NUMBER) }
#line 9093 "parser/tokenizer.cpp"
yy1180:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 522 "parser/tokenizer.re"
	{ KW(UNFORMATTED) }
#line 9102 "parser/tokenizer.cpp"
yy1181:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 286 "parser/tokenizer.re"
	{ KW(ASYNCHRONOUS) }
#line 9111 "parser/tokenizer.cpp"
yy1182:
	yych = *++cur;
	if (yych == 'X') goto yy1203;
	if (yych == 'x') goto yy1203;
	goto yy37;
yy1183:
	yych = *++cur;
	if (yych == 'I') goto yy1204;
	if (yych == 'i') goto yy1204;
	goto yy37;
yy1184:
	yych = *++cur;
	if (yych == 'E') goto yy1205;
	if (yych == 'e') goto yy1205;
	goto yy61;
yy1185:
	yych = *++cur;
	if (yych == 'T') goto yy1206;
	if (yych == 't') goto yy1206;
	goto yy61;
yy1186:
	yych = *++cur;
	if (yych == 'A') goto yy1207;
	if (yych == 'a') goto yy1207;
	goto yy61;
yy1187:
	++cur;
#line 365 "parser/tokenizer.re"
	{ KW(END_CRITICAL) }
#line 9141 "parser/tokenizer.cpp"
yy1188:
	++cur;
#line 350 "parser/tokenizer.re"
	{ KW(END_FUNCTION) }
#line 9146 "parser/tokenizer.cpp"
yy1189:
	yych = *++cur;
	if (yych == 'E') goto yy1208;
	if (yych == 'e') goto yy1208;
	goto yy61;
yy1190:
	yych = *++cur;
	if (yych == 'E') goto yy1209;
	if (yych == 'e') goto yy1209;
	goto yy61;
yy1191:
	yych = *++cur;
	if (yych == 'E') goto yy1210;
	if (yych == 'e') goto yy1210;
	goto yy61;
yy1192:
	yych = *++cur;
	if (yych == 'N') goto yy1211;
	if (yych == 'n') goto yy1211;
	goto yy61;
yy1193:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 363 "parser/tokenizer.re"
	{ KW(ENDASSOCIATE) }
#line 9175 "parser/tokenizer.cpp"
yy1194:
	yych = *++cur;
	if (yych == 'A') goto yy1212;
	if (yych == 'a') goto yy1212;
	goto yy61;
yy1195:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 345 "parser/tokenizer.re"
	{ KW(ENDBLOCKDATA) }
#line 9189 "parser/tokenizer.cpp"
yy1196:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 378 "parser/tokenizer.re"
	{ KW(ENDINTERFACE) }
#line 9198 "parser/tokenizer.cpp"
yy1197:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 354 "parser/tokenizer.re"
	{ KW(ENDPROCEDURE) }
#line 9207 "parser/tokenizer.cpp"
yy1198:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 337 "parser/tokenizer.re"
	{ KW(ENDSUBMODULE) }
#line 9216 "parser/tokenizer.cpp"
yy1199:
	yych = *++cur;
	if (yych == 'E') goto yy1213;
	if (yych == 'e') goto yy1213;
	goto yy37;
yy1200:
	yych = *++cur;
	if (yych == 'C') goto yy1214;
	if (yych == 'c') goto yy1214;
	goto yy37;
yy1201:
	yych = *++cur;
	if (yych == 'B') goto yy1215;
	if (yych == 'b') goto yy1215;
	goto yy37;
yy1202:
	yych = *++cur;
	if (yych == 'E') goto yy1216;
	if (yych == 'e') goto yy1216;
	goto yy37;
yy1203:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 322 "parser/tokenizer.re"
	{ KW(DOUBLE_COMPLEX) }
#line 9245 "parser/tokenizer.cpp"
yy1204:
	yych = *++cur;
	if (yych == 'O') goto yy1217;
	if (yych == 'o') goto yy1217;
	goto yy37;
yy1205:
	++cur;
#line 362 "parser/tokenizer.re"
	{ KW(END_ASSOCIATE) }
#line 9255 "parser/tokenizer.cpp"
yy1206:
	yych = *++cur;
	if (yych == 'A') goto yy1218;
	if (yych == 'a') goto yy1218;
	goto yy61;
yy1207:
	++cur;
#line 344 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9265 "parser/tokenizer.cpp"
yy1208:
	++cur;
#line 377 "parser/tokenizer.re"
	{ KW(END_INTERFACE) }
#line 9270 "parser/tokenizer.cpp"
yy1209:
	++cur;
#line 353 "parser/tokenizer.re"
	{ KW(END_PROCEDURE) }
#line 9275 "parser/tokenizer.cpp"
yy1210:
	++cur;
#line 336 "parser/tokenizer.re"
	{ KW(END_SUBMODULE) }
#line 9280 "parser/tokenizer.cpp"
yy1211:
	yych = *++cur;
	if (yych == 'E') goto yy1219;
	if (yych == 'e') goto yy1219;
	goto yy61;
yy1212:
	++cur;
#line 343 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9290 "parser/tokenizer.cpp"
yy1213:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 348 "parser/tokenizer.re"
	{ KW(ENDSUBROUTINE) }
#line 9299 "parser/tokenizer.cpp"
yy1214:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 465 "parser/tokenizer.re"
	{ KW(NON_INTRINSIC) }
#line 9308 "parser/tokenizer.cpp"
yy1215:
	yych = *++cur;
	if (yych == 'L') goto yy1220;
	if (yych == 'l') goto yy1220;
	goto yy37;
yy1216:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 467 "parser/tokenizer.re"
	{ KW(NON_RECURSIVE) }
#line 9322 "parser/tokenizer.cpp"
yy1217:
	yych = *++cur;
	if (yych == 'N') goto yy1221;
	if (yych == 'n') goto yy1221;
	goto yy37;
yy1218:
	++cur;
#line 342 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9332 "parser/tokenizer.cpp"
yy1219:
	++cur;
#line 347 "parser/tokenizer.re"
	{ KW(END_SUBROUTINE) }
#line 9337 "parser/tokenizer.cpp"
yy1220:
	yych = *++cur;
	if (yych == 'E') goto yy1222;
	if (yych == 'e') goto yy1222;
	goto yy37;
yy1221:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 321 "parser/tokenizer.re"
	{ KW(DOUBLE_PRECISION) }
#line 9351 "parser/tokenizer.cpp"
yy1222:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 466 "parser/tokenizer.re"
	{ KW(NON_OVERRIDABLE) }
#line 9360 "parser/tokenizer.cpp"
}
#line 750 "parser/tokenizer.re"

    }
}

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

void token_loc(Location &loc)
{
    loc.first = 1;
    loc.last = 1;
}

void lex_format(unsigned char *&cur, Location &loc,
        unsigned char *&start, diag::Diagnostics &diagnostics, bool continue_compilation) {
    int num_paren = 0;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 9385 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,  52,  52,  52,  52,  52,  52,  52, 
		 52, 190,  44, 190,  52, 190,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		190,  52,  48,  52,  52,  52,  52,  20, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		244, 244, 244, 244, 244, 244, 244, 244, 
		244, 244,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
	};
	yych = *cur;
	if (yybm[0+yych] & 2) {
		goto yy1227;
	}
	switch (yych) {
		case 0x00: goto yy1224;
		case '"': goto yy1229;
		case '&': goto yy1230;
		case '\'': goto yy1231;
		case '(': goto yy1232;
		case ')': goto yy1233;
		case '*': goto yy1234;
		case ',': goto yy1235;
		case '-': goto yy1236;
		case '/':
		case ':': goto yy1237;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1239;
		case 'A':
		case 'a': goto yy1240;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1242;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1243;
		case 'E':
		case 'e': goto yy1244;
		case 'G':
		case 'g': goto yy1245;
		case 'L':
		case 'l': goto yy1246;
		case 'P':
		case 'p': goto yy1247;
		case 'T':
		case 't': goto yy1248;
		case 'X':
		case 'x': goto yy1249;
		default: goto yy1225;
	}
yy1224:
	++cur;
#line 852 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                diagnostics.add(diag::Diagnostic(
                    "End of file not expected in `format` statement '" + t + "'",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                    diag::Label("", {loc})}
                ));
                if(!continue_compilation) {
                    throw parser_local::TokenizerAbort();
                } else {
                    continue;
                }
            }
#line 9494 "parser/tokenizer.cpp"
yy1225:
	++cur;
yy1226:
#line 810 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                diagnostics.add(diag::Diagnostic(
                    "Token '" + t + "' is not recognized in `format` statement",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                    diag::Label("", {loc})}
                ));
                if(!continue_compilation) {
                    throw parser_local::TokenizerAbort();
                } else {
                    continue;
                }
            }
#line 9513 "parser/tokenizer.cpp"
yy1227:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 2) {
		goto yy1227;
	}
	switch (yych) {
		case 'A':
		case 'a': goto yy1240;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1250;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1252;
		case 'E':
		case 'e': goto yy1253;
		case 'G':
		case 'g': goto yy1254;
		case 'L':
		case 'l': goto yy1255;
		case 'P':
		case 'p': goto yy1247;
		case 'X':
		case 'x': goto yy1249;
		default: goto yy1228;
	}
yy1228:
#line 866 "parser/tokenizer.re"
	{ continue; }
#line 9550 "parser/tokenizer.cpp"
yy1229:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1226;
	goto yy1257;
yy1230:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1226;
		if (yych <= '\v') goto yy1260;
		goto yy1226;
	} else {
		if (yych <= '\r') goto yy1260;
		if (yych <= 0x1F) goto yy1226;
		if (yych <= '!') goto yy1260;
		goto yy1226;
	}
yy1231:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1226;
	goto yy1265;
yy1232:
	++cur;
#line 824 "parser/tokenizer.re"
	{
                if (num_paren == 0) {
                    num_paren++;
                    start = cur;
                    continue;
                } else {
                    cur--;
                    unsigned char *tmp;
                    lex_format(cur, loc, tmp, diagnostics, continue_compilation);
                    continue;
                }
            }
#line 9589 "parser/tokenizer.cpp"
yy1233:
	++cur;
#line 848 "parser/tokenizer.re"
	{
                LCOMPILERS_ASSERT(num_paren == 1);
                return;
            }
#line 9597 "parser/tokenizer.cpp"
yy1234:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1226;
			goto yy1267;
		} else {
			if (yych == '\v') goto yy1267;
			goto yy1226;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1267;
			if (yych <= 0x1F) goto yy1226;
			goto yy1267;
		} else {
			if (yych == '(') goto yy1268;
			goto yy1226;
		}
	}
yy1235:
	++cur;
#line 867 "parser/tokenizer.re"
	{ continue; }
#line 9623 "parser/tokenizer.cpp"
yy1236:
	++cur;
#line 871 "parser/tokenizer.re"
	{ continue; }
#line 9628 "parser/tokenizer.cpp"
yy1237:
	++cur;
yy1238:
#line 873 "parser/tokenizer.re"
	{ continue; }
#line 9634 "parser/tokenizer.cpp"
yy1239:
	yyaccept = 1;
	yych = *(mar = ++cur);
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ':
		case '(':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'L':
		case 'O':
		case 'P':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'l':
		case 'o':
		case 'p':
		case 'x':
		case 'z': goto yy1270;
		case '/': goto yy1237;
		default: goto yy1226;
	}
yy1240:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy1240;
		} else {
			if (yych == '\v') goto yy1240;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1240;
			if (yych >= ' ') goto yy1240;
		} else {
			if (yych <= '/') goto yy1241;
			if (yych <= '9') goto yy1273;
		}
	}
yy1241:
#line 872 "parser/tokenizer.re"
	{ continue; }
#line 9701 "parser/tokenizer.cpp"
yy1242:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1226;
			goto yy1250;
		} else {
			if (yych == '\v') goto yy1250;
			goto yy1226;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1250;
			if (yych <= 0x1F) goto yy1226;
			goto yy1250;
		} else {
			if (yych <= '/') goto yy1226;
			if (yych <= '9') goto yy1274;
			goto yy1226;
		}
	}
yy1243:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1226;
			goto yy1252;
		} else {
			if (yych == '\v') goto yy1252;
			goto yy1226;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1252;
			if (yych <= 0x1F) goto yy1226;
			goto yy1252;
		} else {
			if (yych <= '/') goto yy1226;
			if (yych <= '9') goto yy1275;
			goto yy1226;
		}
	}
yy1244:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'M') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy1226;
				goto yy1253;
			} else {
				if (yych == '\v') goto yy1253;
				goto yy1226;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy1253;
				if (yych <= 0x1F) goto yy1226;
				goto yy1253;
			} else {
				if (yych <= '/') goto yy1226;
				if (yych <= '9') goto yy1276;
				goto yy1226;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'S') {
				if (yych <= 'N') goto yy1277;
				if (yych <= 'R') goto yy1226;
				goto yy1277;
			} else {
				if (yych == 'X') goto yy1277;
				goto yy1226;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'n') goto yy1277;
				if (yych <= 'r') goto yy1226;
				goto yy1277;
			} else {
				if (yych == 'x') goto yy1277;
				goto yy1226;
			}
		}
	}
yy1245:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1226;
			goto yy1254;
		} else {
			if (yych == '\v') goto yy1254;
			goto yy1226;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1254;
			if (yych <= 0x1F) goto yy1226;
			goto yy1254;
		} else {
			if (yych <= '/') goto yy1226;
			if (yych <= '9') goto yy1278;
			goto yy1226;
		}
	}
yy1246:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1226;
			goto yy1255;
		} else {
			if (yych == '\v') goto yy1255;
			goto yy1226;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1255;
			if (yych <= 0x1F) goto yy1226;
			goto yy1255;
		} else {
			if (yych <= '/') goto yy1226;
			if (yych <= '9') goto yy1273;
			goto yy1226;
		}
	}
yy1247:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1279;
			goto yy1241;
		} else {
			if (yych == '\f') goto yy1241;
			goto yy1279;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy1279;
			goto yy1241;
		} else {
			if (yych <= 'F') goto yy1252;
			if (yych <= 'd') goto yy1241;
			if (yych <= 'f') goto yy1252;
			goto yy1241;
		}
	}
yy1248:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1280;
			if (yych <= '\n') goto yy1226;
			goto yy1280;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1226;
				goto yy1280;
			} else {
				if (yych == ' ') goto yy1280;
				goto yy1226;
			}
		}
	} else {
		if (yych <= 'R') {
			if (yych <= 'K') {
				if (yych <= '9') goto yy1281;
				goto yy1226;
			} else {
				if (yych <= 'L') goto yy1282;
				if (yych <= 'Q') goto yy1226;
				goto yy1282;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy1226;
				goto yy1282;
			} else {
				if (yych == 'r') goto yy1282;
				goto yy1226;
			}
		}
	}
yy1249:
	++cur;
	goto yy1241;
yy1250:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy1250;
		} else {
			if (yych == '\v') goto yy1250;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1250;
			if (yych >= ' ') goto yy1250;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1274;
		}
	}
yy1251:
	cur = mar;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy1228;
			} else {
				goto yy1226;
			}
		} else {
			if (yyaccept == 2) {
				goto yy1241;
			} else {
				goto yy1258;
			}
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) {
				goto yy1262;
			} else {
				goto yy1266;
			}
		} else {
			goto yy1238;
		}
	}
yy1252:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1252;
		} else {
			if (yych == '\v') goto yy1252;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1252;
			if (yych <= 0x1F) goto yy1251;
			goto yy1252;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1275;
			goto yy1251;
		}
	}
yy1253:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy1251;
				goto yy1253;
			} else {
				if (yych == '\v') goto yy1253;
				goto yy1251;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy1253;
				if (yych <= 0x1F) goto yy1251;
				goto yy1253;
			} else {
				if (yych <= '/') goto yy1251;
				if (yych <= '9') goto yy1276;
				goto yy1251;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'S') {
				if (yych <= 'N') goto yy1277;
				if (yych <= 'R') goto yy1251;
				goto yy1277;
			} else {
				if (yych == 'X') goto yy1277;
				goto yy1251;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'n') goto yy1277;
				if (yych <= 'r') goto yy1251;
				goto yy1277;
			} else {
				if (yych == 'x') goto yy1277;
				goto yy1251;
			}
		}
	}
yy1254:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1254;
		} else {
			if (yych == '\v') goto yy1254;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1254;
			if (yych <= 0x1F) goto yy1251;
			goto yy1254;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1278;
			goto yy1251;
		}
	}
yy1255:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1255;
		} else {
			if (yych == '\v') goto yy1255;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1255;
			if (yych <= 0x1F) goto yy1251;
			goto yy1255;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1273;
			goto yy1251;
		}
	}
yy1256:
	yych = *++cur;
yy1257:
	if (yybm[0+yych] & 4) {
		goto yy1256;
	}
	if (yych <= 0x00) goto yy1251;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy1256;
yy1258:
#line 869 "parser/tokenizer.re"
	{ continue; }
#line 10059 "parser/tokenizer.cpp"
yy1259:
	yych = *++cur;
yy1260:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1259;
		} else {
			if (yych <= '\n') goto yy1261;
			if (yych <= '\v') goto yy1259;
			goto yy1251;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy1259;
			goto yy1251;
		} else {
			if (yych <= ' ') goto yy1259;
			if (yych <= '!') goto yy1263;
			goto yy1251;
		}
	}
yy1261:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy1261;
	}
	if (yych <= 0x1F) goto yy1262;
	if (yych <= '!') goto yy1263;
	if (yych == '&') goto yy1283;
yy1262:
#line 868 "parser/tokenizer.re"
	{ continue; }
#line 10094 "parser/tokenizer.cpp"
yy1263:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy1263;
	}
	if (yych <= 0x00) goto yy1251;
	goto yy1261;
yy1264:
	yych = *++cur;
yy1265:
	if (yybm[0+yych] & 32) {
		goto yy1264;
	}
	if (yych <= 0x00) goto yy1251;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy1264;
yy1266:
#line 870 "parser/tokenizer.re"
	{ continue; }
#line 10115 "parser/tokenizer.cpp"
yy1267:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1267;
		} else {
			if (yych == '\v') goto yy1267;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1267;
			if (yych <= 0x1F) goto yy1251;
			goto yy1267;
		} else {
			if (yych != '(') goto yy1251;
		}
	}
yy1268:
	++cur;
#line 842 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp, diagnostics, continue_compilation);
                continue;
            }
#line 10144 "parser/tokenizer.cpp"
yy1269:
	yych = *++cur;
yy1270:
	if (yybm[0+yych] & 64) {
		goto yy1272;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1269;
		case '(': goto yy1271;
		case 'A':
		case 'a': goto yy1240;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1250;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1252;
		case 'E':
		case 'e': goto yy1253;
		case 'G':
		case 'g': goto yy1254;
		case 'L':
		case 'l': goto yy1255;
		case 'P':
		case 'p': goto yy1247;
		case 'X':
		case 'x': goto yy1249;
		default: goto yy1251;
	}
yy1271:
	++cur;
#line 836 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp, diagnostics, continue_compilation);
                continue;
            }
#line 10192 "parser/tokenizer.cpp"
yy1272:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy1272;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1269;
		case '(': goto yy1271;
		case '/': goto yy1237;
		case 'A':
		case 'a': goto yy1240;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1250;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1252;
		case 'E':
		case 'e': goto yy1253;
		case 'G':
		case 'g': goto yy1254;
		case 'L':
		case 'l': goto yy1255;
		case 'P':
		case 'p': goto yy1247;
		case 'X':
		case 'x': goto yy1249;
		default: goto yy1251;
	}
yy1273:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1241;
			goto yy1255;
		} else {
			if (yych == '\v') goto yy1255;
			goto yy1241;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1255;
			if (yych <= 0x1F) goto yy1241;
			goto yy1255;
		} else {
			if (yych <= '/') goto yy1241;
			if (yych <= '9') goto yy1273;
			goto yy1241;
		}
	}
yy1274:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 128) {
		goto yy1274;
	}
	if (yych == '.') goto yy1255;
	goto yy1241;
yy1275:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1275;
			goto yy1251;
		} else {
			if (yych == '\f') goto yy1251;
			goto yy1275;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1275;
			goto yy1251;
		} else {
			if (yych <= '.') goto yy1255;
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1275;
			goto yy1251;
		}
	}
yy1276:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1276;
			goto yy1251;
		} else {
			if (yych == '\f') goto yy1251;
			goto yy1276;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1276;
			goto yy1251;
		} else {
			if (yych <= '.') goto yy1284;
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1276;
			goto yy1251;
		}
	}
yy1277:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1277;
		} else {
			if (yych == '\v') goto yy1277;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1277;
			if (yych <= 0x1F) goto yy1251;
			goto yy1277;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1276;
			goto yy1251;
		}
	}
yy1278:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1278;
			goto yy1241;
		} else {
			if (yych == '\f') goto yy1241;
			goto yy1278;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1278;
			goto yy1241;
		} else {
			if (yych <= '.') goto yy1284;
			if (yych <= '/') goto yy1241;
			if (yych <= '9') goto yy1278;
			goto yy1241;
		}
	}
yy1279:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1279;
			goto yy1251;
		} else {
			if (yych == '\f') goto yy1251;
			goto yy1279;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy1279;
			goto yy1251;
		} else {
			if (yych <= 'F') goto yy1252;
			if (yych <= 'd') goto yy1251;
			if (yych <= 'f') goto yy1252;
			goto yy1251;
		}
	}
yy1280:
	yych = *++cur;
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1280;
			if (yych <= '\n') goto yy1251;
			goto yy1280;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1251;
				goto yy1280;
			} else {
				if (yych == ' ') goto yy1280;
				goto yy1251;
			}
		}
	} else {
		if (yych <= 'R') {
			if (yych <= 'K') {
				if (yych >= ':') goto yy1251;
			} else {
				if (yych <= 'L') goto yy1282;
				if (yych <= 'Q') goto yy1251;
				goto yy1282;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy1251;
				goto yy1282;
			} else {
				if (yych == 'r') goto yy1282;
				goto yy1251;
			}
		}
	}
yy1281:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1238;
		} else {
			if (yych != '\v') goto yy1238;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1282;
			if (yych <= 0x1F) goto yy1238;
		} else {
			if (yych <= '/') goto yy1238;
			if (yych <= '9') goto yy1281;
			goto yy1238;
		}
	}
yy1282:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1282;
		} else {
			if (yych == '\v') goto yy1282;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1282;
			if (yych <= 0x1F) goto yy1251;
			goto yy1282;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych <= '9') goto yy1281;
			goto yy1251;
		}
	}
yy1283:
	++cur;
	goto yy1262;
yy1284:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1251;
			goto yy1284;
		} else {
			if (yych == '\v') goto yy1284;
			goto yy1251;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1284;
			if (yych <= 0x1F) goto yy1251;
			goto yy1284;
		} else {
			if (yych <= '/') goto yy1251;
			if (yych >= ':') goto yy1251;
		}
	}
yy1285:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1285;
			goto yy1241;
		} else {
			if (yych == '\f') goto yy1241;
			if (yych <= '\r') goto yy1285;
			goto yy1241;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= ' ') goto yy1285;
			if (yych <= '/') goto yy1241;
			if (yych <= '9') goto yy1285;
			goto yy1241;
		} else {
			if (yych <= 'E') goto yy1255;
			if (yych == 'e') goto yy1255;
			goto yy1241;
		}
	}
}
#line 874 "parser/tokenizer.re"

    }
}

} // namespace LCompilers::LFortran
