/*
 * Copyright (C) 2013 ~ 2019 National University of Defense Technology(NUDT) & Tianjin Kylin Ltd.
 *
 * Authors:
 *  Kobe Lee    lixiang@kylinos.cn/kobe24_lixiang@126.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CONTROLLER_WORKER_H
#define CONTROLLER_WORKER_H

#include <QObject>

class ControllerWorker : public QObject
{
    Q_OBJECT
public:
    explicit ControllerWorker();
    ~ControllerWorker();

public slots:
    void playPause();
    bool seek_forward(int seconds);
    bool seek_rewind(int seconds);
    void stop();
    void quit();

signals:
    void requestSeekForward(int seconds);
    void requestSeekRewind(int seconds);
    void requestPlayPause();
    void requestStop();
};

#endif // CONTROLLER_WORKER_H
