#!/usr/bin/env python

"""
Show a MIME-encoded e-mail message as plain text.

Copyright (C) 2015, 2016 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from email import message_from_string
from email.generator import Generator
from os.path import split
import sys

try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO

def until_from(f, skip=0):
    number = 0
    while number <= skip:
        l = []
        s = f.readline()
        while s:
            l.append(s)
            s = f.readline()
            if s.startswith("From "):
                number += 1
                break
        else:
            number += 1
            break
    if number > skip:
        return "".join(l)
    else:
        return ""

def as_string(message):

    """
    Return the string representation of 'message', attempting to preserve the
    precise original formatting.
    """

    out = StringIO()
    generator = Generator(out, False, 0) # disable reformatting measures
    generator.flatten(message)
    return out.getvalue()

def decode(part):

    """
    Change the transfer encoding on 'part' and its subparts so that a plain text
    representation may be displayed.
    """

    payload = part.get_payload(decode=True)
    if payload:
        encoding = part.get("Content-Transfer-Encoding")
        if encoding:
            del part["Content-Transfer-Encoding"]
            part["Content-Transfer-Encoding"] = "8bit"
            part.set_payload(payload)
    else:
        for p in part.get_payload():
            decode(p)

# Main program.

if __name__ == "__main__":
    if len(sys.argv) > 1 and sys.argv[1] == "--help":
        print >>sys.stderr, """\
Usage: %s [ <messages to skip> ]

Read MIME-encoded e-mail messages from standard input, writing the decoded
messages to standard output.

Where <messages to skip> is given, the indicated number of messages will be
skipped in the input, with the first subsequent message being written out.
""" % split(sys.argv[0])[1]
        sys.exit(1)

    skip = int((sys.argv[1:] or [0])[0])
    message = message_from_string(until_from(sys.stdin, skip))
    decode(message)
    print as_string(message)

# vim: tabstop=4 expandtab shiftwidth=4
