#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER1="mailto:resource-car-porsche911@example.com"
USER2="mailto:resource-car-fiat500@example.com"
SENDER1="mailto:paul.boddie@example.com"
SENDERADDRESS1="paul.boddie@example.com"
QUOTA=cars

# Test quota enforcement on two resources, first checking whether the resources
# can schedule an incoming reservation, then checking whether the reservation
# would exceed the organiser's quota applying collectively to both resources.

# The result should be the first scheduling attempt being declined because it
# attempts to reserve an indefinite amount of time that obviously exceeds the
# quota, with the second attempt succeeding once the quota has been removed.

# The event is then cancelled for one resource and the effect evaluated.

mkdir -p "$PREFS/$USER1"
echo 'Europe/Oslo' > "$PREFS/$USER1/TZID"
echo 'share' > "$PREFS/$USER1/freebusy_sharing"
cat > "$PREFS/$USER1/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

mkdir -p "$PREFS/$USER2"
echo 'Europe/Oslo' > "$PREFS/$USER2/TZID"
echo 'share' > "$PREFS/$USER2/freebusy_sharing"
cat > "$PREFS/$USER2/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
* PT10H
EOF

# Allow cars to delegate to each other. This defines the possible attendees for
# recurring events.

cat <<EOF | "$SET_DELEGATES" "$QUOTA" $SET_DELEGATES_ARGS
mailto:resource-car-porsche911@example.com
mailto:resource-car-fiat500@example.com
EOF

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-car-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
>  out0f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out0f.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out0f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars-recurring.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out1f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out1f2.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1f.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1f.tmp" \
&& ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1f2.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is not confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out1e.tmp

   ! grep -q "event25@example.com" "out1e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Modify the quota and attempt to schedule the event again.

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
* *
EOF

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER1" "freebusy" \
>  out1s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1s.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out1s.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-cars-recurring.txt" 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

# Since the email module used by showmail.py cannot stop after reading a single
# message, the second message is obtained.

  "$SHOWMAIL" 1 < out2r.tmp \
>> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER1" "freebusy" \
>  out2f.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER2" "freebusy" \
>  out2f2.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2f.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out2f.tmp" \
&& grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f2.tmp" \
&& grep -q "^20141130T150000Z${TAB}20141130T160000Z" "out2f2.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out2f2.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed for both resources).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out2e.tmp

   grep -q "event25@example.com" "out2e.tmp" \
&& grep -q "$USER1" "out2e.tmp" \
&& grep -q "$USER2" "out2e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the journal's event store.

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "journal_object" "event25@example.com" \
>  out2o.tmp

   grep -q "event25@example.com" "out2o.tmp" \
&& grep -q "$USER1" "out2o.tmp" \
&& grep -q "$USER2" "out2o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Run the free/busy maintenance script and check that the event provides
# recurrences.

"$FREEBUSY_SCRIPT" "$QUOTA" '*' $FREEBUSY_QUOTA_ARGS $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "journal_freebusy_providers" \
|  tee out2p.tmp \
|  grep -q 'event25@example.com' \
&& echo "Success" \
|| echo "Failed"

# Cancel the event for one of the resources.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-car-recurring.txt" 2>> $ERROR
echo "Cancel..."

# Check the quota (event is confirmed for one resource).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out3e.tmp

   grep -q "event25@example.com" "out3e.tmp" \
&& grep -q "$USER1" "out3e.tmp" \
&& ! grep -q "$USER2" "out3e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the journal's event store.

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "journal_object" "event25@example.com" \
>  out3o.tmp

   grep -q "event25@example.com" "out3o.tmp" \
&& grep -q "$USER1" "out3o.tmp" \
&& ! grep -q "$USER2" "out3o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Run the free/busy maintenance script and check that the event still provides
# recurrences.

"$FREEBUSY_SCRIPT" "$QUOTA" '*' $FREEBUSY_QUOTA_ARGS $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "journal_freebusy_providers" \
|  tee out3p.tmp \
|  grep -q 'event25@example.com' \
&& echo "Success" \
|| echo "Failed"

# Cancel the event completely.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-cars-recurring.txt" 2>> $ERROR
echo "Cancel..."

# Check the quota (event is confirmed for no resources).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER1" \
>  out4e.tmp

   ! grep -q "event25@example.com" "out4e.tmp" \
&& ! grep -q "$USER1" "out4e.tmp" \
&& ! grep -q "$USER2" "out4e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the journal's event store.

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "journal_object" "event25@example.com" \
>  out4o.tmp

   ! grep -q "event25@example.com" "out4o.tmp" \
&& ! grep -q "$USER1" "out4o.tmp" \
&& ! grep -q "$USER2" "out4o.tmp" \
&& echo "Success" \
|| echo "Failed"

# Run the free/busy maintenance script and check that the event no longer
# provides recurrences.

"$FREEBUSY_SCRIPT" "$QUOTA" '*' $FREEBUSY_QUOTA_ARGS $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "journal_freebusy_providers" \
>  out4p.tmp

   ! grep -q 'event25@example.com' "out4p.tmp" \
&& echo "Success" \
|| echo "Failed"
